# copyright (C) 1997-2002 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: myquery.tcl,v 2.16 2001/12/29 00:32:39 jfontain Exp $}


package provide myquery [lindex {$Revision: 2.16 $} 1]
if {[lsearch -exact $auto_path /usr/lib]<0} {                         ;# in case Tcl/Tk is somewhere else than in the /usr hierarchy
    lappend auto_path /usr/lib
}
package require mysqltcl 2


namespace eval myquery {

    array set data {
        updates 0
        0,label {} 0,type integer 0,message {row number in order of arrival}
        pollTimes {10 5 20 30 60 120 300}
        switches {--host 1 --password 1 --port 1 -q 1 --query 1 --swap 0 -t 1 --table 1 --user 1}
        sort {0 increasing}
    }
    set file [open myquery.htm]
    set data(helpText) [read $file]                                                           ;# initialize HTML help data from file
    close $file

    proc initialize {optionsName} {
        upvar $optionsName options
        variable connection
        variable data
        variable statement

        catch {set query $options(-q)}
        catch {set query $options(--query)}                                                                     ;# favor long option
        catch {set table $options(-t)}
        catch {set table $options(--table)}                                                                     ;# favor long option
        if {[info exists query]&&[info exists table]} {
            error {use either table or query option but not both}
        }
        if {[info exists query]} {
            set statement $query
        } elseif {[info exists table]} {
            set statement "select * from $table"
        } else {
            error {either query (-q (--query)) or table (-t (--table)) must be specified}
        }
        set arguments {}
        catch {lappend arguments -host $options(--host)}
        catch {set user $::env(USER)}                                                                                  ;# by default
        catch {set user $::env(LOGNAME)}                                                          ;# more common in UNIX and even NT
        catch {set user $options(--user)}
        catch {lappend arguments -user $user}
        catch {lappend arguments -password $options(--password)}
        catch {lappend arguments -port $options(--port)}
        set connection [eval mysqlconnect $arguments]
        set host [mysqlinfo $connection host]
        set data(identifier) myquery($host)

        mysqlsel $connection $statement
        set column 1
        foreach list [mysqlcol $connection -current {name type length numeric decimals}] {
            foreach {name type width numeric decimals} $list {}
            set data($column,label) $name
            if {$numeric} {
                set data($column,type) real                     ;# so that cell may be dropped in viewers that expect a numeric type
                if {$decimals>0} {
                    set data($column,message) "$name (${type}([expr {$width-$decimals}].$decimals))"
                } else {
                    set data($column,message) "$name (${type}($width))"
                }
            } else {
                set data($column,type) ascii
                set data($column,anchor) left
                set data($column,message) "$name (${type}($width))"
            }
            incr column
        }
        if {[info exists options(--swap)]} {
            for {set index 0} {$index<$column} {incr index} {
                lappend indices $index
            }
            set data(views) [list [list indices $indices swap 1]]
        }
        while {[llength [mysqlnext $connection]]>0} {}
    }

    proc update {} {
        variable connection
        variable statement
        variable data

        array unset data {[0-9]*,[0-9]*}                                                                    ;# clear data every time
        if {[catch {mysqlsel $connection $statement} message]} {                                          ;# problem reaching server
            flashMessage "myquery error: $message"
        } else {
            set row 0
            while {[llength [set list [mysqlnext $connection]]]>0} {
                set data($row,0) $row
                set column 1
                foreach value $list {
                    set data($row,$column) $value
                    incr column
                }
                incr row
            }
        }
        incr data(updates)
    }

    proc terminate {} {
        variable connection
        catch {mysqlclose $connection}
    }

}
