// msql2mysqlWrapper - Version 1.0
// USE @ YOUR OWN RISK
// alfred@sb.net  1999-06-10
#include <mysql.h>

#if defined(__STDC__) || defined(__cplusplus)
#  define __ANSI_PROTO(x)	x
#else
#  define __ANSI_PROTO(x)	()
#endif

#ifdef __cplusplus
extern "C" {
#endif

void Debug(char*);

typedef	char	** m_row;

typedef struct field_s {
	char	*name,
		*table;
	int	type,
		length,
		flags;
} m_field;



typedef	struct	m_data_s {
	int	width;
	m_row	data;
	struct	m_data_s *next;
} m_data;

typedef struct m_fdata_s {
	m_field	field;
	struct m_fdata_s *next;
} m_fdata;



typedef struct result_s {
        m_data 	*queryData,
                *cursor;
	m_fdata	*fieldData,
		*fieldCursor;
	int	numRows,
		numFields;
        MYSQL_RES   *mysql_res;   //  ADDED MYSQL pointer
	m_field lastField;             //  ADDED MSQL pointer
} m_result;


#define INT_TYPE	1
#define CHAR_TYPE	2
#define REAL_TYPE	3
#define IDENT_TYPE	4
#define NULL_TYPE	5

/*  (Already defined in MySQL)
#define NOT_NULL_FLAG   1
#define PRI_KEY_FLAG    2

#define IS_PRI_KEY(n)	(n & PRI_KEY_FLAG)
#define IS_NOT_NULL(n)	(n & NOT_NULL_FLAG)
*/

/*
** Pre-declarations for the API library functions
*/
#ifndef _MSQL_SERVER_SOURCE
	extern  char msqlErrMsg[];
	int 	msqlConnect __ANSI_PROTO((char *));
	int 	msqlSelectDB __ANSI_PROTO((int, char*));
	int 	msqlQuery __ANSI_PROTO((int, char*));
	int 	msqlCreateDB __ANSI_PROTO((int, char*));
	int 	msqlDropDB __ANSI_PROTO((int, char*));
	int 	msqlShutdown __ANSI_PROTO((int));
	int 	msqlReloadAcls __ANSI_PROTO((int));
	int 	msqlGetProtoInfo();
	char 	*msqlGetServerInfo();
	char 	*msqlGetHostInfo();
	void	msqlClose __ANSI_PROTO((int));
	void 	msqlDataSeek __ANSI_PROTO((m_result*, int));
	void 	msqlFieldSeek __ANSI_PROTO((m_result*, int));
	void 	msqlFreeResult __ANSI_PROTO((m_result*));
        m_row   msqlFetchRow __ANSI_PROTO((m_result*));
	m_field	*msqlFetchField __ANSI_PROTO((m_result *));
	m_result *msqlListDBs __ANSI_PROTO((int));
	m_result *msqlListTables __ANSI_PROTO((int));
	m_result *msqlListFields __ANSI_PROTO((int, char*));
	m_result *msqlStoreResult();
   int msqlNumFields __ANSI_PROTO((m_result*));
   int msqlNumRows __ANSI_PROTO((m_result*));
#endif

#ifdef __cplusplus
	}
#endif
