#ifndef QUERYLISTVIEW_H
#define QUERYLISTVIEW_H

#include <qlistview.h>
#include <mysql.h>

class QueryListView : public QListView
{
Q_OBJECT

public:
	QueryListView(MYSQL *,QWidget *parent);
	~QueryListView();

	void set_sql(const QString &, const QString &);
	bool execute();

public slots:
	void slot_clear();
	void slot_close();
	void slot_save();
	void slot_about();

private:
	QString database;
	QString sql;
	MYSQL *mysql;
	MYSQL_RES *result;
	MYSQL_ROW row; 
	MYSQL_FIELD *field;

	void set_row_height(QListViewItem *);
	int get_newline_number(const QString &);

signals:
	void signal_error_log();
};

#endif
