#include "mainwindow.h"
#include "serverlistviewitem.h"
#include <qfile.h>
#include <stdio.h>
#include <stdlib.h>
#include <qdom.h>

void MainWindow::load_session()
{
	char buffer[100];

	sprintf(buffer, "%s/.mysql_navigator.rc", getenv("HOME"));

	QFile l(buffer);

	if(l.exists() == FALSE)
	{
		return;
	}
	
	if(l.open(IO_ReadOnly) == FALSE)
	{
		return;
	}

	QDomDocument mysql("mysql");

	if(mysql.setContent(&l) == FALSE)
	{
		l.close();
		return;
	}

	l.close();

	//debug(mysql.toString().latin1());

	QDomNodeList list = mysql.elementsByTagName("FLAG");
	//debug("flag: %s", list.item(0).firstChild().nodeValue().latin1());
	log.flag = list.item(0).firstChild().nodeValue().toInt();
	
	list = mysql.elementsByTagName("FILE");
	//debug("file: %s", list.item(0).firstChild().nodeValue().latin1());
	log.file = list.item(0).firstChild().nodeValue();
	
}

void MainWindow::save_session()
{
	QString buffer;

	buffer.append("<MYSQL>");
	buffer.append("<LOG>");	
	buffer.append("<FLAG>");	
	buffer.append(log.flag ? "1" : "0");	
	buffer.append("</FLAG>");	
	buffer.append("<FILE>");
	buffer.append(log.file.simplifyWhiteSpace());
	buffer.append("</FILE>");
	buffer.append("</LOG>");	

	if(dialog == NULL)
	{
	}
	else
	{
		QListViewItemIterator l(dialog->list);

		for(; l.current(); ++l)
		{
			buffer.append("<SERVER>");
			buffer.append("<HOST>");
			buffer.append(((ServerListViewItem *)l.current())->host);
			buffer.append("</HOST>");
			buffer.append("<USER>");
			buffer.append(((ServerListViewItem *)l.current())->user);
			buffer.append("</USER>");
			buffer.append("<PASSWORD>");
			buffer.append("</PASSWORD>");
			buffer.append("<DATABASE>");
			buffer.append(((ServerListViewItem *)l.current())->database);
			buffer.append("</DATABASE>");
			buffer.append("<PORT>");
			buffer.append(((ServerListViewItem *)l.current())->port);
			buffer.append("</PORT>");
			buffer.append("<SOCKET>");
			buffer.append(((ServerListViewItem *)l.current())->socket);
			buffer.append("</SOCKET>");
			buffer.append("</SERVER>");
		}
	}
	buffer.append("</MYSQL>");

	//debug(buffer.latin1());

	char log[100];

	sprintf(log, "%s/.mysql_navigator.rc", getenv("HOME"));

	QFile si(log);

	if(si.open(IO_WriteOnly | IO_Truncate) == FALSE)
	{
		//debug("open() system call fail.");
		return;
	}

	si.writeBlock(buffer, buffer.length());

	si.close();
}
