#include <qmessagebox.h>
#include <qmenubar.h>
#include <stdio.h>
#include "mainwindow.h"
#include "mdiwindow.h"
#include "query.h"
#include "multilinelistviewitem.h"
#include "querylistview.h"

void MainWindow::slot_query()
{
	slot_query(database->currentText(), query->currentText());
}

void MainWindow::slot_query(const QString &database, const QString &query)
{
	slot_query(database, query, "");
}

void MainWindow::slot_query(const QString &database, const QString &query, const QString &title)
{
	MDIWindow* si_ = new MDIWindow(work_space, 0, WDestructiveClose);
  
	if(title.length() == 0)
	{
		si_->setCaption(tr("Query") + QString(" - ") + query);
	}
	else
	{
		si_->setCaption(title + QString(" - ") + query);
	}

	QueryListView *sql = new QueryListView(&mysql, si_);

	connect(sql, SIGNAL(signal_error_log()), this, SLOT(slot_error_log()));

	sql->set_sql(database, query);

	save_history(query);

	if(sql->execute() == FALSE)
	{
		//debug("there is no result");

		slot_schema_refresh(0);

		return;
	}
    
	si_->setCentralWidget(sql);

	if(sql->sizeHint().width() + 5 > work_space->width())
	{
		if(sql->sizeHint().height() > 200)
		{
			si_->resize(work_space->width() - 350, 200);
		}
		else
		{
			si_->resize(work_space->width() - 350, sql->sizeHint().height());
		}
	}
	else
	{
		if(sql->sizeHint().height() > 200)
		{
			si_->resize(sql->sizeHint().width() + 5, 200);
		}
		else
		{
			si_->resize(sql->sizeHint().width() + 5, sql->sizeHint().height());
		}
	}

	set_database();
	emit signal_tree();

	QPopupMenu *l = new QPopupMenu();
	l->insertItem(tr("&Save"), sql, SLOT(slot_save()), CTRL+Key_S);
	l->insertSeparator();
	l->insertItem(tr("&Close"), sql, SLOT(slot_close()), CTRL+Key_C);
	si_->menuBar()->insertItem(tr("&File"), l);
	
	l = new QPopupMenu();
	l->insertItem(tr("&About..."), sql, SLOT(slot_about()), Key_F1);
	si_->menuBar()->insertItem(tr("&Help"), l);

	si_->show();
}

void MainWindow::slot_query_window()
{
	if(!flag)
	{
		return;	
	}
	
	MDIWindow* l = new MDIWindow(work_space, 0, WDestructiveClose);
	
	Query *query = new Query(&mysql, l);
	
	connect(query, SIGNAL(signal_query(const QString &, const QString &)), this, SLOT(slot_query(const QString &, const QString &)));

	connect(query, SIGNAL(signal_tree()), this, SLOT(slot_tree()));

    l->setCentralWidget(query);

	l->setCaption(tr("Query"));
   
	//
	QPopupMenu *l_ = new QPopupMenu();
	l_->insertItem(tr("&Fire"), query, SLOT(slot_fire()), CTRL+Key_F);
	l_->insertItem(tr("&Save"), query->listview, SLOT(slot_save()), CTRL+Key_S);
	l_->insertSeparator();
	l_->insertItem(tr("&Close"), query, SLOT(slot_close()), CTRL+Key_C);
	l->menuBar()->insertItem(tr("F&ile"), l_);

	l_ = new QPopupMenu();
	l_->insertItem(tr("&Undo"), query, SLOT(slot_undo()));
	l_->insertItem(tr("&Redo"), query, SLOT(slot_redo()));
	l_->insertSeparator();
	l_->insertItem(tr("&Cut"), query, SLOT(slot_cut()));
	l_->insertItem(tr("C&opy"), query, SLOT(slot_copy()));
	l_->insertItem(tr("&Paste"), query, SLOT(slot_paste()));
	l_->insertItem(tr("C&lear"), query, SLOT(slot_clear()));
	l_->insertItem(tr("Select &All"), query, SLOT(slot_select_all()));
	l->menuBar()->insertItem(tr("&Edit"), l_);

	l_ = new QPopupMenu();
	l_->insertItem(tr("&About..."), query, SLOT(slot_about()), Key_F1);
	l->menuBar()->insertItem(tr("&Help"), l_);
	l->setFixedSize(380, 400 - 3); 

	l->show();
}
