#include "querytable.h"
#include <qmessagebox.h>

QueryTable::QueryTable(MYSQL *mysql, QWidget *parent)
	: QTable(0, 0, parent)
{
	this->mysql = mysql;
	setLeftMargin(0);
	verticalHeader()->hide();
	setShowGrid(TRUE);
}

QueryTable::~QueryTable()
{
}

void QueryTable::set_sql(const QString &database, const QString &sql)
{
	this->sql = sql;
	this->database = database;
}

bool QueryTable::execute()
{
	slot_clear();

	if(database.length() == 0)
	{
	}
	else
	{
		mysql_select_db(mysql,database.latin1());
	}

	if((mysql_query(mysql, sql.latin1())))
	{
		emit signal_error_log();
		QMessageBox::critical(this, tr("MySQL Navigator"), QString::fromLocal8Bit(mysql_error(mysql)));
		return FALSE; 	 
	}

	result = mysql_store_result(mysql);
	
	if(result == NULL)
	{
		return FALSE;
	}

	unsigned int rows = mysql_num_rows(result);
	unsigned int fields = mysql_num_fields(result);

	setNumRows(rows);
	setNumCols(fields);

	for(unsigned int l = 0; l < fields; l++)
	{
		field = mysql_fetch_field(result);
		horizontalHeader()->setLabel(l, field->name);
	}

	rows = 0;

	while((row = mysql_fetch_row(result)))
	{
		setRowStretchable(rows, TRUE);

		for(unsigned int l = 0; l < fields; l++)
		{
			QTableItem *ll = new QTableItem(this, QTableItem::Never, QString::fromLocal8Bit(row[l]));

			setItem(rows, l, ll);
		}
		rows++;
	}

	mysql_free_result(result);
	return TRUE;
}

void QueryTable::slot_clear()
{
	/*
	int l;

	l = columns();

	for(int i = l - 1; i >=0; i--)
	{
		removeColumn(i);
	}

	clear();
	*/
}
