/********************************************************/
/* mysql_structure_dumper.c
/*
/* Author: Thomas Wana
/* Date  : 1999-08-04 
/*
/* Dumps the structure of all tables in a given Data-
/* base to a file. Useful for documentation purposes.
/*
/* Get the most recent version from http://wana.tsx.org!
/*
/* REQUIRES: *) mysql > 3.21.x (tested OK with 3.22.24)
/*
/********************************************************/

#include <stdio.h>
#include <ncurses.h>
#include <string.h>
#include <stdlib.h>
#include <mysql.h>
#include <unistd.h>
#include "mysql_util.h"

#define VERSION "2.0"

char user[20],password[30],host[100];
char query[500],database[80];
char filename[80];
int param_help_requested,param_stdout;

void DoCommandLine(int argc, char **argv);
 
void main(int argc, char **argv)
{
   MYSQL mysql;
   MYSQL_ROW row;
   MYSQL_RES *result;
   FILE *fp;
   char taste,hilf[30],execute[500];
   unsigned long delay;
   int ende,i,j,k,x,y,columns;
   int row_width[80];

   DoCommandLine(argc,argv);

   mysql_init(&mysql);
   if(mysql_real_connect(&mysql,host,user,password,database,0,NULL,0))
   {
      if(!param_stdout) 
      {
         printf("Successfully connected.\n\n");
         fp=fopen(filename,"w");
         if(!fp)
         {
            fprintf(stderr,"Failed to open %s for writing!\n",filename);
            exit(1);
         }
      }
      else fp=stdout;
      fprintf(fp,"TABLES OF DATABASE \"%s\"\n\n",database);
      sprintf(query,"show tables");   
      mysql_query(&mysql,query);
      result=mysql_store_result(&mysql);
      if(mysql_num_rows(result)==0)
      {
         fprintf(fp,"This database is empty!\n");
      }
      else
      {
         while((row=mysql_fetch_row(result))!=NULL)
         {
            if(!param_stdout) printf("Dumping table %s...",row[0]);
            fprintf(fp,"Table %s:\n",row[0]);
            sprintf(query,"show columns from %s",row[0]);
            if(!mysql_util_printquery(&mysql,query,fp))
            {
               fprintf(stderr,"Error: %s\n",mysql_error(&mysql));
            }
            fprintf(fp,"\n");
            if(!param_stdout) printf("done.\n");
         } 
      }
      fclose(fp);
      mysql_free_result(result);
      mysql_close(&mysql);
   }
   else
   {
      fprintf(stderr,"Unable to connect.\nError: %s\n",mysql_error(&mysql));
   }
}

void DoCommandLine(int argc, char **argv)
{
   int i;
   strcpy(host,""); strcpy(user,""); strcpy(database,""); strcpy(password,"");
   strcpy(filename,"");
   for(i=1,param_help_requested=0;i<argc && !param_help_requested;i++)
   {
      if(!strcmp(argv[i],"-?") || !strcmp(argv[i],"--help"))
      {
         param_help_requested=1;
      }
      else if(strstr(argv[i],"-h"))
      {
         strcpy(host,argv[i]+2);
      }
      else if(strstr(argv[i],"-p")) 
      {
         strcpy(password,argv[i]+2);
      }
      else if(strstr(argv[i],"-u"))
      {   
         strcpy(user,argv[i]+2);
      }
      else if(strstr(argv[i],"-d"))
      {
         strcpy(database,argv[i]+2);
      }
      else if(strstr(argv[i],"-f"))
      {
         strcpy(filename,argv[i]+2);
      }
      else if(!strcmp(argv[i],"--stdout"))
      {
         param_stdout=1;
      }
   }
   if(!param_stdout)
      printf("MYSQL STRUCTURE DUMPER %s - (c) 1999 by Thomas Wana <wana@ycom.at>\n\n",VERSION);
   if(!param_stdout)
   {
   if(!param_help_requested)
   {
      if(argc==1)
      {
         printf("Call without parameters. Use --help at the command line.\n\n");
      }
      printf("Host to connect: ");
      if(!strcmp(host,""))
      {
         gets(host);
      }
      else printf("%s\n",host);
      printf("Username: ");
      if(!strcmp(user,""))
      {
         gets(user);
      }
      else printf("%s\n",user);
      printf("Password: ");
      if(!strcmp(password,""))
      { 
         gets(password);
      }
      else printf("[supplied]\n");
      printf("Database: ");
      if(!strcmp(database,""))
      {
         gets(database);
      }
      else printf("%s\n",database);
      printf("Filename to dump to: ");
      if(!strcmp(filename,""))
      {
         gets(filename);
      }
      else printf("%s\n",filename);
      printf("Stdout-Mode: ");
      if(param_stdout==1) printf("on\n");
      else printf("off\n");
   }
   else
   {
      printf("Syntax: mysql_structure_dumper [-hHost] [-uUser] [-pPassword]\n");
      printf("                  [-dDatabase] [-fFile] [--stdout] [--help|-?]");
      printf("\n\n");
      printf("-h       : Host to connect\n");
      printf("-u       : Username\n");
      printf("-p       : Password\n");
      printf("-d       : Database to dump\n");
      printf("-f       : Filename to dump to. Ignored with --stdout.\n");
      printf("--stdout : Dump to stdout (for pipe connections)\n");
      printf("--help   : Help on command-line\n\n");
      printf("Example: Dump a database and send it to the printer:\n");
      printf("mysql_structure_dumper -hlocalhost -umysql -pSecret -dDATA --stdout | lpr\n\n");
      exit(0);
   }
   }
}
