/**
*** Program jdbcMysqlDebug.java
***    in product twz1jdbcForMysql, 
***    Copyright 1997, 1998 by Terrence W. Zellers.
***   
***  All rights explicitly reserved.
***
***  See file "LICENSE" in this package for conditions of use.
**/

package twz1.jdbc.mysql;

import twz1.jdbc.mysql.jdbcMysqlMutex;
 
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;


/** The class which outputs debug messages and formats to the debug
*** file.  Note package and public methods of this class never throw an 
*** exception.
**/
final class jdbcMysqlDebug
{

/** Debug output. */
private PrintWriter dfile;

/** Debug file name. */
private String fileName;

/** Debug output synchronization mutex */
jdbcMysqlMutex guard;

/** My identifier. */
int myOID;

private static final String hexlist   = "0123456789abcdef";
private static final String printable = "01234567890abcdefghijkl"
                                      + "mnopqrstuvwxyzABCDEFGHIJKL"
                                      + "MNOPQRSTUVWXYZ`~!@#$%^&"
                                      + "*()_-+=[]{};:\"',.<>?/|"
                                      + "\"\\ ";
/** Constructor for the defaults */
jdbcMysqlDebug(String name)
    {

    this.fileName = name;
    this.myOID = jdbcMysqlBase.getOID();
    this.guard = new jdbcMysqlMutex();
    open();
    Calendar c = Calendar.getInstance();
    String d = new String( c.get(c.YEAR) + "/" +c.get(c.MONTH) + "/"
                         + c.get(c.DATE) + " " + c.get(c.HOUR)
                         + ":" + c.get(c.MINUTE) + ":"
                         + c.get(c.SECOND));
    iPut("------------------ Debug " + d + " -----------------"); 
    iFlush();
    }

public void put(String s)
    {
    guard.synch(myOID, true, 120);
    iPut(s);
    guard.synch(myOID, false, 120);	
    }

/** internalization of put sine guard. */
private void iPut(String s)
    {
    try { if(dfile != null) dfile.println(s); }
    catch(Exception e) {}
    }


/** Put to a dumpbuffer 
*** @param s input string.
*** @param db the dump buffer.
**/
public void put(String s, jdbcMysqlDumpBuffer db) { db.put(s); }

/** Put a dumpbuffer to the dumpfile.
*** param db The dumpBuffer.
**/
public void put(jdbcMysqlDumpBuffer db)
    {
    guard.synch(myOID, true, 120);
    try { iPut(db); }
    catch(Exception e) {}
    guard.synch(myOID, false, 120);
    }

private void iPut(jdbcMysqlDumpBuffer db)
    {
    String s = db.get();
    while(s != null)
        {
        iPut(s);
        s = db.get();
        }
    iFlush();
    }


/** A hard flush closes and reopends (for append) the debug file. 
*** this is mostly because in some implementations (linux!) d
*** files don't really get written until closed.  This makes it
*** resource intensive, but you don't use debug in a live app
*** anyway.
**/ 
public void flush()
    {
    guard.synch(myOID, true, 120);
    iFlush();
    guard.synch(myOID, false, 120);
    }

/** Internal version of flush, sine synch mutex. */
private void iFlush()
    {
    if(dfile == null) return;
    dfile.close();
    open();
    }

private void open()
    {
    if(fileName != null)
        {
        try { 
            dfile = new PrintWriter(
                    new FileOutputStream(fileName, true)
                                   );
            }
        catch(IOException e) 
            {
            dfile = null; fileName = null; 
            }
        }
    }

/** Dump part of a byte array in hex format. Flushes the debug file
*** when done.
*** @param b The array to be dumped.
*** @param start the offset in the array at which to begin.
*** @param len the length to dump.
**/
public void dump(byte[] b, int start, int len)
    {
    guard.synch(myOID, true, 120);
    try { iDump(b, start, len, null); }
    catch(Exception e) {}
    guard.synch(myOID, false, 120);
    }


/** Dump part of a byte array in hex format to a dumpbuffer.
*** @param b The array to be dumped.
*** @param start the offset in the array at which to begin.
*** @param len the length to dump.
*** @param db the dumpBuffer.
**/
public void dump(byte[] b, int start, int len, jdbcMysqlDumpBuffer db)
    {
    if(db == null) return;
    try { iDump(b, start, len, db); }
    catch(Exception e) {}
    }


private void iDump(byte[] b, int start, int len, jdbcMysqlDumpBuffer db)
    {
    jdbcMysqlDumpBuffer xdb;
    if(db == null) xdb = new jdbcMysqlDumpBuffer();
    else xdb = db;
    int left = len;
    int at = start;
    int i, t, u;
    String pos, hex, ch, p;
    while(left > 0)
        {
        p = new String("........" + at);
	pos  = p.substring(p.length()-8, p.length());
        StringBuffer xsb = new StringBuffer(48);
        StringBuffer csb = new StringBuffer(18);
        csb.append('|');
        for(i = 0; i < 16; i++)
            {
            if(left > 0)
                {
                t = b[at]; if(t < 0) t += 256;
                u = (( t & 240 ) >> 4);
                xsb.append(hexlist.charAt(u));
                u = t & 15;
                xsb.append(hexlist.charAt(u));
                xsb.append(' ');
                if(printable.indexOf(t) > -1) csb.append((char)t);
                else csb.append('.');
                }
            else 
                {
                xsb.append(' ').append(' ').append(' ');
                csb.append(' ');
                }
            at++;
            left--;
            }
        csb.append('|');
        hex = new String(xsb);
        ch  = new String(csb); 
        xdb.put(pos + " " + hex + " " + ch);
        }
    if(db == null) iPut(xdb);
    }

/** Try to close the file at shutdown.  Unfortunately this doesn't
*** work in the linux implementation.
**/

protected void finalize()
   {
   if(dfile != null) dfile.close();
   }
}
