/**
*** Program jdbcMysqlDriver.java
***    in product twz1jdbcForMysql, 
***    Copyright 1997, 1998 by Terrence W. Zellers.
***   
***  All rights explicitly reserved.
***
***  See file "LICENSE" in this package for conditions of use.
**/

/**
*** Overambitious attemt to write a JDBC driver for MySQL.
**/

package twz1.jdbc.mysql;

import java.lang.String;
import java.sql.*;
import java.util.Properties;
import java.util.Vector;
import twz1.jdbc.mysql.jdbcMysqlConnex;
import twz1.jdbc.mysql.jdbcMysqlURL;
import twz1.jdbc.mysql.jdbcMysqlBase;

//*********************************************************************
//          The Driver class is internally known as jdbcMysqlDriver.
//*********************************************************************

public final class jdbcMysqlDriver implements Driver
{
/** Self instantiation */
static { new jdbcMysqlDriver(); }

/** Keep track of connections, just in case we are interested. */
static Vector connections;

/** Locate defaults */
static jdbcMysqlBase mysql;

//----------- Constructor for the class, without parameters. -----------

public jdbcMysqlDriver() 
    {
    this.connections = new Vector();
    this.mysql = new jdbcMysqlBase(this);
    try { DriverManager.registerDriver(this); }
    catch(SQLException se) 
       {
       System.out.println(
          "Error registering twz1.jdbc.mysql Driver\n" + se
                         );
       }
    }

//----------- Report our sad lack of full compliancy as yet. -----------
 
public boolean jdbcCompliant() { return false; } // So far.

//------------------------ Like it says ... ----------------------------

public int getMajorVersion() { return 1; }
public int getMinorVersion() { return 0; }

//----------------------------- Test a url -----------------------------

public boolean acceptsURL(String url)
    {
    jdbcMysqlURL testurl = new jdbcMysqlURL(url);
    return testurl.isValid();
    }

//----------------------- Get properties from url ----------------------

public DriverPropertyInfo[] 
        getPropertyInfo(String url, Properties info)
        throws SQLException
    {
    jdbcMysqlURL testurl = new jdbcMysqlURL();
    testurl.innovate(info);
    jdbcMysqlURL newurl =  new jdbcMysqlURL(url, false);
    testurl.innovate(newurl);
    
    String names[] = testurl.getNames();
    String result;
    int ns = names.length;
    DriverPropertyInfo[] di = new DriverPropertyInfo[ns];
    
    for(int i = 0; i < ns ; i++)
        {
        result = testurl.getProperty(names[i]);
        di[i]  = new DriverPropertyInfo(names[i], result);
        }
    return di;
    } 
   
public Connection connect(String url, Properties info)
        throws SQLException
    {
    jdbcMysqlURL baseURL = new jdbcMysqlURL();
    baseURL.innovate(info);
    jdbcMysqlURL newurl = new jdbcMysqlURL(url, false);
    baseURL.innovate(newurl);
    newurl = null;
 
    jdbcMysqlConnex cx = new jdbcMysqlConnex(baseURL);
    return cx;
    }

}

