/**
*** Program jdbcMysqlMutex.java
***    in product twz1jdbcForMysql, 
***    Copyright 1997, 1998 by Terrence W. Zellers.
***   
***  All rights explicitly reserved.
***
***  See file "LICENSE" in this package for conditions of use.
**/

/**
*** Implementation of mutices to protect objects required to be
*** single threaded.
***
**/


package twz1.jdbc.mysql;

import twz1.jdbc.mysql.jdbcMysqlBase;
import twz1.jdbc.mysql.jdbcMysqlDebug;

/** Mutex implementation class. */
final class jdbcMysqlMutex
{

/** Consumer */
int consumer;
int wcount;

static final int C_LOCK  = 0;
static final int C_TEST  = 1;
static final int C_WHO   = 2;
static final int R_LOCKED      = 0;
static final int R_TIMEOUT     = 1;
static final int R_INTERRUPTED = 2;
static final int R_UNLOCKED    = 3;
static final int R_NOTOWNER    = 4;
static final int R_BADCMD      = 5;

/** Constructor. */
jdbcMysqlMutex() {consumer = -1; wcount = 0;}
 
 
/** Invoke a permanent synchronization on this mutex.
*** @param lock lock if true, release mutex if false.
**/
synchronized int synch(int whom, boolean lock, int timeout) 
    {
    if(lock)
        {
        if(consumer == -1 && wcount == 0) 
            {
            consumer = whom;
            return R_LOCKED; 
            }
        try {
            wcount++;
            if(timeout > -1)wait(timeout * 1000);
            wcount--;
            if(consumer > -1) return R_TIMEOUT;
            consumer = whom;
            return R_LOCKED;
            }
        catch(InterruptedException e)
            {
            wcount--;
            jdbcMysqlDebug DEBUG = jdbcMysqlBase.getDebug();
            if(DEBUG != null)
               DEBUG.put("ZZN0200 Thread interrupted " + e);
            return R_INTERRUPTED;
            }           
        }
    else 
        {
        if(whom == consumer)
            {
            consumer = -1;
            if(wcount > 0)notify();
            return R_UNLOCKED;  
            }
        return R_NOTOWNER;              
        }
    //    return R_BADCMD;
    }
}
