
import twz1.jdbc.mysql.*;
import java.sql.*;
import java.lang.String;
import java.util.Random;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.Vector;
public class jdbctest3
{

public static void main(String[] arg)
    {
    new jdbctest3();
    }

jdbctest3()
    {
    int xrc;
    String ws1, ws2, ws3, ws4, ws5;
    boolean brc;

//-------------------------------------------------------------

    header("Loading Driver");

    try {
        Class.forName("twz1.jdbc.mysql.jdbcMysqlDriver");
        }
    catch(Exception e){System.out.println(e);}


//-------------------------------------------------------------
//------------------------------------------------------------
//------------------------------------------------------------ 

    header("The following connex will succeed");

    Connection cx = null;
    String url = "jdbc:z1MySQL:";
    try {
        cx = DriverManager.getConnection(url, "testuser", "testpass");
        System.out.println("catalog :" + cx.getCatalog());
        }
    catch(SQLException se){System.out.println(se);} 
  
//------------------------------------------------------------
  
    header("Setting catalog to jdbctest");

    try {
        cx.setCatalog("jdbctest");
        String s = cx.getCatalog();
        System.out.println("Catalog is now " + s);
        }
    catch(Exception e) { System.out.println(e); }
 
//------------------------------------------------------------ 
     header("test multiple query");
     try{ 
        boolean mc = jdbcMysqlBase.isMultipleQuery((jdbcMysqlConnex) cx);
        System.out.println("Is connection multiple query: " + mc);
        }
    catch(Exception e) { System.out.println(e); }
    
//------------------------------------------------------------ 
//------------------------------------------------------------

    DatabaseMetaData dbmd = null;
    try { dbmd = cx.getMetaData(); }
    catch(Exception e){ e.printStackTrace(); }


// -------------------------------------------------------------------

    header("creating books table with single primary key");   
    try {
        Statement st = cx.createStatement();
        st.executeUpdate( "create table books (rownum int not null"
                        +   " auto_increment, bname text not null,"
                        +   " author text not null, pubdate int not null,"
                        +   " isbn char(20) not null, price decimal(6,2),"
                        +   " primary key(isbn), unique(rownum))" ); 

        }
    catch(Exception e) { e.printStackTrace(); }

    header("Loading table via inserts");

    try {
        Statement st = cx.createStatement();
        xrc = st.executeUpdate( "insert into books values(0, 'Essential System Administration', 'Frisch', 1993, '0-937175-80-3', 29.95)");
        System.out.println("Returns " + xrc);
        System.out.println("Last insert id " + jdbcMysqlBase.getLastInsertID(st));
        xrc = st.executeUpdate( "insert into books values(65535, 'C, the Complete Reference',  'Schildt', 1987, '0-07-881263-1', 24.95)");
        System.out.println("Returns " + xrc);
        System.out.println("Last insert id " + jdbcMysqlBase.getLastInsertID(st));
        xrc = st.executeUpdate( "insert into books values(0, 'Teach Yourself C++',  'Stevens', 1993, '1-55828-250-5', 29.95)");
        System.out.println("Returns " + xrc);
        System.out.println("Last insert id " + jdbcMysqlBase.getLastInsertID(st));
        xrc = st.executeUpdate( "insert into books values(0, 'Operating Systems, Design and Implementation',  'Tanenbaum', 1987, '0-13-637406-9', 59.95)");
        System.out.println("Returns " + xrc);
        System.out.println("Last insert id " + jdbcMysqlBase.getLastInsertID(st));
        st.close();
        }
    catch(Exception e) { e.printStackTrace(); }

    showkeys(dbmd, "jdbctest", "books");
    droptable(cx, "books");
 
 
// -----------------------------------------------------------------
    header("creating books table with no key");   
    try {
        Statement st = cx.createStatement();
        st.executeUpdate( "create table books (rownum int not null"
                        +   " , bname text not null,"
                        +   " author text not null, pubdate int,"
                        +   " isbn char(20) not null, price decimal(6,2))"
                        );   
        }
    catch(Exception e) { e.printStackTrace(); }

    showkeys(dbmd, "jdbctest", "books");
    droptable(cx, "books");

// -------------------------------------------------------------------

    header("creating books table with 3 element primary key");   
    try {
        Statement st = cx.createStatement();
        st.executeUpdate( "create table books (rownum int not null"
                        +   " ,  bname varchar(40) not null,"
                        +   " author varchar(40) not null,"
                        +   " pubdate int not null,"
                        +   " isbn char(20) not null, price decimal(6,2),"
                        +   " primary key(bname, author, pubdate) )" ); 

        }
    catch(Exception e) { e.printStackTrace(); }


    showkeys(dbmd, "jdbctest", "books");
    droptable(cx, "books");

// -------------------------------------------------------------------

    header("creating books table with primary key in order");   
    try {
        Statement st = cx.createStatement();
        st.executeUpdate( "create table books (rownum int not null"
                        +   " , bname varchar(40) not null,"
                        +   " author varchar(40) not null,"
                        +   " pubdate int not null,"
                        +   " isbn char(20) not null, price decimal(6,2),"
                        +   " primary key(author, bname, pubdate) )" ); 

        }
    catch(Exception e) { e.printStackTrace(); }

    showkeys(dbmd, "jdbctest", "books");
    droptable(cx, "books");

 
//---------------------------------------------------------------

//---------------------------------------------------------------

    header("closing connection");

    try { cx.close(); }
    catch(SQLException se){System.out.println(se);}
      
    }


void droptable(Connection cx, String tab)
    {
    int xrc;
    header("Dropping  " + tab);
    try {
        Statement st = cx.createStatement();
        xrc = st.executeUpdate( "drop table " + tab);
        st.close();
        System.out.println("drop " + tab + " returns " + xrc);
        }
    catch(Exception e) { e.printStackTrace(); }
    }

void showkeys(DatabaseMetaData dbmd,  String cat, String tab)
    {
    ResultSet rs;
    header("Showing keys in " + tab + " in " + cat + "."); 
    System.out.println("------------ Primary key ----------");  
    try {
        rs = dbmd.getPrimaryKeys(cat, null, tab);
        int rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println(" name " + rs.getString(4) 
                   + "   seq " + rs.getString(5));
            }
        System.out.println(rows +  " rows.");

        }
    catch(Exception e) { e.printStackTrace(); }

    System.out.println("------------ best row  ----------");  
    try {
        rs = dbmd.getBestRowIdentifier(cat, null, tab, 0, true);
        int rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println( rs.getString(2) + " " + rs.getString(3) + " "
                              + rs.getString(4) + " " + rs.getString(5) + " "  
                              + rs.getString(8));
            }
        System.out.println(rows +  " rows.");

        }
    catch(Exception e) { e.printStackTrace(); }

    System.out.println("------------ index info ----------");  
    try {
        rs = dbmd.getIndexInfo(cat, null, tab, false, false);
        int rows = 0;
        while(rs.next())
            {
            rows++;
            System.out.println( rs.getString(1) + " " + rs.getString(3) + " "
                              + rs.getString(4) + " " + rs.getString(6) + " "  
                              + rs.getString(7) + " " + rs.getString(8) + " "  
                              + rs.getString(9) + " " + rs.getString(10) + " " 
                              + rs.getString(11));

            }
        System.out.println(rows +  " rows.");

        }
    catch(Exception e) { e.printStackTrace(); }
    }

//---------------------------------------------------------------
//---------------------------------------------------------------

void header(String h)
    {
    String bl = "-----------------------------------";
    String sl = "                                   ";
    bl = new String("+" + bl + bl + "+");
    System.out.println("\n");
    System.out.println(bl);
    String rl = h;
    String tl;
    int i, j, k;
    while(rl != null)
        {
        if(rl.length() > 60)
            {
            tl = rl.substring(0, 60);
            rl = rl.substring(60);
            }
        else { tl = rl; rl = null; }
        k = ( 71 - tl.length() ) / 2;
        tl = new String(sl.substring(0, k) + tl + sl.substring(0, k));
        while(tl.length() > 70) tl = tl.substring(1);
        tl = new String("|" + tl + "|");
        System.out.println(tl);
        }
    System.out.println(bl);
    System.out.println("");
    }

}












