
CREATE TABLE dict (
       word                 VARCHAR2(32) NOT NULL,
       url_id               NUMBER(12) NOT NULL,
       intag                NUMBER(2) NOT NULL
)
       PCTFREE 5
       PCTUSED 95
;


ALTER TABLE dict
       ADD  ( PRIMARY KEY (word, url_id) ) ;


CREATE TABLE robots (
       hostinfo             VARCHAR2(127) NOT NULL,
       path                 VARCHAR2(127) NOT NULL
);


CREATE TABLE stopword (
       word                 CHAR(64) NOT NULL
,
       lang                 CHAR(2) NOT NULL
);


ALTER TABLE stopword
       ADD  ( PRIMARY KEY (word, lang) ) ;


CREATE TABLE url (
       rec_id               NUMBER(12) NOT NULL,
       status               NUMBER(6) DEFAULT 0 NOT NULL,
       url                  VARCHAR2(128) NOT NULL,
       content_type         VARCHAR2(64) NULL,
       title                VARCHAR2(128) NULL,
       txt                  VARCHAR2(255) NULL,
       docsize              NUMBER(12) NULL,
       last_index_time      NUMBER(12) NULL,
       next_index_time      NUMBER(12) NULL,
       last_mod_time        NUMBER(12) NULL,
       referrer             NUMBER(12) DEFAULT 0 NOT NULL,
       tag                  VARCHAR(10) NULL,
       hops                 NUMBER(6) DEFAULT 0 NOT NULL,
       category             VARCHAR2(10) NULL,
       keywords             VARCHAR2(255) NULL,
       description          VARCHAR2(100) NULL,
       crc32                
NUMBER(12) NULL,
       lang		    CHAR(2) NULL
)
       PCTFREE 5
       PCTUSED 95
;

CREATE UNIQUE INDEX XAK1url ON url
(
       url                            ASC
);

CREATE INDEX XIE1url ON url
(
       crc32                          ASC
);

CREATE INDEX rec_id_ind ON url
(
       rec_id			
);

CREATE INDEX next_index_time_ind ON url
(
       	next_index_time
);


CREATE SEQUENCE next_url_id
   INCREMENT BY 1
   START WITH 1;


