#ifndef _UDM_INDEXER_H
#define _UDM_INDEXER_H

/* Some sizes and others definitions */
#define UDM_MAXDOCSIZE			1024*1024  /* 1Mb */
#define UDM_MAXWORDSIZE			32
#define UDM_DEFAULT_REINDEX_TIME	7*24*60*60
#define UDM_DEFAULT_MAX_HOPS		256
#define UDM_READ_TIMEOUT		90
#define UDM_MAXNETERRORS		16
#define UDM_MAXTITLESIZE		128
#define UDM_MAXKEYWORDSIZE		255
#define UDM_MAXDESCSIZE			100

#ifdef NEWS_EXT
#define UDM_MAXTEXTSIZE		256000
#define UDM_MAXFROMSIZE		255
#define UDM_MAXDATESIZE		50
#define UDM_MAXSUBJSIZE		1024
#define UDM_MAXGROUPSIZE	255
#define UDM_MAXREFSIZE		1024
#else
#define UDM_MAXTEXTSIZE		255
#endif

/* API fuctions to be called in main() */

extern __INDLIB__ UDM_INDEXER * UdmAllocIndexer(int handle);
extern __INDLIB__ void UdmFreeIndexer(UDM_INDEXER *Indexer);
extern __INDLIB__ void UdmSetAction(UDM_INDEXER *Indexer,int action);
extern __INDLIB__ char * UdmIndexerErrorMsg(UDM_INDEXER *Indexer);
extern __INDLIB__ int  UdmIndexNextURL(UDM_INDEXER * Indexer,int index_flags);
extern __INDLIB__ int  UdmClearDatabase(UDM_INDEXER *Indexer);
extern __INDLIB__ void UdmAddURLFile(char *name);
extern __INDLIB__ int  UdmURLFile(UDM_INDEXER *Indexer, int action);
extern __INDLIB__ void UdmSetMaxURLNumber(int n);
extern __INDLIB__ int  UdmGetIndexedNumber();

#endif
