#include "udm_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "udm_common.h"
#include "udm_robots.h"
#include "udm_spell.h"
#include "udm_db.h"
#include "udm_utils.h"
#include "udm_mutex.h"


UDM_ROBOT* Robots=NULL;

int UdmFreeRobots(UDM_INDEXER *Indexer){
UDM_ROBOT *r;
	if(LockProc)LockProc(UDM_LOCK,UDM_LOCK_ROBOTS);
	if(!Robots){
		if(LockProc)LockProc(UDM_UNLOCK,UDM_LOCK_ROBOTS);
		return(0);
	}
	r=Robots;
	while(r->hostinfo){
		free(r->hostinfo);
		free(r->path);
		r++;
	}
	UDM_FREE(Robots);
	if(LockProc)LockProc(UDM_UNLOCK,UDM_LOCK_ROBOTS);
	return(0);
}
int UdmFindRobots(UDM_INDEXER *Indexer,char *url){
UDM_ROBOT *r;
int i;
	if(LockProc)LockProc(UDM_LOCK,UDM_LOCK_ROBOTS);
	if(Robots){
		r=Robots;i=0;
		while(r->hostinfo){
			if(strstr(url,r->hostinfo)&&strstr(url,r->path)){
				if(LockProc)LockProc(UDM_UNLOCK,UDM_LOCK_ROBOTS);
				return(i);
			}
			i++;r++;
		}
	}
	if(LockProc)LockProc(UDM_UNLOCK,UDM_LOCK_ROBOTS);
	return(-1);
}
int UdmParseRobots(UDM_INDEXER *Indexer,char *content,char *hostinfo){
	int myrule=0;
	char *s,*e,*lt;

	UdmDeleteRobotsFromHost(Indexer,hostinfo);
	s=UdmGetToken(content,"\r\n",&lt);
	while(s){
		if(*s=='#'){
		}else
		if(!(UDM_STRNCASECMP(s,"User-Agent"))){
			if(strstr(s,UDM_USER_AGENT))myrule=1;
			else
			if(strstr(s,"*"))myrule=1;
			else
				myrule=0;
		}else
		if((!(UDM_STRNCASECMP(s,"Disallow")))&&(myrule)){
			if((e=strchr(s+9,'#')))*e=0;
			e=s+9;UDM_SKIP(e," \t");s=e;
			UDM_SKIPN(e," \t");*e=0;
			if(*s){
				if(IND_ERROR==UdmAddRobotsToHost(Indexer,hostinfo,s))
					return(IND_ERROR);
			}
		}
		s=UdmGetToken(NULL,"\n\r",&lt);
	}
	return(IND_OK);
}
