#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <ctype.h>

#include "udm_config.h"
#include "udmsearch.h"

/* FIXME Why so many includes here? */

#include "udm_search_tl.h"
#include "udm_socket.h"
#include "udm_http.h"
#include "udm_xmalloc.h"


#if (WIN32|WINNT)
#define udm_mutex_t		CRITICAL_SECTION
#define InitMutex(x)		InitializeCriticalSection(x)
#define DestroyMutex(x)	DeleteCriticalSection(x)
#define UDM_MUTEX_LOCK(x)	EnterCriticalSection(x)
#define UDM_MUTEX_UNLOCK(x)	LeaveCriticalSection(x)
#else
#include <unistd.h>
#include <pthread.h>
#ifdef HAVE_PTHREAD
#define udm_mutex_t		pthread_mutex_t
#define InitMutex(x)		pthread_mutex_init(x,NULL)
#define DestroyMutex(x)	pthread_mutex_destroy(x)
#define UDM_MUTEX_LOCK(x)	pthread_mutex_lock(x)
#define UDM_MUTEX_UNLOCK(x)	pthread_mutex_unlock(x)
#else
#define udm_mutex_t		int
#define InitMutex(x)		*(x)=0
#define DestroyMutex(x)
#define UDM_MUTEX_LOCK(x)
#define UDM_MUTEX_UNLOCK(x)
#endif
#endif

#ifdef HAVE_PTHREAD
udm_mutex_t iurl_mut;
#endif


#define NO_TITLE	"No title"
#define MAX_PS		100
#define DEFAULT_PS	20

#define T_STEP		100
#define T_UNKNOWN	 0
#define T_TOP		 1
#define T_BOT		 2
#define T_RESTOP	 3
#define T_RESBOT	 4
#define T_RESULT	 5
#define T_ERROR		 6
#define T_NOTFOUND	 7
#define T_CLONE		 8
#define T_NAVIGATOR	 9
#define T_NAVLEFT	10
#define T_NAVBAR0	11
#define T_NAVBAR1	12
#define T_NAVRIGHT	13
#define T_INCLUDE	14
#define T_NAVLEFT_NOP	15
#define T_NAVRIGHT_NOP	16
#define T_NOQUERY	17
#define T_MAX		18

char Targ[UDMSTRSIZ*16]="";
char *query_words=NULL;
char ul_str[UDMSTRSIZ]="";
int sort_order=UDM_ORD_RATE;
int search_mode=UDM_MOD_ALL;
int iurl_udm_recursion=0;

struct buf_s {
	char *buf;
	int buf_len;
}buf_out;


#define MAX_URL_INCLUDE	25
struct url_include_s {
	int status;
	int visible;
	int where;
	int ntempl;
#ifdef HAVE_PTHREAD
	pthread_t url_pth;
#endif
	char *buf;
	char *url;
	int offset;
}url_include[MAX_URL_INCLUDE];
static int cur_iurl=-1;

static int lastt[T_MAX] = {
	0,
	T_TOP*T_STEP,
	T_BOT*T_STEP,
	T_RESTOP*T_STEP,
	T_RESBOT*T_STEP,
	T_RESULT*T_STEP,
	T_ERROR*T_STEP,	
	T_NOTFOUND*T_STEP,
	T_CLONE*T_STEP,
	T_NAVIGATOR*T_STEP,
	T_NAVLEFT*T_STEP,
	T_NAVBAR0*T_STEP,
	T_NAVBAR1*T_STEP,
	T_NAVRIGHT*T_STEP,
	T_INCLUDE*T_STEP,
	T_NAVLEFT_NOP*T_STEP,
	T_NAVRIGHT_NOP*T_STEP,
	T_NOQUERY*T_STEP
};
#define TEMPL(x)	(((lastt[x]-x*T_STEP)>format)?x*T_STEP+format:lastt[x]-1)

typedef struct var_struct{
	char *name;
	char *value;
} TVAR;

typedef struct template_struct{
	int where;
	char *str;
} TEMPLATE;

typedef struct dict_struct {
	char lang[3];
	char * path;
} DICT;

#define MAXTEMPLATE 1024
static TEMPLATE Template[MAXTEMPLATE];
static int ntempl=0;
static void * db;

#define MAXVARIABLE	32
TVAR Variables[MAXVARIABLE];
int nVar=0;

#define MAXRANDOM 128
int Randoms[MAXRANDOM];

#define MAXDICT 128
DICT Dict[MAXDICT];
int dict_num=0;

/* Template variables */
static char error[BUFSIZ]="";
static char wordinfo[UDMSTRSIZ]="";
static char href[UDMSTRSIZ]="";
static char fullhref[UDMSTRSIZ]="";
static char *query_form_escaped=NULL;
static char *query_url_escaped=NULL;
udmcrc32_t crc32=0;
static char self[UDMSTRSIZ]="";
static char *title=0;
static char *text=0;
static char *descr=0;
static char *keywords=0;
static int size=0;
static int rating=0;
static int url_id, docnum, first=0, last=0, found=0;
static int num_pages=0, navpage=0, ps=0, pps=10, np=0, is_next=0;
static int format=0, use_clones=1;
static char *mode=NULL;
static char *sort=NULL;
static char *ul_unescaped=NULL;
static int LCharset=UDM_CHARSET_NO;
static char * ttag=NULL;
static char * category=NULL;
static int track=0;

/* time limit vars - needed in PrintOneTemplate */
char *dt_s=NULL, *dp_s=NULL;
char *dx_s=NULL, *dm_s=NULL;
char *dd_s=NULL, *dy_s=NULL;
char *db_s=NULL, *de_s=NULL;

void *get_remote_result(void *ind);
int get_ind_by_url(char *url, int where, int ntempl);
int get_ind(void);

int AddVariable(char *name,char *value){
	if(nVar<MAXVARIABLE){
		Variables[nVar].name=strdup(name);
		Variables[nVar].value=strdup(value);
		nVar++;
		return(0);
	}
	return(1);
}

char LightWords[UDMSTRSIZ]="";

char * hilightcpy(char *dst,char *src, char *w_list, char *start,char *stop){
char *s,*t,*word;
char real_word[64]="";

	word=s=src;
	t=dst;*t=0;
	while(*s){
		if(!UdmWordChar(*s,LCharset)||!(*(s+1))){
			if(word<s){
				char save=0;
				if(*(s+1)){
					save=*s;
					*s=0;
				}
				real_word[0]=' ';
				strncpy(real_word+1,word,sizeof(real_word)-3);
				strcpy(real_word+strlen(real_word)," ");
				UdmTolower(real_word,LCharset);
				if(strstr(w_list,real_word)){
					sprintf(t,"%s%s%s",start,word,stop);
					t=t+strlen(t);
				}else{
					strcpy(t,word);
					t+=strlen(word);
				}
				if(*(s+1)){
					*s=save;
				}
			}
			if(*(s+1)){
				*t=*s;
				t++;
				*t=0;
			}
			word=s+1;
		}
		s++;
	}
	return(dst);
}


int LoadTemplate(char *name, char *query, int default_where){
FILE *file;
int where=0,variables=0;
char *s,*lasttok=NULL;
char str[BUFSIZ];
char first_letters[128]="";

	file=fopen(name,"r");
	if(!file)return(1);
	where=default_where;

	/* Init for the case when there is no  */
	/* LocalCharset definition in template */
	LCharset=UdmGetDefaultCharset();

	while((fgets(str,sizeof(str),file))&&(ntempl<MAXTEMPLATE)){
		if(!UDM_STRNCMP(str,"<!--top-->"))	where=lastt[T_TOP]++;
		else
		if(!UDM_STRNCMP(str,"<!--bottom-->"))	where=lastt[T_BOT]++;
		else
		if(!UDM_STRNCMP(str,"<!--restop-->"))	where=lastt[T_RESTOP]++;
		else
		if(!UDM_STRNCMP(str,"<!--resbot-->"))	where=lastt[T_RESBOT]++;
		else
		if(!UDM_STRNCMP(str,"<!--res-->"))	where=lastt[T_RESULT]++;
		else
		if(!UDM_STRNCMP(str,"<!--notfound-->"))	where=lastt[T_NOTFOUND]++;
		else
		if(!UDM_STRNCMP(str,"<!--error-->"))	where=lastt[T_ERROR]++;
		else
		if(!UDM_STRNCMP(str,"<!--clone-->"))	where=lastt[T_CLONE]++;
		else
		if(!UDM_STRNCMP(str,"<!--navigator-->"))	where=lastt[T_NAVIGATOR]++;
		else
		if(!UDM_STRNCMP(str,"<!--navleft-->"))	where=lastt[T_NAVLEFT]++;
		else
		if(!UDM_STRNCMP(str,"<!--navbar1-->"))	where=lastt[T_NAVBAR1]++;
		else
		if(!UDM_STRNCMP(str,"<!--navbar0-->"))	where=lastt[T_NAVBAR0]++;
		else
		if(!UDM_STRNCMP(str,"<!--navright-->"))	where=lastt[T_NAVRIGHT]++;
		else
		if(!UDM_STRNCMP(str,"<!--navleft_nop-->"))	where=lastt[T_NAVLEFT_NOP]++;
		else
		if(!UDM_STRNCMP(str,"<!--navright_nop-->"))	where=lastt[T_NAVRIGHT_NOP]++;
		else
		if(!UDM_STRNCMP(str,"<!--noquery-->"))	where=lastt[T_NOQUERY]++;
		else
		if(!UDM_STRNCMP(str,"<!--/top-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/bottom-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/restop-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/resbot-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/res-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/notfound-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/error-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/clone-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--variables")){
			where=default_where;
			variables=1;
		}else
		if(!UDM_STRNCMP(str,"<!--/navigator-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navleft-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navbar1-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navbar0-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navright-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navleft_nop-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/navright_nop-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"<!--/noquery-->"))	where=default_where;
		else
		if(!UDM_STRNCMP(str,"-->")){	
			if(variables){
				where=default_where;
				variables=0;
			}
		}else{
			Template[ntempl].where=where;
			Template[ntempl].str=strdup(str);
			ntempl++;
#ifdef HAVE_PTHREAD				    
			if(!strncasecmp(str,"$iurl(", 6) && !iurl_udm_recursion){
				char *ch;
				int len;
				
				if(!(ch=strchr(str,')')))
					continue;
				if (TEMPL(T_RESULT) == where)
					continue;
				if ((len = ch-str-6)<1)
					continue;
				UDM_MUTEX_LOCK(&iurl_mut);
				cur_iurl++;
				UDM_MUTEX_UNLOCK(&iurl_mut);
				if (cur_iurl<MAX_URL_INCLUDE){
            				url_include[cur_iurl].status = 1;
            				url_include[cur_iurl].where = where;
            				url_include[cur_iurl].ntempl = ntempl-1;
				    	url_include[cur_iurl].url = UdmXmalloc(len+1);
					udm_snprintf(url_include[cur_iurl].url, len+1, "%s", str+6);
					pthread_create(&(url_include[cur_iurl].url_pth), NULL, 
							    &get_remote_result, (void*)cur_iurl);
					
				}
			}else
#endif
			if((variables)&&(s=UdmGetToken(str,"\r\n",&lasttok))){
				if(!UDM_STRNCASECMP(str,"DBAddr"))
					UdmSetDBAddr(UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"DBMode"))
					UdmSetDBMode(UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"DBHost"))
					DBHost=strdup(UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"DBName"))
					DBName=strdup(UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"DBUser"))
					DBUser=strdup(UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"DBPass"))
					DBPass=strdup(UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"DBPort"))
					DBPort=atoi(UdmTrim(str+6,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"ResultsPerPage"))
					ps=atoi(UdmTrim(str+14,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"PagesPerScreen"))
					pps=atoi(UdmTrim(str+14,"= \t\r\n"));
				else
				if(!UDM_STRNCASECMP(str,"Clones")){
					if(!UDM_STRNCASECMP(UdmTrim(str+6,"= \r\t\n"),"no"))
						use_clones=0;
					else
						use_clones=1;
				}else
				if(!UDM_STRNCASECMP(str,"TrackQuery")){
					if(!UDM_STRNCASECMP(UdmTrim(str+10,"= \r\t\n"),"no"));
					else
						track|=UDM_TRACK_QUERIES;
				}else
				if(!UDM_STRNCASECMP(str,"IspellMode")){
					if(!UDM_STRNCASECMP(UdmTrim(str+10,"= \r\t\n"),"db")) 
					     ispell_mode=UDM_ISPELL_MODE_DB;
					else ispell_mode=UDM_ISPELL_MODE_TEXT;
				}else
				if(!UDM_STRNCASECMP(str,"LocalCharset")){
					LCharset=UdmGetCharset(UdmTrim(str+12,"= \r\t\n"));
					UdmSetDefaultCharset(LCharset);
				}else
				if(!UDM_STRNCASECMP(str,"R")){
					int i,j;
					float frand;
					i=atoi(str+1);
					s=str+1;
					while((*s)&&(isdigit(*s)))s++;
					j=atoi(UdmTrim(s,"= \t\r\n"));
					if((i>0)&&(i<MAXRANDOM)){
						frand=rand();
						frand=frand/RAND_MAX*j;
						Randoms[i]=frand;
					}
				}else
				if(!UDM_STRNCASECMP(str,"Affix")){
					char lang[20]="";char str1[UDMSTRSIZ]="";
					if((query) && (ispell_mode==UDM_ISPELL_MODE_TEXT))
					if(sscanf(str+5,"%s%s",lang,str1)){
						if(*str1=='/')strcpy(str,str1);
						else	sprintf(str,"%s/%s",UDM_CONF_DIR,str1);
						UdmImportAffixes(lang,str,NULL,0);
					}
				}else
				if(!UDM_STRNCASECMP(str,"Spell")){
					char lang[20]="";
					char str1[UDMSTRSIZ]="";
					if(ispell_mode==UDM_ISPELL_MODE_TEXT)
					if(sscanf(str+5,"%s%s",lang,str1)){
						if(*str1=='/')strcpy(str,str1);
						else	sprintf(str,"%s/%s",UDM_CONF_DIR,str1);
						strncpy(Dict[(int)dict_num].lang,lang,2);
						Dict[(int)dict_num].lang[2]=0;
						Dict[(int)dict_num].path=strdup(str);
						dict_num++;
					}
				}
			}
		}
	}
	fclose(file);
	if(query){
		char *w, *lasttok;
		int i;
		/* If the query is specified we'll compose     */
		/* a string with first letters of every        */
		/* word. It will allow fast Ispell dictionary  */
		/* loading. We'll also compose string          */
		/* with light words and tolower query.         */
		/* As far as search is case insensitive        */
		/* the first thing to do is lo-case query      */
	
		UdmTolower(query,LCharset);
		strcpy(str,query);
		w=UdmGetWord(str,&lasttok, LCharset);
		while(w){
			int len;
			/* Add first letter */
			len=strlen(first_letters);
			first_letters[len]=w[0];
			first_letters[len+1]=0;
			/* Make string with words to be hilighted */
			sprintf(UDM_STREND(LightWords)," %s ",w);
			w=UdmGetWord(NULL, &lasttok, LCharset);
		}
		
		if (ispell_mode == UDM_ISPELL_MODE_TEXT) {
		    for(i=0;i<dict_num;i++){
			    UdmImportDictionary(Dict[i].lang,Dict[i].path,1,first_letters);
			    free(Dict[i].path);
		    }
		    if(dict_num);
			UdmSortDictionary();
		}
	}
	return(0);
}


int PrintTemplate(char * Target,int where,char *url,char *content_type,time_t last_mod_time);

static int PrintOneTemplate(char * Target,char *s,int where,char *url,char *content_type, time_t last_mod_time, int ntempl){
UDM_DOCUMENT *r=NULL;
UDM_CATEGORY *c=NULL;
int rnum,tmp, len;
char notitle[]=NO_TITLE;
char buf[UDM_MAXTIMESTRLEN];

	*Target=0;
	while(*s){
		if((*s=='\\')&&(*(s+1)=='$')){
			sprintf(UDM_STREND(Target),"$");
			s+=2;
			continue;
		}
		if(*s!='$'){
			sprintf(UDM_STREND(Target),"%c",*s);
			s++;
			continue;
		}

		s++;
		switch(*s){
		case 'A': 
			sprintf(UDM_STREND(Target),"%s",self);
			break;
		case 'Q': sprintf(UDM_STREND(Target),"%s",query_form_escaped?query_form_escaped:"");break;
		case 'q': sprintf(UDM_STREND(Target),"%s",query_url_escaped?query_url_escaped:"");break;
		case 'E': sprintf(UDM_STREND(Target),"%s",error);break;
		case 'W': sprintf(UDM_STREND(Target),"%s",wordinfo);break;
		case 'f': sprintf(UDM_STREND(Target),"%d",first);break;
		case 'l': sprintf(UDM_STREND(Target),"%d",last);break;
		case 't': sprintf(UDM_STREND(Target),"%d",found);break;
		case 'm': sprintf(UDM_STREND(Target),"%s",mode?mode:"all");break;
		case 's': sprintf(UDM_STREND(Target),"%s",sort?sort:"rate");break;
		case 'o': sprintf(UDM_STREND(Target),"%d",format);break;
		case 'g': {
			if(s[1]=='('){
				char parent[100]="";
				char *ch;
				int level=0;
				int len;

				if(!(ch=strchr(s,')')))	continue;
				level=atoi(s+2);
				if(ttag){
					strncpy(parent,ttag,sizeof(parent)-1);
					parent[sizeof(parent)-1]=0;
				}
				len=strlen(parent)-level;
				if(len>0)parent[len]='\0';
				else	parent[0]='\0';
				sprintf(UDM_STREND(Target),"%s",parent);
					s=ch;
				}else{
					sprintf(UDM_STREND(Target),"%s",ttag?ttag:"");
				}
			break;
		}
			
		case 'r': {
			s++;
			rnum=atoi(s);
			if((rnum>=0)&&(rnum<MAXRANDOM))
				sprintf(UDM_STREND(Target),"%d",Randoms[rnum]);
			while((*s)&&(isdigit(*(s+1))))
				s++;
			break;
		}
		case 'V': {
			if(num_pages>1)
				PrintTemplate(UDM_STREND(Target),TEMPL(T_NAVIGATOR),"","",0);
			break;
		}
		case 'D':
			s++;
			switch(*s){
			case 'U':sprintf(UDM_STREND(Target),"%s",url?url:"");break;
			case 'C':sprintf(UDM_STREND(Target),"%s",content_type?content_type:"");break;
			case 'M':UdmTime_t2HttpStr(last_mod_time, buf); sprintf(UDM_STREND(Target),"%s",buf);break;
			case 'R':sprintf(UDM_STREND(Target),"%d",rating);break;
			case 'S':sprintf(UDM_STREND(Target),"%d",size);break;
			case 'N':sprintf(UDM_STREND(Target),"%d",docnum);break;

			case 'D':hilightcpy(UDM_STREND(Target),descr    ,LightWords,"<b>","</b>");break;
			case 'T':hilightcpy(UDM_STREND(Target),title[0]?title:notitle ,LightWords,"<b>","</b>");break;
			case 'K':hilightcpy(UDM_STREND(Target),keywords ,LightWords,"<b>","</b>");break;
			case 'X':hilightcpy(UDM_STREND(Target),text     ,LightWords,"<b>","</b>");break;

			default :sprintf(UDM_STREND(Target),"%c",*s);
			}
			break;

		case 'C':
			s++;
			switch(*s){
			case 'L':
			if(use_clones && crc32 && (where==T_RESULT)){
				if((r=UdmCloneList(db,crc32))){
					while(r->url_id){
						if(r->url_id!=url_id)
						PrintTemplate(UDM_STREND(Target),TEMPL(T_CLONE),r->url,r->content_type,r->last_mod_time);
						r++;
					}
				}
			}
			break;
			
			case 'P':
			if((c=UdmCatPath(db,category))){
				while(c->rec_id){
					sprintf(UDM_STREND(Target)," &gt; <A HREF=\"%s?cat=%s\">%s</A> ",
						self,c->path,c->name);
					c++;
				}
			}
			break;
			
			case 'S':
			if((c=UdmCatList(db,category))){
				while(c->rec_id){
					sprintf(UDM_STREND(Target),"<A HREF=\"%s?cat=%s\">%s%s</A><BR>",
						self,
						c->link[0]?c->link:c->path,
						c->link[0]?"@ ":"",
						c->name);
					c++;
				}
			}
			break;
			
			default : sprintf(UDM_STREND(Target),"%c",*s);
			}
			
			break;
		
		case 'N':
			s++;
			switch(*s){
			case 'L':
				if (np > 0) {
					if(np>1)sprintf(fullhref,"%s&np=%d",href,np-1);
					else strcpy(fullhref,href);
					PrintTemplate(UDM_STREND(Target),TEMPL(T_NAVLEFT),"","",0);
				}
				else {
					PrintTemplate(UDM_STREND(Target),TEMPL(T_NAVLEFT_NOP),"","",0);
				}
				break;
			case 'B':
				for(navpage = 1; navpage <= num_pages;navpage++){
					tmp = np + 1 - pps/2;
					if (tmp < 1) tmp = 1;
					if (tmp > num_pages - pps + 1)
					tmp = num_pages - pps + 1;
					if (navpage >= tmp && navpage <(tmp+pps)){
						if(navpage>1)sprintf(fullhref,"%s&np=%d",href,navpage-1);
						else strcpy(fullhref,href);
						if (np == navpage-1)
						PrintTemplate(UDM_STREND(Target),TEMPL(T_NAVBAR0),"","",0);
					else
						PrintTemplate(UDM_STREND(Target),TEMPL(T_NAVBAR1),"","",0);
					}
				}
				break;
			case 'R':
				if (is_next) {
					sprintf(fullhref,"%s&np=%d",href,np+1);
					PrintTemplate(UDM_STREND(Target),TEMPL(T_NAVRIGHT),"","",0);
				}
				else {
					PrintTemplate(UDM_STREND(Target),TEMPL(T_NAVRIGHT_NOP),"","",0);
				}
				break;
			case 'H': 
				sprintf(UDM_STREND(Target),"%s",fullhref);
				break;
			case 'P': 
				sprintf(UDM_STREND(Target),"%d",navpage);
				break;
			}
			break;
		case 'i':
		case 'I':
			if(!strncasecmp(s,"if(",3)){
				char *fname=s+3;
				
				if((s=strchr(s,')'))){
					char template[UDMSTRSIZ];
					*s=0;
					if(strlen(fname)>sizeof(template))
						fname[sizeof(template)-1]=0;
					sprintf(template,"%s%c%s", UDM_CONF_DIR,UDMSLASH,fname);
					if(LoadTemplate(template,"",lastt[T_INCLUDE])){
						sprintf(UDM_STREND(Target),"Unable to include '%s'",template);
					}else{
						PrintTemplate(UDM_STREND(Target),TEMPL(T_INCLUDE),"","",0);
						lastt[T_INCLUDE]++;
					}
				}
			}else if (!strncasecmp(s,"iurl(", 5)){
				char *ch, *url;
				if((ch=strchr(s,')'))){
					if (((len = ch-s-5)<1) || (TEMPL(T_RESULT) == where) || iurl_udm_recursion){
						s=ch;
						break;
					}
				    	url = UdmXmalloc(len+1);
					udm_snprintf(url, len+1, "%s", s+5);
#ifdef HAVE_PTHREAD
					{
						int i;
						i=get_ind_by_url(url, where, ntempl);
						if (i >= 0){
							url_include[i].offset = buf_out.buf_len+strlen(Targ);
							url_include[i].visible = 1;
						}
					}
#else
			                if (cur_iurl++ < MAX_URL_INCLUDE){
                                		url_include[cur_iurl].status = 1;
                                                url_include[cur_iurl].offset = buf_out.buf_len+strlen(Targ);
						url_include[cur_iurl].visible = 1;
            					url_include[cur_iurl].where = where;
            					url_include[cur_iurl].ntempl = ntempl;
						url_include[cur_iurl].url = UdmXmalloc(len+1);
                                                udm_snprintf(url_include[cur_iurl].url, len+1, "%s", url);
			            		get_remote_result((void*)cur_iurl);
			                }
#endif
					s=ch;
					UDM_FREE(url);
				}
			}else
				sprintf(UDM_STREND(Target),"%c",*s);
			break;
		case 'd': /* time limits vars */
			s++;
			switch(*s){
				case 't':
					sprintf(UDM_STREND(Target),"%s",dt_s?dt_s:DEFAULT_DT);
					break;
				case 'p':
					sprintf(UDM_STREND(Target),"%s",dp_s?dp_s:DEFAULT_DP);
					break;
				case 'x':
					sprintf(UDM_STREND(Target),"%s",dx_s?dx_s:DEFAULT_DX);
					break;
				case 'm':
					sprintf(UDM_STREND(Target),"%s",dm_s?dm_s:DEFAULT_DM);
					break;
				case 'd':
					sprintf(UDM_STREND(Target),"%s",dd_s?dd_s:DEFAULT_DD);
					break;
				case 'y':
					sprintf(UDM_STREND(Target),"%s",dy_s?dy_s:DEFAULT_DY);
					break;
				case 'b':
					sprintf(UDM_STREND(Target),"%s",db_s?db_s:DEFAULT_DB);
					break;
				case 'e':
					sprintf(UDM_STREND(Target),"%s",de_s?de_s:DEFAULT_DE);
					break;
			}
			break;	
		case 'p':
			s++;
			switch(*s){
				case 's':
					sprintf(UDM_STREND(Target),"%d",ps?ps:DEFAULT_PS);
					s++;
					break;
				case 'n':
					tmp = ps*np;
					sprintf(UDM_STREND(Target),"%d",tmp);
					s++;
					break;
			}
			break;
		default: 
			if(!strncmp(s,"ul",2)){
				sprintf(UDM_STREND(Target),"%s",ul_unescaped?ul_unescaped:"");
				s++;
			}else
			if(!strncmp(s,"cat",3)){
				if(s[3]=='('){
					char parent[100]="";
					char *ch;
					int level=0;
					int len;
					
					if(!(ch=strchr(s,')')))
						continue;
					level=atoi(s+4);
					if(category){
						strncpy(parent,category,sizeof(parent)-1);
						parent[sizeof(parent)-1]=0;
					}
					len=strlen(parent)-level*2;
					if(len>0)parent[len]='\0';
					else	parent[0]='\0';
					sprintf(UDM_STREND(Target),"%s",parent);

					s=ch;
				}else{
					sprintf(UDM_STREND(Target),"%s",category?category:"");
					s+=2;
				}
			}else{
			    sprintf(UDM_STREND(Target),"%c",*s);
			}
		}
		s++;
	}
	return(0);
}

int get_ind_by_url(char *url, int where, int ntempl){
int i;
	for (i=0; i<MAX_URL_INCLUDE; i++)
        	if (url_include[i].url)
			if (!strcmp(url_include[i].url, url) && 
			    (url_include[i].where == where) &&
			    (url_include[i].ntempl == ntempl))
				return i;
	return -1;
}

void *get_remote_result(void *ind){
	UDM_URL url;
	UDM_CONN *connp;
	int len,i;
	int timeout = 60;
	int maxsize = 102400;

	char header[UDMSTRSIZ]="", *body, *charset;
	char exp_url[UDMSTRSIZ]="";

	i = (int)ind;

	/* Expand $q, $pn parameters*/
	PrintOneTemplate(exp_url, url_include[i].url, 0, "", "", 0, 0);
	UdmParseURL(&url, exp_url);

	/* Support only http for now */
	if (strncmp(url.schema, "http", 4)){
		url_include[i].buf = UdmXmalloc(strlen(exp_url)+50);
		sprintf(url_include[i].buf , "$iurl() error: Bad url %s given (only http is supported)", exp_url);
		url_include[i].status = 2;
		return  NULL;
	}
	
	connp = UdmXmalloc(sizeof(UDM_CONN));

	if (http_connect(connp, url.hostname, url.port?url.port:80, timeout) == -1){
		url_include[i].buf = UdmXmalloc(strlen(url.hostname)+50);
		sprintf(url_include[i].buf , "$iurl() error: Can't connect to %s", url.hostname);
		UDM_FREE(connp);
		url_include[i].status = 2;
		return  NULL;
	}

	/*Fix me: Make HTTP header */
	udm_snprintf(header, UDMSTRSIZ, "GET %s%s HTTP/1.0\r\nHost: %s\r\n",
		url.path, url.filename, url.hostname);
        if (LCharset!=UDM_CHARSET_NO )
		if ((charset = UdmCharsetStr(LCharset)))
    			sprintf(UDM_STREND(header),"Accept-charset: %s\r\n", charset);
        strcat(header,"\r\n");

	if (socket_write(connp, header) == -1){
		socket_close(connp);
		UDM_FREE(connp);
		url_include[i].status = 2;
		return  NULL;
	}
    
	if (socket_read(connp, maxsize) == -1 ){
		url_include[i].buf = UdmXmalloc(strlen(exp_url)+50);
		sprintf(url_include[i].buf , "Read error %s", exp_url);
		socket_close(connp);
		UDM_FREE(connp->buf);
		UDM_FREE(connp);
		url_include[i].status = 2;
		return  NULL;
	}

	/* Fixme  */
        if((body=strstr(connp->buf,"\r\n\r\n")))
                body +=4;
        else if ((body=strstr(connp->buf,"\n\n")))
                body +=2;
        
        if(body){
		len = strlen(body);
		url_include[i].buf = UdmXmalloc(len+1);
		sprintf(url_include[i].buf, "%s", body);
        }else{
		url_include[i].buf = UdmXmalloc(1);
	}
	

	socket_close(connp);
	UDM_FREE(connp->buf);
	UDM_FREE(connp);
	url_include[i].status = 2;
	return  NULL;
}

void *get_result(void){
UDM_DOCUMENT *r=NULL;


	if (ispell_mode==UDM_ISPELL_MODE_DB) {
	    if (UdmDBImportAffixes(db)) {
		strcpy(error,UdmDBErrorMsg(db));
		PrintTemplate(Targ, TEMPL(T_ERROR), "", "", 0);
		buf_out.buf_len += strlen(Targ);
		buf_out.buf = UdmXrealloc(buf_out.buf, buf_out.buf_len+1);
		sprintf(UDM_STREND(buf_out.buf), "%s", Targ);
	
		UdmFreeDB(db);

		PrintTemplate(Targ, TEMPL(T_BOT), "", "", 0);
		buf_out.buf_len+= strlen(Targ);
		buf_out.buf = UdmXrealloc(buf_out.buf, buf_out.buf_len+1);
		sprintf(UDM_STREND(buf_out.buf), "%s", Targ);
		UDM_FREE(buf_out.buf);
		return(0);
    	    }
	}
	
	if((r=UdmFind(db,query_words,np,ps?ps:DEFAULT_PS,search_mode,sort_order,wordinfo,&found))){
		UDM_DOCUMENT * r1;

		last=first=docnum=(ps?ps:DEFAULT_PS)*np+1;
		r1=r;
		while ((++r1)->url_id)
			last++;
		num_pages = found/(ps?ps:DEFAULT_PS);
		is_next=last<found;
		if ( (ps?ps:DEFAULT_PS)*num_pages < found )
			num_pages++;			
		sprintf(href,"%s?q=%s",self,query_url_escaped);
		strcpy(UDM_STREND(href),ul_str);
		if (mode)
			sprintf(UDM_STREND(href),"&m=%s",mode);
		if (sort)
			sprintf(UDM_STREND(href),"&s=%s",sort);
		if (ps)
			sprintf(UDM_STREND(href),"&ps=%d",ps);
		if (format)
			sprintf(UDM_STREND(href),"&o=%d",format);
		if (dt_s)
			sprintf(UDM_STREND(href),"&dt=%s",dt_s);
		if (dp_s)
			sprintf(UDM_STREND(href),"&dp=%s",dp_s);
		if (dm_s)
			sprintf(UDM_STREND(href),"&dm=%s",dm_s);
		if (dy_s)
			sprintf(UDM_STREND(href),"&dy=%s",dy_s);
		if (dd_s)
			sprintf(UDM_STREND(href),"&dd=%s",dd_s);
		if (db_s)
			sprintf(UDM_STREND(href),"&db=%s",db_s);
		if (de_s)
			sprintf(UDM_STREND(href),"&de=%s",de_s);

		/* Print RESTOP then all RES's */
		PrintTemplate(Targ, TEMPL(T_RESTOP), "", "", 0);
		buf_out.buf_len+= strlen(Targ);
		buf_out.buf = UdmXrealloc(buf_out.buf, buf_out.buf_len+1);
		sprintf(UDM_STREND(buf_out.buf), "%s", Targ);
		while(r->url_id){
			url_id=r->url_id;
			title=UdmHtmlSpecialChars(r->title?r->title:"");
			text=UdmHtmlSpecialChars(r->text?r->text:"");
			size=r->size;
			rating=r->rating;
			descr=UdmHtmlSpecialChars(r->description?r->description:"");
			keywords=UdmHtmlSpecialChars(r->keywords?r->keywords:"");
			crc32=r->crc32;
			PrintTemplate(Targ, TEMPL(T_RESULT),
				r->url?r->url:"",
				r->content_type?r->content_type:"",
				r->last_mod_time);
			buf_out.buf_len+= strlen(Targ);
			buf_out.buf = UdmXrealloc(buf_out.buf, buf_out.buf_len+1);
			sprintf(UDM_STREND(buf_out.buf), "%s", Targ);

			UDM_FREE(title);
			UDM_FREE(text);
			UDM_FREE(descr);
			UDM_FREE(keywords);
			r++;docnum++;
		}
		/* Print RESBOT */
		PrintTemplate(Targ, TEMPL(T_RESBOT), "", "", 0);
		buf_out.buf_len+= strlen(Targ);
		buf_out.buf = UdmXrealloc(buf_out.buf, buf_out.buf_len+1);
		sprintf(UDM_STREND(buf_out.buf), "%s", Targ);
	}else{
		/* Check the reason of NOTFOUND */
		if(UdmDBErrorCode(db)){
			/* Oops... error! We tried ...*/
			strcpy(error,UdmDBErrorMsg(db));
			PrintTemplate(Targ, TEMPL(T_ERROR), "", "", 0);
    			buf_out.buf_len+= strlen(Targ);
		        buf_out.buf = UdmXrealloc(buf_out.buf, buf_out.buf_len+1);
			sprintf(UDM_STREND(buf_out.buf), "%s", Targ);
		}
		else{
			PrintTemplate(Targ, TEMPL(T_NOTFOUND), "", "", 0);
			buf_out.buf_len+= strlen(Targ);
			buf_out.buf = UdmXrealloc(buf_out.buf, buf_out.buf_len+1);
			sprintf(UDM_STREND(buf_out.buf), "%s", Targ);
		}
	}
	UdmFreeDB(db);
	return NULL;
}

static int PrintOption(char * Target,int where,char * option){
UDM_TAG tag;
char *s;
int len;
char tmp[UDMSTRSIZ]="";

	if(!(s=strchr(option,'>'))){
		sprintf(UDM_STREND(Target),"%s",option);
		return(0);
	}
	len=s-option;
	s=strdup(option);
	s[len+1]=0;
	UdmParseTag(&tag,s);
	if(tag.selected && tag.value){
		int i;
		char *value;
		PrintOneTemplate(tmp,option,where,"","",0, 0);
		UdmFreeTag(&tag);
		UdmParseTag(&tag,tmp);
		value=tag.selected?tag.selected:"";
		if(*value=='$'){
			for(i=0;i<nVar;i++){
				if(!strcmp(Variables[i].name,"ul")&&
					!strcmp(Variables[i].value,tag.value)){
					value=Variables[i].value;
					break;
				}
			}
		}
		sprintf(UDM_STREND(Target),"<OPTION VALUE=\"%s\"%s>",tag.value,
			strcmp(tag.value,value)?"":" SELECTED");
		PrintOneTemplate(UDM_STREND(Target),option+len+1,where,"","",0, 0);
	}else{	
		sprintf(UDM_STREND(Target),"%s",option);
	}
	UdmFreeTag(&tag);
	return(0);
}


static int PrintInput(char * Target,int where,char * option){
UDM_TAG tag;
char *s;
int len;
char tmp[UDMSTRSIZ]="";

	if(!(s=strchr(option,'>'))){
		sprintf(UDM_STREND(Target),"%s",option);
		return(0);
	}
	len=s-option;
	s=strdup(option);
	s[len+1]=0;
	UdmParseTag(&tag,s);

	if((tag.selected && tag.value)){
		char * checked="";

		/* Original line from template */
		/*printf("HELLO INPUT!<BR>%s<BR>\n",option);*/
		
		/* This is to avoid recursion */
		strcpy(tmp,"<INPUT");
		PrintOneTemplate(UDM_STREND(tmp),option+6,where,"","",0, 0);

		/* Line with variables replaced by their values*/
		/* printf("HELLO INPUT!<BR>%s<BR>\n",tmp); */

		/* Parse tag again */
		UdmFreeTag(&tag);UdmParseTag(&tag,tmp);
		
		/*printf("<BR>HELLO '%s' '%s' '%s'<BR>\n",tag.selected,tag.value,tag.name);*/

		if(!strcmp(tag.selected?tag.selected:"",
				tag.value?tag.value:""))
			checked=" CHECKED";

		sprintf(UDM_STREND(Target),
			"<INPUT TYPE=\"%s\" NAME=\"%s\" VALUE=\"%s\"%s>",
			tag.type,tag.name,tag.value,checked);

		PrintOneTemplate(UDM_STREND(Target),option+len+1,where,"","",0, 0);
	}else{	
		/* To avoid recursion again */
		sprintf(UDM_STREND(Target),"%s","<INPUT");
		PrintOneTemplate(UDM_STREND(Target),option+6,where,"","",0,0);
	}
	UdmFreeTag(&tag);
	return(0);
}



int PrintTemplate(char * Target,int where,char *url,char *content_type,time_t last_mod_time){
int i;
	*Target=0;
	for(i=0;i<ntempl;i++){
		char *s;
		if(Template[i].where!=where)continue;
		s=Template[i].str;
		while((*s==' '||*s=='\t'))s++;

		if(!UDM_STRNCASECMP(s,"<OPTION")){
			PrintOption(UDM_STREND(Target),where,s);
		}else
		if(!UDM_STRNCASECMP(s,"<INPUT")){
			PrintInput(UDM_STREND(Target),where,s);
		}else{
			PrintOneTemplate(UDM_STREND(Target),Template[i].str,where,url,content_type,last_mod_time, i);
		}
	}
	return(0);
}

void InitRand(){
int i;
time_t tclock;
	tclock=time(0);
	srand(tclock);
	for(i=0;i<MAXRANDOM;i++)
		Randoms[i]=0;
}

int main(int argc, char **argv) {
char template[UDMSTRSIZ]="";
char query_string[UDMSTRSIZ]="";
char *env,*lasttok,*token;
/* search with time limits local vars */
int dx=0, dm=0, dd=0, dy=0, dt=0;
int i, ind_prev, len, imin=0, min;
char *buf_tmp=NULL;
time_t dp=0;
struct udm_stl_info_t stl_info = { 0, 0, 0 };

	
	UdmInit(); /* Initialize library */
#ifdef HAVE_PTHREAD
	InitMutex(&iurl_mut);
#endif
	UDMMEMZERO(url_include, sizeof(url_include));

	/* Output Content-type if under HTTPD	*/
	/* Some servers do not pass QUERY_STRING*/
	/* if the query was empty, so check	*/
	/* REQUEST_METHOD as well to be safe    */

	if(getenv("QUERY_STRING")||getenv("REQUEST_METHOD")){
		printf("Content-type: text/html\r\n\r\n");
	}

	/* Determine self and template name */
	if((env=getenv("UDMSEARCH_TEMPLATE")))
		strcpy(template,env);

	if((env=getenv("QUERY_STRING"))){
		strcpy(query_string,env);
		if((env=getenv("REDIRECT_STATUS"))){

			/* Check Apache internal redirect  */
			/* via   "AddHandler" and "Action" */

			env=getenv("REDIRECT_URL");
			strcpy(self,env?env:"search.cgi");
			if(!template[0]){
				env=getenv("PATH_TRANSLATED");
				strcpy(template,env?env:"");
			}
		}else{
			/* CGI executed directly */

			env=getenv("SCRIPT_NAME");
			strcpy(self,env?env:"search.cgi");
			if(!template[0]){
				char *s;
				if(strcmp(UDM_CONF_DIR,".")){
					sprintf(template,"%s/%s", UDM_CONF_DIR,(s=strrchr(self,UDMSLASH))?(s+1):(self));
				}else{
					env=getenv("SCRIPT_FILENAME");
					strcpy(template,env?env:"search.cgi");
				}
				if((s=strrchr(template,'.'))){
					*s=0;strcat(template,".htm");
				}else{
					strcpy(template,"search.htm");
				}
			}
		}
	}else{
		/* Executed from command line     */
		/* or under server which do not   */
		/* pass an empty QUERY_STRING var */

		if(argv[1])
			sprintf(query_string,"q=%s",argv[1]);
		if(!template[0])
			sprintf(template,"%s/%s", UDM_CONF_DIR,"search.htm");
	}

	InitRand();
	
	db=UdmAllocDB(UDM_OPEN_MODE_READ);

	/* Parse Query String */
	token=UdmGetToken(query_string,"&",&lasttok);
	while(token){
		if(!UDM_STRNCMP(token,"q=")){
			char str[UDMSTRSIZ]="";
			query_words=strdup(UdmUnescapeCGIQuery(str,token+2));
			query_url_escaped=strdup(UdmEscapeURL(str,query_words));
			query_form_escaped=UdmHtmlSpecialChars(query_words);
		}else
		if(!UDM_STRNCMP(token,"np=")){
			np=atoi(token+3);
		}else
		if(!UDM_STRNCMP(token,"o=")){
			format=atoi(token+2);
			if((format>99)||(format<0))
				format=0;
		}else
		if(!UDM_STRNCMP(token,"ps=")){
			ps=atoi(token+3);
			/* Extra safety          */
			/* Don not allow to pass */
			/* very big page sizes   */
			ps=(ps>MAX_PS)?ps=MAX_PS:ps;
		}
		/* time limiting options */
		else
		if(!UDM_STRNCMP(token,"dt=") && strlen(token) > 3){
			/* search type */
			dt_s=strdup(token+3);
			dt=getSTLType(token+3);
		}
		else
		if(!UDM_STRNCMP(token,"dp=") && strlen(token) > 3){
			dp_s=strdup(token+3);
			dp=dp2time_t(token+3);
		}
		else
		if(!UDM_STRNCMP(token,"dx=") && strlen(token) > 3){
			/* Before/After flag */
			dx_s=strdup(token+3);
			dx=atoi(token+3);
		}
		else
		if(!UDM_STRNCMP(token,"dm=") && strlen(token) > 3){
			/* Month */
			dm_s=strdup(token+3);
			dm=atoi(token+3);
		}
		else
		if(!UDM_STRNCMP(token,"dd=") && strlen(token) > 3){
			dd_s=strdup(token+3);
			/* Day */
			dd=atoi(token+3);
		}
		else
		if(!UDM_STRNCMP(token,"dy=") && strlen(token) > 3){
			/* Year */
			dy_s=strdup(token+3);
			dy=atoi(token+3);
		}
		else
		if(!UDM_STRNCMP(token,"db=") && strlen(token) > 3){
			/* (range) begin date */
			db_s=malloc(strlen(token+3)+1);
			if (db_s)
			    UdmUnescapeCGIQuery(db_s, token+3);
		}
		else
		if(!UDM_STRNCMP(token,"de=") && strlen(token) > 3){
			/* (range) end date */
			de_s=malloc(strlen(token+3)+1);
			if (de_s)
			    UdmUnescapeCGIQuery(de_s, token+3);
		}
		/* end of time limiting options */
		else
		if(!UDM_STRNCMP(token,"ul=") && strlen(token) > 3){
			char str1[UDMSTRSIZ]="";
			char str[UDMSTRSIZ]="";
#ifdef HAVE_FILES
#undef USE_AUTO_WILD
#endif
#ifdef USE_AUTO_WILD
			sprintf(str1,"%%%s%%",UdmUnescapeCGIQuery(str,token+3));
#else
			sprintf(str1,"%s",UdmUnescapeCGIQuery(str,token+3));
#endif
			AddVariable("ul",str);
			UDM_FREE(ul_unescaped);
			ul_unescaped=strdup(str);
			UdmAddURLLimit(str1);
			sprintf(UDM_STREND(ul_str),"&ul=%s",token+3);
		}else
		if((!UDM_STRNCMP(token,"t="))&&(*(token+2))){
			char str[UDMSTRSIZ]="";
			UdmUnescapeCGIQuery(str,token+2);
			UdmAddTagLimit(str);
			sprintf(UDM_STREND(ul_str),"&t=%s",token+2);
			UDM_FREE(ttag);
			ttag=strdup(token+2);
		}else
		if((!UDM_STRNCMP(token,"g="))&&(*(token+2))){
			UdmAddLangLimit(token+2);
			sprintf(UDM_STREND(ul_str),"&g=%s",token+2);
		}else
		if(!UDM_STRNCMP(token,"m=")){
			mode=token+2;
			if(!strcmp(mode,"all"))search_mode=UDM_MOD_ALL;
			if(!strcmp(mode,"any"))search_mode=UDM_MOD_ANY;
		}else
		if(!UDM_STRNCMP(token,"s=")){
			sort=token+2;
			if(!strcmp(sort,"date"))sort_order=UDM_ORD_DATE;
			if(!strcmp(sort,"rate"))sort_order=UDM_ORD_RATE;
		}else
		if(!UDM_STRNCMP(token,"cat=")){
			category=token+4;
			UdmAddCatLimit(token+4);
			sprintf(UDM_STREND(ul_str),"&%s",token);
		}else
                if(!UDM_STRNCMP(token,"udm_recursion")){
	                iurl_udm_recursion=1;
                }

		token=UdmGetToken(NULL,"&",&lasttok);
	}

	ispell_mode=UDM_ISPELL_MODE_TEXT;
	if(LoadTemplate(template,query_words,0)){
		printf("<html><body>Can't open template file '%s'!</body></html>\n",template);
		return(0);
	} /* end while(token) */
	
	/* Set tracking levels */
	UdmSetTrackMode(track);
	
	/* commonize various "search with date limit" options */
	if (dt){
		switch(dt){
			case 1: /* dp seconds behind now */
				/* construct 'last_mod_time>=d1' */
				if (dp>0){ /* valid time and not 'anytime' */
					stl_info.t1=time(NULL)-dp;
					stl_info.type=1; /* after */
	                               }
	                               break;
			case 2: /* newer/older than dd/dm/dy */
				if ((stl_info.t1=d_m_y2time_t(dd, dm, dy))>0)
	                    		stl_info.type=dx;
	            		break;
			case 3: /* interval between db_s and de_s */
	            		/* db_s and de_s are in the form of dd/mm/yyyy */
	            		if ((stl_info.t1=dmy2time_t(db_s))>0)
	                        if ((stl_info.t2=dmy2time_t(de_s))>0)
	                    		stl_info.type=2; /* that means 'between' */
	                	break;
		}
		UdmAddTimeLimit(&stl_info);
	} /* if (dt) */

	/* Make TOP and if no query BOTTOM */
	PrintTemplate(Targ, TEMPL(T_TOP), "", "", 0);	
	buf_out.buf_len += strlen(Targ);
	buf_out.buf = UdmXrealloc(buf_out.buf, buf_out.buf_len+1);
	sprintf(UDM_STREND(buf_out.buf), "%s", Targ);

	/* First print TOP */
	if (url_include[0].offset){
		len = url_include[0].offset;
		buf_tmp = UdmXrealloc(buf_tmp, len+1);
		udm_snprintf(buf_tmp, len+1, "%s", buf_out.buf);
		ind_prev = url_include[0].offset;
		printf("%s", buf_tmp);
		fflush(stdout);
	}else{
		ind_prev = strlen(Targ);
		printf("%s", Targ);
		fflush(stdout);
	}
	/* Make RES*/
	if ((query_words) && (query_words[0]!='\0')){
		get_result();
	}
	else{
		PrintTemplate(Targ, TEMPL(T_NOQUERY), "", "", 0);
		buf_out.buf_len += strlen(Targ);
		buf_out.buf = UdmXrealloc(buf_out.buf, buf_out.buf_len+1);
		sprintf(UDM_STREND(buf_out.buf), "%s", Targ);
	}


	/* Make the BOT */
        PrintTemplate(Targ, TEMPL(T_BOT), "", "", 0);
	buf_out.buf_len += strlen(Targ);
	buf_out.buf = UdmXrealloc(buf_out.buf, buf_out.buf_len+1);
	sprintf(UDM_STREND(buf_out.buf), "%s", Targ);

	/* Print it all */
	while(1){
		min = 1000000;
		imin =-1;
		for ( i=0; i<MAX_URL_INCLUDE; i++){
			if ((url_include[i].offset < min) &&
			    (url_include[i].status != 0)){
				imin = i;
				min = url_include[i].offset;
			}
		}
		if (imin == -1)
			break;
		/* fix me: Wait for phtread */
		if (url_include[imin].status == 1){
			sleep(1);
			continue;
		}

    		if (url_include[imin].buf){
			if (url_include[imin].visible == 1){
				len = url_include[imin].offset - ind_prev;
				buf_tmp = UdmXrealloc(buf_tmp, len+1);
				udm_snprintf(buf_tmp, len+1, "%s", buf_out.buf+ind_prev);

				printf("%s", buf_tmp);
    				printf("%s", url_include[imin].buf);
				fflush(stdout);
			}
			UDM_FREE(url_include[imin].buf);
			url_include[imin].status = 0;
			ind_prev = url_include[imin].offset;
		}
	}
	len = buf_out.buf_len - ind_prev;
	buf_tmp = UdmXrealloc(buf_tmp, len+1);
	udm_snprintf(buf_tmp, len+1, "%s", buf_out.buf+ind_prev);
	printf("%s", buf_tmp);

	/* Keep your country tidy! */
	UDM_FREE(db_s);
	UDM_FREE(de_s);
	UDM_FREE(dt_s);
	UDM_FREE(dp_s);
	UDM_FREE(dx_s);
	UDM_FREE(dm_s);
	UDM_FREE(dd_s);
	UDM_FREE(dy_s);
	UDM_FREE(buf_out.buf);
	UDM_FREE(buf_tmp);
	return(0);
}
