/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _DEFERRED_INDEX_H_
#define _DEFERRED_INDEX_H_

#include "SyncObject.h"

static const int DEFERRED_INDEX_FANOUT		= 32; // 4;
static const int DEFERRED_INDEX_HUNK_SIZE	= 32768;
static const int DEFERRED_INDEX_MAX_LEVELS		= 16;


struct DIHunk {
	DIHunk	*next;
	UCHAR	space[DEFERRED_INDEX_HUNK_SIZE];
	};

struct DINode {
	int32	pageNumber;
	uint16	keyLength;
	UCHAR	key[1];
	};	

struct DILeaf {
	uint	count;
	DINode	*nodes[DEFERRED_INDEX_FANOUT];
	};

struct DIBucket;

struct DIRef {
	DINode		*node;
	DIBucket	*bucket;
	};

struct DIBucket {
	uint		count;
	DIRef		references[DEFERRED_INDEX_FANOUT];
	};

struct DIState {
	DIBucket	*bucket;
	uint		slot;
	};


class Transaction;
class Index;
class IndexKey;
class Bitmap;

class DeferredIndex
{
public:
	int compare (IndexKey *node1, DINode *node2, bool partial);
	int checkTail (uint position, IndexKey *indexKey);
	//void flush();
	void scanIndex (IndexKey *lowKey, IndexKey *highKey, bool partial, Bitmap *bitmap);
	void print(const char *text, DINode *node);
	DeferredIndex(Index *index, Transaction *trans);
	~DeferredIndex(void);
	
	void*			alloc(uint length);
	void			addNode(IndexKey* indexKey, int32 pageNumber);
	int				compare(DINode* node1, DINode* node2);
	int				checkTail(uint position, DINode* node);
	void			validate(void);
	void			print (int indent, int level, DIBucket *bucket);
	void			print();

	static char*	format (uint indent, DINode *node, uint bufferLength, char *buffer);

	SyncObject		syncObject;	
	DeferredIndex	*next;
	DeferredIndex	*prior;
	DeferredIndex	*nextInTransaction;
	Index			*index;
	Transaction		*transaction;
	DIHunk			initialHunk;
	DIHunk			*hunks;
	void			*root;
	uint			currentHunkOffset;
	uint			count;
	int				levels;
	void detachIndex(void);
	void detachTransaction(void);
	bool deleteNode(IndexKey* key, int32 pageNumber);
	int compare(IndexKey* node1, int32 pageNumber, DINode* node2);
	void print(DIBucket* bucket);
	void print(DILeaf* leaf);
};

#endif
