/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

// Record.h: interface for the Record class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_RECORD_H__02AD6A50_A433_11D2_AB5B_0000C01D2301__INCLUDED_)
#define AFX_RECORD_H__02AD6A50_A433_11D2_AB5B_0000C01D2301__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#define ALLOCATE_RECORD(n)		(char*) MemMgrRecordAllocate (n, __FILE__, __LINE__)
#define DELETE_RECORD(record)	MemMgrRecordDelete (record);

#define CHECK_RECORD_ACTIVITY

enum RecordEncoding {
	noEncoding = 0,
	traditional,
	valueVector,
	byteVector,
	shortVector,
	longVector
	};

// Record states

static const int recData	= 0;		// record pointer is valid or record is deleted
static const int recDeleted	= 1;		// record has been deleted
static const int recSwapped	= 2;		// record is in temp file
static const int recOnDisk	= 3;		// record is on disk and must be read


class Format;
class Table;
class Transaction;
class Value;
class Stream;
class Database;
CLASS(Field);

extern char	*RecordAllocate (int size, const char *file, int line);
extern void	RecordDelete (char *record);

class Record
{
public:
	virtual Transaction* getTransaction();
	virtual TransId	getTransactionId();
	virtual int		getSavePointId();
	virtual void	setSuperceded (bool flag);
	virtual Record* fetchVersion (Transaction *transaction);
	virtual bool	scavenge(TransId oldestActive);
	virtual void	scavenge(TransId targetTransactionId, int oldestActiveSavePointId);
	virtual bool	isVersion();
	virtual bool	isSuperceded();
	virtual bool	isNull(int fieldId);
	virtual Record* releaseNonRecursive(void);
	virtual void	setPriorVersion(Record* record);
	virtual Record* getPriorVersion();
	
	const UCHAR*	getEncoding (int index);
	const char*		getEncodedRecord();
	void			setEncodedRecord(Stream *stream);
	void			getValue (int fieldId, Value* value);
	int				getFormatVersion();
	void			setValue (Transaction *transaction, int id, Value *value, bool cloneFlag, bool copyFlag);
	void			poke ();
	void			release();
	void			addRef();
	int				getBlobId(int fieldId);
	void			finalize(Transaction *transaction);
	void			getEncodedValue (int fieldId, Value *value);
	void			getRecord (Stream *stream);
	void			setAgeGroup();

	Record (Table *table, Format *recordFormat);
	Record(Table *table, int32 recordNumber, Stream *stream);

	inline int		hasRecord()
		{
		return data.record != NULL;
		};
		
protected:
	virtual ~Record();
	
	union {
		char	*record;
		int64	swapOffset;
		}		data;

public:
	volatile INTERLOCK_TYPE useCount;
	Table		*table;
	Format		*format;
	int			recordNumber;
	int			size;
	int			ageGroup;
	short		highWater;
	UCHAR		encoding;
	UCHAR		state;

#ifdef CHECK_RECORD_ACTIVITY
	UCHAR		active;					// this is for debugging only
#endif
};

#endif // !defined(AFX_RECORD_H__02AD6A50_A433_11D2_AB5B_0000C01D2301__INCLUDED_)
