/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

// SRLDataPage.cpp: implementation of the SRLDataPage class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "Engine.h"
#include "SRLDataPage.h"
#include "SerialLog.h"
#include "SerialLogTransaction.h"
#include "SerialLogControl.h"
#include "Section.h"
#include "Dbb.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

SRLDataPage::SRLDataPage()
{

}

SRLDataPage::~SRLDataPage()
{

}

void SRLDataPage::append(TransId transId, int id, int32 locatorPage, int32 page)
{
	START_RECORD(srlDataPage, "SRLDataPage::append");

	if (transId)
		{
		SerialLogTransaction *trans = log->getTransaction(transId);
		
		if (trans)
			trans->setPhysicalBlock();
		}

	putInt(id);
	putInt(locatorPage);
	putInt(page);
	
	if (page == log->tracePage)
		{
		sectionId = id;
		pageNumber = page;
		print();
		}
}

void SRLDataPage::read()
{
	sectionId = getInt();
	
	if (control->version >= srlVersion5)
		locatorPageNumber = getInt();
	else
		locatorPageNumber = 0;

	pageNumber = getInt();
}

void SRLDataPage::pass1()
{
	log->bumpPageIncarnation(pageNumber, objInUse);
	log->bumpSectionIncarnation(sectionId, objInUse);
}

void SRLDataPage::pass2()
{
	if (log->tracePage == pageNumber || log->tracePage == locatorPageNumber)
		print();
	
	bool sectionActive = log->bumpSectionIncarnation(sectionId, objInUse);
	
	if (log->bumpPageIncarnation(pageNumber, objInUse))
		{
		if (sectionActive)
			{
			if (control->isPostFlush())
				log->dbb->redoDataPage(sectionId, pageNumber, locatorPageNumber);
			}
		else
			log->redoFreePage(pageNumber);
		}
}

void SRLDataPage::redo()
{
	bool sectionActive = log->bumpSectionIncarnation(sectionId, objInUse);
	log->bumpPageIncarnation(pageNumber, objInUse);
}

void SRLDataPage::print()
{
	logPrint("Data Page section %d, locator page %d, data page %d\n",
		   sectionId, locatorPageNumber, pageNumber);
}
