/* Copyright (C) 2006 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include <stdio.h>
#include "Engine.h"
#include "SRLSectionLine.h"
#include "SerialLog.h"
#include "Section.h"
#include "Dbb.h"

SRLSectionLine::SRLSectionLine(void)
{
}

SRLSectionLine::~SRLSectionLine(void)
{
}

void SRLSectionLine::append(int32 sectionPageNumber, int32 dataPageNumber)
{
	START_RECORD(srlSectionLine, "SRLSectionLine::append");
	putInt(sectionPageNumber);
	putInt(dataPageNumber);
	sync.unlock();
}

void SRLSectionLine::read(void)
{
	pageNumber = getInt();
	dataPageNumber = getInt();
	
	if (pageNumber == log->tracePage || dataPageNumber == log->tracePage)
		print();
}

void SRLSectionLine::pass1(void)
{
	log->bumpPageIncarnation(pageNumber, objInUse);
	log->bumpPageIncarnation(dataPageNumber, objInUse);
}

void SRLSectionLine::pass2(void)
{
	if (log->bumpPageIncarnation(pageNumber, objInUse))
		Section::redoSectionLine(log->dbb, pageNumber, dataPageNumber);
	
	log->bumpPageIncarnation(dataPageNumber, objInUse); 
}

void SRLSectionLine::redo(void)
{
	log->bumpPageIncarnation(pageNumber, objInUse);
	log->bumpPageIncarnation(dataPageNumber, objInUse);
}

void SRLSectionLine::print(void)
{
	logPrint("Section Line: section index page %d, data page %d\n", pageNumber, dataPageNumber);
}
