/* Copyright (c) 2011, 2012 Oracle and/or its affiliates. All rights reserved.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2 of the License.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */

using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Deployment.WindowsInstaller;
using System.Windows.Forms;
using System.IO;
using System.Diagnostics;

namespace MySQLCA
{
  public class CustomActions
  {
    [CustomAction]
    public static ActionResult PrecompilePythonFiles(Session session)
    {
      session.Log("Entering PrecompilePythonFiles");

      try
      {
        string installpath = GetCustomActionDataArguments(session)[0];
        Process proc = new Process();

        proc.StartInfo.FileName = installpath + "\\python.exe";
        proc.StartInfo.Arguments = "-mcompileall ..";

        proc.StartInfo.UseShellExecute = true;
        proc.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
      //  proc.StartInfo.RedirectStandardError = true;
        proc.StartInfo.WorkingDirectory = installpath + "\\python";
        proc.Start();
   //     session.Log(proc.StandardError.ReadToEnd());
        proc.WaitForExit();

        session.Log("Exiting PrecompilePythonFiles");
      }
      catch (Exception ex)
      {
        session.Log("Exception in PrecompilePythonFiles: "+ex.Message);
        return ActionResult.Failure;
      }

      return ActionResult.Success;
    }


    private static string[] GetCustomActionDataArguments(Session session)
    {
      string[] keys = new string[session.CustomActionData.Keys.Count];
      session.CustomActionData.Keys.CopyTo(keys, 0);
      return keys[0].Split(',');
    }
  }
}
