/* 
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include "MySQLTableEditorBE.h"
#include "grtdb/db_object_helpers.h"
#include "mforms/view.h"

namespace MySQL {
namespace Grt {
namespace Db {

  //--------------------------------------------------------------------------------------------------

MySQLTableColumnsListBE::MySQLTableColumnsListBE(::MySQLTableColumnsListBE *inn)
  : TableColumnsListBE(inn)
{}

//--------------------------------------------------------------------------------------------------

MySQLTableEditorBE::MySQLTableEditorBE(MySQL::Grt::GrtManager^ grtm, MySQL::Grt::GrtValue^ arglist)
: TableEditorBE(
      new ::MySQLTableEditorBE(grtm->get_unmanaged_object(), 
      db_mysql_TableRef::cast_from(::grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0)),
      get_rdbms_for_db_object(::grt::BaseListRef::cast_from(arglist->get_unmanaged_object()).get(0))
      )
    )
{
}

//--------------------------------------------------------------------------------------------------

MySQLTableColumnsListBE^ MySQLTableEditorBE::get_columns() 
{ return gcnew MySQLTableColumnsListBE(get_unmanaged_object()->get_columns()); }


//--------------------------------------------------------------------------------------------------

MySQLTablePartitionTreeBE^ MySQLTableEditorBE::get_partitions()
{
  return gcnew MySQLTablePartitionTreeBE(get_unmanaged_object()->get_partitions());
}

//--------------------------------------------------------------------------------------------------

Control ^MySQLTableEditorBE::get_trigger_panel()
{
  mforms::View* panel = get_unmanaged_object()->get_trigger_panel();
  MySQL::Forms::ViewImpl^ managed_view= (MySQL::Forms::ViewImpl^) MySQL::Forms::ViewImpl::FromUnmanaged(panel);
  return managed_view->get_control();
}

//--------------------------------------------------------------------------------------------------

void MySQLTableEditorBE::commit_changes()
{
  get_unmanaged_object()->commit_changes();
}

//--------------------------------------------------------------------------------------------------

};  // namespace Db
};  // namespace Grt
};  // namespace MySQL
