#!/bin/sh

templatedmg=mysqlworkbench-template.dmg
app="MySQLWorkbench.app"

srcdir="$HOME/guibuild/Release"



#ver=$(grep -A1 CFBundleVersion ../Info.plist|tail -1|sed -e 's/<[^>]*>//g'|cut -f2)
edition=$1
ver=$2
if test "$ver" == ""; then
	echo "./make_dmg.sh <edition> <wbversion>"
	exit 1
fi

finaldmg=mysql-workbench-$edition-$ver-osx-i686


###############################################################################################

echo "Packaging $finaldmg"


oifs=$IFS
IFS=,

echo "Attaching template"
hdiutil attach "$templatedmg" -noautoopen -mountpoint template -quiet

echo "Copying app"
rm -fr "template/$app"
ditto "$srcdir/$app" "template/$app"

if test "$edition" == "com-se"; then
        echo "Copying LGPL srcs to SE pkg"
        cp ~/guibuild/lgpl-deps/* "template/$app"
fi

echo "Detaching template"
hdiutil detach template -force -quiet

rm -f $finaldmg.*

echo "Creating dmg"
hdiutil convert "$templatedmg" -format UDBZ -imagekey zlib-level=9 -o "$finaldmg" -ov


hdiutil internet-enable -yes "$finaldmg".dmg
