/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: minimum
// Release: 0.1
//
// @doc
//
// @module CLASSFAC.CPP | The module contains the DLL Entry and Exit
// points, plus the OLE ClassFactory class.
//
//

// Includes ------------------------------------------------------------------

#include "hfiles.h"
#include "headers.h"
#include "classfac.h"
#include "errors.h"
#include "srcrwset.h"
#include "resource.h"
#include <process.h>

#include "cache_openfile.h"  
#include "cache_loadmeta.h" 

// MYSQL -->
extern "C" {
extern BOOL APIENTRY MySqlMain(HANDLE hInst,DWORD ul_reason_being_called, LPVOID lpReserved);
extern int mysql_server_init();
extern int mysql_applic_addref_instance();
extern int mysql_applic_release_instance();
extern BOOL MySqlEngineAvailable(); // from libmyodbc.lib
}
// --> MYSQL
enum MYSQLAVAIL { MYSQLAVAIL_NOTAVAIL = 0, MYSQLAVAIL_DLL = 1, MYSQLAVAIL_EXE = -1, MYSQLAVAIL_EXERUNNING = -2 };

#define SPLASHSCREEN_TIMEOUT	3

// Window to Center
extern void WINAPI CenterDialog( HWND hDlg );
// About box
void AboutBox(LICENSESTATE newState );

// Static vars ---------------------------------------------------------------

static const char * s_strDllName = "MyProv";  // used with GetModuleHandle
static const struct
{
	char * strRegKey;
	char * strValueName;
	char * strValue;
} s_rgRegInfo[] =
{
    { ".ddf", NULL, "SwstProv.2.5" },


	{ "MySqlProv", NULL, "MySQL.OLEDB Provider" },
    { "MySqlProv\\CLSID", NULL, "{C86FB69E-3664-11d2-A112-00104BD15372}" },
    { "MySqlProv\\CurVer", NULL, "MySqlProv.2.5" },
    { "MySqlProv.2.5", NULL, "MySQL.OLEDB Provider" },
    { "MySqlProv.2.5\\CLSID", NULL, "{C86FB69E-3664-11d2-A112-00104BD15372}" },

    { "CLSID\\{C86FB69E-3664-11d2-A112-00104BD15372}", NULL, "MySqlProv" },
    { "CLSID\\{C86FB69E-3664-11d2-A112-00104BD15372}\\ProgID", NULL, "MySqlProv.2.5" },
    { "CLSID\\{C86FB69E-3664-11d2-A112-00104BD15372}\\VersionIndependentProgID", NULL, "MySqlProv" },
    { "CLSID\\{C86FB69E-3664-11d2-A112-00104BD15372}\\InprocServer32", NULL, "%s" },
	{ "CLSID\\{C86FB69E-3664-11d2-A112-00104BD15372}\\InprocServer32", "ThreadingModel", "Apartment" },
	{ "CLSID\\{C86FB69E-3664-11d2-A112-00104BD15372}\\OLE DB Provider", NULL, "MySQL.OLEDB Provider" },


	{ "MySqlEnumerator", NULL, "MySql Enumerator" },
	{ "MySqlEnumerator\\CLSID", NULL, "{C86FB69D-3664-11d2-A112-00104BD15372}" },
	{ "MySqlEnumerator\\CurVer", NULL, "MySqlEnumerator.2.5" },
	{ "MySqlEnumerator.2.5", NULL, "MySql Enumerator" },
	{ "MySqlEnumerator.2.5\\CLSID", NULL, "{C86FB69D-3664-11d2-A112-00104BD15372}" },
	{ "CLSID\\{C86FB69D-3664-11d2-A112-00104BD15372}", NULL, "MySql Enumerator" },
	{ "CLSID\\{C86FB69D-3664-11d2-A112-00104BD15372}\\InprocServer32", NULL, "%s" },
	{ "CLSID\\{C86FB69D-3664-11d2-A112-00104BD15372}\\InprocServer32", "ThreadingModel", "Apartment" },
	{ "CLSID\\{C86FB69D-3664-11d2-A112-00104BD15372}\\OLE DB Enumerator", NULL, "MySQL.OLEDB Data Sources Enumerator" },
	{ "CLSID\\{C86FB69D-3664-11d2-A112-00104BD15372}\\ProgID", NULL, "MySqlEnumerator.2.5" },
	{ "CLSID\\{C86FB69D-3664-11d2-A112-00104BD15372}\\VersionIndependentProgID", NULL, "MySqlEnumerator" }

};
static const struct
{
	char * strRegKey;
	char * strValueName;
	char * strValue;
} s_rgSecurityInfo[] =
{
    { "CLSID\\%s", NULL, "shell32.dll" },
    { "CLSID\\%s\\InprocServer32", NULL, "shell32.dll" },
	{ "CLSID\\%s\\MiscStatus", NULL, "1" }, 
	{ "CLSID\\%s\\Version", NULL, "1.0" }, 
	{ "CLSID\\%s\\xxxxxxx\\1", NULL, "%d" }, 
	{ "CLSID\\%s\\xxxxxx\\2", NULL, "%d" } 
};
#define REGTMSTP_VERSION	3
#define REGTMSTP_BTRIEVE	4
#define REGTMSTP_MYSQL		5


// Code ----------------------------------------------------------------------

LPSTR CLSID2String(REFCLSID rclsid, char* pszCLSID)
{
	//Converting CLSID to registry format
	wsprintf(pszCLSID, "{%08X-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X}",
		rclsid.Data1, rclsid.Data2, rclsid.Data3,
		rclsid.Data4[0], rclsid.Data4[1], rclsid.Data4[2], rclsid.Data4[3],
		rclsid.Data4[4], rclsid.Data4[5], rclsid.Data4[6], rclsid.Data4[7]);
	return pszCLSID;
}


DWORD CurrentTimeStamp()
{
	//Get current time with 0.6 day precission
	FILETIME ftCurrent;
	GetSystemTimeAsFileTime(&ftCurrent);
	return ((ftCurrent.dwHighDateTime >> 7));
}

DWORD RegistryTimeStamp( int iSecurity )
{
	//Query timestamp stored in the registry
	DWORD ret = 0;

	return 0;
}


// This function destrois splash screen
VOID CALLBACK TimerProc(
  HWND hwnd,     // handle of window for timer messages
  UINT uMsg,     // WM_TIMER message
  UINT idEvent,  // timer identifier
  DWORD dwTime   // current system time
)
{
   	KillTimer( hwnd, idEvent );
	EndDialog( hwnd, IDCANCEL );
}

BOOL CALLBACK DlgSplashScreen (HWND hwnd, UINT uMsg,  WPARAM wParam, LPARAM lParam) 
{
   	const UINT uiTimeID = 0;
	
	// Set init Data Source on dialog initialization
	if( uMsg == WM_INITDIALOG )
	{
		// Set registration information. Default text is "Unreg. version"
		if( LICENSESTATE(lParam) == LICENSED )
			SetWindowText( GetDlgItem(hwnd, IDC_WARN), "Registered version.\nCopyright  SWsoft 1998-2000" );
		else if( LICENSESTATE(lParam) == EXPIRED )
			SetWindowText( GetDlgItem(hwnd, IDC_WARN), "Your trial version is EXPIRED.\nContact oledb@sw.com.sg to register" );
		
		// Center dialog
		CenterDialog( hwnd );

		// Allow user not to do anything to destroy splash screen
		SetTimer( hwnd, uiTimeID, SPLASHSCREEN_TIMEOUT * 1000, TimerProc );
		
		// Specific return value for WM_INITDIALOG
		return FALSE; 
	}

	// Destroy splash screen
	if( uMsg == WM_COMMAND )
	{
	   	KillTimer( hwnd, uiTimeID );
		EndDialog( hwnd, IDCANCEL );		 
	}
    
	return FALSE;
}

LICENSESTATE& check_lic_state( int idx, LICENSESTATE& lic )
{
	return lic = LICENSED;
}


// DllMain -------------------------------------------------------------------
//
// @func DLL Entry point where Instance and Thread attach/detach notifications
// takes place.  OLE is initialized and the IMalloc Interface pointer is obtained.
//
// @rdesc Boolean Flag
//      @flag TRUE | Successful initialization
//      @flag FALSE | Failure to intialize
//
BOOL WINAPI DllMain
    (
    HINSTANCE   hInstDLL,   //@parm IN | Application Instance Handle
    DWORD       fdwReason,  //@parm IN | Indicated Process or Thread activity
    LPVOID      lpvReserved //@parm IN | Reserved...
    )
{
    BOOL        fRetVal = FALSE;
    HRESULT     hr;
    SYSTEM_INFO SystemInformation;

	switch (fdwReason)
	{
		case DLL_PROCESS_ATTACH:

			TRACE(NULL);
			TRACE("DllMain.1 (DLL_PROCESS_ATTACH)");
			
			// Assume successfully initialized
			fRetVal = TRUE;

				// Do one-time initialization when first process attaches
			//Attn: g_cAttachedProcesses & license global variables must be shared in a couple if ever
			//Now this initialization occurs in each process.
			if (!g_cAttachedProcesses)
			{
				TRACE("DllMain.2");
				
				g_hInstance = hInstDLL;
				
				// Get the OLE task memory allocator; we'll use it to allocate
				// all memory that we return to the client
				hr = CoGetMalloc( MEMCTX_TASK, &g_pIMalloc );
				if (!g_pIMalloc || !SUCCEEDED( hr ))
				{
					fRetVal = FALSE;
					break;
				}
				
				TRACE("DllMain.3");
				
				// Get the system page size
				if (!g_dwPageSize)
				{
					GetSystemInfo( &SystemInformation );    // can't fail
					g_dwPageSize = SystemInformation.dwPageSize;
				}

				TRACE("DllMain.4");


				
				//check if time is expired
				TRACE("DllMain.5");

				g_LicenseStateSwst = LICENSED;

			}
			
			// Do per-process initialization here...
			// Initialize the critical section
			InitializeCriticalSection(&g_CriticalSection);
        
			TRACE("DllMain.7");

			// Remember that another process successfully attached
			g_cAttachedProcesses++;
			
			break;
			
		case DLL_PROCESS_DETACH:
			
			TRACE("DllMain (DLL_PROCESS_DETACH)");


			// Clean up when the last process is going away
			if (g_cAttachedProcesses == 1)
			{
				// Release the memory allocator object.
				if (g_pIMalloc)
					g_pIMalloc->Release();
				g_pIMalloc = NULL;
			}
			
			// Do per-process clean up here...
			// Delete the critical section
			DeleteCriticalSection(&g_CriticalSection);
			
			// Remember that a process has detached
			g_cAttachedProcesses--;


#ifdef SWSOFT_LIB
			// Clean Up: Lib version of *any* MySQL 
			if(	MySqlEngineAvailable() == MYSQLAVAIL_DLL ) 
				mysql_applic_release_instance();
#endif
			
			break;
			
		case DLL_THREAD_ATTACH:
			TRACE("DllMain (DLL_THREAD_ATTACH)");
			break;
			
		case DLL_THREAD_DETACH:
			TRACE("DllMain (DLL_THREAD_DETACH)");


			break;
	}

	if( g_LicenseStateMySql != REGISTRATION && g_LicenseStateMySql != EXPIRED )
		MySqlMain( hInstDLL, fdwReason, lpvReserved );

	
	return fRetVal;
}


// DllGetClassObject ---------------------------------------------------------
//
// @func This function is exposed to OLE so that the classfactory can
// be obtained.
//
// @rdesc HRESULT indicating status of routine
//      @flag S_OK                      | The object was retrieved successfully.
//      @flag CLASS_E_CLASSNOTAVAILABLE | DLL does not support class.
//      @flag E_OUTOFMEMORY             | Out of memory.
//      @flag E_INVALIDARG              | One or more arguments are invalid.
//      @flag E_UNEXPECTED              | An unexpected error occurred.
//      @flag OTHER | Other HRESULTs returned by called functions
//

HRESULT CALLBACK DllGetClassObject
    (
    REFCLSID    rclsid, //@parm IN | CLSID of the object class to be loaded
    REFIID      riid,   //@parm IN | Interface on object to be instantiated
    LPVOID *    ppvObj  //@parm OUT | Pointer to interface that was instantiated
    )
{	
	TRACE( "DllGetClassObject" );
	
	HRESULT         hr;

    // Check for valid ppvObj pointer
    if (!ppvObj)
        return E_INVALIDARG;

    // In case we fail, we need to zero output arguments
    *ppvObj = NULL;

    // Check if SwstProv object is requested
    if (rclsid == CLSID_SwstProv || 
		rclsid == CLSID_MySqlProv || 
		rclsid == CLSID_SwstProvEnum || 
		rclsid == CLSID_MySqlProvEnum )
	{
		// We only support the IUnknown and IClassFactory[2] interfaces
		if (riid != IID_IUnknown &&
			riid != IID_IClassFactory &&
			riid != IID_IClassFactory2)
			return E_NOINTERFACE;

		// Create our ClassFactory object
		CClassFactory* pClassFactory = new CClassFactory( rclsid );
		if (pClassFactory == NULL)
			return E_OUTOFMEMORY;

		// Get the desired interface on this object
		hr = pClassFactory->QueryInterface(riid, ppvObj);
		if (FAILED(hr))
			delete pClassFactory;

		TRACE2( "  DllGetClassObject : class factory with 0x%x", hr );
		return hr;
	}

#ifdef _DEBUG
    // Check if SwstProv Lookup object is requested
    if (rclsid == CLSID_SwstProvLookup)
	{
		// Create our ErrorLookup object
		CError* pError = new CError;
		if (pError == NULL)
			return E_OUTOFMEMORY;

		// Get the desired interface on this object
		hr = pError->QueryInterface(riid, ppvObj);
		if (FAILED(hr))
			delete pError;

		TRACE2( "  DllGetClassObject : error lookup with 0x%x", hr );
		return hr;
	}
#endif

	TRACE( "  DllGetClassObject failed" );

	return CLASS_E_CLASSNOTAVAILABLE;
}


// DllCanUnloadNow -----------------------------------------------------------
//
// @func Indicates whether the DLL is no longer in use and
// can be unloaded.
//
// @rdesc HRESULT indicating status of routine
//      @flag S_OK | DLL can be unloaded now.
//      @flag S_FALSE | DLL cannot be unloaded now.
//
STDAPI DllCanUnloadNow( void )
{
    if (!g_cObj && !g_cLock)
        return  ( S_OK );
    else
        return  ( S_FALSE );
}


//-----------------------------------------------------------------------------
// CClassFactory
//-----------------------------------------------------------------------------

// CClassFactory -------------------------------------------------------------
//
// @mfunc Constructor for this class
//
// @rdesc NONE
//
CClassFactory::CClassFactory( REFCLSID refCLSID )
{
    CLEAR_CONSTRUCT( CClassFactory );
	//m_cRef = 0;
	m_CLSID = refCLSID;

    // Increment global object count
    OBJECT_CONSTRUCTED();

	TRACE( " Class Factory Object is constructed!" );
}

// ~CClassFactory ------------------------------------------------------------
//
// @mfunc Destructor for this class
//
// @rdesc NONE
//
CClassFactory:: ~CClassFactory( void )
{
    // Decrement global object count
    OBJECT_DESTRUCTED();

	TRACE( " Class Factory Object is destructed!" );
}

// QueryInterface ------------------------------------------------------------
//
// @mfunc Returns a pointer to a specified interface. Callers use
// QueryInterface to determine which interfaces the called object
// supports.
//
// @rdesc HRESULT indicating the status of the method
//      @flag S_OK          | Interface is supported and ppvObject is set.
//      @flag E_NOINTERFACE | Interface is not supported by the object
//      @flag E_INVALIDARG  | One or more arguments are invalid.
//
STDMETHODIMP CClassFactory::QueryInterface
    (
    REFIID      riid,   //@parm IN | Interface ID of the interface being queried for.
    LPVOID *    ppvObj  //@parm OUT | Pointer to interface that was instantiated
    )
{
	TRACE( "CClassFactory::QueryInterface" );
	
	// Check for valid ppvObj pointer
    if (ppvObj == NULL)
        return E_INVALIDARG;

    // In case we fail, we need to zero output arguments
    *ppvObj = NULL;

    // Do we support this interface?
    if (riid == IID_IUnknown ||
        riid == IID_IClassFactory || 
		riid == IID_IClassFactory2
		)
	{
        *ppvObj = (LPVOID) this;
	} 

	if (*ppvObj == NULL)
		return E_NOINTERFACE;

    // If we're going to return an interface, AddRef it first
	((LPUNKNOWN)*ppvObj)->AddRef();
    return S_OK;
}

// AddRef --------------------------------------------------------------------
//
// @mfunc Increments a persistence count for the object
//
// @rdesc Current reference count
//
STDMETHODIMP_( ULONG ) CClassFactory::AddRef( void )
{
	// return InterlockedIncrement((LONG*)&m_cRef);
    return ++m_cRef;
}

// Release -------------------------------------------------------------------
//
// @mfunc Decrements a persistence count for the object and if
// persistence count is 0, the object destroys itself.
//
// @rdesc Current reference count
//
STDMETHODIMP_( ULONG ) CClassFactory::Release( void )
{	
     if (!--m_cRef)
        {
        delete this;
        return 0;
        }
	/*
	if (!(InterlockedDecrement((LONG*)&m_cRef)))
        {
        delete this;
        return 0;
        }
	*/
    return m_cRef;
}


HRESULT CClassFactory::StartUp()
{
	CLSID zeroCLSID;
	ZeroMemory( &zeroCLSID, sizeof(zeroCLSID) );

	if( m_createdCLSID != zeroCLSID ) // already initialized
	{
		if( m_createdCLSID == CLSID_SwstProv && 
			( m_CLSID == CLSID_SwstProv || m_CLSID == CLSID_SwstProvEnum ) )
				return S_OK; 
		if( m_createdCLSID == CLSID_MySqlProv &&
			( m_CLSID == CLSID_MySqlProv || m_CLSID == CLSID_MySqlProvEnum ) )
				return S_OK; 
		return E_NOINTERFACE;  // incompatible
	}

	// Be careful, do not call MySqlEngineAvailable() before SetEnvironmentVariable("TargetDbType")
	
	if( m_CLSID == CLSID_SwstProv || m_CLSID == CLSID_SwstProvEnum )
	{

		// Initialize About Box. Warn if necessary
		AboutBox( g_LicenseStateSwst );

		if( g_LicenseStateSwst == EXPIRED || g_LicenseStateSwst == REGISTRATION ) 
			return CLASS_E_NOTLICENSED; 


		// This one is necessary for libmyodbc.lib
		SetEnvironmentVariable( "TargetDbType", "Btrieve" );

#ifdef SWSOFT_LIB
		// Configure ports for Lib version of *changed* MySQL 
		if(	MySqlEngineAvailable() == MYSQLAVAIL_DLL ) 
			mysql_applic_addref_instance();		
#endif
		
		m_createdCLSID = CLSID_SwstProv;

		return S_OK;
	}
	
	if( m_CLSID == CLSID_MySqlProv || m_CLSID == CLSID_MySqlProvEnum )
	{
		// Initialize About Box. Warn if necessary
		AboutBox( g_LicenseStateMySql );


		if( g_LicenseStateMySql == EXPIRED || g_LicenseStateMySql == REGISTRATION ) 
			return CLASS_E_NOTLICENSED; 

		// This one is necessary for libmyodbc.lib
		SetEnvironmentVariable( "TargetDbType", "MySql" );
		
		switch( MySqlEngineAvailable() )
		{
#ifdef SWSOFT_LIB
		case MYSQLAVAIL_DLL: // mysqld.dll
				if( mysql_server_init() )
					return E_FAIL;
				break;
#endif
			
			case MYSQLAVAIL_EXE: // mysqld.exe, not running
				{
					PROCESS_INFORMATION pi;  
					STARTUPINFO si;
					ZeroMemory( &si, sizeof(si) );
					si.cb = sizeof(si);

					// pass at least 1 parameter to prevent starting the EXE as service
					if( !CreateProcess( NULL, "mysqld.exe --standalone", NULL, NULL, FALSE, DETACHED_PROCESS, NULL, NULL, &si, &pi ) )
						return E_FAIL;
				}
				break;
		}
		
		m_createdCLSID = CLSID_MySqlProv;

		return S_OK;
	}

	return E_NOINTERFACE;
}

// CreateInstance ------------------------------------------------------------
//
// @mfunc Creates an uninitialized instance of an object class.
// Initialization is subsequently performed using another
// interface-specific method
//
// @rdesc HRESULT indicating the status of the method
//      @flag S_OK          | Interface is supported and ppvObject is set.
//      @flag E_NOINTERFACE | Interface is not supported by the object
//      @flag E_INVALIDARG  | One or more arguments are invalid.
//      @flag E_OUTOFMEMORY | Memory could not be allocated
//      @flag OTHER         | Other HRESULTs returned by called functions
//
STDMETHODIMP CClassFactory::CreateInstance
    (
    LPUNKNOWN   pUnkOuter,  //@parm IN | Points to the controlling IUnknown interface
    REFIID      riid,       //@parm IN | Interface ID of the interface being queried for.
    LPVOID *    ppvObj      //@parm OUT | Pointer to interface that was instantiated
    )
{
	TRACE( "CClassFactory::CreateInstance" );

    // Check for valid ppvObj pointer
    if (ppvObj == NULL)
        return  ( E_INVALIDARG );

    // In case we fail, we need to zero output arguments
    *ppvObj = NULL;

    // If we're given a controlling IUnknown, it must ask for IUnknown.
    // Otherwise, the caller will end up getting a pointer to their pUnkOuter
    // instead of to the new object we create and will have no way of getting
    // back to this new object, so they won't be able to free it.  Bad!
    if (pUnkOuter && riid != IID_IUnknown)
        return  ( E_NOINTERFACE );

    // Perform startup routines
	HRESULT hr = StartUp();
	if( FAILED(hr) )
		return hr;	
	
	return CreateInstanceHelper( pUnkOuter, riid, ppvObj );
}

STDMETHODIMP CClassFactory::CreateInstanceHelper
    (
    LPUNKNOWN   pUnkOuter,  //@parm IN | Points to the controlling IUnknown interface
    REFIID      riid,       //@parm IN | Interface ID of the interface being queried for.
    LPVOID *    ppvObj      //@parm OUT | Pointer to interface that was instantiated
    )
{
	PCDATASOURCE    pObj;
    HRESULT         hr;

    // If we asked to get sources rowset...
	if( m_CLSID == CLSID_SwstProvEnum || m_CLSID == CLSID_MySqlProvEnum )
	{
		// Create object
		CSources* pSources = new CSources( pUnkOuter );
		if( pSources == NULL )
			return E_OUTOFMEMORY;

		// Query interface
		if( !pSources->Init( m_CLSID == CLSID_MySqlProvEnum ) )
			return E_FAIL;

		hr = pSources->QueryInterface( riid, ppvObj ); 
		if( FAILED( hr ) )
			delete pSources;
		return hr;
	}

	// Create a CDataSource object
    pObj = new CDataSource( pUnkOuter );
	if( !pObj )
        return E_OUTOFMEMORY;

    // Initialize it
    if( !pObj->FInit( m_CLSID == CLSID_MySqlProv ) )
		return E_FAIL;
        
	hr = pObj->QueryInterface( riid, ppvObj );
    if (FAILED( hr ))
        delete pObj;
    return hr;
}


// LockServer ----------------------------------------------------------------
//
// @mfunc Controls whether an object application is kept in memory.
// Keeping the application alive in memory allows instances of this
// class to be created more quickly.
//
// @rdesc HRESULT indicating the status of the method
//      @flag S_OK | Interface is supported and ppvObject is set.
//
STDMETHODIMP CClassFactory::LockServer
    (
    BOOL fLock                  //@parm IN | TRUE or FALSE to lock or unlock
    )
{
    TRACE( "CClassFactory::LockServer" );

    if (fLock)
        InterlockedIncrement( &g_cLock );
    else
        InterlockedDecrement( &g_cLock );

    return NOERROR;
}

//  CClassFactory::GetLicInfo ---------------------------------------
//
//
//  Summary:  The GetLicInfo member method of the IClassFactory2 interface
//            implementation.
//
//  Args:     LPLICINFO lpLicInfo
//              Pointer to the license info structure to fill.
//
//  Returns:  HRESULT
//              Standard result code. NOERROR for success.
//--------------------------------------------------------------------------
STDMETHODIMP CClassFactory::GetLicInfo(
               LPLICINFO pLicInfo)
{
  TRACE( "CClassFactory::GetLicInfo" );
	
  HRESULT hr = NOERROR;

  if (NULL != pLicInfo)
  {
    pLicInfo->cbLicInfo = sizeof(LICINFO);

    // Inform whether RequestLicKey will work.
    pLicInfo->fRuntimeKeyAvail = true;

    // Inform whether the standard CreateInstance will work.
    pLicInfo->fLicVerified = (g_LicenseStateSwst == LICENSED);
  }
  else
    hr = E_POINTER;

  return hr;
}


//  CClassFactory::RequestLicKey ----------------------------------------
//
//
//  Summary:  The RequestLicKey member method of the IClassFactory2
//            interface implementation.  Returns a license key string
//            for this Class Factory.  The key string is used in calls
//            to the CreateInstanceLic IClassFactory2 method.
//
//  Args:     DWORD dwReserved,
//              Reserved for future use with multiple licenses.
//            BSTR* pbstrKey
//              Pointer to the buffer in which to return the key string.
//
//  Returns:  HRESULT
//              Standard result code. NOERROR for success.
//-----------------------------------------------------------------------
STDMETHODIMP CClassFactory::RequestLicKey(
               DWORD dwReserved,
               BSTR* pbstrKey)
{
  TRACE( "CClassFactory::RequestLicKey" );

  HRESULT hr = CLASS_E_NOTLICENSED;
  OLECHAR szLicKey[LICLENGTH];


  // Only return the license key if the server machine license was verified.
  if (g_LicenseStateSwst == LICENSED)
  {
    // Convert our ANSI license string to Wide Char and then alloc as BSTR.
    mbstowcs(szLicKey, g_szLicense, LICLENGTH);
    *pbstrKey = SysAllocString(szLicKey);
    hr = (NULL != *pbstrKey) ? NOERROR : E_OUTOFMEMORY;
  }

  return hr;
}

//  CClassFactory::CreateInstanceLic ------------------------------------
//
//  Summary:  The CreateInstanceLic member method of the IClassFactory2
//            interface implementation.  Creates an instance of the managed
//            COM object given a proper license key string.
//
//  Args:     IUnknown* pUnkOuter,
//              Pointer to the aggregation controlling IUnknown.
//            IUnknown* pUnkReserved,
//              Reserved.
//            REFIID riid,
//              A reference to the GUID of the interface requested on the
//              new object.
//            BSTR bstrKey,
//              The license key string.
//            LPVOID * ppvObj
//              Address of the caller's pointer variable that will
//              receive the requested interface pointer.
//
//  Returns:  HRESULT
//              Standard result code. NOERROR for success.
//------------------------------------------------------------------------
STDMETHODIMP CClassFactory::CreateInstanceLic(
               IUnknown* pUnkOuter,
               IUnknown* pUnkReserved,
               REFIID riid,
               BSTR bstrKey,
               LPVOID * ppvObj)
{
  TRACE( "CClassFactory::CreateInstanceLic" );

  HRESULT hr;
  BOOL    bMatch = FALSE;
  BSTR    bstrTemp;
  OLECHAR szLicKey[LICLENGTH];

    // Check for valid ppvObj pointer
	if (ppvObj == NULL)
		return  ( E_INVALIDARG );

	*ppvObj = NULL;

	// Prepare for the possibility that there might be an error
	hr =  ( E_OUTOFMEMORY );


	// Convert our ANSI license string to Wide Char and then alloc as BSTR.
	mbstowcs(szLicKey, g_szLicense, LICLENGTH);

	bstrTemp = SysAllocString(szLicKey);
    if (NULL != bstrKey)
		bMatch = (0 == memcmp(bstrTemp, bstrKey, LICLENGTH * sizeof(OLECHAR)));

    SysFreeString(bstrTemp);

	return bMatch ? CreateInstanceHelper( pUnkOuter, riid, ppvObj ) : CLASS_E_NOTLICENSED;
}

//---------------------------------------------------------------------------
// @func    Removes keys to the registry.
//
// @rdesc Returns NOERROR
//
// @comm
// Special Notes:   This allows us to avoid using a .reg file.
//
// Note that a more robust method would be to trace existing
// CLSID and ProgID, and trace each from the other.  This would handle the
// case where either changed.  Then should probably enumerate all keys under
// the ProgID and CLSID, then delete them.
//
// Also note the problem with our exposing a different CLSID for the debug
// and ndebug versions, yet the ProgID remains the same.  Should we have
// different ProgID's also?
//
//---------------------------------------------------------------------------
STDAPI DllUnregisterServer(void)
{
    int     i;
    int     iNumErrors = 0;
	LONG	stat;

    // Delete all table entries.  Loop in reverse order, since they
    // are entered in a basic-to-complex order.
    // We cannot delete a key that has subkeys.
    // Ignore errors.
    for (i=NUMELEM( s_rgRegInfo ) - 1; i >= 0; i--)
    {
		stat = RegDeleteKey( HKEY_CLASSES_ROOT, s_rgRegInfo[i].strRegKey );
        if ((stat != ERROR_SUCCESS) && 
        	(stat != ERROR_FILE_NOT_FOUND) )
			   iNumErrors++;
    }
    
	return  ( iNumErrors ? E_FAIL : S_OK );
}


//---------------------------------------------------------------------------
// @func    Adds necessary keys to the registry.
//
// @rdesc Returns one of the following
// @flag NOERROR    | Registration succeeded
// @flag E_FAIL     | Something didn't work
//
// @comm
// Special Notes:   This allows us to avoid using a .reg file.
// Here is what was in the SwstProv.REG file of yours.
// Note that now we have two CLSID's, one for DEBUG.  Then each one
// can point to a different .DLL.
//
//---------------------------------------------------------------------------
STDAPI DllRegisterServer(void)
{
    int         i;
    HKEY        hk;
    HMODULE     hModule;
    DWORD       dwDisposition;
    LONG        stat;
    char        strOutBuff[300 ], strFileName[MAX_PATH + 1 ];

    // Get the full path name for this DLL.
    if (NULL == (hModule = GetModuleHandle( s_strDllName )))
        return  ( E_FAIL );
    if (0 == GetModuleFileName( hModule, strFileName, MAXSTR( strFileName ) ) )
        return  ( E_FAIL );
	// Some partes of provider require short names
	if (0 == GetShortPathName( strFileName, strFileName, MAXSTR( strFileName ) ) )
		return ( E_FAIL );

    // Make a clean start
    DllUnregisterServer();

    // Loop through s_rgRegInfo, and put everything in it.
    // Every entry is based on HKEY_CLASSES_ROOT.
    for (i=0; i < NUMELEM( s_rgRegInfo ); i++)
        {
        // Fill in any "%s" arguments with the name of this DLL.
        wsprintf( strOutBuff, s_rgRegInfo[i].strValue, strFileName );

        // Create the Key.  If it exists, we open it.
        // Thus we can still change the value below.
        stat = RegCreateKeyEx(
                HKEY_CLASSES_ROOT,
                s_rgRegInfo[i].strRegKey,
                0,  // dwReserved
                NULL,   // lpszClass
                REG_OPTION_NON_VOLATILE,
                KEY_ALL_ACCESS, // security access mask
                NULL,   // lpSecurityAttributes
                &hk,    // phkResult
                &dwDisposition );
        if (stat != ERROR_SUCCESS)
            return  ( E_FAIL );

        stat = RegSetValueEx(
                hk,								// created above
                s_rgRegInfo[i].strValueName,	// lpszValueName
                0,								// dwReserved
                REG_SZ,							// fdwType
                (BYTE *) strOutBuff,			// value
                strlen( strOutBuff ) + sizeof( char )); // cbData, including null terminator
        RegCloseKey( hk );
        if (stat != ERROR_SUCCESS)
            return  ( E_FAIL );
        }
	
	//Don't overwrite previous timestamp
	DWORD rtsSwst = RegistryTimeStamp( REGTMSTP_BTRIEVE );
	DWORD rtsMySql = RegistryTimeStamp( REGTMSTP_MYSQL );
	//if( rts != 0 && rts != -1 )
	//	return (S_OK);
    


	return  ( S_OK );
}


// About box
void AboutBox(LICENSESTATE newState )
{
	static LICENSESTATE licState = EXPIRED;
	static int iCall = 0;
	
	// Count every call
	iCall++;

	// Show me during loading if the version is not licensed
	if( iCall == 1 )
	{
		if( newState != LICENSED && newState != REGISTRATION )
			DialogBoxParam(g_hInstance, MAKEINTRESOURCE(IDD_SPLASH), NULL, DlgSplashScreen, newState );

		// Init state
		licState = newState;
	}
	
	
	// Show me if it was not shown yet
	if( iCall > 2 || (iCall == 2 && ( licState == LICENSED || newState == REGISTRATION ) ) )
		DialogBoxParam(g_hInstance, MAKEINTRESOURCE(IDD_SPLASH), NULL, DlgSplashScreen, licState );
}

CLSID CClassFactory::m_createdCLSID = { 0, 0, 0, { 0, 0, 0, 0, 0, 0, 0, 0 } };
