/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: minimum
// Release: 0.1
//
// @doc
//
// @module CRTSESS.CPP | IDBCreateSession interface implementation
//

// Includes ------------------------------------------------------------------

#include "hfiles.h"
#include "headers.h"


// Code ----------------------------------------------------------------------

// CImpIDBCreateSession::CreateSession ------------------------------------------------
//
// @mfunc Creates a new DB Session object from the DSO, and returns the
// requested interface on the newly created object.
//
// @rdesc HRESULT
//      @flag S_OK                  | The method succeeded.
//      @flag E_INVALIDARG          | ppDBSession was NULL
//      @flag DB_E_NOAGGREGATION    | pUnkOuter was not NULL (this object does not support
//                                    being aggregated)
//      @flag E_FAIL                | Provider-specific error. This provider can only create
//                                    one DBSession
//      @flag E_OUTOFMEMORY         | Out of memory
//      @flag E_NOINTERFACE         | Could not obtain requested interface on DBSession object
//      @flag E_UNEXPECTED	        | The data source object was in an uninitialized state
//      @flag DB_E_OBJECTCREATIONLIMITREACHED | The maximum number of sessions supported 
//									  by the provider has already been created. 
//      @flag DB_E_OBJECTOPEN       | The provider would have to open a new connection to 
//									  support the operation and DBPROP_MULTIPLECONNECTIONS is set to VARIANT_FALSE
//
STDMETHODIMP CImpIDBCreateSession::CreateSession
    (
    IUnknown*   pUnkOuter,  //@parm IN | Controlling IUnknown if being aggregated 
    REFIID      riid,       //@parm IN | The ID of the interface 
    IUnknown**  ppDBSession //@parm OUT | A pointer to memory in which to return the interface pointer
    )
{
	INTERFACE_METHOD_START( "IDBCreateSession::CreateSession" );

    CDBSession* pDBSession = NULL;
    HRESULT hr;

	ULONG	ulSess;

    // check in-params and NULL out-params in case of error
    if (ppDBSession)
        *ppDBSession = NULL;
    else
        return E_INVALIDARG;
	
	if (pUnkOuter != NULL && riid != IID_IUnknown)
		return DB_E_NOAGGREGATION;

    assert( m_pObj );
	
	// Check to see if the DSO is Uninitialized
	if (!m_pObj->m_fDSOInitialized)
        return E_UNEXPECTED;
	
	// Create session:
	// Get number of first inactive session
	hr = m_pObj->GetFirstInactiveSession(&ulSess);
	if (hr == S_FALSE)
		return 	DB_E_OBJECTCREATIONLIMITREACHED;	

	// shortcut for (m_pObj->m_pSessions)[ulSess]
	pDBSession = (m_pObj->m_pSessions)[ulSess];
	// some cautions
	assert(ulSess < NUM_SUPPORTED_SESSIONS_PER_DATASOURCE);
	assert(pDBSession == NULL);

	// allocate memory for new session
    pDBSession = new CDBSession( pUnkOuter );
    if (!pDBSession)
        return E_OUTOFMEMORY;

	// mark session # ulSess as active
	hr = m_pObj->SetActiveSession(ulSess);
	if (hr == S_FALSE)
		return E_FAIL;	
	
	// refresh the number of active sessions
	hr = m_pObj->CountActiveSessions();
	if (hr != S_OK)
		return E_FAIL;	

	// Initialize new session
    if (!pDBSession->FInit( ulSess, /*m_pObj->m_szPath,*/ m_pObj ))
	{
        delete pDBSession;
        return E_FAIL;
	}

    // get requested interface pointer on DBSession
    hr = pDBSession->QueryInterface(riid, (void**)ppDBSession);
	if (hr != S_OK)
	{
        delete pDBSession;
        return hr;
	}
	
	return S_OK;

	INTERFACE_METHOD_END();
}



