/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: minimum
// Release: 0.1
//
// @doc
//
// @module PERSIST.CPP | IPersist interface implementation
//

// Includes ------------------------------------------------------------------

#include "hfiles.h"
#include "headers.h"


// Code ----------------------------------------------------------------------

// CImpIPersist::GetClassID --------------------------------------------------
//
// @mfunc Get the CLSID of the DSO.
//
// @rdesc HRESULT
//      @flag S_OK                  | The method succeeded.
//      @flag E_FAIL                | Provider-specific error.
//
STDMETHODIMP CImpIPersist::GetClassID(CLSID *pClassID)
{
	INTERFACE_METHOD_START( "IPersist::GetClassID" );
	
	// Check the pointer
	if (pClassID == NULL)
		return E_FAIL;
	
	memcpy(pClassID, &CLSID_MySqlProv, sizeof(CLSID));
	
	return S_OK;

	INTERFACE_METHOD_END();
}


// CImpIPersist::IsDirty --------------------------------------------------
//
// Checks an object for changes since it was last saved to its current file
//
// Return Values
//		S_OK The object has changed since it was last saved. 
//		S_FALSE The object has not changed since the last save
//
STDMETHODIMP CImpIPersist::IsDirty()
{
	INTERFACE_METHOD_START( "IPersistFile::IsDirty" );
	
	// Dummy implementation
	return S_OK;
	
	INTERFACE_METHOD_END();
}


// CImpIPersist::Load --------------------------------------------------------
// Opens the specified file and initializes an object from the file contents.
//
// Return Values
//		S_OK	The object was successfully loaded. 
//		E_OUTOFMEMORY	The object could not be loaded due to a lack of memory. 
//		E_FAIL	The object could not be loaded for some reason other than a lack of memory. 
//		IPersistFile::Load STG_E_* error codes. 
//
STDMETHODIMP CImpIPersist::Load(
  LPCOLESTR pwszFileName,  // [in] Pointer to absolute path of the file to open
  DWORD dwMode			// [in] Specifies the access mode from the STGM enumeration
								)
{
	INTERFACE_METHOD_START( "IPersistFile::Load" );
	
	HRESULT hr;
	
	// This function only sets initialization properties: 
	// DBPROP_INIT_DATASOURCE and DBPROP_INIT_PROMPT.
	// User should initialize data source object before aby actions
	// If it is already initialized, then setting of properties fails.
	// I ignore dwMode param now (because there are no appropriate settable properties)
	
	// There are no necessary objects (unexpected error)
	assert( m_pObj && m_pObj->m_pUtilProp );
	if( !m_pObj || !m_pObj->m_pUtilProp )
		return E_FAIL;
	
	// Set properties: Data Source name as file name; ask to keep silence
	DBPROPSET	rgPropertySets[1];
	DBPROP		rgProp[2];

	// Set up datasource name
	rgProp[0].dwPropertyID					= DBPROP_INIT_DATASOURCE;
	rgProp[0].dwOptions						= DBPROPOPTIONS_REQUIRED;
	rgProp[0].colid							= DB_NULLID;
	V_VT(&rgProp[0].vValue)					= VT_BSTR;
	V_BSTR(&rgProp[0].vValue)				= SysAllocString( pwszFileName );	
	
	// Set up prompt options
	rgProp[1].dwPropertyID					= DBPROP_INIT_PROMPT;
	rgProp[1].dwOptions						= DBPROPOPTIONS_REQUIRED;
	rgProp[1].colid							= DB_NULLID;
	V_VT(&rgProp[1].vValue)					= VT_I2;
	V_I2(&rgProp[1].vValue)					= DBPROMPT_NOPROMPT;	

	// Set up property sets array
	rgPropertySets[0].guidPropertySet		= DBPROPSET_DBINIT;
	rgPropertySets[0].cProperties			= 2;
	rgPropertySets[0].rgProperties			= rgProp;

	// Set necessary properties
	hr = m_pObj->m_pUtilProp->SetProperties(
									PROPSET_INIT,
									1, 
									rgPropertySets );
	
	// Release allocated memory
	VariantClear( &rgProp[0].vValue );  
	
	// Return values according to specifications
	if( hr == S_OK )
		return hr;
	if( hr == E_OUTOFMEMORY )
		return hr;
	return E_FAIL;

	INTERFACE_METHOD_END();
}


// CImpIPersist::Save --------------------------------------------------
//
// Saves a copy of the object into the specified file
//
// Return Values
//		S_OK The object was successfully saved 
//		E_FAIL The file was not saved
//
STDMETHODIMP CImpIPersist::Save(
  LPCOLESTR pszFileName,   // [in] Pointer to absolute path of the file 
                           //where the object is saved
  BOOL fRemember           // [in] Specifies whether the file is to be the 
                           //current working file or not								
								)
{
	INTERFACE_METHOD_START( "IPersistFile::Save" );
	
	// Dummy implementation
	return E_FAIL;

	INTERFACE_METHOD_END()
}


// CImpIPersist::Save --------------------------------------------------
//
// Notifies the object that it can write to its file. 
// It does this by notifying the object that it can revert from NoScribble mode 
// (in which it must not write to its file), to Normal mode (in which it can). 
// The component enters NoScribble mode when it receives an IPersistFile::Save call.
//
// Return Values
//		S_OK Returned in all cases
//
STDMETHODIMP CImpIPersist::SaveCompleted(
	LPCOLESTR pszFileName  // [in] Pointer to absolute path of the file where the object was saved
										)
{
	INTERFACE_METHOD_START( "IPersistFile::SaveCompleted" );

	// Dummy implementation
	return S_OK;

	INTERFACE_METHOD_END();
}


// CImpIPersist::Save --------------------------------------------------
//
// Retrieves either the absolute path to the object's current working file or, 
// if there is no current working file, the object's default filename prompt
//
// Return Values
//		S_OK	A valid absolute path was successfully returned. 
//		S_FALSE The default save prompt was returned. 
//		E_OUTOFMEMORY The operation failed due to insufficient memory. 
//		E_FAIL The operation failed due to some reason other than insufficient memory
//		
//
STDMETHODIMP CImpIPersist::GetCurFile(
	LPOLESTR *ppszFileName  // [out] Pointer to the path for the current file or the default save prompt
							// Callers should use IMalloc::Free to free allocated memory
										)
{
	INTERFACE_METHOD_START( "IPersistFile::GetCurFile" );

	// Set up out variables for the case if errors occure
	if( ppszFileName )
		*ppszFileName = NULL;

	// check argments
	if( ppszFileName == NULL )
		return E_FAIL;
	
	// check necessary objects
	assert( m_pObj && g_pIMalloc );
	if( !m_pObj || !g_pIMalloc )
		return E_FAIL;

	if( *m_pObj->m_szDDFPath ) // if path is set
	{
		// Allocate memory
		*ppszFileName = (WCHAR*) g_pIMalloc->Alloc( sizeof( m_pObj->m_szDDFPath ) * sizeof( WCHAR ) + sizeof(L"\\file.ddf") );
		if( *ppszFileName == NULL )
			return E_OUTOFMEMORY;

		// Convert path
		A2W( m_pObj->m_szDDFPath, *ppszFileName, sizeof( m_pObj->m_szDDFPath ) - 1 );
		// Append file name to directory name
		wcscat( *ppszFileName, L"\\file.ddf" );
		
		return S_OK;  // File is returned
	}
	else  // file is not set
	{
		// Allocate memory
		*ppszFileName = (WCHAR*) g_pIMalloc->Alloc( sizeof( L"*.ddf" ) );
		if( *ppszFileName == NULL )
			return E_OUTOFMEMORY;

		// Convert path
		wcscpy( *ppszFileName, L"*.ddf" );

		return S_FALSE;	// Prompt, not a file
	}

	INTERFACE_METHOD_END();
}
