/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: base
// Release: 0.1
//
// @doc 
//
// @module ROWSCROLL.H | CRowsetScroll base object and contained interface
// definitions
//
//
//----------------------------------------------------------------------------
// @class CImpIRowsetScroll | Contained IRowsetScroll class
//
class CImpIRowsetScroll : public IRowsetScroll		//@base public | IRowsetScroll
{
	private: //@access private
		DEBUGCODE(ULONG m_cRef);										
		CRowset		*m_pObj;											
		LPUNKNOWN	m_pUnkOuter;

	public: //@access public
		CImpIRowsetScroll( CRowset *pObj, IUnknown *pUnkOuter )					
		{																	
			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}																	
		
		~CImpIRowsetScroll()														
		{																	
		}

		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}


	//	IRowsetScroll members inherited from IRowsetLocate
	//@cmember Compares two bookmarks.
	STDMETHODIMP	Compare (
						HCHAPTER		hReserved, 
						ULONG			cbBookmark1, 
						const BYTE*		pBookmark1,
						ULONG			cbBookmark2,
						const BYTE*		pBookmark2,
						DBCOMPARE*		pComparison);

	//@cmember Fetches rows starting with the row specified by an offset from a bookmark.
	STDMETHODIMP	GetRowsAt (
						HWATCHREGION	hReserved1,
						HCHAPTER		hReserved2,
						ULONG			cbBookmark,
						const BYTE*		pBookmark,
						LONG			lRowsOffset,
						LONG			cRows,
						ULONG*			pcRowsObtained,
						HROW**			prghRows);

	//@cmember Fetches the rows that match the specified bookmarks.
	STDMETHODIMP	GetRowsByBookmark (
						HCHAPTER		hChapter,
						ULONG			cRows,
						const ULONG		rgcbBookmarks[],
						const BYTE*		rgpBookmarks[],
						HROW			rghRows[],
						DBROWSTATUS		rgRowStatus[]);

	//@cmember Returns hash values for the specified bookmarks.
	STDMETHODIMP	Hash (
						HCHAPTER		hChapter,
						ULONG			cBookmarks,
						const ULONG		rgcbBookmarks[],
						const BYTE*		rgpBookmarks[],
						DWORD			rgHashedValues[],
						DBROWSTATUS		rgBookmarkStatus[]);

		//	"Native" IRowsetScroll members
		//@cmember GetApproximatePosition Method 
		// Gets the approximate position of a row corresponding to a specified bookmark
		STDMETHODIMP GetApproximatePosition (
						HCHAPTER        hChapter,
						ULONG           cbBookmark,
						const BYTE *    pBookmark,
						ULONG *         pulPosition,
						ULONG *         pcRows);

		//@cmember GetRowsAtRatio Method 
		// Fetches rows starting from a fractional position in the rowset
		STDMETHODIMP GetRowsAtRatio (
						HWATCHREGION    hReserved1,
						HCHAPTER        hChapter,
						ULONG           ulNumerator,
						ULONG           ulDenominator,
						LONG            cRows,
						ULONG *         pcRowsObtained,
						HROW **         prghRows);
};

