/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: minimum
// Release: 0.1
//
// @doc
//
// @module TTYPES.H | Main include file
//
#ifndef _TTYPES_H_
#define _TTYPES_H_

// DB_BIT helpers
typedef class bitset<8> BITS8;

//  Data Types
// As define's set 
#define BDTC_STRING		0			// STRING
#define BDTC_INTEGER	1			// INTEGER
#define BDTC_FLOAT		2			// FLOAT
#define BDTC_DATE		3			// DATE
#define BDTC_TIME		4			// TIME
#define BDTC_DECIMAL	5			// DECIMAL
#define BDTC_MONEY		6			// MONEY
#define BDTC_LOGICAL	7			// LOGICAL
#define BDTC_NUMERIC	8			// NUMERIC
#define BDTC_BFLOAT		9			// BFLOAT
#define BDTC_LSTRING	10 			// LSTRING
#define BDTC_ZSTRING	11 			// ZSTRING
#define BDTC_UNSIGNED   14 			// UNSIGNED
#define BDTC_AUTOINC	15 			// AUTOINCREMENT
#define BDTC_NUMERICSTS 17 			// NUMERICSTS
#define BDTC_NUMERICSA  18 			// NUMERICSA
#define BDTC_CURRENCY   19 			// CURRENCY
#define BDTC_TIMESTAMP  20 			// TIMESTAMP

// NOTE Type
#define NOTE_TYPE       12 			// NOTE
#define LVAR_TYPE		13 			// LVAR
#define BIT_TYPE		16 			// BIT
#define LONGVAR_TYPE	21			// LONGVARCHAR, LONG VARBINARY

#define MAXSUPPORTEDLEN_LONGVARTYPE		1024 // Should be more than SIZEOF_CASHDATA


// CONVERSION: TIMESTAMP 
#define TS_MASK			"yyyy-mm-ddBhh:tt:ss[.fffffff]"
#define TS_MASK_LENGTH	30

// CONVERSION: BFLOAT 
#define BF_MASK			"-Z.ZZZZZZZZZZZZZZZZZE+ZZZ"
// #define BF_MASK		"9.999999999999999999E+999"
#define BF_MASK_LENGTH	27

// CONVERSION: NUMERIC 
#define NUM_MASK		"-ZZZZZZZZZZZZZZZZZZ.ZZZZZZZZZ"
#define NUM_MASK_LENGTH	30


// ABS VALUE
#define ABSVAL(x)		((x) > 0 ? (x) : -1*(x))

// As enum type
typedef enum tagSwstDataTypeCodes
{
	eBDTC_STRING = 0,		// STRING
	eBDTC_INTEGER = 1,		// INTEGER
	eBDTC_FLOAT = 2,		// FLOAT
	eBDTC_DATE = 3,			// DATE
	eBDTC_TIME = 4,			// TIME
	eBDTC_DECIMAL = 5,		// DECIMAL
	eBDTC_MONEY = 6,		// MONEY
	eBDTC_LOGICAL = 7,		// LOGICAL
	eBDTC_NUMERIC = 8,		// NUMERIC
	eBDTC_BFLOAT = 9,		// BFLOAT
	eBDTC_LSTRING = 10,		// LSTRING
	eBDTC_ZSTRING = 11,		// ZSTRING
	eBDTC_UNSIGNED = 14,	// UNSIGNED
	eBDTC_AUTOINC = 15,		// AUTOINCREMENT
	eBDTC_NUMERICSTS = 17,	// NUMERICSTS
	eBDTC_NUMERICSA = 18,	// NUMERICSA
	eBDTC_CURRENCY = 19,	// CURRENCY
	eBDTC_TIMESTAMP = 20,	// TIMESTAMP
} SwstDataTypeCodes;


// Detailed information about columns in a table 
typedef struct
{
  MT_SINT siOffset;		// Column offset in data record.
  MT_BYTE btDataType;		// Data type code.
  MT_BYTE btFlags;			// Flags
  MT_SINT btSize;			// Internal size.
  MT_SINT siDecs;			// Number of decimal places.
  MT_CHAR caName[20];		// Column name (blank filled).
} COLUMN_INFO_BUF;

typedef COLUMN_INFO_BUF* PCOLUMN_INFO_BUF;

// Detailed information about the table (returned by xDDFile function)
typedef struct _SWST_TABLE_STATUS_INFO
{
	MT_SINT	siRecordLength;		// Record Length 2
	MT_SINT	shPageSize;			// Page Size 2
	MT_SINT	shNumOfIndexes;		// Number of indexes 2
	MT_LONG	lNumOfRecords;		// Number of records 4
	MT_SINT	shFileFlags;		// MicroKernel File flags 2
	MT_SINT	siReserved;			// Reserved Word 2
	MT_SINT	shUnusedPages;		// Number of unused pages 2

	//////////////////
	/*
	MT_INT  shPageSize;		// MicroKernel PageSize
	MT_INT  shFileFlags;		// MicroKernel File flags
	MT_INT  shUnusedPages;		// Number of unused pages
	MT_INT  shTMAColSec;		// Total without alternate collating sequence
	MT_BYTE bReserved[4];		// Reserved
	MT_BYTE bAColSeq[265];		// Alternate collating sequence
	MT_BYTE bTPAColSeq[281];	// Total with alternate collating sequence
	*/
} SWST_TABLE_STATUS_INFO;

typedef SWST_TABLE_STATUS_INFO* PTR_SWST_TABLE_STATUS_INFO;

// SWST_TABLE_STATUS_INFO buffer size, necessary when stat operation called
#define	STATUS_BUFFER_SIZE	512

/*
// Detailed information about the table Name (returned by xDDFile function)
typedef struct _SWST_TABLE_NAME_INFO
{
	MT_SINT siFlag;			// Flag
	MT_BYTE bPath[64];			// DOS path
	MT_BYTE bTable[20];		// File name
} SWST_TABLE_NAME_INFO;

typedef SWST_TABLE_NAME_INFO* PTR_SWST_TABLE_NAME_INFO;
*/

// Detailed information about Get ConnectOption Block Parameter
// (used by GetConnectOption function)
typedef struct _GCOPARAMBLOCK { 
	   MT_SINT iOption;
	   MT_SINT iType;
	   MT_SIZE iSize;
	   MT_SIZE iDec;
	   MT_SIZE iDSize;
	   MT_CHAR_PTR sValue;
	   MT_CHAR_PTR sRetVal;
	   MT_CHAR_PTR sMask;
	   MT_SINT iJustify;
   } GCOPARAMBLOCK;
typedef  GCOPARAMBLOCK *PTR_GCOPARAMBLOCK;


// type for  Get Position
typedef union {
	char  chPos[PHYSICAL_POS_BUF_LEN];
	ULONG ulPos;
} MT_RECPOSITION, *MT_RECPOSITION_PTR;


//  Type definitions for Client ID and version Structures
typedef struct
{
  MT_CHAR networkAndNode[12];
  MT_CHAR applicationID[2];
  MT_WORD threadID;
} CLIENT_ID;

typedef struct
{
  MT_SINT  Version;
  MT_SINT  Revision;
  MT_CHAR  MKDEId;
} VERSION_STRUCT;


// typedefs, usefull for extracting data from  data buffer

typedef struct
{
	BYTE day;
	BYTE month;
	WORD year;
} BT_DATE;
 
typedef struct
{
	BYTE hsecond;
	BYTE second;
	BYTE minute;
	BYTE hour;
} BT_TIME;

#endif