/*
 * aBasic
 * Copyright (C) 2007 m_inaba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "calc.h"


static char buf[MAX_STR_LEN];


//g[NƂɐ؂o
void token(char*str,std::vector<std::string>*data){
	char pos;
	std::string strpos="";
	while(pos=*str++){
		switch (pos){
		case '\"':
			strpos=strpos+pos;
			pos=*str++;
			while('\"'!=pos && '\0'!=pos){
				if('\\'==pos){//GXP[vV[PX̓ǂݍ
					//strpos=strpos+pos;
					pos=*str++;
					if('\0'==pos){return;}//vIȃG[
					if('n'==pos) pos='\n';
				}
				strpos=strpos+pos;
				pos=*str++;//""ň͂܂ꂽǂݔ΂
			}
			//͐擪"̂ƍl
			//strpos=strpos+pos;
			break;
		case '+':
			if(strpos!="") data->push_back(strpos);
			strpos="";
			data->push_back("+");
			break;
		case '-':
			if(strpos!="") data->push_back(strpos);
			strpos="";
			data->push_back("-");
			break;
		case '*':
			if(strpos!="") data->push_back(strpos);
			strpos="";
			data->push_back("*");
			break;
		case '/':
			if(strpos!="") data->push_back(strpos);
			strpos="";
			data->push_back("/");
			break;
		case '(':
			if(strpos!="") data->push_back(strpos);
			strpos="";
			data->push_back("(");
			break;
		case ')':
			if(strpos!="") data->push_back(strpos);
			strpos="";
			data->push_back(")");
			break;
//------------------------------------------------
		case '=':
			if(strpos!="") data->push_back(strpos);
			strpos="";
			data->push_back("=");
			break;
		case '<':
			if(strpos!="") data->push_back(strpos);
			strpos="";
			if('='==*(str)){
				data->push_back("<=");
				str++;
			}else if('>'==*(str)){
				data->push_back("<>");
				str++;
			}else{
				data->push_back("<");
			}
			break;
		case '>':
			if(strpos!="") data->push_back(strpos);
			strpos="";
			if('='==*(str)){
				data->push_back(">=");
				str++;
			}else{
				data->push_back(">");
			}
			break;
		case '&':
			if(0==strncmp((str-1),"&&",sizeof("&&")-1)){
				str++;
				if(strpos!="") data->push_back(strpos);
				strpos="";
				data->push_back("&&");
				break;
			}
		case '|':
			if(0==strncmp((str-1),"||",sizeof("||")-1)){
				str++;
				if(strpos!="") data->push_back(strpos);
				strpos="";
				data->push_back("||");
				break;
			}
//------------------------------------------------
		default:
			strpos=strpos+pos;
			break;
		}
	}
	if(strpos!="") data->push_back(strpos);
}

//g[Nł邩mF
bool isToken(std::string str){
	if(
		str=="+" || str=="-" || str=="*" || str=="/" || str=="=" || str=="<" ||
		str=="<=" || str==">" || str==">=" || str=="&&" || str=="||" || str=="<>"
		) return true;
	return false;
}

//g[N̐`
void tokenAna(std::vector<std::string>*in,std::vector<std::string>*out){
	if(isToken((*in)[0])){
		(*in)[1]=(*in)[0]+(*in)[1];
	}else{
		out->push_back((*in)[0]);
	}

	for(int i=1;(unsigned int)i<in->size();i++) {
		if(isToken((*in)[i])){
			if(isToken((*in)[i-1])){
				(*in)[i+1]=(*in)[i]+(*in)[i+1];
			}else{
				if((*in)[i-1]=="("){
					(*in)[i+1]=(*in)[i]+(*in)[i+1];
				}else{
					out->push_back((*in)[i]);
				}
			}
		}else{
			out->push_back((*in)[i]);
		}
	}
}



//t|[h@ɕϊ邽߂̉Zq̗D揇ʂ
int Priority(const char*str){
	if(0==strcmp(str,"=")) return 5;
	if(0==strcmp(str,"<")) return 5;
	if(0==strcmp(str,"<=")) return 5;
	if(0==strcmp(str,">")) return 5;
	if(0==strcmp(str,">=")) return 5;
	if(0==strcmp(str,"<>")) return 5;
	if(0==strcmp(str,"&&")) return 4;
	if(0==strcmp(str,"||")) return 4;

	if(0==strcmp(str,"+")) return 10;
	if(0==strcmp(str,"-")) return 10;
	if(0==strcmp(str,"*")) return 20;
	if(0==strcmp(str,"/")) return 25;
	return 0;
}

//t|[h@ɕϊ
void Analyzer(std::vector<std::string>*data,std::vector<std::string>*out,int*i){
	std::stack<const char*> stack;

	for(;(unsigned int)*i<data->size();(*i)++){
		if( (*data)[*i]=="+" || (*data)[*i]=="-" || (*data)[*i]=="*" || (*data)[*i]=="/" ||
			(*data)[*i]=="=" || (*data)[*i]=="<" || (*data)[*i]=="<="|| (*data)[*i]==">" ||
			(*data)[*i]==">="|| (*data)[*i]=="<>"|| (*data)[*i]=="||"|| (*data)[*i]=="&&"
			){
			if(stack.empty()==false){//false : X^bNɒl
				if(Priority((*data)[*i].c_str())==Priority(stack.top())){
					stack.push((*data)[*i].c_str());//l̒ǉ
				}
				if(Priority((*data)[*i].c_str())<Priority(stack.top())){
					while(stack.empty()==false){//false : X^bNɒl
						const char*str=stack.top();//Ō̒l̎擾
						stack.pop();//Ō̒l̍폜
						out->push_back(str);
					}
					stack.push((*data)[*i].c_str());//l̒ǉ
				}
				if(Priority((*data)[*i].c_str())>Priority(stack.top())){
					stack.push((*data)[*i].c_str());//l̒ǉ
				}
			}else{
				stack.push((*data)[*i].c_str());//l̒ǉ
			}
		}else{
			if((*data)[*i]=="("){
				*i=*i+1;
				Analyzer(data,out,i);
			}else{
				if((*data)[*i]==")"){
					goto end;
				}else{
					out->push_back((*data)[*i]);
				}
			}
		}
	}
end:
	while(stack.empty()==false){//false : X^bNɒl
		const char*str=stack.top();//Ō̒l̎擾
		stack.pop();//Ō̒l̍폜
		out->push_back(str);
	}
}

//t|[h@\ĽvZvZ
VARIANT_ calc(std::vector<std::string>*out){
	int c=(int)(out->size());
	std::stack<VARIANT_> stack;
	VARIANT_ j,k;
	for(int i=0;i<c;i++){
			if((*out)[i]== "+"){
				j=stack.top();
				stack.pop();
				k=stack.top();
				stack.pop();
				stack.push(k+j);
			}else if((*out)[i]=="-"){
				j=stack.top();
				stack.pop();
				k=stack.top();
				stack.pop();
				stack.push(k-j);
			}else if((*out)[i]=="*"){
				j=stack.top();
				stack.pop();
				k=stack.top();
				stack.pop();
				stack.push(k*j);
			}else if((*out)[i]=="/"){
				j=stack.top();
				stack.pop();
				k=stack.top();
				stack.pop();
				stack.push(k/j);
//----------------------------------------------------
			}else if((*out)[i]=="="){
				j=stack.top();
				stack.pop();
				k=stack.top();
				stack.pop();
				stack.push(k==j);
			}else if((*out)[i]=="<"){
				j=stack.top();
				stack.pop();
				k=stack.top();
				stack.pop();
				stack.push(k<j);
			}else if((*out)[i]=="<="){
				j=stack.top();
				stack.pop();
				k=stack.top();
				stack.pop();
				stack.push(k<=j);
			}else if((*out)[i]==">"){
				j=stack.top();
				stack.pop();
				k=stack.top();
				stack.pop();
				stack.push(k>j);
			}else if((*out)[i]==">="){
				j=stack.top();
				stack.pop();
				k=stack.top();
				stack.pop();
				stack.push(k>=j);
			}else if((*out)[i]=="<>"){
				j=stack.top();
				stack.pop();
				k=stack.top();
				stack.pop();
				stack.push(k!=j);
			}else if((*out)[i]=="&&"){
				j=stack.top();
				stack.pop();
				k=stack.top();
				stack.pop();
				stack.push(k&&j);
			}else if((*out)[i]=="||"){
				j=stack.top();
				stack.pop();
				k=stack.top();
				stack.pop();
				stack.push(k||j);
//-----------------------------------------------------

			}else{
				j=setVariant((char*)(*out)[i].c_str());//ϐlɕϊsĂ
				stack.push(j);
			}
		}
	return stack.top();
}


//vZvZĕϐe[uɊi[
void calculation(char*str){
	char*st_ptr=strstr((const char*)str,"=");
	if(NULL!=st_ptr){
		*st_ptr++='\0';
		std::vector<std::string> data;
		std::vector<std::string> out;

		token(st_ptr,&data);
		
		std::vector<std::string> data2;
		tokenAna(&data,&data2);

		//{printf("g[N؂o : ");for(int a=0;a<data2.size();a++) printf("%s ",data2[a].c_str());}
		
		int c=0;
		Analyzer(&data2,&out,&c);

		//{printf("\nt|[h@ɕϊ : ");for(int a=0;a<out.size();a++) printf("%s ",out[a].c_str());}

		str_print_(calc(&out),buf);
		setVariable(str,buf);
	}
}


//-------------------------------------------------------------------------------
