/*
 * aBasic
 * Copyright (C) 2007 m_inaba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "vari.h"

struct ltstr
{
  bool operator()(const char* s1, const char* s2) const
  {
    return strcmp(s1, s2) < 0;
  }
};

std::map<const char*,st_form,ltstr> variable_table;//̃}bv
std::map<const char*,st_form,ltstr>::iterator it;


//`̕ϐ͒lϊoAgϐɊi[
void getVariable(char*data,VARIANT_*v){
	v->init();//l
	double d=atof(data);
	if(0==d && '0'!=*data){
		if('\"'==*data){
			//f[^ꍇ
			//̃_uNI[e[V폜
			char*c=&data[strlen(data)-1];
			if('\"'==*c) *c='\0';
			v->flag=TYPE_STR;//^ɐݒ
			_strcpy(v->str_val,data);//l𕡐
		}else{
			//ϐꍇ
			double pos;
			if(!strncmp(data,"time.",sizeof("time.")-1)){
				time_t now = time(NULL);
				struct tm *pnow = localtime(&now);
				if(!strcmp(data,"time.year")){
					pos=pnow->tm_year+1900;
					v->flag=TYPE_VAL;//l^ɐݒ
					v->d_val=pos;//l𕡐
				}else if(!strcmp(data,"time.mon")){
					pos=pnow->tm_mon + 1;
					v->flag=TYPE_VAL;//l^ɐݒ
					v->d_val=pos;//l𕡐
				}else if(!strcmp(data,"time.day")){
					pos=pnow->tm_mday;
					v->flag=TYPE_VAL;//l^ɐݒ
					v->d_val=pos;//l𕡐
				}else if(!strcmp(data,"time.week")){
					pos=pnow->tm_wday;
					v->flag=TYPE_VAL;//l^ɐݒ
					v->d_val=pos;//l𕡐
				}else if(!strcmp(data,"time.hour")){
					pos=pnow->tm_hour;
					v->flag=TYPE_VAL;//l^ɐݒ
					v->d_val=pos;//l𕡐
				}else if(!strcmp(data,"time.min")){
					pos=pnow->tm_min;
					v->flag=TYPE_VAL;//l^ɐݒ
					v->d_val=pos;//l𕡐
				}else if(!strcmp(data,"time.sec")){
					pos=pnow->tm_sec;
					v->flag=TYPE_VAL;//l^ɐݒ
					v->d_val=pos;//l𕡐
				}
			}else if(!strcmp(data,"rand")){
				//̎QƂ̂ߗ𐶐
				pos=rand()%9999;
				v->flag=TYPE_VAL;//l^ɐݒ
				v->d_val=pos;//l𕡐
			}else{
				//ϐƍlAϐe[uQ
				unsigned int i;
				void*r=getVariable(data,&i);
				if(r){
					if(TYPE_VAL==i){
						v->flag=TYPE_VAL;//l^ɐݒ
						v->d_val=*((double*)r);//l𕡐
					}else{
						v->flag=TYPE_STR;//^ɐݒ
						_strcpy(v->str_val,(char*)r);//l𕡐
					}
				}
			}
		}
	}else{
		//ꍇ
		v->flag=TYPE_VAL;//l^ɐݒ
		v->d_val=d;//l𕡐
	}
}


//`̕ϐ͒lϊϐɊi[
void setVariableEtc(const char*name,char*data,int write_mode){
	double d=atof(data);
	if(0==d && '0'!=*data){
		if('\"'==*data){
			//f[^ꍇ
			//̃_uNI[e[V폜
			char*c=&data[strlen(data)-1];
			if('\"'==*c) *c='\0';
			setVariable(name,data,write_mode);
		
		}else{
			//ϐꍇ
			double pos;
			if(!strncmp(data,"time.",sizeof("time.")-1)){
				time_t now = time(NULL);
				struct tm *pnow = localtime(&now);
				if(!strcmp(data,"time.year")){
					pos=pnow->tm_year+1900;
					setVariable(name,pos,write_mode);
				}else if(!strcmp(data,"time.mon")){
					pos=pnow->tm_mon + 1;
					setVariable(name,pos,write_mode);
				}else if(!strcmp(data,"time.day")){
					pos=pnow->tm_mday;
					setVariable(name,pos,write_mode);
				}else if(!strcmp(data,"time.week")){
					pos=pnow->tm_wday;
					setVariable(name,pos,write_mode);
				}else if(!strcmp(data,"time.hour")){
					pos=pnow->tm_hour;
					setVariable(name,pos,write_mode);
				}else if(!strcmp(data,"time.min")){
					pos=pnow->tm_min;
					setVariable(name,pos,write_mode);
				}else if(!strcmp(data,"time.sec")){
					pos=pnow->tm_sec;
					setVariable(name,pos,write_mode);
				}
			}else if(!strcmp(data,"rand")){
				//̎QƂ̂ߗ𐶐
				pos=rand()%9999;
				setVariable(name,pos,write_mode);
			}else{
				//ϐƍlAϐe[uQ
				unsigned int i;
				void*r=getVariable(data,&i);
				if(r){
					if(TYPE_VAL==i){
						setVariable(name,*((double*)r),write_mode);
					}else{
						setVariable(name,(char*)r,write_mode);
					}
				}else{
					//ϐݒ肳ĖꍇA0
					setVariable(name,(double)0,write_mode);
				}
			}
		}
	}else{
		//ꍇ
		setVariable(name,d,write_mode);
	}
}


VARIANT_ reg1;


void setVariable(const char*name,const char*data,int write_flag){
	if(write_flag){
		//mapւ̏݃[hIt
		reg1.flag=TYPE_STR;//^ɐݒ
		reg1.d_val=0;
		_strcpy(reg1.str_val,data);//l𕡐
	}else{
		//mapւ̏݃[hI
		it=variable_table.find(name);
		if(it == variable_table.end()){
			st_form stf;
			stf.flag=TYPE_STR;//tO
			stf.d=NULL;
			stf.str=new std::string(data);
			char*key=new char[strlen(name)+1];
			_strcpy(key,name);
			std::pair<const char*,st_form> p((const char*)key,stf);
			variable_table.insert(p);
		}else{
			st_form*pos=&(it->second);
			pos->flag=TYPE_STR;//tO
			if(pos->str){
				*(pos->str)=data;
			}else{
				pos->str=new std::string(data);
			}
		}
	}
}

void setVariable(const char*name,double data,int write_flag){
	if(write_flag){
		//mapւ̏݃[hIt
		reg1.flag=TYPE_VAL;//l^ɐݒ
		reg1.d_val=data;//l𕡐
		reg1.str_val[0]='\0';
	}else{
		//mapւ̏݃[hI
		it=variable_table.find(name);
		if(it == variable_table.end()){
			st_form stf;
			stf.flag=TYPE_VAL;//ltO
			stf.str=NULL;
			stf.d=new double(data);
			char*key=new char[strlen(name)+1];
			_strcpy(key,name);
			std::pair<const char*,st_form> p((const char*)key,stf);
			variable_table.insert(p);
		}else{
			st_form*pos=&(it->second);
			pos->flag=TYPE_VAL;//ltO
			if(pos->d){
				*(pos->d)=data;
			}else{
				pos->d=new double(data);
			}
		}
	}
}

int isVariable(const char*name){
	return (int)variable_table.count(name);
}

void*getVariable(const char*name,unsigned int*type){
	it=variable_table.find(name);
	if(it != variable_table.end()){
		*type=it->second.flag;
		if(*type==TYPE_STR){
			return (void*)(it->second.str->c_str());
		}
		if(*type==TYPE_VAL){
			return (void*)(it->second.d);
		}
	}
	return NULL;
}

//-----------------------------------------------
//ϐ^쐬邽߂̈ꎞ̂
char buf[32];

const char*getVariableStr(const char*name){
	it=variable_table.find(name);
	if(it == variable_table.end()){
		return (const char*)"";
	}else{
		if(TYPE_STR==((st_form)(it->second)).flag){
			return (const char*)((((st_form)(it->second)).str)->c_str());
		}else{
			sprintf(buf,"%.13g",*(((st_form)(it->second)).d));
			return (const char*)buf;
		}
	}
}

void setVariableStr(const char*name,const char*data){
	if('\"'==*data){
		//
		setVariable(name,data);
	}else{
		//
		setVariable(name,atof(data));
	}
}
//-------------------------------------------------------------------------------
