/*
 * aBasic
 * Copyright (C) 2007 m_inaba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "st_inst.h"

static char str_buf[MAX_STR_LEN+2];
static char str_buf2[MAX_STR_LEN+2];
static char str_buf3[MAX_STR_LEN+2];

int eval_(char*str){
	if(0==strncmp(str,"eval ",sizeof("eval ")-1)){
		char*pos=str+sizeof("eval")-1;//߂̌̕ϐo
		*pos='=';
		calculation(str);
		if('\"'==*getVariableStr("eval")){
			instcpy(str_buf,(getVariableStr("eval")+1));
		}else{
			instcpy(str_buf,(getVariableStr("eval")));
		}
		_strcpy(str,str_buf);
		return 1;
	}else{
		return 0;
	}
}

int machine_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"machine ",sizeof("machine ")-1)){
		char*str_ptr;
		str_ptr = str + sizeof("machine ")-1;
		trim_a(str_ptr);

		int counter=0;
		while(*str_ptr){
			if('\\'!=*str_ptr++){
				setError("ERR \"machine \\x \"");
				return 0;
			}
			if('x'!=*str_ptr++){
				setError("ERR \"machine \\x \"");
				return 0;
			}
			if(MAX_STR_LEN==(str_ptr+2)-str){
				setError("ERR \"machine buffer over\"");
				return 0;
			}
			str_buf[counter++]=(char)getHex2(str_ptr);
			str_ptr++;str_ptr++;
		}

		typedef int (*func)(void);
		func fu=(func)(void*)str_buf;
		setVariable("machine",(double)fu());
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int if_(char*str,unsigned char*){
	int resolt=0;//̌ʂԂtO
	char*_str=str;
	char*str_ptr;
	if(0==strncmp(str,"if ",sizeof("if ")-1)){
		if(!(str_ptr=_strstr2(str," then "))){
			//G[
			//setError("ERR \"then\"");
			return 0;
		}
		*str_ptr='\0';
		*(str + sizeof("if")-1)='=';//if=vZ@ɕό`
		trim_a(str);
		
		calculation(str,WRITE_REG);
		
		str_ptr+=sizeof(" then")-1;
		if(0!=reg1.d_val){
			str=str_ptr;
			if(str_ptr=_strstr2(str_ptr," else ")){
				*str_ptr='\0';
			}
			if(' '==*str) str++;
			resolt=1;//ʂTRUÊ1Ԃ
		}else{
			if(str_ptr=_strstr2(str_ptr," else ")){
				str=str_ptr+sizeof(" else ")-1;
			}else *str='\0';
			resolt=2;//ʂFALSÊ2Ԃ
		}
		_strcpy(_str,str);
		return resolt;
	}
	return 0;
}


int if2_(char*str,std::vector<std::string>*source,
		  unsigned int*p_counter,std::vector<unsigned long>*data,unsigned char*flag){
	char*str_ptr;
	if((0x80 & *flag) || 0==strncmp(str,"if ",sizeof("if ")-1)){
		*(str + sizeof("if")-1)='=';//if=vZ@ɕό`
		if(!(str_ptr=_strstr2(str," then"))){
			//G[
			setError("ERR \"then\"");
			return 0;
		}
		*str_ptr='\0';

		trim_a(str);
		calculation(str,WRITE_REG);

		if(0!=reg1.d_val){
			*flag|=0x80;//֐
			return 1;
		}else{
			if((*data)[*p_counter]){
				//x̕ʉ߂dataɃWvԒncĂꍇ
				*p_counter=(*data)[*p_counter]+1;//vOJE^ɑ
				return 1;
			}else{
				unsigned int p_pos=*p_counter;
				int if_count=0;
				do{
					_strcpy(str_buf,(*source)[p_pos].c_str());
					
					if(if_count==0 && (0==strcmp(str_buf,"else") || 0==strcmp(str_buf,"endif"))){
						(*data)[*p_counter]=(unsigned long)p_pos;//ۑ
						*p_counter=p_pos+1;//vOJE^ɑ
						*flag|=0x80;//֐

						return 1;
					}
					
					if(0==strncmp(str_buf,"if ",sizeof("if ")-1) && NULL==_strstr2(str_buf," then ")) if_count++;
					if(0==strcmp(str_buf,"endif")) if_count--;
					p_pos++;
				}while(EOF!=*str_buf);
				//G[
				setError("ERR \"else endif\"");
				return 0;
			}
		}
	}
	return 0;
}


int else_(char*str,std::vector<std::string>*source,
		  unsigned int*p_counter,std::vector<unsigned long>*data,unsigned char*flag){
	if((0x80 & *flag) || 0==strcmp(str,"else")){
		if((*data)[*p_counter]){
			//x̕ʉ߂dataɃWvԒncĂꍇ
			*p_counter=(*data)[*p_counter]+1;//vOJE^ɑ
			return 1;
		}else{
			unsigned int p_pos=*p_counter;
			int if_count=0;
			do{
				_strcpy(str_buf,(*source)[p_pos].c_str());
				
				if(if_count==0 && 0==strcmp(str_buf,"endif")){
					(*data)[*p_counter]=(unsigned long)p_pos;//ۑ
					*p_counter=p_pos+1;//vOJE^ɑ
					*flag|=0x80;//֐
					return 1;
				}
				
				if(0==strncmp(str_buf,"if ",sizeof("if ")-1) && NULL==_strstr2(str_buf," then ")) if_count++;
				if(0==strcmp(str_buf,"endif")) if_count--;
				p_pos++;
			}while(EOF!=*str_buf);
			//G[
			setError("ERR \"endif\"");
			return 0;
		}
	}
	return 0;
}


int print_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"print ",sizeof("print ")-1)){
		*(str + sizeof("print")-1)='=';//print=vZ@ɕό`
		trim_a(str);
		
		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str);
		}else{
			//vZKv
			if(!calculation(str)) *flag|=0x40;//񂩂͌vZKvȂ
		}
		
		//͕ȅꍇ̏
		//ϐ̏ꍇ̏
		const char*str_ptr=getVariableStr("print");
		//\擪"菜
		if('\"'==*str_ptr) str_ptr++;
		printf("%s\n",str_ptr);
		fflush(stdout);//obt@tbV
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int input_(char*str,unsigned char*flag){
	char*str_ptr;
	if((0x80 & *flag) || 0==strncmp(str,"input ",sizeof("input ")-1)){
		str_ptr = str + sizeof("input ")-1;
		trim_a(str_ptr);

		//mubLO[hł͓͎?\Ȃ		
		if('1'==*getVariableStr("system.io.inputblock")){
			printf("%s","? ");
		}

		unsigned int i=0;
		for(i=1;i<MAX_STR_LEN-1;i++){
			char pos;
			pos=(char)_getchar();
			if(pos=='\r' || pos=='\n' || pos==EOF) break;
			str_buf[i]=pos;
		}
		str_buf[i]='\0';

		//ł邩Alł邩
		VARIANT_ pos;
		pos=str_buf+1;
		if(TYPE_VAL==pos.flag){
			//l^	
			setVariableStr(str_ptr,(str_buf+1));
		}else{
			//^
			str_buf[0]='\"';
			setVariableStr(str_ptr,str_buf);
		}

		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int goto_(char*str,unsigned int*p_counter,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"goto ",sizeof("goto ")-1)){
		//߂Ă̕ʉ߂ꍇ̏
		str = str + sizeof("goto ")-1;
		unsigned int i;
		void*r=getVariable(str,&i);
		if((0x80 & *flag) || r){
			//ɃWvAhX
			if(TYPE_VAL==i){
				*p_counter=((unsigned int)*((double*)r))+1;//vOJE^ɑ
				*flag|=0x80;//֐
				return 1;
			}
		}
		//ɃWvAhXȂ
		//G[
		setError("ERR \"goto\"");
	}
	return 0;
}

int for_(char*str,unsigned char*flag){
	char*str_ptr;
	if((0x80 & *flag) || 0==strncmp(str,"for ",sizeof("for ")-1)){
		str+=sizeof("for ")-1;
		str_ptr=((char*)strstr(str," to "));
		if(str_ptr!=NULL){
			*str_ptr='\0';
		}else{
			//G[
			setError("ERR \"for\"");
			return 0;
		}

		trim_a(str);
		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str);
		}else{
			//vZKv
			if(!calculation(str)) *flag|=0x40;//񂩂͌vZKvȂ
		}
		
		*flag|=0x80;//֐
		return 1;
	}
	return 0;
}

int next_(char*str,
		  std::vector<std::string>*source,unsigned int*p_counter,
		  std::vector<unsigned long>*data,unsigned char*flag){
	unsigned int pc_pos;
	char*str_ptr;
	if((0x80 & *flag) || 0==strncmp(str,"next ",sizeof("next ")-1)){
		str+=sizeof("next ")-1;
		char*str_key=str_buf2;
		_strcpy(str_key,"for ");
		
		strcat(str_key,str);//for a ̂悤ȕ쐬

		if((*data)[*p_counter]){
			//x̕ʉ߂dataɃWvԒncĂꍇ
			pc_pos=(*data)[*p_counter];
			_strcpy(str_buf,(*source)[pc_pos].c_str());
		}else{
			//߂Ă̕ʉ߂ꍇ̏
			for(pc_pos=*p_counter-2;pc_pos!=(unsigned int)-1;pc_pos--){
				_strcpy(str_buf,(*source)[pc_pos].c_str());
				if((NULL!=_strstr2(str_buf,str_key))&&
					(' '==*(str_buf+strlen(str_key)) || '='==*(str_buf+strlen(str_key)))
					){
					//Ή for *** 
					(*data)[*p_counter]=(unsigned long)pc_pos;
					break;
				}
			}
			//pc_pos (unsigned int)-1 ̏ꍇ͑ΉforȂ
			if(pc_pos==(unsigned int)-1){
				//G[
				setError("ERR \"next\"");
				return 0;
			}
		}

		*(str_key + sizeof("for")-1)='=';//str_key @for=a@ɕό`
		str_ptr=strstr(str_buf,"to ");
		if(str_ptr==NULL){
			//G[
			setError("ERR \"next 2\"");
			return 0;
		}

		*str_ptr='<';*(str_ptr+1)='=';//for=a>=1 step 10 ɕό`
		strcat(str_key,str_ptr);

		char*inc_num=str_buf3;
		str_ptr=strstr(str_key,"step ");

		if(str_ptr!=NULL){
			*str_ptr='\0';
			str_ptr+=sizeof("step ")-1;
			sprintf(inc_num,"%s=%s+%s",str,str,str_ptr);//step`Ŋi[
			trim_a(inc_num);
		}else{
			sprintf(inc_num,"%s=%s+%s",str,str,"1");//step`Ŋi[
		}
		calculation(inc_num);//CNgvZ

		trim_a(str_key);
		calculation(str_key);//vZ

		if(strcmp(getVariableStr("for"),"0")){
			*p_counter=pc_pos+1;//vOJE^ɑ
			
			*flag|=0x80;//֐
			return 1;
		}else{
			
			*flag|=0x80;//֐
			return 1;//̌ʂ0̂߉Ȃ@̍sɐi
		}
	}
	return 0;
}

int clr_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strcmp(str,"clr")){
		printf("\033[2J"); //ʃNA
		*flag|=0x80;//֐
		return 1;
	}
	return 0;
}

int location_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"location ",sizeof("location ")-1)){
		*(str + sizeof("location")-1)='=';//location=vZ@ɕό`
		_strcpy(str_buf,str);

		int i;
		for(i=sizeof("location=")-1;i<MAX_STR_LEN;i++){//,NULLɕϊ
			if(','==str[i]){
				str[i]='\0';
				break;
			}
		}

		for(i=sizeof("location=")-1;i<MAX_STR_LEN;i++){//=,܂ł̕Xy[Xɕϊ
			if(','==str_buf[i]){
				str_buf[i]=' ';
				break;
			}else str_buf[i]=' ';
		}

		trim_a(str);
		
		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str);
		}else{
			//vZKv
			if(!calculation(str)) *flag|=0x40;//񂩂͌vZKvȂ
		}
		
		_strcpy(str,getVariableStr("location"));

		trim_a(str_buf);

		if(0x20 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x20;//񂩂͌vZKvȂ
		}
		
		_strcpy(str_buf,getVariableStr("location"));

		printf("\033[%s;%sH" ,str,str_buf); //J[\ʒuړ

		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int wait_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strcmp(str,"wait")){
		sleep(1); //1bX[v
		
		*flag|=0x80;//֐
		return 1;
	}
	return 0;
}


//func̖߂lAhXi[X^bN
std::stack<unsigned long> adr_stack;
//[Jϐ邽߃O[o̒li[X^bN
std::stack<std::string> st_stack;

int func_(char*str,std::vector<std::string>*source,unsigned int*p_counter,unsigned char*flag){
	if((0x80 & *flag) || ':'!=str[strlen(str)-1]){
		adr_stack.push(*p_counter);//݂̃vOJE^X^bNɕۑ

		char*label=str;

		char*pos=cut_func(label);

		//xvZ
		arry(str_buf,label);
		label=str_buf;
		
		unsigned int pushCount=0;//ۑ̐̃JE^
		
		if(NULL!=pos){
			//pos 
			trim_a(pos);

			setVariable("#",(double)0);

			//ۑ
			pos=_strchop(pos ,',');
			if(pos!=NULL){
//---------------------------------------------------------------
//ێ@\̂߁A̕ϐ͓eۑ
//---------------------------------------------------------------
				str_buf2[0]='\"';
				strcpy(&str_buf2[1],pos);
				setVariable("#",str_buf2);
//---------------------------------------------------------------
				str_buf2[0]='\xFF';
				str_buf2[1]='=';
				strcpy(&str_buf2[2],pos);

				if(0x40 & *flag){
					//vZKvȂ̂
					substitution(str_buf2);
				}else{
					//vZKv
					if(!calculation(str_buf2)) *flag|=0x40;//񂩂͌vZKvȂ
				}
				pushCount++;//ۑꂽ

				int i=0;
				while(pos=_strchop(NULL ,',')){
					i++;
					
					str_buf2[0]='\xFF';
					str_buf2[1]=(char)i;
					str_buf2[2]='=';
					strcpy(&str_buf2[3],pos);

					if(0x20 & *flag){
						//vZKvȂ̂
						substitution(str_buf2);
					}else{
						//vZKv
						if(calculation(str_buf2)) *flag|=0x01;//tO𗧂Ă
					}
					pushCount++;//ۑꂽ
				}
			}
			if(0==(0x01 & *flag)) *flag|=0x20;//񂩂͌vZKvȂ
			*flag|=!0x01;//1bitڂ̃tONA
		}

		str_buf2[0]='@';
		strcpy(&str_buf2[1],label);
		unsigned int i;
		void*r=getVariable(str_buf2,&i);
		
		if(NULL==r){
			//Wv悪Ȃ
			//ftHgWvT
			default_func(str_buf,str);
			str_buf2[0]='@';
			strcpy(&str_buf2[1],str_buf);
			r=getVariable(str_buf2,&i);
		}
		
		if(NULL!=r && TYPE_VAL==i){
			pushVariable(_strchop(label,'['));//x̕ϐX^bNɕۑ ߂lԂ߁B

			//ɃWvAhX
			unsigned int i=((unsigned int)*((double*)r));
			if(0==i){
				setError("ERR  \"func not adder\"");
				return 1;
			}
			
			_strcpy(str_buf2,(*source)[i].c_str());

			pos=cut_func(str_buf2);
			
			//ɒl
			trim_a(pos);
			pos=_strchop(pos ,',');
			unsigned int pushVariableCount=0;//O[oϐۑ𒲂ׂJE^
			if(NULL!=pos){

				//ꖼ̃O[o̕ϐvbVāA
				pushVariable(pos);//O[oϐX^bNɕۑ
				copyVariable(pos,"\xFF");//O[oϐ㏑
				pushVariableCount++;//O[oϐۑꂽ

				int j=0;
				while(pos=_strchop(NULL ,',')){
					str_buf2[0]='\xFF';
					str_buf2[1]=(char)++j;
					str_buf2[2]='\0';
					
					//ꖼ̃O[o̕ϐvbVāA
					pushVariable(pos);//O[oϐX^bNɕۑ
					if(pushVariableCount<=pushCount){//ۑƔr
						//
						copyVariable(pos,str_buf2);//O[oϐ㏑
					}else{
						//ߏ
						setVariable(pos,(double)0);
					}
					pushVariableCount++;//O[oϐۑꂽ
				}
			}
			adr_stack.push(pushVariableCount);//ۑO[oϐ̐vbV
			*p_counter=i+1;//vOJE^ɑ
			*flag|=0x80;//֐
			return 1;
		}else{
			//ɃWvAhXȂ
			//G[
			adr_stack.pop();//G[̂߃X^bNɒǉꂽl̍폜
			//G[ G[̊荞݃tO
			if(1!=interlope){
				setError("ERR  \"func\"");
			}
			return 0;
		}
	}
	return 0;
}

int return_(char*str,std::vector<std::string>*source,
		  unsigned int*p_counter,std::vector<unsigned long>*data,unsigned char*flag){
	if((0x80 & *flag) || 0==strcmp(str,"return")){
		if((*data)[*p_counter]){
			//x̕ʉ߂dataɃWvԒncĂꍇ
			*p_counter=(*data)[*p_counter];//vOJE^ɑ
			return 1;
		}else{
			//߂Ă̕ʉ߂ꍇ̏
			unsigned int p_pos=*p_counter;
			*str_buf='\0';
			int counter=0;
			while(EOF!=*str_buf){
				_strcpy(str_buf,(*source)[p_pos].c_str());
				if(0==strncmp(str_buf,"@",sizeof("@")-1) && !strstr(str_buf,"=")) counter++;
				
				if(0==strcmp(str_buf,"_@")){
					if(!counter){
						(*data)[*p_counter]=(unsigned long)p_pos;//ۑ
						*p_counter=p_pos;//vOJE^ɑ
						*flag|=0x80;//֐
						return 1;
					}else{
						counter--;	
					}
				}
				p_pos++;
			}
			//G[
			setError("ERR \"@...._@\"");
			return 0;
		}
	}
	return 0;
}

int abs_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"abs ",sizeof("abs ")-1)){
		str+=sizeof("abs ")-1;//߂̌̕ϐo
		trim_a(str);
		
		_strcpy(str_buf,getVariableStr(str));//ϐ̒lo
		
		int i=0;
		while(str_buf[i]){  //l̐擪珬_TAꍇɂNULLɒu
			if(str_buf[i]=='.'){
				str_buf[i]='\0';
				break;
			}
			i++;
		}

		setVariableStr("abs",str_buf);//Cꂽl֐Ɋi[
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int shell_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"shell ",sizeof("shell ")-1)){
		*(str + sizeof("shell")-1)='=';//shell=vZ@ɕό`

		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str);
		}else{
			//vZKv
			if(!calculation(str)) *flag|=0x40;//񂩂͌vZKvȂ
		}

		char*str_ptr=str_buf+1;
		
		_strcpy(str_ptr,getVariableStr("shell"));
		
		if(*str_ptr!='\"'){
			str_ptr--;
			*str_ptr='\"';
		}
		int len=(int)strlen(str_ptr);
		str_ptr[len]='\"';//̌"t
		str_ptr[len+1]='\0';
		shell(str_ptr);//s
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}


int len_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"len ",sizeof("len ")-1)){
		str+=sizeof("len ")-1;//߂̌̕ϐo
		trim_a(str);
		
		const char*str_ptr=getVariableStr(str);//ϐ̒lo
		
		if('\"'==*str_ptr) str_ptr++;
		setVariable("len",(double)strlen(str_ptr));//Cꂽl֐Ɋi[
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}


int mid_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"mid ",sizeof("mid ")-1)){
		str+=sizeof("mid ")-1;//߂̌̕ϐo
		trim_a(str);
		char*st0=_strchop(str ,',');//1ڂ؂o܂B
		char*st1=_strchop(NULL,',');//2ڂ؂o܂B
		char*st2=_strchop(NULL,',');//3ڂ؂o܂B
	
		//Qڂ̈̏
		_strcpy(str_buf,"mid=");
		strcat(str_buf,st1);
		
		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x40;//񂩂͌vZKvȂ
		}
		
		unsigned int st=atoi(getVariableStr("mid"));
		
		//Rڂ̈̏
		_strcpy(str_buf,"mid=");
		strcat(str_buf,st2);
		
		if(0x20 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x20;//񂩂͌vZKvȂ
		}
		
		unsigned int en=atoi(getVariableStr("mid"));

		//Pڂ̈̏
		_strcpy(str_buf,"mid=");
		strcat(str_buf,st0);
		
		if(0x10 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x10;//񂩂͌vZKvȂ
		}
		
		_strcpy(str_buf,getVariableStr("mid"));

		if(st>(int)strlen(str_buf)) st=(int)strlen(str_buf);
		if(st+en>(int)strlen(str_buf)) en=(int)strlen(str_buf)-st;
		str_buf[(int)(st)]='\"';
		str_buf[(int)(st+en+1)]='\0';
		setVariable("mid",&(str_buf[st]));//Cꂽl֐Ɋi[
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int val_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"val ",sizeof("val ")-1)){
		str+=sizeof("val ")-1;//߂̌̕ϐo
		trim_a(str);
		
		const char*str_ptr;
		
		str_ptr=getVariableStr(str);//ϐ̒lo
		
		if('\"'==*str_ptr) str_ptr++;
		double d=atof(str_ptr);

		setVariable(str,d);//CꂽlϐɊi[
		setVariable("val",d);//Cꂽl֐Ɋi[
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int str_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"str ",sizeof("str ")-1)){
		str+=sizeof("str ")-1;//߂̌̕ϐo
		trim_a(str);
		
		char*str_ptr=str_buf+1;
		
		_strcpy(str_ptr,getVariableStr(str));//ϐ̒lo
		if('\"'!=*str_ptr){
			str_ptr--;
			*str_ptr='\"';
			setVariable(str,str_ptr);//CꂽlϐɊi[
		}
		setVariable("val",str_ptr);//Cꂽl֐Ɋi[
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int csv_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"csv ",sizeof("csv ")-1)){
		str+=sizeof("csv ")-1;//߂̌̕ϐo
		trim_a(str);
		
		const char*str_val=getVariableStr(str);//ϐ̒lo
		
		//ŕƂĈ悤ɂtOǂݔ΂
		str_val++;
		
		int count=0;
		
		do{
			char*last_ptr=str_buf+1;
			char*first_ptr=str_buf+1;

			//擪񂪃_uNI[e[V̏ꍇÃ_uNI[e[V܂œǂݔ΂
			if('\"'==*str_val){
				do{
					*last_ptr++=*str_val++;
				}while('\"'!=*str_val && *str_val);
			}

			//J}Ő؂o
			while(','!=*str_val && *str_val){
				*last_ptr++=*str_val++;
			}
			*last_ptr--='\0';
			
			//[Ƀ_uNI[e[VtĂꍇ͍폜
			if('\"'==*first_ptr && '\"'==*last_ptr){
				first_ptr++;
				*last_ptr='\0';
			}

			//ŕƂĈ悤ɐ擪Ƀ_uNI[e[V
			*--first_ptr='\"';

			sprintf(str_buf2,"%s[\"%d\"]",str,++count);
			setVariable(str_buf2,first_ptr);//CꂽlϐɊi[

		}while(*str_val++);
		
		sprintf(str_buf2,"%s[\"%d\"]",str,++count);
		setVariable(str_buf2,"\",");//z̏I\

		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int vsc_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"vsc ",sizeof("vsc ")-1)){
		str+=sizeof("vsc ")-1;//߂̌̕ϐo
		trim_a(str);
		char*st0=_strchop(str ,',');//1ڂ؂o܂B
		char*st1=_strchop(NULL,',');//2ڂ؂o܂B
		char*st2=_strchop(NULL,',');//3ڂ؂o܂B

		//3ڂ̈̏
		_strcpy(str_buf,"vsc=");
		strcat(str_buf,st2);
		
		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x40;//񂩂͌vZKvȂ
		}
		
		unsigned int len=atoi(getVariableStr("vsc"));

		//2ڂ̈̏
		_strcpy(str_buf,"vsc=");
		strcat(str_buf,st1);
		
		if(0x20 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x20;//񂩂͌vZKvȂ
		}
		
		_strcpy(str_buf,(getVariableStr("vsc")+1));

		int w_flag=1;
		unsigned int i=0;
		str_buf3[0]='\0';
		while(1){
			i++;
			sprintf(str_buf2,"%s[\"%d\"]",st0,i);
			const char*pos=getVariableStr(str_buf2);
			//z̖[o
			if('\"'==*pos && ','==*(pos+1)){
				w_flag=0;//z̖[\tO
			}
			
			if(len && i>len){
				break;
			}else{
				if(!len && !w_flag) break;
			}
			
			strcat(str_buf3,",");
			if(w_flag){
				if('\"'==*pos || '\0'==*pos){
					strcat(str_buf3,str_buf);
					strcat(str_buf3,pos+1);
					strcat(str_buf3,str_buf);
				}else{
					strcat(str_buf3,pos);
				}
			}else{
				strcat(str_buf3,str_buf);
				strcat(str_buf3,str_buf);
			}
		}
		
		str_buf3[0]='\"';//̃tOZbg
		
		setVariable("vsc",str_buf3);
		setVariable(st0,str_buf3);

		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}


int chop_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"chop ",sizeof("chop ")-1)){
		str+=sizeof("chop ")-1;//߂̌̕ϐo
		trim_a(str);
		char*st0=_strchop(str ,',');//1ڂ؂o܂B
		char*st1=_strchop(NULL,',');//2ڂ؂o܂B
		//char*st2=_strchop(NULL,',');//3ڂ؂o܂B
		int count=0;
		int len=1;
		
		_strcpy(str_buf,(getVariableStr(st0)+1));
		char*str_ptr=str_buf;
		char*str_ptr2=str_buf2+1;
		str_buf2[0]='\"';

		while(*str_ptr){
			count++;
			sprintf(str_buf3,"%s[\"%d\"]",st1,count);
			const char*pos=getVariableStr(str_buf3);
			
			if('\"'==*pos){
				//̏ꍇ̏
				len=atoi((const char *)(pos+1));
			}else{
				//̏ꍇ̏
				len=atoi((const char *)(pos));
			}
			
			sprintf(str_buf3,"%s[\"%d\"]",st0,count);
			
			if(len){
				int i=0;
				while(i<len && *str_ptr){
					str_ptr2[i++]=*str_ptr++;
				}
				str_ptr2[i]='\0';
				setVariable(str_buf3,(str_ptr2-1));
			}else{
				sprintf(str_ptr2,str_ptr);
				setVariable(str_buf3,(str_ptr2-1));
				break;	
			}
		}
		
		count++;
		sprintf(str_buf3,"%s[\"%d\"]",st0,count);
		setVariable(str_buf3,"\",");//z̏I\
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int trim_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"trim ",sizeof("trim ")-1)){
		str+=sizeof("trim ")-1;//߂̌̕ϐo
		trim_a(str);
		
		_strcpy(str_buf,getVariableStr(str));//ϐ̒lo
		if('\"'==*str_buf){
			trim_rl(&str_buf[1]);
			setVariable(str,str_buf);//CꂽlϐɊi[
		}
		setVariable("trim",str_buf);//Cꂽl֐Ɋi[
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int ltrim_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"ltrim ",sizeof("ltrim ")-1)){
		str+=sizeof("ltrim ")-1;//߂̌̕ϐo
		trim_a(str);
		
		_strcpy(str_buf,getVariableStr(str));//ϐ̒lo
		if('\"'==*str_buf){
			trim_l(&str_buf[1]);
			setVariable(str,str_buf);//CꂽlϐɊi[
		}
		setVariable("ltrim",str_buf);//Cꂽl֐Ɋi[
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int rtrim_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"rtrim ",sizeof("rtrim ")-1)){
		str+=sizeof("rtrim ")-1;//߂̌̕ϐo
		trim_a(str);
		
		_strcpy(str_buf,getVariableStr(str));//ϐ̒lo
		if('\"'==*str_buf){
			trim_r(&str_buf[1]);
			setVariable(str,str_buf);//CꂽlϐɊi[
		}
		setVariable("rtrim",str_buf);//Cꂽl֐Ɋi[
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int replace_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"replace ",sizeof("replace ")-1)){
		str+=sizeof("replace ")-1;//߂̌̕ϐo
		trim_a(str);
		const char*st0=_strchop(str ,',');//1ڂ؂o܂B
		const char*st1=_strchop(NULL,',');//2ڂ؂o܂B
		const char*st2=_strchop(NULL,',');//3ڂ؂o܂B
		const char*pos;
		//ΏۂƂȂ镶o
		pos=getVariableStr(st0);
		if('\"'==*pos){
			_strcpy(str_buf,pos+1);//tO΂
		}else{
			_strcpy(str_buf,pos);
		}

		//Qڂ̈̏
		_strcpy(str_buf2,"replace=");
		strcat(str_buf2,st1);

		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str_buf2);
		}else{
			//vZKv
			if(!calculation(str_buf2)) *flag|=0x40;//񂩂͌vZKvȂ
		}

		_strcpy(str_buf2,getVariableStr("replace"));
		st1=str_buf2;
		if('\"'==*st1) st1++;//tO΂

		//Rڂ̈̏
		_strcpy(str_buf3,"replace=");
		strcat(str_buf3,st2);

		if(0x20 & *flag){
			//vZKvȂ̂
			substitution(str_buf3);
		}else{
			//vZKv
			if(!calculation(str_buf3)) *flag|=0x20;//񂩂͌vZKvȂ
		}

		st2=getVariableStr("replace");
		if('\"'==*st2) st2++;//tO΂
		char*pos2=replace(str_buf3+1,str_buf,st1,st2);
		if(pos2){
			*(--pos2)='\"';//tOt
			setVariable(st0,pos2);
			setVariable("replace",pos2);
		}
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int match_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"match ",sizeof("match ")-1)){
		str+=sizeof("match ")-1;//߂̌̕ϐo
		trim_a(str);
		const char*st0=_strchop(str ,',');//1ڂ؂o܂B
		const char*st1=_strchop(NULL,',');//2ڂ؂o܂B
		
		//1ڂ̈̏
		_strcpy(str_buf,"match=");
		strcat(str_buf,st0);

		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x40;//񂩂͌vZKvȂ
		}

		_strcpy(str_buf,getVariableStr("match"));
		st0=str_buf;
		if('\"'==*st0) st0++;//tO΂
		
		//2ڂ̈̏
		_strcpy(str_buf2,"match=");
		strcat(str_buf2,st1);

		if(0x20 & *flag){
			//vZKvȂ̂
			substitution(str_buf2);
		}else{
			//vZKv
			if(!calculation(str_buf2)) *flag|=0x40;//񂩂͌vZKvȂ
		}

		st1=getVariableStr("match");
		if('\"'==*st1) st1++;//tO΂

		int i,j;
		char*c;
		char*pos=str_buf2+1;
		c=match(st0,st1,&i);
		if(c){
			for(j=0;j<i;j++){
				pos[j]=c[j];
			}
			pos[j]='\0';
			str_buf2[0]='\"';//tOt
			setVariable("match",str_buf2);
		}else{
			setVariable("match","\"");
		}
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int lcase_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"lcase ",sizeof("lcase ")-1)){
		str+=sizeof("lcase ")-1;//߂̌̕ϐo
		trim_a(str);

		_strcpy(str_buf,getVariableStr(str));//ϐ̒lo
		
		char*pos=str_buf;
		
		while(*(++pos)){
#ifdef SHIFT_JIS
			//VtgJIS̓ǂݍ
			if((0x81<=(unsigned char)*pos && 0x9F>=(unsigned char)*pos) || (0xE0<=(unsigned char)*pos && 0xFC>=(unsigned char)*pos)){
				pos++;pos++;
			}
#endif
			if('A'<=*pos && 'Z'>=*pos){
				*pos+=('a'-'A');
			}
		}

		setVariable(str,str_buf);//CꂽlϐɊi[
		setVariable("lcase",str_buf);//Cꂽl֐Ɋi[
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int ucase_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"ucase ",sizeof("ucase ")-1)){
		str+=sizeof("ucase ")-1;//߂̌̕ϐo
		trim_a(str);

		_strcpy(str_buf,getVariableStr(str));//ϐ̒lo
		
		char*pos=str_buf;
		
		while(*(++pos)){
#ifdef SHIFT_JIS
			//VtgJIS̓ǂݍ
			if((0x81<=(unsigned char)*pos && 0x9F>=(unsigned char)*pos) || (0xE0<=(unsigned char)*pos && 0xFC>=(unsigned char)*pos)){
				pos++;pos++;
			}
#endif
			if('a'<=*pos && 'z'>=*pos){
				*pos-=('a'-'A');
			}
		}

		setVariable(str,str_buf);//CꂽlϐɊi[
		setVariable("lcase",str_buf);//Cꂽl֐Ɋi[
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int left_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"left ",sizeof("left ")-1)){
		str+=sizeof("left ")-1;//߂̌̕ϐo
		trim_a(str);
		char*st0=_strchop(str ,',');//1ڂ؂o܂B
		char*st1=_strchop(NULL,',');//2ڂ؂o܂B
	
		//Qڂ̈̏
		_strcpy(str_buf,"left=");
		strcat(str_buf,st1);
		
		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x40;//񂩂͌vZKvȂ
		}
		
		unsigned int st=atoi(getVariableStr("left"));

		//Pڂ̈̏
		_strcpy(str_buf,"left=");
		strcat(str_buf,st0);
		
		if(0x20 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x20;//񂩂͌vZKvȂ
		}
		
		_strcpy(str_buf,getVariableStr("left"));

		if(st+1>(int)strlen(str_buf)) st=(int)strlen(str_buf);

		str_buf[(int)(st+1)]='\0';
		setVariable("left",str_buf);//Cꂽl֐Ɋi[
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int right_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"right ",sizeof("right ")-1)){
		str+=sizeof("right ")-1;//߂̌̕ϐo
		trim_a(str);
		char*st0=_strchop(str ,',');//1ڂ؂o܂B
		char*st1=_strchop(NULL,',');//2ڂ؂o܂B
	
		//Qڂ̈̏
		_strcpy(str_buf,"right=");
		strcat(str_buf,st1);
		
		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x40;//񂩂͌vZKvȂ
		}
		
		unsigned int st=atoi(getVariableStr("right"));

		//Pڂ̈̏
		_strcpy(str_buf,"right=");
		strcat(str_buf,st0);
		
		if(0x20 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x20;//񂩂͌vZKvȂ
		}
		
		_strcpy(str_buf,getVariableStr("right"));

		if(st+1>(int)strlen(str_buf)) st=(int)strlen(str_buf);

		setVariable("right",&(str_buf[strlen(str_buf)-st]));//Cꂽl֐Ɋi[
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

const char*conv_1b_map=
"1 2 3 4 5 6 7 8 9 0 "
"A B C D E F G H I J K L M N O P Q R S T U V W X Y Z "
"a b c d e f g h i j k l m n o p q r s t u v w x y z "
"          "
"               "
"                              "
;

//Shift_JIS
const char*conv_2b_map=
"PQRSTUVWXO"
"`abcdefghijklmnopqrstuvwxy"
""
"@BDFHb"
"ACEGIJLNPRTVXZ\x83\x5C"
"^`cegijklmnqtwz}~"
;

int jis_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"jis ",sizeof("jis ")-1)){
		str+=sizeof("jis ")-1;//߂̌̕ϐo
		trim_a(str);
		_strcpy(str_buf,getVariableStr(str));

		char*pos;
		char*pt1=str_buf;
		char*pt2=str_buf2;
		const char*c1bmap=conv_1b_map;
		const char*c2bmap=conv_2b_map;

		char a[3]="";
		char b[3]="";
		
		while(*c1bmap){
			a[0]=*c1bmap;
			b[0]=*c2bmap;
			b[1]=*(c2bmap+1);
			
			//Ώە̒u
			replace(pt2,pt1,a,b);
			//pt1pt2̓ւ
			pos=pt1;pt1=pt2;pt2=pos;
			//uΏۂɐi߂
			c1bmap++;c1bmap++;
			c2bmap++;c2bmap++;
		}

		setVariable(str,pt1);//CꂽlϐɊi[
		setVariable("jis",pt1);//Cꂽl֐Ɋi[
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int asc_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"asc ",sizeof("asc ")-1)){
		str+=sizeof("asc ")-1;//߂̌̕ϐo
		trim_a(str);
		_strcpy(str_buf,getVariableStr(str));

		char*pos;
		char*pt1=str_buf;
		char*pt2=str_buf2;
		const char*c1bmap=conv_1b_map;
		const char*c2bmap=conv_2b_map;

		char a[3]="";
		char b[3]="";
		
		while(*c1bmap){
			a[0]=*c2bmap;
			a[1]=*(c2bmap+1);
			b[0]=*c1bmap;

			//Ώە̒u
			replace(pt2,pt1,a,b);
			//pt1pt2̓ւ
			pos=pt1;pt1=pt2;pt2=pos;
			//uΏۂɐi߂
			c1bmap++;c1bmap++;
			c2bmap++;c2bmap++;
		}

		setVariable(str,pt1);//CꂽlϐɊi[
		setVariable("asc",pt1);//Cꂽl֐Ɋi[
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int instr_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"instr ",sizeof("instr ")-1)){
		str+=sizeof("instr ")-1;//߂̌̕ϐo
		trim_a(str);
		
		char*st0=_strchop(str ,',');//1ڂ؂o܂B
		char*st1=_strchop(NULL,',');//2ڂ؂o܂B
		//char*st2=_strchop(NULL,',');//3ڂ؂o܂B

		//1ڂ̈̏
		_strcpy(str_buf,"instr=");
		strcat(str_buf,st0);
		
		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x40;//񂩂͌vZKvȂ
		}
		
		_strcpy(str_buf,(getVariableStr("instr")+1));

		//2ڂ̈̏
		_strcpy(str_buf2,"instr=");
		strcat(str_buf2,st1);
		
		if(0x20 & *flag){
			//vZKvȂ̂
			substitution(str_buf2);
		}else{
			//vZKv
			if(!calculation(str_buf2)) *flag|=0x20;//񂩂͌vZKvȂ
		}
		
		_strcpy(str_buf2,(getVariableStr("instr")+1));

		char*ptr=_strstr(str_buf,str_buf2);

		if(ptr){
			setVariable("instr",(double)((ptr-str_buf)+1));//l֐Ɋi[
		}else{
			setVariable("instr",(double)0);//l֐Ɋi[
		}

		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int format_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"format ",sizeof("format ")-1)){
		str+=sizeof("format ")-1;//߂̌̕ϐo
		trim_a(str);
		char*st0=_strchop(str ,',');//1ڂ؂o܂B
		char*st1=_strchop(NULL,',');//2ڂ؂o܂B
//		char*st2=_strchop(NULL,',');//3ڂ؂o܂B

		//3ڂ̈̏
		_strcpy(str_buf,"format=");
		strcat(str_buf,st0);
		
		if(0x20 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x20;//񂩂͌vZKvȂ
		}
		
		_strcpy(str_buf,(getVariableStr("format")+1));

		//2ڂ̈̏
		_strcpy(str_buf2,"format=");
		strcat(str_buf2,st1);
		
		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str_buf2);
		}else{
			//vZKv
			if(!calculation(str_buf2)) *flag|=0x40;//񂩂͌vZKvȂ
		}
		
		_strcpy(str_buf2,(getVariableStr("format")+1));

		format(str_buf3,str_buf,str_buf2);
		setVariable("format",str_buf3);
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}



int fread_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"fread ",sizeof("fread ")-1)){
		str+=sizeof("fread ")-1;//߂̌̕ϐo
		trim_a(str);
		char*st0=_strchop(str ,',');//1ڂ؂o܂B
		char*st1=_strchop(NULL,',');//2ڂ؂o܂B
		//char*st2=_strchop(NULL,',');//3ڂ؂o܂B

		//2ڂ̈̏
		_strcpy(str_buf,"fread=");
		strcat(str_buf,st1);
		
		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x40;//񂩂͌vZKvȂ
		}
		
		_strcpy(str_buf,(getVariableStr("fread")+1));

		FILE * fp;
		if((fp=fopen(str_buf,"r"))==NULL){
			//G[
			setVariable("fread",(double)-1);
		}else{
			int count=1;
			str_buf[0]='\"';
			while(fgets(str_buf+1,MAX_STR_LEN-1,fp)!=NULL){
				char*pos=str_buf;
				//s菜
				while(*pos){
					if('\r'==*pos || '\n'==*pos)
					{
						*pos='\0';break;
					}
					pos++;
				}
				sprintf(str_buf2,"%s[\"%d\"]",st0,count++);
				setVariable(str_buf2,str_buf);
			}
			setVariable("fread",(double)count-1);
			fclose(fp);
		}

		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int fwrite_(char*str,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"fwrite ",sizeof("fwrite ")-1)){
		str+=sizeof("fwrite ")-1;//߂̌̕ϐo
		trim_a(str);
		char*st0=_strchop(str ,',');//1ڂ؂o܂B
		char*st1=_strchop(NULL,',');//2ڂ؂o܂B
		char*st2=_strchop(NULL,',');//3ڂ؂o܂B

		//3ڂ̈̏
		_strcpy(str_buf,"fwrite=");
		strcat(str_buf,st2);
		
		if(0x20 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x20;//񂩂͌vZKvȂ
		}
		
		int len=atoi(getVariableStr("fwrite"));

		//2ڂ̈̏
		_strcpy(str_buf,"fwrite=");
		strcat(str_buf,st1);
		
		if(0x40 & *flag){
			//vZKvȂ̂
			substitution(str_buf);
		}else{
			//vZKv
			if(!calculation(str_buf)) *flag|=0x40;//񂩂͌vZKvȂ
		}
		
		_strcpy(str_buf,(getVariableStr("fwrite")+1));

		FILE * fp;
		if((fp=fopen(str_buf,"w"))==NULL){
			//G[
			setVariable("fwrite",(double)-1);
		}else{
			for(int i=1;i<=len;i++){
				sprintf(str_buf,"%s[\"%d\"]",st0,i);
				_strcpy(str_buf,(getVariableStr(str_buf)));
				if('\"'==*str_buf){
					fprintf(fp,"%s\n",str_buf+1);
				}else{
					fprintf(fp,"%s\n",str_buf);
				}
			}
			setVariable("fwrite",(double)0);
	    	fclose(fp);
		}
		
		*flag|=0x80;//֐
		return 1;
	}else{
		return 0;
	}
}

int block_(char*str,std::vector<std::string>*source,
		  unsigned int*p_counter,std::vector<unsigned long>*data,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"@",sizeof("@")-1)){
		//@Ɍ݂̃AhX
		setVariable("@",(double)((*p_counter)-1));
		//@_ɃWv
		if((*data)[*p_counter]){
			//x̕ʉ߂dataɃWvԒncĂꍇ
			*p_counter=(*data)[*p_counter]+1;//vOJE^ɑ
			return 1;
		}else{
			//߂Ă̕ʉ߂ꍇ̏
			unsigned int p_pos=*p_counter;
			*str_buf='\0';
			int counter=0;
			while(EOF!=*str_buf){
				_strcpy(str_buf,(*source)[p_pos].c_str());
				_strcpy(str_buf,(*source)[p_pos].c_str());
				if(0==strncmp(str_buf,"@",sizeof("@")-1) && !strstr(str_buf,"=")) counter++;
				
				if(0==strcmp(str_buf,"_@")){
					if(!counter){
						(*data)[*p_counter]=(unsigned long)p_pos;//ۑ
						*p_counter=p_pos+1;//vOJE^ɑ
						*flag|=0x80;//֐
						return 1;
					}else{
						counter--;	
					}
				}
				p_pos++;
			}
			//G[
			setError("ERR \"@...._@\"");
			return 0;
		}
	}
	return 0;
}

int blockClose_(char*str,unsigned int*p_counter,unsigned char*flag){
	if((0x80 & *flag) || 0==strncmp(str,"_@",sizeof("_@")-1)){
		if(adr_stack.empty()==false){
			//X^bNɒli[Ă

			//ۑꂽO[oϐ̐擾
			unsigned int pushCount=adr_stack.top();//Ō̒l̎擾
			adr_stack.pop();//Ō̒l̍폜
			for(unsigned int i=0;i<pushCount;i++) popVariable();

			popVariable("this");//߂l֐̕ϐɖ߂߁AX^bN̕ϐthisϐ𕡐
			//vOJE^X^bN畜A
			*p_counter=adr_stack.top();//Ō̒l̎擾
			adr_stack.pop();//Ō̒l̍폜

			*flag|=0x80;//֐
			return 1;
		}else{
			return -1;//ERR
		}
	}
	return 0;
}

//-------------------------------------------------------------------------------
