/*
 * aBasic
 * Copyright (C) 2007 m_inaba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "basic.h"

unsigned int p_counter; //vOJE^
std::vector<std::string> source; //basic̃vOi[z
std::vector<unsigned long> jmp_true; //basic̃vÕWvz
std::vector<unsigned long> jmp_false;//if̕򌋉ʂɂ2ނ̃AhXKvɂȂ
std::vector<unsigned long> func; //basic̃vO̖߂z

/*
func\ς݃rbg
--------------------------------
*.*.............****************
--------------------------------
32              16             1 LSB

32bit  eval
30bit  IF
16bit`1bit e햽
*/

std::vector<unsigned long> lineNo; //si[z
std::vector<unsigned char> func_true; //֐̃Xe[^Xi[z
std::vector<unsigned char> func_false;
/*
func_true,func_false\ς݃rbg
--------
*****..*
--------
8      1 LSB

8bit`5bit e햽
4bit  _arry֐
1bit ꎞprbg(p0ɖ߂)
*/

static char buff[MAX_STR_LEN];
static char buff2[MAX_STR_LEN];
static char buff3[MAX_STR_LEN];

//inputŉs܂ŃubN郂[hݒ肷|C^
double*inputblock;


int fileLoad(const char*filename);
int basic_init(char*filename);
void basic_setup();
void basic_start(int adder);
void basic_end();
int expCheck(const char*str);
int eval_(char*str);


int fileLoad(const char*filename){
	//basicvOǂݍ݁AHăxN^[zɊi[
	FILE * fp;
	if((fp=fopen(filename,"r"))==NULL){
		//G[
		printf("%s : %s\n","file open error",filename);
		return 1;
	}else{
		unsigned long line=0;//sԍ
		*buff2='\0';
		while(fgets(buff,MAX_STR_LEN,fp)!=NULL){
			line++;//ۂ̍sԍ
			instcpy(buff3,buff);
			trim_rl(buff3);

			if(*buff3 && '\\'==buff3[strlen(buff3)-1]){
				buff3[strlen(buff3)-1]='\0';
				strcat(buff2,buff3);
				*buff3='\0';
			}else{
				strcat(buff2,buff3);
				_strcpy(buff3,buff2);
				*buff2='\0';
			}

			if(*buff3){
				if(0==strncmp(buff3,"import ",sizeof("import ")-1)){
					char*pos=buff3+sizeof("import ")-1;//߂̌̕ϐo
					//_uNI[e[V<>菜
					if('\"'==*pos){
						pos++;
						pos[strlen(pos)-1]='\0';
					}else if('<'==*pos){
						pos++;
						pos[strlen(pos)-1]='\0';
					}
					if(fileLoad(pos)) return 1;
				}else{
					source.push_back(buff3);
					jmp_true.push_back(0);
					jmp_false.push_back(0);
					func.push_back(0);
					func_true.push_back(0);
					func_false.push_back(0);
					lineNo.push_back(line);//ۂ̍sԍۑ
				}
			}
		}
		*buff2='\0';
		fclose(fp);
	}
	return 0;	
}

int basic_init(char*filename){
	srand((unsigned)time(NULL));//̎
	//\G[̋s[hݒ 0:s
	setVariable("system.err.exit",(double)0);
	//inputŉs܂ŃubN郂[h 1:ubN
	//ϐ̃|C^ۑ
	inputblock=setVariable("system.io.inputblock",(double)1);
	//@thisϐ
	setVariable("@this",(double)0);

	//0sڂ͋ɂ
	source.push_back("");
	jmp_true.push_back(0);
	jmp_false.push_back(0);
	func.push_back(0);
	func_true.push_back(0);
	func_false.push_back(0);
	lineNo.push_back(0);

	int r = fileLoad(filename);
	
	source.push_back("\xFF");//EOFŌɒǉ
	jmp_true.push_back(0);
	jmp_false.push_back(0);
	func.push_back(0);
	func_true.push_back(0);
	func_false.push_back(0);
	lineNo.push_back((unsigned long)-1);
	
	return r;
}

void basic_setup(){
	//x̃AhXɓo^
	char*pos=buff2;
	for(unsigned int i=0;i<source.size();i++){
		_strcpy(buff,source[i].c_str());
		if(!expCheck(buff)){
			cut_func(buff);
			arry(pos,buff);
			if('@'==*pos){
				setVariable(pos,(double)i);
			}else if(':'==pos[strlen(pos)-1]){
				setVariable(pos,(double)i);
			}
		}
	}
}


void basic_start(int adder){
	//JnAhX0̏ꍇɂ̓vOJE^ύXȂ
	if(adder) p_counter=adder;

	int rst;
	unsigned int pos;
	std::vector<unsigned long>*jmp;
	unsigned char*func_flag;

	//[hG[
	//荞݃tO
	if(1==interlope){
		printf("ERR line:%s\n",getVariableStr("system.err"));
		setVariable("system.err.msg",getVariableStr("system.err"));
		return;
	}
	
	while(1){
		char*str=buff;
		_strcpy(str,source[p_counter++].c_str());
		rst=0;
		//EOF̏
		if(*str==EOF){//EOF
			break;
		}

		//eval̏
		if(!(func[p_counter]&EVAL)){
			if(eval_(str)){
				//eval
				//̎_Ńobt@̒Ă				
				//eval͓Ȗ߂̂ߑSĂNA
				func[p_counter]=0;
				func_true[p_counter]=0;
				func_false[p_counter]=0;
				jmp_true[p_counter]=0;//WvZbg
				jmp_false[p_counter]=0;
			}else{
				//evalł͂Ȃ
				func[p_counter]|=EVAL;
			}
		}


		//if̌ʂɂVtgl
		int if_shift=0;
		
		//֐̃Xe[^X
		func_flag=(unsigned char*)&func_true[p_counter];

		//OutputDebugString(str);OutputDebugString("\n");//fobOo

		//WvAhXۑz
		jmp=&jmp_true;
		
		//IF̏ if **** then **** else **** \̏
		if(!(func[p_counter]&IF)){
			rst=if_(str,NULL);
			//߂lɕ򌋉ʂĂ
			if(2==rst){
				//FALSȄꍇ
				if_shift=8;//Vtglݒ
				//֐̃Xe[^X
				func_flag=(unsigned char*)&func_false[p_counter];
				jmp=&jmp_false;//WvAhXۑzւ
			}else if(0==rst){
				//IFŖꍇ 1𗧂Ă
				func[p_counter]|=IF;
			}
		}
		//ߕ󕶎̏ꍇ͎̍sɐi
		if('\0'==*str) {func[p_counter]|=(NOTHING<<if_shift);goto LOOP_LAST;}

		if(0==(func[p_counter]&(MASK<<if_shift))){
			pos=p_counter;
			
			//foȑ
			if(for_(str,func_flag)){func[pos]|=(FOR<<if_shift);}
			//next̏
			else if(next_(str,&source,&p_counter,jmp,func_flag)){func[pos]|=(NEXT<<if_shift);}
			//gotȍ
			else if(goto_(str,&p_counter,func_flag)){func[pos]|=(GOTO<<if_shift);}
			//return̏
			else if(return_(str,&source,&p_counter,jmp,func_flag)){func[pos]|=(RETURN<<if_shift);}
			//sɓnif̏
			else if(if2_(str,&source,&p_counter,jmp,func_flag)){func[pos]|=(IF2<<if_shift);}
			//elsȅ
			else if(else_(str,&source,&p_counter,jmp,func_flag)){func[pos]|=(ELSE<<if_shift);}
			//input̏
			else if(input_(str,func_flag)){func[pos]|=(INPUT<<if_shift);}
			//print̏
			else if(print_(str,func_flag)){func[pos]|=(PRINT<<if_shift);}
			//clȑ
			else if(clr_(str,func_flag)){func[pos]|=(CLR<<if_shift);}
			//location̏
			else if(location_(str,func_flag)){func[pos]|=(LOCATION<<if_shift);}
			//wait̏
			else if(wait_(str,func_flag)){func[pos]|=(WAIT<<if_shift);}
			//abs̏
			else if(abs_(str,func_flag)){func[pos]|=(ABS<<if_shift);}
			//shell̏
			else if(shell_(str,func_flag)){func[pos]|=(SHELL<<if_shift);}
			//len̏
			else if(len_(str,func_flag)){func[pos]|=(LEN<<if_shift);}
			//mid̏
			else if(mid_(str,func_flag)){func[pos]|=(MID<<if_shift);}
			//val̏
			else if(val_(str,func_flag)){func[pos]|=(VAL<<if_shift);}
			//stȑ
			else if(str_(str,func_flag)){func[pos]|=(STR<<if_shift);}
			//csv̏
			else if(csv_(str,func_flag)){func[pos]|=(CSV<<if_shift);}
			//vsc̏
			else if(vsc_(str,func_flag)){func[pos]|=(VSC<<if_shift);}
			//chop̏
			else if(chop_(str,func_flag)){func[pos]|=(CHOP<<if_shift);}
			//trim̏
			else if(trim_(str,func_flag)){func[pos]|=(TRIM<<if_shift);}
			//ltrim̏
			else if(ltrim_(str,func_flag)){func[pos]|=(LTRIM<<if_shift);}
			//rtrim̏
			else if(rtrim_(str,func_flag)){func[pos]|=(RTRIM<<if_shift);}
			//replacȅ
			else if(replace_(str,func_flag)){func[pos]|=(REPLACE<<if_shift);}
			//match̏
			else if(match_(str,func_flag)){func[pos]|=(MATCH<<if_shift);}
			//lcasȅ
			else if(lcase_(str,func_flag)){func[pos]|=(LCASE<<if_shift);}
			//ucasȅ
			else if(ucase_(str,func_flag)){func[pos]|=(UCASE<<if_shift);}
			//left̏
			else if(left_(str,func_flag)){func[pos]|=(LEFT<<if_shift);}
			//right̏
			else if(right_(str,func_flag)){func[pos]|=(RIGHT<<if_shift);}
			//jis̏
			else if(jis_(str,func_flag)){func[pos]|=(JIS<<if_shift);}
			//asc̏
			else if(asc_(str,func_flag)){func[pos]|=(ASC<<if_shift);}
			//instȑ
			else if(instr_(str,func_flag)){func[pos]|=(INSTR<<if_shift);}
			//fread̏
			else if(fread_(str,func_flag)){func[pos]|=(ABASIC_FREAD<<if_shift);}
			//fwritȅ
			else if(fwrite_(str,func_flag)){func[pos]|=(ABASIC_FWRITE<<if_shift);}
			//format̏
			else if(format_(str,func_flag)){func[pos]|=(FORMAT<<if_shift);}
			//_@̏
			else if(rst=blockClose_(str,&p_counter,func_flag)){func[pos]|=(_BLOCK<<if_shift);}
			//END̏
			else if(0==strncmp(str,"end",sizeof("end")-1)){//END
				if(strlen(str)==strlen("end")) break;
			}
			//̏
			else if(expCheck(str)){
				func[pos]|=(EXP<<if_shift);
				trim_a(str);
				if(!calculation(str)) *func_flag|=0x40;//񂩂͌vZKvȂ
			}
			//@_̏
			else if(block_(str,&source,&p_counter,jmp,func_flag)){func[pos]|=(BLOCK_<<if_shift);}
			//func̏
			else if(func_(str,&source,&p_counter,func_flag)){func[pos]|=(FUNC<<if_shift);}
			//\G[̏
			else {
				func[pos]|=(NOTHING<<if_shift);
				//G[ݒ肳ĖăxłȂꍇ͕sȍ\ł
				if(1!=interlope){
					if(':'!=str[strlen(str)-1]) setError(str);
				}
			}
		}else{
			
			switch ((func[p_counter]&(MASK<<if_shift))>>if_shift){
				case FOR:
					//foȑ
					for_(str,func_flag);
					break;
				case NEXT:
					//next̏
					next_(str,&source,&p_counter,jmp,func_flag);
					break;
				case GOTO:
					//gotȍ
					goto_(str,&p_counter,func_flag);
					break;
				case RETURN:
					//return̏
					return_(str,&source,&p_counter,jmp,func_flag);
					break;
				case IF2:
					//sɓnif̏
					if2_(str,&source,&p_counter,jmp,func_flag);
					break;
				case ELSE:
					//elsȅ
					else_(str,&source,&p_counter,jmp,func_flag);
					break;
				case INPUT:
					//input̏
					input_(str,func_flag);
					break;
				case PRINT:
					//print̏
					print_(str,func_flag);
					break;
				case CLR:
					//clȑ
					clr_(str,func_flag);
					break;
				case LOCATION:	
					//location̏
					location_(str,func_flag);
					break;
				case WAIT:
					//wait̏
					wait_(str,func_flag);
					break;
				case ABS:
					//abs̏
					abs_(str,func_flag);
					break;
				case SHELL:
					//shell̏
					shell_(str,func_flag);
					break;
				case LEN:
					//len̏
					len_(str,func_flag);
					break;
				case MID:
					//mid̏
					mid_(str,func_flag);
					break;
				case VAL:
					//val̏
					val_(str,func_flag);
					break;
				case STR:
					//stȑ
					str_(str,func_flag);
					break;
				case CSV:
					//csv̏
					csv_(str,func_flag);
					break;
				case VSC:
					//vsc̏
					vsc_(str,func_flag);
					break;
				case CHOP:
					//chop̏
					chop_(str,func_flag);
					break;
				case TRIM:
					//trim̏
					trim_(str,func_flag);
					break;
				case LTRIM:
					//ltrim̏
					ltrim_(str,func_flag);
					break;
				case RTRIM:
					//rtrim̏
					rtrim_(str,func_flag);
					break;
				case REPLACE:
					//replacȅ
					replace_(str,func_flag);
					break;
				case MATCH:
					//match̏
					match_(str,func_flag);
					break;
				case LCASE:
					//lcasȅ
					lcase_(str,func_flag);
					break;
				case UCASE:
					//ucasȅ
					ucase_(str,func_flag);
					break;
				case LEFT:
					//left̏
					left_(str,func_flag);
					break;
				case RIGHT:
					//right̏
					right_(str,func_flag);
					break;
				case JIS:
					//jis̏
					jis_(str,func_flag);
					break;
				case ASC:
					//asc̏
					asc_(str,func_flag);
					break;
				case INSTR:
					//instȑ
					instr_(str,func_flag);
					break;
				case ABASIC_FREAD:
					//fread̏
					fread_(str,func_flag);
					break;
				case ABASIC_FWRITE:
					//fwritȅ
					fwrite_(str,func_flag);
					break;
				case FORMAT:
					//format̏
					format_(str,func_flag);
					break;
				case _BLOCK:
					//_@̏
					rst=blockClose_(str,&p_counter,func_flag);
					break;
				case EXP:
					//̏
					trim_a(str);
					if(0x40 & *func_flag){
						//vZKvȂ̂
						substitution(str);
					}else{
						//vZKv
						calculation(str);
					}
					break;
				case BLOCK_:
					//@_̏
					block_(str,&source,&p_counter,jmp,func_flag);
					break;
				case FUNC:
					//func̏
					func_(str,&source,&p_counter,func_flag);
					break;
			}
		}
		if(-1==rst) break;//returnŖ߂lꍇɂ͏I
LOOP_LAST:;
		//VXe[hݒ@MapɊi[ꂽϐ̃|C^Ŕf
		if(1.0==*inputblock){
			//ubLO[h
			nonblock_end();
		}else{
			//mubLO[h
			nonblock_start();
		}
		//G[ 荞݃tO
		if(1==interlope){
			interlope=0;
			printf("ERR line:%d\tmsg:%s\tsource:%s\n",lineNo[p_counter-1],getVariableStr("system.err"),str);
			setVariable("system.err.line",(double)lineNo[p_counter-1]);
			setVariable("system.err.msg",getVariableStr("system.err"));
			setVariable("system.err","");
			//G[̋s[h̊mF 0:s 0ȊO:vOI
			if(0!=strcmp("0",getVariableStr("system.err.exit"))) return;
		}
	}
}

void basic_end(){
	//^[~ȉԂɖ߂
	nonblock_end();
}

//񂪑ł邩 1: 0:ȊO
int expCheck(const char*str){
	int flag=0;
	while(*str){
		
#ifdef SHIFT_JIS
		//񂾂ꍇ͑łȂ
		//VtgJIS̓ǂݍ
		if((0x81<=(unsigned char)*str && 0x9F>=(unsigned char)*str) || (0xE0<=(unsigned char)*str && 0xFC>=(unsigned char)*str)){
			return 0;
		}
#endif
		//z͓ǂݔ΂
		if('['==*str){//""ň͂܂ꂽ͏O
			while(']'!=*++str){
				if('\0'==*str) return 0;//"̖G[
				if('\\'==*str){
					str++;//GXP[vV[PX̓ǂݍ
					if('\0'==*str)return 0;//"̖G[
				}
#ifdef SHIFT_JIS
				//VtgJIS̓ǂݍ
				if((0x81<=(unsigned char)*str && 0x9F>=(unsigned char)*str) || (0xE0<=(unsigned char)*str && 0xFC>=(unsigned char)*str)){
					str++;//Shift_JIS̓ǂݍ
					if('\0'==*str)return 0;//"̖G[
				}
#endif
			}
		}
		
		//񂾂ꍇ͑łȂ
		if('\"'==*str){
			return 0;
		}
		
		//CR[AȂΑ
		if('='==*str){
			if('='==*(str+1)){
				return 0;
			}else{
				return 1;
			}
		}
		
		//sꍇ͑łȂ
		if('<'==*str || '>'==*str){
			return 0;
		}

		//Xy[X̎ɃCR[ȊO̕łȂ
		//CR[炱ɗ܂łɔ肳Ă
		if(flag && ' '!=*str){
			return 0;
		}
		
		if(' '==*str){
			flag=1;
		}
		
		str++;
	}
	return 0;
}


//-------------------------------------------------------------------------------
