//-------------------------------------------------------------------------------
// vari.cpp
//-------------------------------------------------------------------------------

#include "vari.h"

struct ltstr
{
  bool operator()(const char* s1, const char* s2) const
  {
    return strcmp(s1, s2) < 0;
  }
};

std::map<const char*,st_form,ltstr> variable_table;//̃}bv
std::map<const char*,st_form,ltstr>::iterator it;


//𑍂ďZbg
void initVariable(){
	//Ă̗vf̃J
	for(it = variable_table.begin(); it!= variable_table.end();it++){
		st_form*pos=&(it->second);
		const char*c=it->first;
		delete [] c;
		if(pos->str) delete [] pos->str;
		if(pos->d) delete [] pos->d;
	}
	//}bṽNA
	variable_table.clear();
}


//`̕ϐ͒lϊoAgϐɊi[
void getVariable(char*data,VARIANT_*v){
	v->init();//l
	if(('0'<=*data && '9'>=*data) || '+'==*data || '-'==*data){
		//ꍇ
		double d=atof(data);
		v->flag=TYPE_VAL;//l^ɐݒ
		v->d_val=d;//l𕡐
	}else{
		if('\"'==*data){
			//f[^ꍇ
			//̃_uNI[e[V폜
			char*c=&data[strlen(data)-1];
			if('\"'==*c) *c='\0';
			v->flag=TYPE_STR;//^ɐݒ
			_strcpy(v->str_val,data);//l𕡐
		}else{
			//ϐꍇ
			double pos;
			if(!strncmp(data,"time.",sizeof("time.")-1)){
				time_t now = time(NULL);
				struct tm *pnow = localtime(&now);
				if(!strcmp(data,"time.year")){
					pos=pnow->tm_year+1900;
					v->flag=TYPE_VAL;//l^ɐݒ
					v->d_val=pos;//l𕡐
				}else if(!strcmp(data,"time.mon")){
					pos=pnow->tm_mon + 1;
					v->flag=TYPE_VAL;//l^ɐݒ
					v->d_val=pos;//l𕡐
				}else if(!strcmp(data,"time.day")){
					pos=pnow->tm_mday;
					v->flag=TYPE_VAL;//l^ɐݒ
					v->d_val=pos;//l𕡐
				}else if(!strcmp(data,"time.week")){
					pos=pnow->tm_wday;
					v->flag=TYPE_VAL;//l^ɐݒ
					v->d_val=pos;//l𕡐
				}else if(!strcmp(data,"time.hour")){
					pos=pnow->tm_hour;
					v->flag=TYPE_VAL;//l^ɐݒ
					v->d_val=pos;//l𕡐
				}else if(!strcmp(data,"time.min")){
					pos=pnow->tm_min;
					v->flag=TYPE_VAL;//l^ɐݒ
					v->d_val=pos;//l𕡐
				}else if(!strcmp(data,"time.sec")){
					pos=pnow->tm_sec;
					v->flag=TYPE_VAL;//l^ɐݒ
					v->d_val=pos;//l𕡐
				}
			}else if(!strcmp(data,"rand")){
				//̎QƂ̂ߗ𐶐
				pos=rand()%9999;
				v->flag=TYPE_VAL;//l^ɐݒ
				v->d_val=pos;//l𕡐
			}else{
				//ϐƍlAϐe[uQ
				unsigned int i;
				void*r=getVariable(data,&i);
				if(r){
					if(TYPE_VAL==i){
						v->flag=TYPE_VAL;//l^ɐݒ
						v->d_val=*((double*)r);//l𕡐
					}else{
						v->flag=TYPE_STR;//^ɐݒ
						_strcpy(v->str_val,(char*)r);//l𕡐
					}
				}
			}
		}
	}
}


//`̕ϐ͒lϊϐɊi[
void setVariableEtc(const char*name,char*data,int write_mode){
	if(('0'<=*data && '9'>=*data) || '+'==*data || '-'==*data){
		//ꍇ
		double d=atof(data);
		setVariable(name,d,write_mode);
	}else{
		if('\"'==*data){
			//f[^ꍇ
			//̃_uNI[e[V폜
			char*c=&data[strlen(data)-1];
			if('\"'==*c) *c='\0';
			setVariable(name,data,write_mode);
		
		}else{
			//ϐꍇ
			double pos;
			if(!strncmp(data,"time.",sizeof("time.")-1)){
				time_t now = time(NULL);
				struct tm *pnow = localtime(&now);
				if(!strcmp(data,"time.year")){
					pos=pnow->tm_year+1900;
					setVariable(name,pos,write_mode);
				}else if(!strcmp(data,"time.mon")){
					pos=pnow->tm_mon + 1;
					setVariable(name,pos,write_mode);
				}else if(!strcmp(data,"time.day")){
					pos=pnow->tm_mday;
					setVariable(name,pos,write_mode);
				}else if(!strcmp(data,"time.week")){
					pos=pnow->tm_wday;
					setVariable(name,pos,write_mode);
				}else if(!strcmp(data,"time.hour")){
					pos=pnow->tm_hour;
					setVariable(name,pos,write_mode);
				}else if(!strcmp(data,"time.min")){
					pos=pnow->tm_min;
					setVariable(name,pos,write_mode);
				}else if(!strcmp(data,"time.sec")){
					pos=pnow->tm_sec;
					setVariable(name,pos,write_mode);
				}
			}else if(!strcmp(data,"rand")){
				//̎QƂ̂ߗ𐶐
				pos=rand()%9999;
				setVariable(name,pos,write_mode);
			}else{
				//ϐƍlAϐe[uQ
				unsigned int i;
				void*r=getVariable(data,&i);
				if(r){
					if(TYPE_VAL==i){
						setVariable(name,*((double*)r),write_mode);
					}else{
						setVariable(name,(char*)r,write_mode);
					}
				}else{
					//ϐݒ肳ĖꍇA0
					setVariable(name,(double)0,write_mode);
				}
			}
		}
	}
}


VARIANT_ reg1;


char*setVariable(const char*name,const char*data,int write_flag,unsigned int bufsize){
	if(write_flag){
		//mapւ̏݃[hIt
		reg1.flag=TYPE_STR;//^ɐݒ
		reg1.d_val=0;
		_strcpy(reg1.str_val,data);//l𕡐
		return NULL;
	}else{
		//mapւ̏݃[hI
		
		//KvƂobt@ʂvZ
		unsigned int len;
		len=(unsigned int)((strlen(data)/8)+1)*8;
		if(len<bufsize){
			len=bufsize;
		}
		
		it=variable_table.find(name);
		if(it == variable_table.end()){
			st_form stf;
			stf.flag=TYPE_STR;//tO
			stf.d=NULL;
			stf.str=NULL;
			stf.strlen=len;
			while(!(stf.str)) stf.str=new char[stf.strlen];
			_strcpy(stf.str,data);
			char*key=NULL;
			while(!key) key=new char[strlen(name)+1];
			_strcpy(key,name);
			std::pair<const char*,st_form> p((const char*)key,stf);
			variable_table.insert(p);
			return stf.str;
		}else{
			st_form*pos=&(it->second);
			pos->flag=TYPE_STR;//tO
			if(pos->str){
				if(pos->strlen<len){
					//obt@eʂȂ׍Đݒ肷
					delete [] pos->str;
					pos->str=NULL;
					pos->strlen=len;
					while(!(pos->str)) pos->str=new char[pos->strlen];
					_strcpy(pos->str,data);
				}else{
					_strcpy(pos->str,data);
				}
			}else{
				pos->strlen=len;
				while(!(pos->str)) pos->str=new char[pos->strlen];
				_strcpy(pos->str,data);
			}
			return pos->str;
		}
	}
}

double*setVariable(const char*name,double data,int write_flag){
	if(write_flag){
		//mapւ̏݃[hIt
		reg1.flag=TYPE_VAL;//l^ɐݒ
		reg1.d_val=data;//l𕡐
		reg1.str_val[0]='\0';
		return NULL;
	}else{
		//mapւ̏݃[hI
		it=variable_table.find(name);
		if(it == variable_table.end()){
			st_form stf;
			stf.flag=TYPE_VAL;//ltO
			stf.str=NULL;
			stf.d=NULL;
			while(!(stf.d)) stf.d=new double(data);
			char*key=NULL;
			while(!key) key=new char[strlen(name)+1];
			_strcpy(key,name);
			std::pair<const char*,st_form> p((const char*)key,stf);
			variable_table.insert(p);
			return stf.d;
		}else{
			st_form*pos=&(it->second);
			pos->flag=TYPE_VAL;//ltO
			if(pos->d){
				*(pos->d)=data;
			}else{
				while(!(pos->d)) pos->d=new double(data);
			}
			return pos->d;
		}
	}
}

//ύXȂ萔̑ ̃obt@ŏɂ
char*setVariableConst(const char*name,const char*data){
	st_form stf;
	stf.flag=TYPE_STR;//tO
	stf.d=NULL;
	stf.str=NULL;
	while(!(stf.str)) stf.str=new char[strlen(data)+1];
	_strcpy(stf.str,data);
	char*key=NULL;
	while(!key) key=new char[strlen(name)+1];
	_strcpy(key,name);
	std::pair<const char*,st_form> p((const char*)key,stf);
	variable_table.insert(p);
	return stf.str;
}

int isVariable(const char*name){
	return (int)variable_table.count(name);
}

void*getVariable(const char*name,unsigned int*type){
	it=variable_table.find(name);
	if(it != variable_table.end()){
		*type=it->second.flag;
		if(*type==TYPE_STR){
			return (void*)(it->second.str);
		}
		if(*type==TYPE_VAL){
			return (void*)(it->second.d);
		}
	}
	return NULL;
}

//-----------------------------------------------
double getVariableVal(const char*name){
	it=variable_table.find(name);
	if(it == variable_table.end()){
		return (double)0;
	}else{
		if(TYPE_VAL==((st_form)(it->second)).flag){
			return *(((st_form)(it->second)).d);
		}else{
			return (double)0;
		}
	}
}

char buf[32];

const char*getVariableStr(const char*name){
	it=variable_table.find(name);
	if(it == variable_table.end()){
		buf[0]='\0';
		return (const char*)buf;
	}else{
		if(TYPE_STR==((st_form)(it->second)).flag){
			return (const char*)((((st_form)(it->second)).str));
		}else{
			sprintf(buf,"%.13g",*(((st_form)(it->second)).d));
			return (const char*)buf;
		}
	}
}

void*setVariableStr(const char*name,const char*data){
	if('\"'==*data){
		//
		return (void*)setVariable(name,data);
	}else{
		//
		return (void*)setVariable(name,atof(data));
	}
}

//ϐ̓e𕡐
void copyVariable(const char*out,const char*in){
	unsigned int i;
	void*r=getVariable(in,&i);
	if(r){
		if(TYPE_VAL==i){
			setVariable(out,*((double*)r));
		}else if(TYPE_STR==i){
			setVariable(out,(char*)r);
		}else{
			setVariable(out,(double)0);
		}
	}else{
		setVariable(out,(double)0);
	}
}


//------------------------------------------------------------------------

//ϐX^bN\
struct vari_form{
	std::string name;
	st_form st;
};

unsigned int stack_ptr;
unsigned int last_stack_ptr;
std::vector<vari_form*> st_ar;

//w肳ꂽϐ̒lX^bNɕۑ
void pushVariable(const char*name){
	vari_form*vf;
	if(stack_ptr<last_stack_ptr){
		vf=st_ar[stack_ptr];
	}else{
		vf=NULL;
		while(!vf) vf=new vari_form();
		vf->st.d=NULL;
		vf->st.str=NULL;
		st_ar.push_back(vf);
		last_stack_ptr++;
	}
	stack_ptr++;

	it=variable_table.find(name);
	if(it != variable_table.end()){
		st_form*pos=&(it->second);
		vf->name=name;
		vf->st.flag=pos->flag;
		
		if(TYPE_VAL==pos->flag){
			if(vf->st.d){
				*(vf->st.d)=*(pos->d);
			}else{
				while(!(vf->st.d)) vf->st.d=new double(*(pos->d));
			}
		}else if(TYPE_STR==pos->flag){
			if(vf->st.str){
				_strcpy(vf->st.str,pos->str);
			}else{
				while(!(vf->st.str)) vf->st.str=new char[MAX_STR_LEN];
				_strcpy(vf->st.str,pos->str);
			}
		}
	}else{
		vf->name=name;
		vf->st.flag=TYPE_VAL;
		if(vf->st.d){
			*(vf->st.d)=(double)0;
		}else{
			while(!(vf->st.d)) vf->st.d=new double((double)0);
		}
	}
}

//X^bNϐ𕜌
void popVariable(){
	stack_ptr--;
	vari_form*vf=st_ar[stack_ptr];
	if(TYPE_VAL==vf->st.flag){
		setVariable(vf->name.c_str(),*(vf->st.d));
	}else if(TYPE_STR==vf->st.flag){
		setVariable(vf->name.c_str(),vf->st.str);
	}
}

//X^bNϐ𕜌Aw̕ϐ㏑
void popVariable(const char*name){
	stack_ptr--;
	vari_form*vf=st_ar[stack_ptr];
	copyVariable(vf->name.c_str(),name);
}


//-------------------------------------------------------------------------------
