package jp.sourceforge.acerola3d.a2viewer;

import jp.sourceforge.acerola3d.*;
import jp.sourceforge.acerola3d.a2.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.URL;
import javax.swing.*;

public class A2Viewer implements ActionListener {
    JFrame frame;
    JMenuBar menuBar;
    JMenu configMenu;
    JMenuItem consoleMenuItem;
    JMenuItem proxyMenuItem;
    JMenuItem snapshotMenuItem;
    JMenuItem backgroundMenuItem;
    JTextField urlTextField;
    JButton refButton;
    JFileChooser fileChooser;
    A2Canvas a2canvas;
    JComboBox actionNameCB;
    JTextArea commentTextArea;
    JLabel statusBarLabel;
    JFrame consoleFrame;
    JTextArea consoleTextArea;
    JButton clearConsoleButton;

    Action2D a2;
    String actionName = "0";

    public A2Viewer(String args[]) {
        A23.initA23();
        frame = new JFrame("A2Viewer");
        Box baseBox = Box.createVerticalBox();
        frame.getContentPane().add(baseBox);

        menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        menuBar.add(Box.createHorizontalGlue());
        configMenu = new JMenu("Config");
        menuBar.add(configMenu);
        consoleMenuItem = new JMenuItem("Console");
        consoleMenuItem.addActionListener(this);
        configMenu.add(consoleMenuItem);
        proxyMenuItem = new JMenuItem("Proxy");
        proxyMenuItem.addActionListener(this);
        configMenu.add(proxyMenuItem);
        snapshotMenuItem = new JMenuItem("Snapshot");
        snapshotMenuItem.addActionListener(this);
        configMenu.add(snapshotMenuItem);
        backgroundMenuItem = new JMenuItem("Background");
        backgroundMenuItem.addActionListener(this);
        configMenu.add(backgroundMenuItem);

        consoleFrame = new JFrame("Console");
        Box b = Box.createVerticalBox();
        consoleTextArea = new JTextArea(20,60);
        consoleTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(consoleTextArea);
        b.add(sp);
        clearConsoleButton = new JButton("Clear");
        clearConsoleButton.addActionListener(this);
        b.add(clearConsoleButton);
        consoleFrame.getContentPane().add(b);
        consoleFrame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                consoleFrame.setVisible(false);
            }
        });
        PrintStream systemOut = System.out;
        JTextAreaOutputStream jtaos = new JTextAreaOutputStream(consoleTextArea,systemOut);
        PrintStream ps = new PrintStream(jtaos,true);
        System.setOut(ps);
        System.setErr(ps);
        consoleFrame.pack();
        
        Box box1 = Box.createHorizontalBox();
        baseBox.add(box1);
        box1.add(new JLabel("URL:"));
        urlTextField = new JTextField();
        try {
            File f = null;
            if ((args!=null)&&(args.length==2)&&(args[0].equals("-open")))
                f  = new File(args[1]);
            else
                f = new File(args[0]);
            URL url = f.toURL();
            urlTextField.setText(url.toExternalForm());
        } catch (Exception e) {
            urlTextField.setText("x-res:///jp/sourceforge/acerola3d/a2viewer/resources/acerola.a2");
        }
        urlTextField.addActionListener(this);
urlTextField.setMaximumSize(new Dimension(3000,30));
        box1.add(urlTextField);
        refButton = new JButton("ref");
        refButton.addActionListener(this);
        box1.add(refButton);

        Box box2 = Box.createHorizontalBox();
        baseBox.add(box2);

        a2canvas = A2Canvas.createA2Canvas(300,300);
        box2.add(a2canvas);

        Box controlBox = makeControlBox();
        box2.add(controlBox);

        statusBarLabel = new JLabel("Status:");
        baseBox.add(statusBarLabel);

        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                frame.dispose();
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);

        loadAction2D();
    }

    Box makeControlBox() {
        Box controlBox = Box.createVerticalBox();

        controlBox.add(new JLabel("ActionName:"));
        actionNameCB = new JComboBox();
actionNameCB.setPreferredSize(new Dimension(50,30));
actionNameCB.setMaximumSize(new Dimension(30000,30));
        actionNameCB.addActionListener(this);
        controlBox.add(actionNameCB);

        controlBox.add(Box.createVerticalGlue());

        controlBox.add(new JLabel("***Comment***"));
        commentTextArea = new JTextArea(10,30);
        commentTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(commentTextArea);
sp.setPreferredSize(new Dimension(50,150));
sp.setMaximumSize(new Dimension(30000,150));
        controlBox.add(sp);

        controlBox.add(Box.createVerticalGlue());

        String buildTime = null;
        try {
            URL url = getClass().getClassLoader().getResource("buildTime.txt");
            InputStreamReader isr = new InputStreamReader(url.openStream(),"UTF-8");
            BufferedReader br = new BufferedReader(isr);
            buildTime = br.readLine();
        } catch (Exception e) {
e.printStackTrace();
            buildTime = "???";
        }
        controlBox.add(new JLabel("build time:"));
        controlBox.add(new JLabel("   "+buildTime));

        return controlBox;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == actionNameCB) {
            actionName = (String)actionNameCB.getSelectedItem();
if (actionName == null) {
System.out.println("gaha1");
return;
}
            System.out.println("actionName:"+actionName);
            repaint();
        } else if (ae.getSource() == urlTextField) {
            loadAction2D();
        } else if (ae.getSource() == refButton) {
            ref();
        } else if (ae.getSource() == consoleMenuItem) {
            consoleFrame.setVisible(true);
        } else if (ae.getSource() == clearConsoleButton) {
            consoleTextArea.setText("");
        } else if (ae.getSource() == proxyMenuItem) {
            proxyConfig();
        } else if (ae.getSource() == snapshotMenuItem) {
            try {
                File f = new File("snapshot.png");
                a2canvas.saveImage(f);
            } catch (Exception e) {
                System.out.println("A2Viewer:snapshot");
                e.printStackTrace();
            }
        } else if (ae.getSource() == backgroundMenuItem){
            setBackground();
        } else {
            System.out.append("gaha???");
        }
    }

    void loadAction2D() {
        statusBarLabel.setText("Status: Loading ... ");
        statusBarLabel.repaint();
        if (a2!=null)
            a2canvas.del(a2);
        String urlString = urlTextField.getText();
        try {
            URL url = new URL(urlString);
            a2 = A2Loader.load(url);
        } catch(Exception e) {
            System.out.println("A2Viewer.loadAction2D. error!");
            e.printStackTrace();
        }

        a2canvas.add(a2);
        actionNameCB.removeAllItems();
        String sss[] = a2.getActionNames();
        for (int i=0;i<sss.length;i++)
            actionNameCB.addItem(sss[i]);

        commentTextArea.setText(a2.getComment());

        a2canvas.resetCamera();

        statusBarLabel.setText("Status: Loading ... done.");
    }

    void repaint() {
        if (a2 == null)
            return;
        a2.change(actionName);
    }

    ProxyPanel proxyPanel = null;
    String proxyData[] = {"","","",""};
    void proxyConfig() {
        if (proxyPanel == null) {
            proxyPanel = new ProxyPanel();
            proxyData[0] = System.getProperty("proxyHost");
            proxyData[1] = System.getProperty("proxyPort");
            proxyData[2] = System.getProperty("ftpProxyHost");
            proxyData[3] = System.getProperty("ftpProxyPort");
        }
        proxyPanel.setData(proxyData);

        Object options[] = {"Ok","Cancel"};
        int result = JOptionPane.showOptionDialog(frame,proxyPanel,"proxy",
                                                  JOptionPane.DEFAULT_OPTION,
                                                  JOptionPane.INFORMATION_MESSAGE,
                                                  null,options,options[0]);
        if (result==0) {
            proxyData = proxyPanel.getData();
            if (!proxyData[0].equals("")) {
                System.getProperties().put("proxySet","true");
                System.getProperties().put("proxyHost",proxyData[0]);
                System.getProperties().put("proxyPort",proxyData[1]);
            } else {
                System.getProperties().put("proxySet","false");
                System.getProperties().put("proxyHost","");
                System.getProperties().put("proxyPort","");
            }
            if (!proxyData[2].equals("")) {
                System.getProperties().put("ftpProxySet","true");
                System.getProperties().put("ftpProxyHost",proxyData[2]);
                System.getProperties().put("ftpProxyPort",proxyData[3]);
            } else {
                System.getProperties().put("ftpProxySet","false");
                System.getProperties().put("ftpProxyHost","");
                System.getProperties().put("ftpProxyPort","");
            }
        }
    }

    class ProxyPanel extends JPanel {
        private static final long serialVersionUID = 1L;
        JTextField httpHostTF;
        JTextField httpPortTF;
        JTextField ftpHostTF;
        JTextField ftpPortTF;

        public ProxyPanel() {
            Box b0 = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            Box b2 = Box.createHorizontalBox();

            this.add(b0);
            b0.add(b1);
            b0.add(b2);

            b1.add(new JLabel("http: host"));
            httpHostTF = new JTextField(40);
            b1.add(httpHostTF);
            b1.add(new JLabel(" port "));
            httpPortTF = new JTextField(5);
            b1.add(httpPortTF);

            b2.add(new JLabel("ftp: host"));
            ftpHostTF = new JTextField(40);
            b2.add(ftpHostTF);
            b2.add(new JLabel(" port "));
            ftpPortTF = new JTextField(5);
            b2.add(ftpPortTF);
        }

        public void setData(String proxyData[]) {
            httpHostTF.setText(proxyData[0]);
            httpPortTF.setText(proxyData[1]);
            ftpHostTF.setText(proxyData[2]);
            ftpPortTF.setText(proxyData[3]);
        }

        public String[] getData() {
            String ret[] = new String[4];
            ret[0] = httpHostTF.getText();
            ret[1] = httpPortTF.getText();
            ret[2] = ftpHostTF.getText();
            ret[3] = ftpPortTF.getText();
            return ret;
        }
    }

    void ref() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(".");
        }
        int returnVal = fileChooser.showOpenDialog(frame);
        if(returnVal != JFileChooser.APPROVE_OPTION)
            return;

        File f = fileChooser.getSelectedFile();
        URL url = null;
        try{url = f.toURL();}catch(Exception e){;}
        if (url == null)
            return;
        urlTextField.setText(url.toExternalForm());
        loadAction2D();
    }
    void setBackground() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(".");
        }
        int returnVal = fileChooser.showOpenDialog(frame);
        if (returnVal != JFileChooser.APPROVE_OPTION)
            return;

        File f = fileChooser.getSelectedFile();
        URL url = null;
        try{url = f.toURL();}catch(Exception e){;}
        if (url == null)
            return;
        Action2D a = null;
        try{
            a = A2Loader.load(url);
        } catch(Exception e) {
            e.printStackTrace();
        }
        if (a!=null)
            a2canvas.setBackground(a);
    }

    public static void main(String args[]) {
        // A3ViewerかつLinuxのJava Web Startの時
        // セキュリティマネージャがExceptionを出す．
        // このA2Viewerでもとりあえずnullにしておく。
        System.setSecurityManager(null);
        A2Viewer v = new A2Viewer(args);
    }
}


/*

package net.sf.elm_ve.a2viewer;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;
import java.net.*;

public class A2ViewerBak implements ActionListener {
    JFrame frame;
    JTextField urlTextField;
    JPanel panel;
    JLabel label;
    JComboBox actionNameCB;
    JButton proxyButton;
    JLabel statusBarLabel;

    Action2D a2;
    String actionName;

    public A2ViewerBak(String args[]) {
        A23.initA23();
        frame = new JFrame("A2Viewer");
        Box baseBox = Box.createVerticalBox();
        frame.getContentPane().add(baseBox);

        Box box1 = Box.createHorizontalBox();
        baseBox.add(box1);
        box1.add(new JLabel("URL:"));
        urlTextField = new JTextField();
        try {
            File f = null;
            if ((args!=null)&&(args.length==2)&&(args[0].equals("-open")))
                f = new File(args[1]);
            else
                f = new File(args[0]);
            URL url = f.toURL();
            urlTextField.setText(url.toExternalForm());
        } catch(Exception e) {
            urlTextField.setText("x-res:/ac/hiu/j314/a23/resources/error.a2");
        }
        urlTextField.addActionListener(this);
urlTextField.setMaximumSize(new Dimension(3000,30));
        box1.add(urlTextField);

        Box box2 = Box.createHorizontalBox();
        baseBox.add(box2);

        panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setPreferredSize(new Dimension(300,300));
        box2.add(panel);

        label = new JLabel();
        panel.add(label,"Center");

        Box controlBox = makeControlBox();
        box2.add(controlBox);

        statusBarLabel = new JLabel("Status:");
        baseBox.add(statusBarLabel);

        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                frame.dispose();
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);

        loadAction2D();
    }

    Box makeControlBox() {
        Box controlBox = Box.createVerticalBox();

        Box boxA = Box.createHorizontalBox();
        controlBox.add(boxA);
        boxA.add(new JLabel("ActionName"));
        actionNameCB = new JComboBox();
//actionNameCB.setPreferredSize(new Dimension(100,30));
actionNameCB.setMaximumSize(new Dimension(3000,30));
        actionNameCB.addActionListener(this);
        boxA.add(actionNameCB);

        proxyButton = new JButton("Proxy Configuration");
        proxyButton.addActionListener(this);
        controlBox.add(proxyButton);

        controlBox.add(Box.createVerticalGlue());

        return controlBox;
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == actionNameCB) {
            actionName = (String)actionNameCB.getSelectedItem();
if (actionName == null) {
System.out.println("gaha1");
return;
}
            System.out.println("actionName:"+actionName);
            repaint();
        } else if (ae.getSource() == urlTextField) {
            loadAction2D();
        } else if (ae.getSource() == proxyButton) {
            proxyConfig();
        }
    }

    void loadAction2D() {
        statusBarLabel.setText("Status: Loading ... ");
        statusBarLabel.repaint();
        String urlString = urlTextField.getText();
        a2 = A2Loader.load(urlString);

        actionNameCB.removeAllItems();
        String sss[] = a2.getActionNames();
        for (int i=0;i<sss.length;i++) {
            actionNameCB.addItem(sss[i]);
        }

        ImageIcon ii = new ImageIcon(a2.getImage(actionName));
        label.setIcon(ii);
    }

    String oldActionName = null;
    void repaint() {
        if (a2 == null)
            return;
        if ((oldActionName == null)||(!oldActionName.equals(actionName))) {
            ImageIcon ii = new ImageIcon(a2.getImage(actionName));
            label.setIcon(ii);
            oldActionName = actionName;
        }
    }

    ProxyPanel proxyPanel = null;
    String proxyData[] = {"","","",""};
    void proxyConfig() {
        if (proxyPanel == null) {
            proxyPanel = new ProxyPanel();
            proxyData[0] = System.getProperty("proxyHost");
            proxyData[1] = System.getProperty("proxyPort");
            proxyData[2] = System.getProperty("ftpProxyHost");
            proxyData[3] = System.getProperty("ftpProxyPort");
        }
        proxyPanel.setData(proxyData);

        Object options[] = {"Ok","Cancel"};
        int result = JOptionPane.showOptionDialog(frame,proxyPanel,"proxy",
                                                  JOptionPane.DEFAULT_OPTION,
                                                  JOptionPane.INFORMATION_MESSAGE,
                                                  null,options,options[0]);
        if (result==0) {
            proxyData = proxyPanel.getData();
            if (!proxyData[0].equals("")) {
                A23.setHttpProxy(true,proxyData[0],proxyData[1]);
            } else {
                A23.setHttpProxy(false,"","");
            }
            if (!proxyData[2].equals("")) {
                A23.setFtpProxy(true,proxyData[2],proxyData[3]);
            } else {
                A23.setFtpProxy(false,"","");
            }
        }
    }

    class ProxyPanel extends JPanel {
        private static final long serialVersionUID = 1L;
        JTextField httpHostTF;
        JTextField httpPortTF;
        JTextField ftpHostTF;
        JTextField ftpPortTF;

        public ProxyPanel() {
            Box b0 = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            Box b2 = Box.createHorizontalBox();

            this.add(b0);
            b0.add(b1);
            b0.add(b2);

            b1.add(new JLabel("http: host"));
            httpHostTF = new JTextField(40);
            b1.add(httpHostTF);
            b1.add(new JLabel(" port "));
            httpPortTF = new JTextField(5);
            b1.add(httpPortTF);

            b2.add(new JLabel("ftp: host"));
            ftpHostTF = new JTextField(40);
            b2.add(ftpHostTF);
            b2.add(new JLabel(" port "));
            ftpPortTF = new JTextField(5);
            b2.add(ftpPortTF);
        }

        public void setData(String proxyData[]) {
            httpHostTF.setText(proxyData[0]);
            httpPortTF.setText(proxyData[1]);
            ftpHostTF.setText(proxyData[2]);
            ftpPortTF.setText(proxyData[3]);
        }

        public String[] getData() {
            String ret[] = new String[4];
            ret[0] = httpHostTF.getText();
            ret[1] = httpPortTF.getText();
            ret[2] = ftpHostTF.getText();
            ret[3] = ftpPortTF.getText();
            return ret;
        }
    }

    public static void main(String args[]) {
        A2ViewerBak v = new A2ViewerBak(args);
    }
}



*/
