/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a2;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.Serializable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a2.A2Object;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class Action2D
extends A2Object {
    static Toolkit toolkit = null;
    static Image errImg = null;
    int actionCount = 0;
    Hashtable<String, Image> nameHash;
    String[] nameArray;
    double x;
    double y;
    int actionNo;

    Action2D(String a2File, boolean interpolating) throws Exception {
        super(interpolating);
        Hashtable<String, Serializable[]> actionHash = new Hashtable<String, Serializable[]>();
        this.prepareActionHashtable(a2File, actionHash);
        this.init(a2File, actionHash);
    }

    Action2D(URL url, boolean interpolating) throws Exception {
        super(interpolating);
        Hashtable<String, Serializable[]> actionHash = new Hashtable<String, Serializable[]>();
        this.prepareActionHashtable(url.toExternalForm(), actionHash);
        this.init(url, actionHash);
    }

    static boolean isInitialized() {
        return toolkit != null && errImg != null;
    }

    static void initAction2D() {
        toolkit = Toolkit.getDefaultToolkit();
        URL url = A23.getClassLoader().getResource("jp/sourceforge/acerola3d/resources/error.gif");
        errImg = toolkit.getImage(url);
    }

    void prepareActionHashtable(String a2File, Hashtable<String, Serializable[]> actionHash) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document d = db.parse("x-rzip:" + a2File + "!/CATALOG.XML");
        NodeList nl = d.getChildNodes();
        Node n = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals("a2")) continue;
            n = nl.item(i);
            break;
        }
        int actionCount = 0;
        nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals("a")) continue;
            Node nn = nl.item(i);
            NamedNodeMap nnm = nn.getAttributes();
            Attr aaa = (Attr)nnm.getNamedItem("an");
            String av = aaa.getValue();
            av = av.trim();
            NodeList nl2 = nn.getChildNodes();
            String ttt = null;
            for (int j = 0; j < nl2.getLength(); ++j) {
                if (!(nl2.item(j) instanceof Text)) continue;
                ttt = ((Text)nl2.item(j)).getData();
                ttt = ttt.trim();
                break;
            }
            Serializable[] seri = new Serializable[]{ttt, new Integer(actionCount)};
            actionHash.put(av, seri);
            ++actionCount;
        }
    }

    void init(String a2File, Hashtable<String, Serializable[]> actionHash) throws Exception {
        this.nameHash = new Hashtable();
        Set<String> set = actionHash.keySet();
        this.nameArray = new String[set.size()];
        for (String k : set) {
            Serializable[] seri = actionHash.get(k);
            String fn = (String)((Object)seri[0]);
            int j = (Integer)seri[1];
            this.nameArray[j] = k;
            Image i = toolkit.createImage(new URL("x-rzip:" + a2File + "!/" + fn));
            this.nameHash.put(k, i);
        }
    }

    void init(URL url, Hashtable<String, Serializable[]> actionHash) throws Exception {
        String a2File = url.toExternalForm();
        this.nameHash = new Hashtable();
        Set<String> set = actionHash.keySet();
        this.nameArray = new String[set.size()];
        for (String k : set) {
            Serializable[] seri = actionHash.get(k);
            String fn = (String)((Object)seri[0]);
            int j = (Integer)seri[1];
            this.nameArray[j] = k;
            Image i = toolkit.createImage(new URL("x-rzip:" + a2File + "!/" + fn));
            this.nameHash.put(k, i);
        }
    }

    public Image getImage(String actionName) {
        if (actionName == null) {
            return errImg;
        }
        Image i = this.nameHash.get(actionName);
        if (i == null) {
            System.out.println("Action2D.getImage(). Illegal ActionName.");
            return errImg;
        }
        return i;
    }

    public Image getImage(int actionNumber) {
        String actionName = this.getActionName(actionNumber);
        return this.getImage(actionName);
    }

    public Image getImage(Serializable s) {
        if (s instanceof String) {
            return this.getImage((String)((Object)s));
        }
        if (s instanceof Integer) {
            return this.getImage((Integer)s);
        }
        System.out.println("Action2D.getImage(). Illegal ActionID.");
        return errImg;
    }

    public int getActionCount() {
        return this.nameArray.length;
    }

    public String[] getActionNames() {
        String[] ret = new String[this.nameArray.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.nameArray[i];
        }
        return ret;
    }

    public String getActionName(int i) {
        try {
            return this.nameArray[i];
        }
        catch (Exception e) {
            System.out.println("Action2D.getActionName(). Illegal ActionNumber.");
            return null;
        }
    }

    public String getComment() {
        return null;
    }

    @Override
    public void paint(Graphics g) {
        String an = this.getActionName(this.actionNo);
        Image i = this.nameHash.get(an);
        g.drawImage(i, 0, 0, this.canvas);
        if (!this.interpolating) {
            this.needRepaint = false;
        }
    }

    public void change(int actionNo) {
        this.change((Serializable)((Object)this.getActionName(actionNo)));
    }

    public void change(Serializable actionID) {
        if (actionID instanceof Integer) {
            this.actionNo = (Integer)actionID;
        } else if (actionID instanceof String) {
            for (int i = 0; i < this.nameArray.length; ++i) {
                if (!this.nameArray[i].equals(actionID)) continue;
                this.actionNo = i;
                break;
            }
        }
        this.repaint();
    }
}

