package jp.sourceforge.acerola3d.a3editor;

import jp.sourceforge.acerola3d.a3.catalog.*;
import java.io.*;
import java.math.BigInteger;
import java.util.ArrayList;

import javax.xml.bind.*;

class Catalog {
    A3eFileManager fileManager;
    File file;
    A3 a3;
    Catalog(File f,A3eFileManager fm) throws Exception {
        file = f;
        fileManager = fm;
        JAXBContext jc = JAXBContext.newInstance("jp.sourceforge.acerola3d.a3.catalog");
        Unmarshaller u = jc.createUnmarshaller();
        FileInputStream fis = new FileInputStream(file);
        a3 = (A3)u.unmarshal(fis);
        fis.close();
    }
    Catalog(A3eFileManager fm) {
        fileManager = fm;
        a3 = new A3();
        Profile profile = new Profile();
        profile.setUri("http://acerola3d.sourceforge.jp/a3profile/RootProfile");
        a3.getProfile().add(profile);
        A a = new A();
        a.setAn("enter action name");
        a3.getA().add(a);
    }
    void save() throws Exception {
        JAXBContext jc = JAXBContext.newInstance("jp.sourceforge.acerola3d.a3.catalog");
        Marshaller m = jc.createMarshaller();
        FileOutputStream fos = new FileOutputStream(file);
        m.marshal(a3,fos);
        fos.close();
    }
    A3eMetadataGUI getMetadataGUI() {
        return new A3eMetadataGUI(this,fileManager);
    }
    //----------------------------------------
    String[] getProfiles() {
        ArrayList<String> al = new ArrayList<String>();
        for (Profile p:a3.getProfile()) {
            al.add(p.getUri());
        }
        return al.toArray(new String[0]);
    }
    String[] getTags() {
        ArrayList<String> al = new ArrayList<String>();
        for (Tag t:a3.getTag()) {
            al.add(t.getName());
        }
        return al.toArray(new String[0]);
    }
    A3eFile[] getThumbnails() {
        ArrayList<A3eFile> al = new ArrayList<A3eFile>();
        for (Thumbnail t:a3.getThumbnail()) {
            A3eFile f = fileManager.getA3eFileFromPath(t.getSrc());
            if (f!=null)
                al.add(f);
        }
        if (al.size()==0)
            al.add(A3eFile.noneFile);
        return al.toArray(new A3eFile[0]);
    }
    A3eFile getHtml() {
        Htmlfile hf = a3.getHtmlfile();
        if (hf==null)
            return A3eFile.noneFile;
        A3eFile f = fileManager.getA3eFileFromPath(hf.getSrc());
        if (f==null)
            return A3eFile.noneFile;
        else
            return f;
    }
    String[] getActionNames() {
        ArrayList<String> al = new ArrayList<String>();
        for (A a:a3.getA()) {
            al.add(a.getAn());
        }
        return al.toArray(new String[0]);
    }
    String getHaltActionName() {
        BigInteger abi = a3.getHaltActionNo();
        int ai = abi.intValue();
        try {
            A a = a3.getA().get(ai);
            return a.getAn();
        }catch(IndexOutOfBoundsException e) {
            return "[none]";
        }
    }
    String getWalkActionName() {
        BigInteger abi = a3.getWalkActionNo();
        int ai = abi.intValue();
        try {
            A a = a3.getA().get(ai);
            return a.getAn();
        }catch(IndexOutOfBoundsException e) {
            return "[none]";
        }
    }
    String getRunActionName() {
        BigInteger abi = a3.getRunActionNo();
        int ai = abi.intValue();
        try {
            A a = a3.getA().get(ai);
            return a.getAn();
        }catch(IndexOutOfBoundsException e) {
            return "[none]";
        }
    }
    double getMinWalkSpeed() {
        return a3.getMinWalkSpeed();
    }
    double getMinRunSpeed() {
        return a3.getMinRunSpeed();
    }
    boolean isBillboard() {
        return a3.isBillboard();
    }
    void setProfiles(String uris[]) {
        a3.getProfile().clear();
        for (String uri:uris) {
            Profile p = new Profile();
            p.setUri(uri);
            a3.getProfile().add(p);
        }
    }
    void setComment(String s) {
        a3.setC(s);
    }
    void setTags(String tags[]) {
        a3.getTag().clear();
        for (String tag:tags) {
            Tag t = new Tag();
            t.setName(tag);
            a3.getTag().add(t);
        }
    }
    void setThumbnail(A3eFile file) {
        a3.getThumbnail().clear();
        if (file!=A3eFile.noneFile) {
            Thumbnail t = new Thumbnail();
            t.setSrc(file.getPath());
        }
    }
    void setHtmlfile(A3eFile file) {
        if (file==A3eFile.noneFile) {
            a3.setHtmlfile(null);
        } else {
            Htmlfile h = new Htmlfile();
            h.setSrc(file.getPath());
            a3.setHtmlfile(h);
        }
    }
    void setHaltAction(String an) {
        int i = 0;
        for (A a:a3.getA()) {
            if (a.getAn().equals(an)) {
                a3.setHaltActionNo(new BigInteger(""+i));
                return;
            }
            i++;
        }
        a3.setHaltActionNo(new BigInteger(""+0));
    }
    void setWalkAction(String an) {
        int i = 0;
        for (A a:a3.getA()) {
            if (a.getAn().equals(an)) {
                a3.setWalkActionNo(new BigInteger(""+i));
                return;
            }
            i++;
        }
        a3.setHaltActionNo(new BigInteger(""+0));
    }
    void setRunAction(String an) {
        int i = 0;
        for (A a:a3.getA()) {
            if (a.getAn().equals(an)) {
                a3.setRunActionNo(new BigInteger(""+i));
                return;
            }
            i++;
        }
        a3.setHaltActionNo(new BigInteger(""+0));
    }
    void setMinWalkSpeed(double d) {
        a3.setMinWalkSpeed(d);
    }
    void setMinRunSpeed(double d) {
        a3.setMinRunSpeed(d);
    }
    void setBillboard(boolean b) {
        a3.setBillboard(b);
    }
}
