package jp.sourceforge.acerola3d.a3viewer;

import javax.swing.*;
import java.io.File;
import java.net.URL;

public class A3Viewer {
    public static void main(String args[]) {
        // セキュリティマネージャが、
        // LinuxのJava Web Startの時だけ
        // Exceptionを出すので、とりあえずnullに
        // しておく。
        System.setSecurityManager(null);
        jp.sourceforge.acerola3d.A23.initA23();
        final String argsCopy[] = args;
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                final JFrame frame = new JFrame("A3Viewer");
                frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                URL url = null;
                try {
                    if ((argsCopy.length==2)&&(argsCopy[0].equals("-open"))) {
                        if (argsCopy[1].startsWith("x-res://") ||
                            argsCopy[1].startsWith("http://") ||
                            argsCopy[1].startsWith("https://") ||
                            argsCopy[1].startsWith("ftp://")) {
                            url = new URL(argsCopy[1]);
                        } else {
                            File f  = new File(argsCopy[1]);
                            url = f.toURI().toURL();
                        }
                    } else if ((argsCopy.length==1)&&(argsCopy[0]!=null)) {
                        if (argsCopy[0].startsWith("x-res://") ||
                            argsCopy[0].startsWith("http://") ||
                            argsCopy[0].startsWith("https://") ||
                            argsCopy[0].startsWith("ftp://")) {
                            url = new URL(argsCopy[0]);
                        } else {
                            File f  = new File(argsCopy[0]);
                            url = f.toURI().toURL();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                A3Panel p = new A3Panel(frame,url);
                frame.add(p);

                frame.setTransferHandler(new A3TransferHandler(p));

                frame.setSize(700,500);
                frame.setVisible(true);
            }
        });
    }
}
