//---------------------------------------------------------------------------
//		ver.1.0		2004/03		author : Endou
//---------------------------------------------------------------------------
#ifdef		HAVE_CONFIG_H
#include	"config.h"
#endif
#include	"acpplib.h"
//---------------------------------------------------------------------------
char	tohex(char);				//change ASCII to hex
//---------------------------------------------------------------------------
void	print_v(map <int,string> *pData,const char *pName)
//print all data for debug
//parameter		*pData : data to be printed
//return		none
{
	map <int,string> :: iterator it;

	if(pName != NULL) {
		for(it=pData->begin();it!=pData->end();it++) {
			cout << "<B>" << pName << "[" << it->first << "]</B> = " << it->second << "<BR>" << endl;
		}
	} else {
		for(it=pData->begin();it!=pData->end();it++) {
			cout << "<B>" << it->first << "</B> = " << it->second << "<BR>" << endl;
		}
	}
}
//---------------------------------------------------------------------------
void	print_v(map <string,string> *pData,const char *pName)
//print all data for debug
//parameter		*pData : data to be printed
//return		none
{
	map <string,string> :: iterator it;

	if(pName != NULL) {
		for(it=pData->begin();it!=pData->end();it++) {
			cout << "<B>" << pName << "[" << it->first << "]</B> = " << it->second << "<BR>" << endl;
		}
	} else {
		for(it=pData->begin();it!=pData->end();it++) {
			cout << "<B>" << it->first << "</B> = " << it->second << "<BR>" << endl;
		}
	}
}
//---------------------------------------------------------------------------
void	print_v(vector <string> *pData,const char *pName)
//print all data for debug
//parameter		*pData : data to be printed
//				*pName : data name
//return		none
{
	int		i,n;

	n = pData->size();
	if(pName != NULL) {
		for(i=0;i<n;i++) {
			cout << "<B>" << pName << "[" << i << "]</B> = " << (*pData)[i] << "<BR>" << endl;
		}
	} else {
		for(i=0;i<n;i++) {
			cout << "<B>[" << i << "]</B> = " << (*pData)[i] << "<BR>" << endl;
		}
	}
}
//---------------------------------------------------------------------------
int		explode(const char *pStr,vector <string> *pToken,char pDelim,int pLimit)
//separate string by delimiter character
//parameters	*pStr : original string
//				*pToken : separated resuld
//				pDelim : special charactor ie. delimiter
//				pLimit : max token
//return		numberof token;
{
	const char	*p;
	string	s;
	int		c;

	pToken->clear();
	if(pLimit == 1) {
		pToken->push_back(pStr);
		return(1);
	}

	s = "";
	c = 0;
	for(p=pStr;*p!='\0';p++) {
		if(*p == pDelim) {
			if(!s.empty()) {
				pToken->push_back(s);
				c++;
			}
			if(c == pLimit - 1) {
				s = ++p;
				break;
			}
			s = "";
		} else {
			s += *p;
		}
	}
	if(!s.empty()) pToken->push_back(s);
	return(pToken->size());
}
//---------------------------------------------------------------------------
string	implode(vector <string> *pToken,string pGlue)
//combine each token
//parameter		*pToken : source strings
//				pGlue   : combination charactor
//return		combined string
{
	string	str;
	int		i,n;

	str = "";
	n = pToken->size();
	if(n == 0) return(str);
	str = (*pToken)[0];
	for(i=1;i<n;i++) {
		str += pGlue + (*pToken)[i];
	}
	return(str);
}
//---------------------------------------------------------------------------
string	trim(string *pStr)
//delete white space top and end of string
//parameter		*pStr : source string
//return		string
{
	int		posl,posr,n;
	string	str;

	str = *pStr;
	n = str.length();
	if(n == 0) return(str);

	posl = str.find_first_not_of(" \t\n\r");
	posr = str.find_last_not_of(" \t\n\r");

	if(posl == posr) {
		str = "";
		return(str);
	}
	str.erase(posr+1,n-posr);
	str.erase(0,posl);
	return(str);
}
//---------------------------------------------------------------------------
string	urlencode(const char *pStr)
//url encode
//parameter		*pStr : source string
//return		encoded string
{
	const char	*p;
	string	str;
	unsigned char	h,l;

	str = "";
	for(p=pStr;*p!=0;p++) {
		if(*p == ' ') {
			str += '+';
		} else {
			if(isalnum(*p) || *p == '*' || *p == '-' || *p == '.' || *p == '@' || *p == '_') {
				str += *p;
			} else {
				h = l = *p;
				h = h >> 4;
				h = (h < 10) ? h + '0' : h + 'A' - 10;
				l = l & 0x0f;
				l = (l < 10) ? l + '0' : l + 'A' - 10;
				str += "%";
				str += h;
				str += l;
			}
		}
	}
	return(str);
}
//---------------------------------------------------------------------------
char	tohex(char gC)
//change ASCII to hex
//parameters	gC : ASCII  '0'-'9'A'A'-'Z'
//return		hex value
{
	gC = toupper(gC);

	if((gC >= 'A') && (gC <= 'F'))	return(gC - 'A' + 10);
	if((gC >= '0') && (gC <= '9'))	return(gC - '0');
	return(0);
}
//---------------------------------------------------------------------------
string	urldecode(const char *pStr)
//url decode
//parameters	pStr : source string
//return		decoded string
{
	string	dst;
	const char	*str;
	char	ch;

	str = pStr;
	dst  = "";

	while(*str != '\0') {
		if(*str == '+') {
			dst += ' ';
		} else {
			if(*str == '%') {
				str++;
				ch = tohex(*str);
				ch = ch << 4;
				str++;
				ch = ch + tohex(*str);
				dst += ch;
			}else{
				dst +=  *str;
			}
		}
		str++;
	}

	return(dst);
}
//---------------------------------------------------------------------------
