//---------------------------------------------------------------------------
#include "unit001.h"
int		gErrorNo;		//error code
//---------------------------------------------------------------------------
void	PreProcess(string pSrcName,string pDstName)
//preprocessor execute
//parameter		pSrcName : source file name.  ie. gSrcFiles[i]
//				pDstName : destin file name.  ie. gSrcFiles[i] + kTmpSfx
//return		none
{
	FILE		*fp;
	string		error;

	fp = fopen(pSrcName.c_str(),"r");
	if(fp == NULL) {
		gErrorNo = 1;
		error = pSrcName + ": acpp error (PreProcess): can not open";
		throw(error);
	}

	gSrcFileName = pSrcName;
	gGiven[gSrcFileName].clear();	//clear parameters
	gHeader[gSrcFileName].clear();
	gHead[gSrcFileName].clear();
	gPragma[gSrcFileName].clear();
	gConfFile[gSrcFileName].clear();

	gOut.open(pDstName.c_str());
	if(! gOut) {
		fclose(fp);
		gErrorNo = 1;
		error = pDstName + ": acpp error (PreProcess): can not open temp file";
		throw(error);
	}

	gOut << "#line 0 \"" << gSrcFileName << "\"" << endl;
	LexicalAnalize(fp);			//lexical scanner = pre process

	fclose(fp);
	gOut.close();
}
//---------------------------------------------------------------------------
int		ExecCmdLine()
//execute command line. ie. compile & link
//parameter		none
//return		none
{
	string	error;
	int		ret;

	ret = system(gCmdLine.c_str());
	if(ret != 0) {
		gErrorNo = WEXITSTATUS(ret);
		error = "acpp error (ExecCmdLine) : " + gCmdLine;
		throw(error);
	}

	return(ret);
}
//---------------------------------------------------------------------------
string	Suffix(string pFileName)
//split suffix from string
//parameter		pFileName : source string
//return		suffix
{
	string			str;
	unsigned int	pos;

	str = pFileName;
	pos = str.rfind(".");
	if(pos == string::npos) str = "";
	 else str.erase(0,pos);
	return(str);
}
//---------------------------------------------------------------------------
int		explode(const char *pStr,vector <string> *pToken,char pDelim,int pLimit)
//separate string by delimiter character
//parameters	*pStr : original string
//				*pToken : separated resuld
//				*pChar : special charactor ie. delimiter
//				pLimit : max token
//return		numberof token;
{
	const char	*p;
	string	s;
	int		c;

	pToken->clear();
	if(pLimit == 1) {
		pToken->push_back(pStr);
		return(1);
	}

	s = "";
	c = 0;
	for(p=pStr;*p!='\0';p++) {
		if(*p == pDelim) {
			if(!s.empty()) {
				pToken->push_back(s);
				c++;
			}
			if(c == pLimit - 1) {
				s = ++p;
				break;
			}
			s = "";
		} else {
			s += *p;
		}
	}
	if(!s.empty()) pToken->push_back(s);
	return(pToken->size());
}
//---------------------------------------------------------------------------
string	implode(vector <string> *pToken,string pGlue)
//combine each token
//parameter		*pToken : source strings
//				pGlue   : combination charactor
//return		combined string
{
	string	str;
	int		i,n;

	str = "";
	n = pToken->size();
	if(n == 0) return(str);
	str = (*pToken)[0];
	for(i=1;i<n;i++) {
		str += pGlue + (*pToken)[i];
	}
	return(str);
}
//---------------------------------------------------------------------------
string	trim(string *pStr)
//delete white space top and end of string
//parameter		*pStr : source string
//return		string
{
	int		posl,posr,n;
	string	str;

	str = *pStr;
	n = str.length();
	if(n == 0) return(str);

	for(posl=0;posl<n;posl++) {
		if(str[posl] != ' ' && str[posl] != '\t' && str[posl] != '\n' && str[posl] != '\r') break;
	}

	for(posr=n-1;posr>=0;posr--) {
		if(str[posr] != ' ' && str[posr] != '\t' && str[posr] != '\n' && str[posr] != '\r') break;
	}

	if(posl == posr) {
		str = "";
		return(str);
	}
	str.erase(posr+1,n-posr);
	str.erase(0,posl);
	return(str);
}
//---------------------------------------------------------------------------
void	DeleteTmp()
//delete temp source file and temp include file
//parameter		none
//return		none
{
	int		i,n;
	set		<string> :: iterator it;
	string	str;

	n = gSrcFiles.size();
	for(i=0;i<n;i++) {
		str = gSrcFiles[i] + kTmpSfx;
		if(gVisibleFlag) cout << "  delete file   : " << str << endl;
		remove(str.c_str());
	}
	for(it=gIncFile.begin();it!=gIncFile.end();it++) {
		str = *it + kIncSfx;
		if(gVisibleFlag) cout << "  delete file   : " << str << endl;
		remove(str.c_str());
	}
}
//---------------------------------------------------------------------------
string	escape_encode(const char *pStr)
//escape strings. ie (TAB)->\t (CR)->\n (LF)->\r (\)->\\ (")->\"
//parameters	*pStr : source strings
//return		escaped string
{
	const char	*p;
	string	s;

	s = "";
	p = pStr;
	while(*p) {
		switch(*p) {
			case '\t':	s += "\\t";break;
			case '\n':	s += "\\n";break;
			case '\r':	s += "\\r";break;
			case '\\':	s += "\\\\";break;
			case '"':	s += "\\\"";break;
			default:	s += *p;break;
		}
		p++;
	}
	return(s);
}
//---------------------------------------------------------------------------
