/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.bkrutil;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerCmdStatusEvent;
import com.sun.messaging.jmq.admin.apps.console.event.BrokerErrorEvent;
import com.sun.messaging.jmq.admin.bkrutil.AdminMQAddress;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminException;
import com.sun.messaging.jmq.admin.bkrutil.MessageAckThread;
import com.sun.messaging.jmq.admin.bkrutil.SSLAdminMQAddress;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.io.DestMetricsCounters;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.MetricCounters;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.admin.DurableInfo;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import com.sun.messaging.jms.management.server.BrokerClusterInfo;
import java.io.EOFException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class BrokerAdmin
implements ExceptionListener {
    public static final String DEFAULT_ADMIN_USERNAME = "admin";
    public static final String DEFAULT_ADMIN_PASSWD = "admin";
    public static long defaultTimeout = 10000L;
    public static int defaultNumRetries = 5;
    public static final int RECONNECT_RETRIES = 5;
    public static final long RECONNECT_DELAY = 5000L;
    private static boolean debug = false;
    private String key = null;
    private String username;
    private String passwd;
    private long timeout;
    private int numRetries;
    private QueueConnectionFactory qcf;
    private QueueConnection connection;
    private QueueSession session;
    private Queue requestQueue;
    private TemporaryQueue replyQueue;
    private QueueSender sender;
    protected QueueReceiver receiver;
    private MQAddress address = null;
    private static final String[] savedQCFProperties = new String[]{"imqBrokerHostName", "imqBrokerHostPort"};
    private boolean isConnected = false;
    private boolean adminKeyUsed = false;
    private boolean sslTransportUsed = false;
    private boolean isInitiator = false;
    private boolean isReconnect = false;
    private Vector eListeners = new Vector();
    private MessageAckThread msgAckThread = null;
    private boolean busy = false;
    private BrokerCmdStatusEvent statusEvent = null;
    private Object aObj = null;

    public BrokerAdmin(String string, int n) throws BrokerAdminException {
        this(string, n, null, null, -1L, false, -1, -1L);
    }

    public BrokerAdmin(String string, int n, String string2, String string3) throws BrokerAdminException {
        this(string, n, string2, string3, -1L, false, -1, -1L);
    }

    public BrokerAdmin(String string, int n, String string2, String string3, int n2) throws BrokerAdminException {
        this(string, n, string2, string3, n2, false, -1, -1L);
    }

    public BrokerAdmin(String string, String string2, String string3, int n, boolean bl) throws BrokerAdminException {
        this(string, string2, string3, n, false, -1, -1L, bl);
    }

    public BrokerAdmin(String string, int n, String string2, String string3, long l, boolean bl, int n2, long l2) throws BrokerAdminException {
        Properties properties = new Properties();
        if (string != null) {
            properties.setProperty("imqBrokerHostName", string);
        }
        if (n > 0) {
            properties.setProperty("imqBrokerHostPort", String.valueOf(n));
        }
        if (bl) {
            properties.setProperty("imqReconnectEnabled", String.valueOf(bl));
            properties.setProperty("imqReconnectAttempts", String.valueOf(n2));
            properties.setProperty("imqReconnectInterval", String.valueOf(l2));
        }
        this.timeout = l >= 0L ? l : defaultTimeout;
        this.numRetries = defaultNumRetries;
        this.username = string2;
        this.passwd = string3;
        this.createFactory(properties);
    }

    public BrokerAdmin(String string, String string2, String string3, long l, boolean bl, int n, long l2, boolean bl2) throws BrokerAdminException {
        Properties properties = new Properties();
        if (string == null) {
            string = "";
        }
        try {
            this.address = bl2 ? SSLAdminMQAddress.createAddress(string) : AdminMQAddress.createAddress(string);
        }
        catch (Exception exception) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(16);
            brokerAdminException.setBrokerAddress(string);
            brokerAdminException.setLinkedException(exception);
            throw brokerAdminException;
        }
        properties.setProperty("imqAddressList", this.address.toString());
        if (bl) {
            properties.setProperty("imqReconnectEnabled", String.valueOf(bl));
            properties.setProperty("imqReconnectAttempts", String.valueOf(n));
            properties.setProperty("imqReconnectInterval", String.valueOf(l2));
        }
        this.timeout = l >= 0L ? l : defaultTimeout;
        this.numRetries = defaultNumRetries;
        this.username = string2;
        this.passwd = string3;
        this.createFactory(properties);
    }

    public BrokerAdmin(Properties properties, String string, String string2, long l) throws BrokerAdminException {
        this.timeout = l >= 0L ? l : defaultTimeout;
        this.numRetries = defaultNumRetries;
        this.username = string;
        this.passwd = string2;
        this.createFactory(properties);
    }

    public void setBrokerHost(String string) throws BrokerAdminException {
        try {
            this.setFactoryAttr("imqBrokerHostName", string);
        }
        catch (JMSException jMSException) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(9);
            brokerAdminException.setBadValue(string);
            brokerAdminException.setLinkedException((Exception)((Object)jMSException));
            throw brokerAdminException;
        }
    }

    public String getBrokerAddress() {
        if (this.address != null) {
            return this.address.toString();
        }
        return this.getFactoryAttr("imqAddressList");
    }

    public String getBrokerHost() {
        if (this.address != null) {
            return this.address.getHostName();
        }
        return this.getFactoryAttr("imqBrokerHostName");
    }

    public void setBrokerPort(String string) throws BrokerAdminException {
        try {
            this.setFactoryAttr("imqBrokerHostPort", string);
        }
        catch (JMSException jMSException) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(10);
            brokerAdminException.setBadValue(string);
            brokerAdminException.setLinkedException((Exception)((Object)jMSException));
            throw brokerAdminException;
        }
    }

    public String getBrokerPort() {
        if (this.address != null) {
            return new Integer(this.address.getPort()).toString();
        }
        return this.getFactoryAttr("imqBrokerHostPort");
    }

    public static void setDefaultTimeout(long l) {
        defaultTimeout = l;
        if (debug) {
            Globals.stdOutPrintln("BrokerAdmin defaultTimeout set to: " + defaultTimeout);
        }
    }

    public static long getDefaultTimeout() {
        return defaultTimeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public static void setDefaultNumRetries(int n) {
        defaultNumRetries = n;
        if (debug) {
            Globals.stdOutPrintln("BrokerAdmin defaultNumRetries set to: " + defaultNumRetries);
        }
    }

    public static long getDefaultNumRetries() {
        return defaultNumRetries;
    }

    public void setNumRetries(int n) {
        this.numRetries = n;
        if (debug) {
            Globals.stdOutPrintln("BrokerAdmin num retries set to: " + this.numRetries);
        }
    }

    public void setUserName(String string) {
        this.username = string;
    }

    public String getUserName() {
        return this.username;
    }

    public void setPassword(String string) {
        this.passwd = string;
    }

    public String getPassword() {
        return this.passwd;
    }

    public void setBusy(boolean bl) {
        this.busy = bl;
        if (debug) {
            Globals.stdOutPrintln("***** BrokerAdmin.setBusy(): " + bl);
        }
        if (!bl && this.msgAckThread != null) {
            this.msgAckThread = null;
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setAdminKeyUsed(boolean bl) {
        this.adminKeyUsed = bl;
    }

    public boolean getAdminKeyUsed() {
        return this.adminKeyUsed;
    }

    public void setSSLTransportUsed(boolean bl) {
        this.sslTransportUsed = bl;
    }

    public boolean getSSLTransportUsed() {
        return this.sslTransportUsed;
    }

    public void setInitiator(boolean bl) {
        this.isInitiator = bl;
    }

    public boolean isInitiator() {
        return this.isInitiator;
    }

    public void setReconnect(boolean bl) {
        this.isReconnect = bl;
    }

    public boolean isReconnect() {
        return this.isReconnect;
    }

    public Properties getBrokerAttrs() {
        Properties properties = new Properties();
        if (this.qcf == null) {
            return properties;
        }
        for (int i = 0; i < savedQCFProperties.length; ++i) {
            String string = savedQCFProperties[i];
            String string2 = this.getFactoryAttr(string);
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public void connect() throws BrokerAdminException {
        this.connect(null, null, false);
    }

    public void connect(String string, String string2) throws BrokerAdminException {
        this.connect(string, string2, true);
    }

    private void connect(String string, String string2, boolean bl) throws BrokerAdminException {
        try {
            if (this.adminKeyUsed) {
                this.qcf.setConnectionType("ADMINKEY");
            }
            if (this.sslTransportUsed) {
                try {
                    this.qcf.setProperty("imqConnectionType", "SSL");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.setFactoryAttr("imqConnectionType", "SSL");
                }
                catch (JMSException jMSException) {
                    BrokerAdminException brokerAdminException = new BrokerAdminException(15);
                    brokerAdminException.setBrokerHost(this.getBrokerHost());
                    brokerAdminException.setBrokerPort(this.getBrokerPort());
                    brokerAdminException.setLinkedException((Exception)((Object)jMSException));
                    throw brokerAdminException;
                }
            }
            if (debug) {
                this.printObjProperties((AdministeredObject)this.qcf);
            }
            this.connection = bl ? this.qcf.createQueueConnection(string, string2) : this.qcf.createQueueConnection(this.username, this.passwd);
            this.connection.setExceptionListener((ExceptionListener)this);
            this.connection.start();
            if (debug) {
                Globals.stdOutPrintln("***** Creating queue connection");
            }
            this.session = this.connection.createQueueSession(false, 2);
            if (debug) {
                Globals.stdOutPrintln("***** Creating queue session: not transacted, auto ack");
            }
            this.requestQueue = this.session.createQueue("__JMQAdmin");
            if (debug) {
                Globals.stdOutPrintln("***** Created requestQueue: " + this.requestQueue);
            }
            this.replyQueue = this.session.createTemporaryQueue();
            if (debug) {
                Globals.stdOutPrintln("***** Created replyQueue: " + this.replyQueue);
            }
            this.sender = this.session.createSender(this.requestQueue);
            this.sender.setDeliveryMode(1);
            if (debug) {
                Globals.stdOutPrintln("***** Created a sender: " + this.sender);
            }
            this.receiver = this.session.createReceiver((Queue)this.replyQueue);
            if (debug) {
                Globals.stdOutPrintln("***** Created a receiver: " + this.receiver);
            }
        }
        catch (JMSException jMSException) {
            BrokerAdminException brokerAdminException;
            if (jMSException instanceof JMSSecurityException) {
                String string3 = jMSException.getErrorCode();
                brokerAdminException = "C4060".equals(string3) ? new BrokerAdminException(11) : new BrokerAdminException(12);
            } else {
                brokerAdminException = new BrokerAdminException(0);
            }
            brokerAdminException.setBrokerHost(this.getBrokerHost());
            brokerAdminException.setBrokerPort(this.getBrokerPort());
            brokerAdminException.setLinkedException((Exception)((Object)jMSException));
            throw brokerAdminException;
        }
        catch (Exception exception) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(0);
            brokerAdminException.setLinkedException(exception);
            brokerAdminException.setBrokerHost(this.getBrokerHost());
            brokerAdminException.setBrokerPort(this.getBrokerPort());
            throw brokerAdminException;
        }
    }

    private void printObjProperties(AdministeredObject administeredObject) {
        Globals.stdOutPrintln("Connection Factory Object properties:");
        Properties properties = administeredObject.getConfiguration();
        Enumeration enumeration = administeredObject.enumeratePropertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            try {
                string = administeredObject.getPropertyLabel(string2);
            }
            catch (Exception exception) {
                string = "UNKNOWN";
            }
            String string4 = string2 + " [" + string + "]";
            Globals.stdOutPrintln("\t" + string4 + " = " + string3);
        }
        Globals.stdOutPrintln("");
    }

    public void sendHelloMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendHelloMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 28);
            this.statusEvent = this.createStatusEvent(22, 29, "HELLO_REPLY");
            if (debug) {
                this.printMsgType(28, "HELLO");
                Globals.stdOutPrintln("\tJMQProtocolLevel=102");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveHelloReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveHelloReplyMessage() *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 29, "HELLO_REPLY");
            this.isConnected = true;
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetServicesMessage(String string) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetServicesMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 26);
            if (string != null) {
                objectMessage.setStringProperty("JMQServiceName", string);
                this.statusEvent = this.createStatusEvent(1, 27, "GET_SERVICES_REPLY");
            } else {
                this.statusEvent = this.createStatusEvent(2, 27, "GET_SERVICES_REPLY");
            }
            this.statusEvent.setServiceName(string);
            if (debug) {
                this.printMsgType(26, "GET_SERVICES");
                if (string != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + string);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetServicesReplyMessage() throws BrokerAdminException {
        return this.receiveGetServicesReplyMessage(true);
    }

    public Vector receiveGetServicesReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetServicesReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 27, "GET_SERVICES_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                if (debug) {
                    this.printServiceInfoList((Vector)serializable);
                }
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendPauseMessage(String string) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendPauseMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 30);
            objectMessage.setStringProperty("JMQPauseTarget", "JMQServiceName");
            if (string != null) {
                objectMessage.setStringProperty("JMQServiceName", string);
                this.statusEvent = this.createStatusEvent(3, 31, "PAUSE_REPLY");
                this.statusEvent.setServiceName(string);
            } else {
                this.statusEvent = this.createStatusEvent(4, 31, "PAUSE_REPLY");
            }
            if (debug) {
                this.printMsgType(30, "PAUSE");
                if (string != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + string);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void sendPauseMessage(String string, int n, int n2) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendPauseMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 30);
            objectMessage.setStringProperty("JMQPauseTarget", "JMQDestination");
            if (string != null) {
                objectMessage.setStringProperty("JMQDestination", string);
                objectMessage.setIntProperty("JMQDestType", n);
            }
            if (n2 != -1) {
                objectMessage.setIntProperty("JMQDestState", n2);
            }
            this.statusEvent = this.createStatusEvent(28, 31, "PAUSE_REPLY");
            this.statusEvent.setDestinationName(string);
            this.statusEvent.setDestinationType(n);
            if (debug) {
                this.printMsgType(30, "PAUSE");
                Globals.stdOutPrintln("\tJMQDestination=" + string);
                Globals.stdOutPrintln("\tJMQDestType=" + n);
                Globals.stdOutPrintln("\tJMQDestState=" + n2);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receivePauseReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receivePauseReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 31, "PAUSE_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendResetBrokerMessage(String string) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendResetBrokerMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 84);
            if (string != null) {
                objectMessage.setStringProperty("JMQResetType", string);
            }
            this.statusEvent = this.createStatusEvent(42, 85, "RESET_BROKER_REPLY");
            if (debug) {
                this.printMsgType(84, "RESET_BROKER");
                Globals.stdOutPrintln("\tJMQResetType=" + string);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveResetBrokerReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveResetBrokerReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 85, "RESET_BROKER_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendResumeMessage(String string) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendResumeMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 36);
            objectMessage.setStringProperty("JMQPauseTarget", "JMQServiceName");
            if (string != null) {
                objectMessage.setStringProperty("JMQServiceName", string);
                this.statusEvent = this.createStatusEvent(5, 37, "RESUME_REPLY");
                this.statusEvent.setServiceName(string);
            } else {
                this.statusEvent = this.createStatusEvent(6, 37, "RESUME_REPLY");
            }
            if (debug) {
                this.printMsgType(36, "RESUME");
                if (string != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + string);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void sendResumeMessage(String string, int n) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendResumeMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 36);
            objectMessage.setStringProperty("JMQPauseTarget", "JMQDestination");
            if (string != null) {
                objectMessage.setStringProperty("JMQDestination", string);
                objectMessage.setIntProperty("JMQDestType", n);
            }
            this.statusEvent = this.createStatusEvent(29, 37, "RESUME_REPLY");
            this.statusEvent.setDestinationName(string);
            this.statusEvent.setDestinationType(n);
            if (debug) {
                this.printMsgType(36, "RESUME");
                Globals.stdOutPrintln("\tJMQDestination=" + string);
                Globals.stdOutPrintln("\tJMQDestType=" + n);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveResumeReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveResumeReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 37, "RESUME_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendQuiesceMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendQuiesceMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 74);
            this.statusEvent = this.createStatusEvent(36, 75, "QUIESCE_BROKER_REPLY");
            if (debug) {
                this.printMsgType(74, "QUIESCE_BROKER");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveQuiesceReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveQuiesceReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 75, "QUIESCE_BROKER_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendUnquiesceMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendUnquiesceMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 82);
            this.statusEvent = this.createStatusEvent(41, 83, "UNQUIESCE_BROKER_REPLY");
            if (debug) {
                this.printMsgType(82, "UNQUIESCE_BROKER");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveUnquiesceReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveUnquiesceReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 83, "UNQUIESCE_BROKER_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendTakeoverMessage(String string) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendTakeoverMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 76);
            objectMessage.setStringProperty("JMQBrokerID", string);
            this.statusEvent = this.createStatusEvent(37, 77, "TAKEOVER_BROKER_REPLY");
            if (debug) {
                this.printMsgType(76, "TAKEOVER_BROKER");
                Globals.stdOutPrintln("\tJMQBrokerID = " + string);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveTakeoverReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveTakeoverReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 77, "TAKEOVER_BROKER_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetDestinationsMessage(String string, int n) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetDestinationsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 20);
            if (string != null) {
                objectMessage.setStringProperty("JMQDestination", string);
                objectMessage.setIntProperty("JMQDestType", n);
                this.statusEvent = this.createStatusEvent(7, 21, "GET_DESTINATIONS_REPLY");
                this.statusEvent.setDestinationName(string);
                this.statusEvent.setDestinationType(n);
            } else {
                this.statusEvent = this.createStatusEvent(8, 21, "GET_DESTINATIONS_REPLY");
            }
            if (debug) {
                this.printMsgType(20, "GET_DESTINATIONS");
                if (string != null) {
                    Globals.stdOutPrintln("\tJMQDestination=" + string);
                    Globals.stdOutPrintln("\tJMQDestType=" + n);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetDestinationsReplyMessage() throws BrokerAdminException {
        return this.receiveGetDestinationsReplyMessage(true);
    }

    public Vector receiveGetDestinationsReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetDestinationsReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 21, "GET_DESTINATIONS_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                if (debug) {
                    this.printDestinationInfoList((Vector)serializable);
                }
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendCreateDestinationMessage(DestinationInfo destinationInfo) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendCreateDestinationMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 10);
            objectMessage.setObject((Serializable)destinationInfo);
            this.statusEvent = this.createStatusEvent(9, 11, "CREATE_DESTINATION_REPLY");
            this.statusEvent.setDestinationInfo(destinationInfo);
            if (debug) {
                this.printMsgType(10, "CREATE_DESTINATION");
                this.printDestinationInfo(destinationInfo);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveCreateDestinationReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveCreateDestinationReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 11, "CREATE_DESTINATION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendDestroyDestinationMessage(String string, int n) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendDestroyDestinationMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 12);
            objectMessage.setStringProperty("JMQDestination", string);
            objectMessage.setIntProperty("JMQDestType", n);
            this.statusEvent = this.createStatusEvent(0, 13, "DESTROY_DESTINATION_REPLY");
            this.statusEvent.setDestinationName(string);
            this.statusEvent.setDestinationType(n);
            if (debug) {
                this.printMsgType(12, "DESTROY_DESTINATION");
                Globals.stdOutPrintln("\tJMQDestination=" + string);
                Globals.stdOutPrintln("\tJMQDestType=" + n);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveDestroyDestinationReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveDestroyDestinationReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 13, "DESTROY_DESTINATION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendPurgeDestinationMessage(String string, int n) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendPurgeDestinationMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 32);
            objectMessage.setStringProperty("JMQDestination", string);
            objectMessage.setIntProperty("JMQDestType", n);
            this.statusEvent = this.createStatusEvent(10, 33, "PURGE_DESTINATION_REPLY");
            this.statusEvent.setDestinationName(string);
            this.statusEvent.setDestinationType(n);
            if (debug) {
                this.printMsgType(32, "PURGE_DESTINATION");
                Globals.stdOutPrintln("\tJMQDestination=" + string);
                Globals.stdOutPrintln("\tJMQDestType=" + n);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receivePurgeDestinationReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receivePurgeDestinationReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 33, "PURGE_DESTINATION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetBrokerPropsMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetBrokerPropsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 54);
            this.statusEvent = this.createStatusEvent(11, 55, "GET_BROKER_PROPS_REPLY");
            if (debug) {
                this.printMsgType(54, "GET_BROKER_PROPS");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Properties receiveGetBrokerPropsReplyMessage() throws BrokerAdminException {
        return this.receiveGetBrokerPropsReplyMessage(true);
    }

    public Properties receiveGetBrokerPropsReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetBrokerPropsReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 55, "GET_BROKER_PROPS_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Properties) {
                return (Properties)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendUpdateBrokerPropsMessage(Properties properties) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendUpdateBrokerPropsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 56);
            objectMessage.setObject((Serializable)properties);
            this.statusEvent = this.createStatusEvent(12, 57, "UPDATE_BROKER_PROPS_REPLY");
            this.statusEvent.setBrokerProperties(properties);
            if (debug) {
                this.printMsgType(56, "UPDATE_BROKER_PROPS");
                Globals.stdOutPrintln("\tProperties=" + properties.toString());
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveUpdateBrokerPropsReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveUpdateBrokerPropsReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 57, "UPDATE_BROKER_PROPS_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendUpdateDestinationMessage(DestinationInfo destinationInfo) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendUpdateDestinationMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 40);
            objectMessage.setObject((Serializable)destinationInfo);
            this.statusEvent = this.createStatusEvent(13, 41, "UPDATE_DESTINATION_REPLY");
            this.statusEvent.setDestinationInfo(destinationInfo);
            if (debug) {
                this.printMsgType(40, "UPDATE_DESTINATION");
                this.printDestinationInfo(destinationInfo);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveUpdateDestinationReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveUpdateDestinationReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 41, "UPDATE_DESTINATION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendUpdateServiceMessage(ServiceInfo serviceInfo) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendUpdateServiceMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 46);
            objectMessage.setObject((Serializable)serviceInfo);
            this.statusEvent = this.createStatusEvent(14, 47, "UPDATE_SERVICE_REPLY");
            this.statusEvent.setServiceInfo(serviceInfo);
            if (debug) {
                this.printMsgType(46, "UPDATE_SERVICE");
                this.printServiceInfo(serviceInfo);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveUpdateServiceReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveUpdateServiceReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 47, "UPDATE_SERVICE_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendShutdownMessage(boolean bl) throws BrokerAdminException {
        this.sendShutdownMessage(bl, false);
    }

    public void sendShutdownMessage(boolean bl, boolean bl2) throws BrokerAdminException {
        this.sendShutdownMessage(bl, bl2, false, -1);
    }

    public void sendShutdownMessage(boolean bl, boolean bl2, boolean bl3, int n) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendShutdownMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 38);
            if (bl) {
                this.statusEvent = this.createStatusEvent(15, 39, "SHUTDOWN_REPLY");
                objectMessage.setBooleanProperty("JMQRestart", true);
            } else {
                this.statusEvent = this.createStatusEvent(16, 39, "SHUTDOWN_REPLY");
                objectMessage.setBooleanProperty("JMQNoFailover", bl3);
                if (n > 0) {
                    objectMessage.setIntProperty("JMQTime", n);
                }
            }
            if (bl2) {
                objectMessage.setBooleanProperty("JMQKill", true);
            }
            if (debug) {
                this.printMsgType(38, "SHUTDOWN");
                if (bl) {
                    Globals.stdOutPrintln("\tJMQRestart=true");
                } else {
                    Globals.stdOutPrintln("\tJMQNoFailover=" + bl3);
                    Globals.stdOutPrintln("\tJMQTime=" + n);
                }
                if (bl2) {
                    Globals.stdOutPrintln("\tJMQKill=true");
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveShutdownReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveShutdownReplyMessage *****");
        }
        Message message = null;
        try {
            message = this.receiver.receive(this.timeout);
            this.checkReplyTypeStatus(message, 39, "SHUTDOWN_REPLY");
        }
        catch (JMSException jMSException) {
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetDurablesMessage(String string, String string2) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetDurablesMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 22);
            if (string != null) {
                objectMessage.setStringProperty("JMQDestination", string);
            }
            if (string2 != null) {
                objectMessage.setStringProperty("JMQDurableName", string2);
            }
            this.statusEvent = this.createStatusEvent(17, 23, "GET_DURABLES_REPLY");
            this.statusEvent.setDestinationName(string);
            this.statusEvent.setDurableName(string2);
            if (debug) {
                this.printMsgType(22, "GET_DURABLES");
                Globals.stdOutPrintln("\tJMQDestination=" + string);
                if (string2 != null) {
                    Globals.stdOutPrintln("\tJMQDurableName=" + string2);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetDurablesReplyMessage() throws BrokerAdminException {
        return this.receiveGetDurablesReplyMessage(true);
    }

    public Vector receiveGetDurablesReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetDurablesReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 23, "GET_DURABLES_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                if (debug) {
                    this.printDurableInfoList((Vector)serializable);
                }
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendDestroyDurableMessage(String string, String string2) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendDestroyDurableMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 14);
            objectMessage.setStringProperty("JMQDurableName", string);
            objectMessage.setStringProperty("JMQClientID", string2);
            this.statusEvent = this.createStatusEvent(18, 15, "DESTROY_DURABLE_REPLY");
            this.statusEvent.setDurableName(string);
            this.statusEvent.setClientID(string2);
            if (debug) {
                this.printMsgType(14, "DESTROY_DURABLE");
                Globals.stdOutPrintln("\tJMQDurableName=" + string);
                Globals.stdOutPrintln("\tJMQClientID=" + string2);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void sendPurgeDurableMessage(String string, String string2) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendPurgeDurableMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 66);
            objectMessage.setStringProperty("JMQDurableName", string);
            objectMessage.setStringProperty("JMQClientID", string2);
            this.statusEvent = this.createStatusEvent(27, 67, "PURGE_DURABLE_REPLY");
            this.statusEvent.setDurableName(string);
            this.statusEvent.setClientID(string2);
            if (debug) {
                this.printMsgType(66, "PURGE_DURABLE");
                Globals.stdOutPrintln("\tJMQDurableName=" + string);
                Globals.stdOutPrintln("\tJMQClientID=" + string2);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveDestroyDurableReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveDestroyDurableReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 15, "DESTROY_DURABLE_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void receivePurgeDurableReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receivePurgeDurableReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 67, "PURGE_DURABLE_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetMetricsMessage(String string) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetMetricsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 52);
            if (string != null) {
                objectMessage.setStringProperty("JMQServiceName", string);
                this.statusEvent = this.createStatusEvent(19, 53, "GET_METRICS_REPLY");
                this.statusEvent.setServiceName(string);
            } else {
                this.statusEvent = this.createStatusEvent(20, 53, "GET_METRICS_REPLY");
            }
            if (debug) {
                this.printMsgType(52, "GET_METRICS");
                if (string != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + string);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void sendGetMetricsMessage(String string, int n) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetMetricsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 52);
            objectMessage.setStringProperty("JMQDestination", string);
            objectMessage.setIntProperty("JMQDestType", n);
            this.statusEvent = this.createStatusEvent(30, 53, "GET_METRICS_REPLY");
            if (debug) {
                this.printMsgType(52, "GET_METRICS");
                Globals.stdOutPrintln("\tJMQDestination=" + string);
                Globals.stdOutPrintln("\tJMQDestType=" + n);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Object receiveGetMetricsReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetMetricsReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 53, "GET_METRICS_REPLY");
            String string = objectMessage.getStringProperty("JMQBodyType");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null) {
                if ("DESTINATION".equals(string) && serializable instanceof DestMetricsCounters) {
                    return (DestMetricsCounters)serializable;
                }
                if ((string == null || "SERVICE".equals(string)) && serializable instanceof MetricCounters) {
                    return (MetricCounters)serializable;
                }
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendReloadClusterMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendReloadClusterMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 58);
            this.statusEvent = this.createStatusEvent(21, 59, "RELOAD_CLUSTER_REPLY");
            if (debug) {
                this.printMsgType(58, "RELOAD_CLUSTER");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveReloadClusterReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveReloadClusterReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 59, "RELOAD_CLUSTER_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetClusterMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetClusterMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 78);
            this.statusEvent = bl ? this.createStatusEvent(38, 79, "GET_CLUSTER_REPLY") : this.createStatusEvent(11, 79, "GET_CLUSTER_REPLY");
            if (debug) {
                this.printMsgType(78, "GET_CLUSTER");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetClusterReplyMessage() throws BrokerAdminException {
        return this.receiveGetClusterReplyMessage(true);
    }

    public Vector receiveGetClusterReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetClusterReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 79, "GET_CLUSTER_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                if (debug) {
                    this.printClusterList((Vector)serializable);
                }
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendGetJMXConnectorsMessage(String string) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetJMXConnectorsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 80);
            this.statusEvent = this.createStatusEvent(39, 81, "GET_JMX_REPLY");
            if (debug) {
                this.printMsgType(80, "GET_JMX");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetJMXConnectorsReplyMessage() throws BrokerAdminException {
        return this.receiveGetJMXConnectorsReplyMessage(true);
    }

    public Vector receiveGetJMXConnectorsReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetJMXConnectorsReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 81, "GET_JMX_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                if (debug) {
                    this.printJMXList((Vector)serializable);
                }
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendGetMessagesMessage(String string, int n, boolean bl, String string2, Long l, Long l2) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetMessagesMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 86);
            objectMessage.setStringProperty("JMQDestination", string);
            objectMessage.setIntProperty("JMQDestType", n);
            objectMessage.setBooleanProperty("JMQGetMessageBody", bl);
            if (string2 != null) {
                objectMessage.setStringProperty("JMQMessageID", string2);
            }
            if (l != null) {
                objectMessage.setLongProperty("JMQStartMessageIndex", l.longValue());
            }
            if (l2 != null) {
                objectMessage.setLongProperty("JMQMaxNumMsgsRetrieved", l2.longValue());
            }
            this.statusEvent = this.createStatusEvent(43, 87, "GET_MESSAGE_REPLY");
            if (debug) {
                this.printMsgType(86, "GET_MESSAGES");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetMessagesReplyMessage() throws BrokerAdminException {
        return this.receiveGetMessagesReplyMessage(true);
    }

    public Vector receiveGetMessagesReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetMessagesReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 87, "GET_MESSAGES_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendDestroyMessagesMessage(String string, int n, String string2) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendDestroyMessagesMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 88);
            objectMessage.setStringProperty("JMQDestination", string);
            objectMessage.setIntProperty("JMQDestType", n);
            if (string2 != null) {
                objectMessage.setStringProperty("JMQMessageID", string2);
            }
            this.statusEvent = this.createStatusEvent(44, 89, "DELETE_MESSAGE_REPLY");
            if (debug) {
                this.printMsgType(88, "DELETE_MESSAGE");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveDestroyMessagesReplyMessage() throws BrokerAdminException {
        this.receiveDestroyMessagesReplyMessage(true);
    }

    public void receiveDestroyMessagesReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveDestroyMessagesReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 89, "DELETE_MESSAGE_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendCommitTxnMessage(Long l) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendCommitTxnMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 62);
            objectMessage.setLongProperty("JMQTransactionID", l.longValue());
            this.statusEvent = this.createStatusEvent(23, 63, "COMMIT_TRANSACTION_REPLY");
            if (debug) {
                this.printMsgType(62, "COMMIT_TRANSACTION");
                Globals.stdOutPrintln("\tJMQTransactionID=" + l);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveCommitTxnReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveCommitTxnReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 63, "COMMIT_TRANSACTION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendRollbackTxnMessage(Long l) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendRollbackTxnMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 64);
            objectMessage.setLongProperty("JMQTransactionID", l.longValue());
            this.statusEvent = this.createStatusEvent(24, 65, "ROLLBACK_TRANSACTION_REPLY");
            if (debug) {
                this.printMsgType(64, "ROLLBACK_TRANSACTION");
                Globals.stdOutPrintln("\tJMQTransactionID=" + l);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveRollbackTxnReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveRollbackTxnReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 65, "ROLLBACK_TRANSACTION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetTxnsMessage(Long l) throws BrokerAdminException {
        this.sendGetTxnsMessage(true, l);
    }

    public void sendGetTxnsMessage() throws BrokerAdminException {
        this.sendGetTxnsMessage(false, null);
    }

    private void sendGetTxnsMessage(boolean bl, Long l) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetTxnsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 60);
            if (bl) {
                objectMessage.setLongProperty("JMQTransactionID", l.longValue());
                this.statusEvent = this.createStatusEvent(26, 61, "GET_TRANSACTIONS_REPLY");
                this.statusEvent.setTid(l);
            } else {
                this.statusEvent = this.createStatusEvent(25, 61, "GET_TRANSACTIONS_REPLY");
            }
            if (debug) {
                this.printMsgType(60, "GET_TRANSACTIONS");
                Globals.stdOutPrintln("\tJMQTransactionID=");
                if (bl) {
                    Globals.stdOutPrintln(l.toString());
                } else {
                    Globals.stdOutPrintln("NOT SPECIFIED");
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetTxnsReplyMessage() throws BrokerAdminException {
        return this.receiveGetTxnsReplyMessage(true);
    }

    public Vector receiveGetTxnsReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetTxnsReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 61, "GET_TRANSACTIONS_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (debug) {
                int n = 0;
                Globals.stdOutPrintln("obj returned: " + serializable);
                try {
                    n = objectMessage.getIntProperty("JMQQuantity");
                }
                catch (JMSException jMSException) {
                    Globals.stdOutPrintln("failed to get JMQ_QUANTITY: " + (Object)((Object)jMSException));
                }
                Globals.stdOutPrintln("JMQ_QUANTTY: " + n);
            }
            if (serializable != null && serializable instanceof Vector) {
                if (debug) {
                    this.printTxnInfoList((Vector)serializable);
                }
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendCompactDestinationMessage(String string, int n) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendCompactDestinationMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 68);
            if (string != null) {
                objectMessage.setStringProperty("JMQDestination", string);
            }
            if (n != -1) {
                objectMessage.setIntProperty("JMQDestType", n);
            }
            this.statusEvent = this.createStatusEvent(32, 69, "COMPACT_DESTINATION_REPLY");
            this.statusEvent.setDestinationName(string);
            this.statusEvent.setDestinationType(n);
            if (debug) {
                this.printMsgType(68, "COMPACT_DESTINATION");
                Globals.stdOutPrintln("\tJMQDestination=" + string);
                Globals.stdOutPrintln("\tJMQDestType=" + n);
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveCompactDestinationReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveCompactDestinationReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 69, "COMPACT_DESTINATION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendGetConnectionsMessage(String string, Long l) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendGetConnectionsMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 16);
            if (l != null) {
                this.statusEvent = this.createStatusEvent(34, 17, "GET_CONNECTIONS_REPLY");
                objectMessage.setLongProperty("JMQConnectionID", l.longValue());
                this.statusEvent.setCxnid(l);
            } else {
                this.statusEvent = this.createStatusEvent(33, 17, "GET_CONNECTIONS_REPLY");
            }
            if (string != null) {
                objectMessage.setStringProperty("JMQServiceName", string);
                this.statusEvent.setServiceName(string);
            }
            if (debug) {
                this.printMsgType(16, "GET_CONNECTIONS");
                if (string != null) {
                    Globals.stdOutPrintln("\tJMQServiceName=" + string);
                }
                if (l != null) {
                    Globals.stdOutPrintln("\tJMQConnectionID=" + l);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Vector receiveGetConnectionsReplyMessage() throws BrokerAdminException {
        return this.receiveGetConnectionsReplyMessage(true);
    }

    public Vector receiveGetConnectionsReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveGetConnectionsReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 17, "GET_CONNECTIONS_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Vector) {
                if (debug) {
                    this.printConnectionInfoList((Vector)serializable);
                }
                return (Vector)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void sendDestroyConnectionMessage(Long l) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendDestroyConnectionMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 70);
            if (l != null) {
                this.statusEvent = this.createStatusEvent(40, 71, "DESTROY_CONNECTION_REPLY");
                objectMessage.setLongProperty("JMQConnectionID", l.longValue());
                this.statusEvent.setCxnid(l);
            }
            if (debug) {
                this.printMsgType(70, "DESTROY_CONNECTION");
                if (l != null) {
                    Globals.stdOutPrintln("\tJMQConnectionID=" + l);
                }
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public void receiveDestroyConnectionReplyMessage() throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveDestroyConnectionReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 71, "DESTROY_CONNECTION_REPLY");
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
    }

    public void sendDebugMessage(String string, String string2, String string3, String string4, Properties properties) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** sendDebugMessage *****");
        }
        ObjectMessage objectMessage = null;
        this.checkIfBusy();
        try {
            objectMessage = this.session.createObjectMessage();
            objectMessage.setJMSReplyTo((Destination)this.replyQueue);
            objectMessage.setIntProperty("JMQMessageType", 72);
            if (string != null) {
                objectMessage.setStringProperty("JMQCommand", string);
            }
            if (string2 != null) {
                objectMessage.setStringProperty("JMQCommandArg", string2);
            }
            if (string3 != null) {
                objectMessage.setStringProperty("JMQTarget", string3);
            }
            if (string4 != null) {
                objectMessage.setStringProperty("JMQTargetType", string4);
            }
            if (properties != null) {
                objectMessage.setObject((Serializable)properties);
            }
            this.statusEvent = this.createStatusEvent(35, 73, "DEBUG_REPLY");
            if (debug) {
                this.printMsgType(72, "DEBUG");
            }
            this.sender.send((Message)objectMessage);
        }
        catch (Exception exception) {
            this.handleSendExceptions(exception);
        }
    }

    public Hashtable receiveDebugReplyMessage() throws BrokerAdminException {
        return this.receiveDebugReplyMessage(true);
    }

    public Hashtable receiveDebugReplyMessage(boolean bl) throws BrokerAdminException {
        if (debug) {
            Globals.stdOutPrintln("***** receiveDebugReplyMessage *****");
        }
        ObjectMessage objectMessage = null;
        try {
            objectMessage = (ObjectMessage)this.receiveCheckMessageTimeout(false, bl);
            objectMessage.acknowledge();
            this.clearStatusEvent();
            this.checkReplyTypeStatus((Message)objectMessage, 73, "DEBUG_REPLY");
            Serializable serializable = objectMessage.getObject();
            if (serializable != null && serializable instanceof Hashtable) {
                return (Hashtable)serializable;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return null;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        return this.getBrokerHost() + ":" + this.getBrokerPort();
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setIsConnected(boolean bl) {
        this.isConnected = bl;
    }

    private String getErrorMessage(Message message) {
        String string;
        block4: {
            string = null;
            try {
                string = message.getStringProperty("JMQErrorString");
            }
            catch (JMSException jMSException) {
                if (debug) {
                    Globals.stdErrPrint("Failed to retrieve the error message: ");
                    Globals.stdErrPrintln(jMSException.getMessage());
                    jMSException.printStackTrace();
                }
            }
            catch (Exception exception) {
                if (!debug) break block4;
                Globals.stdErrPrintln("Exception caught: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        return string;
    }

    public void forceClose() {
        try {
            this.connection.close();
            this.isConnected = false;
        }
        catch (JMSException jMSException) {
            Globals.stdErrPrintln("JMSException caught: " + jMSException.getMessage());
            jMSException.printStackTrace();
        }
    }

    public void close() {
        if (!this.isConnected()) {
            return;
        }
        try {
            if (this.msgAckThread != null) {
                this.msgAckThread.stop();
                this.msgAckThread = null;
                if (debug) {
                    Globals.stdOutPrintln("***** Stopped msgAckThread thread...");
                }
            }
            if (debug) {
                Globals.stdOutPrintln("***** Closing sender and receiver...");
            }
            this.sender.close();
            if (debug) {
                Globals.stdOutPrintln("***** Closed sender.");
            }
            this.receiver.close();
            if (debug) {
                Globals.stdOutPrintln("***** Closed receiver.");
            }
            if (debug) {
                Globals.stdOutPrintln("***** Closing queue session and queue connection...");
            }
            this.session.close();
            if (debug) {
                Globals.stdOutPrintln("***** Closed session.");
            }
        }
        catch (JMSException jMSException) {
            Globals.stdErrPrintln("JMSException caught: " + jMSException.getMessage());
            jMSException.printStackTrace();
        }
        catch (Exception exception) {
            Globals.stdErrPrintln("Exception caught: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            this.connection.close();
            if (debug) {
                Globals.stdOutPrintln("***** Closed connection.");
            }
            this.isConnected = false;
            this.setBusy(false);
        }
        catch (JMSException jMSException) {
            if (this.sslTransportUsed) {
                this.isConnected = false;
                this.setBusy(false);
            } else {
                Globals.stdErrPrintln("JMSException caught: " + jMSException.getMessage());
                jMSException.printStackTrace();
            }
        }
        catch (Exception exception) {
            if (this.sslTransportUsed) {
                this.isConnected = false;
                this.setBusy(false);
            }
            Globals.stdErrPrintln("Exception caught: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void setFactoryAttr(String string, String string2) throws JMSException {
        if (this.qcf == null) {
            return;
        }
        this.qcf.setProperty(string, string2);
    }

    private String getFactoryAttr(String string) {
        String string2;
        if (this.qcf == null) {
            return null;
        }
        try {
            string2 = this.qcf.getProperty(string);
        }
        catch (JMSException jMSException) {
            string2 = null;
        }
        return string2;
    }

    private void createFactory(Properties properties) throws BrokerAdminException {
        this.qcf = new QueueConnectionFactory();
        try {
            this.qcf.setConnectionType("ADMIN");
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                if (string2 == null) continue;
                this.qcf.setProperty(string, string2);
            }
        }
        catch (JMSException jMSException) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(0);
            brokerAdminException.setLinkedException((Exception)((Object)jMSException));
            brokerAdminException.setBrokerHost(this.getBrokerHost());
            brokerAdminException.setBrokerPort(this.getBrokerPort());
            throw brokerAdminException;
        }
        catch (Exception exception) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(0);
            brokerAdminException.setLinkedException(exception);
            brokerAdminException.setBrokerHost(this.getBrokerHost());
            brokerAdminException.setBrokerPort(this.getBrokerPort());
            throw brokerAdminException;
        }
        if (debug) {
            Globals.stdOutPrintln("***** BrokerAdmin instance: " + this.getKey());
            Globals.stdOutPrintln("BrokerAdmin created with timeout set to: " + this.timeout / 1000L + " seconds");
            Globals.stdOutPrintln("BrokerAdmin created with num retries set to: " + this.numRetries);
        }
    }

    private void checkIfBusy() throws BrokerAdminException {
        if (this.isBusy()) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(13);
            brokerAdminException.setBrokerAdmin(this);
            throw brokerAdminException;
        }
    }

    private Message receiveCheckMessageTimeout(boolean bl) throws BrokerAdminException {
        return this.receiveCheckMessageTimeout(bl, true);
    }

    private Message receiveCheckMessageTimeout(boolean bl, boolean bl2) throws BrokerAdminException {
        ObjectMessage objectMessage = null;
        long l = this.timeout;
        int n = 0;
        try {
            while (n <= this.numRetries && (objectMessage = (ObjectMessage)this.receiver.receive(l)) == null) {
                if (bl) {
                    this.isConnected = false;
                    break;
                }
                l += this.timeout;
                if (++n <= this.numRetries) {
                    BrokerCmdStatusEvent brokerCmdStatusEvent = new BrokerCmdStatusEvent(this, this, 31);
                    brokerCmdStatusEvent.setNumRetriesAttempted(n);
                    brokerCmdStatusEvent.setMaxNumRetries(this.numRetries);
                    brokerCmdStatusEvent.setRetryTimeount(l / 1000L);
                    this.fireAdminEventDispatched(brokerCmdStatusEvent);
                    continue;
                }
                this.msgAckThread = new MessageAckThread(this);
                this.msgAckThread.start();
                BrokerAdminException brokerAdminException = bl2 ? new BrokerAdminException(6) : new BrokerAdminException(14);
                throw brokerAdminException;
            }
        }
        catch (Exception exception) {
            this.handleReceiveExceptions(exception);
        }
        return objectMessage;
    }

    private void checkReplyTypeStatus(Message message, int n, String string) throws BrokerAdminException {
        int n2;
        int n3;
        if (message == null && n == 39) {
            this.isConnected = false;
            return;
        }
        try {
            n3 = message.getIntProperty("JMQMessageType");
        }
        catch (JMSException jMSException) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(4);
            brokerAdminException.setLinkedException((Exception)((Object)jMSException));
            throw brokerAdminException;
        }
        try {
            n2 = message.getIntProperty("JMQStatus");
        }
        catch (JMSException jMSException) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(5);
            brokerAdminException.setLinkedException((Exception)((Object)jMSException));
            throw brokerAdminException;
        }
        if (debug) {
            Globals.stdOutPrintln("\tReplyMsgType=" + n3 + "(expecting " + n + "[" + string + "]), ReplyStatus=" + n2);
        }
        if (n == n3 && n2 == 200) {
            if (n == 39) {
                this.isConnected = false;
            }
            return;
        }
        String string2 = this.getErrorMessage(message);
        if (debug) {
            Globals.stdOutPrintln("\tJMQ_ERROR_STRING=" + string2);
        }
        BrokerAdminException brokerAdminException = new BrokerAdminException(2);
        brokerAdminException.setBrokerErrorStr(string2);
        brokerAdminException.setReplyMsgType(n3);
        brokerAdminException.setReplyStatus(n2);
        throw brokerAdminException;
    }

    private void printMsgType(int n, String string) {
        Globals.stdOutPrintln("\tJMQMessageType=" + n + "(" + string + ")");
    }

    private void printDestinationInfoList(Vector vector) {
        Enumeration enumeration = vector.elements();
        Globals.stdOutPrintln("\t************************");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof DestinationInfo)) {
                Globals.stdOutPrintln("\tprintDestinationInfoList: Vector contained object of type: " + e.getClass().getName());
                Globals.stdOutPrintln("\t************************");
                return;
            }
            DestinationInfo destinationInfo = (DestinationInfo)e;
            this.printDestinationInfo(destinationInfo);
            if (!enumeration.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printDestinationInfo(DestinationInfo destinationInfo) {
        Globals.stdOutPrintln("\tDestinationInfo:");
        Globals.stdOutPrintln("\t  name=" + destinationInfo.name);
        Globals.stdOutPrintln("\t  type=" + destinationInfo.type);
        Globals.stdOutPrintln("\t  nMessages=" + destinationInfo.nMessages);
        Globals.stdOutPrintln("\t  nMessageBytes=" + destinationInfo.nMessageBytes);
        Globals.stdOutPrintln("\t  nConsumers=" + destinationInfo.nConsumers);
        Globals.stdOutPrintln("\t  maxMessages=" + destinationInfo.maxMessages);
        Globals.stdOutPrintln("\t  maxMessageBytes=" + destinationInfo.maxMessageBytes);
        Globals.stdOutPrintln("\t  maxMessageSize=" + destinationInfo.maxMessageSize);
        Globals.stdOutPrintln("\t  maxFailoverConsumers=" + destinationInfo.maxFailoverConsumers);
        Globals.stdOutPrintln("\t  maxActiveConsumers=" + destinationInfo.maxActiveConsumers);
        Globals.stdOutPrintln("\t  destScope=" + destinationInfo.destScope);
        Globals.stdOutPrintln("\t  destLimitBehavior=" + destinationInfo.destLimitBehavior);
        Globals.stdOutPrintln("\t  destCDP=" + destinationInfo.destCDP);
        Globals.stdOutPrintln("\t  maxPrefetch=" + destinationInfo.maxPrefetch);
        Globals.stdOutPrintln("\t  maxProducers=" + destinationInfo.maxProducers);
        Globals.stdOutPrintln("\t  autocreated=" + destinationInfo.autocreated);
        Globals.stdOutPrintln("\t  naConsumers=" + destinationInfo.naConsumers);
        Globals.stdOutPrintln("\t  nfConsumers=" + destinationInfo.nfConsumers);
        Globals.stdOutPrintln("\t  destState=" + destinationInfo.destState);
    }

    private void printServiceInfoList(Vector vector) {
        Enumeration enumeration = vector.elements();
        Globals.stdOutPrintln("\t************************");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof ServiceInfo)) {
                Globals.stdOutPrintln("\tprintServiceInfoList: Vector contained object of type: " + e.getClass().getName());
                Globals.stdOutPrintln("\t************************");
                return;
            }
            ServiceInfo serviceInfo = (ServiceInfo)e;
            this.printServiceInfo(serviceInfo);
            if (!enumeration.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printServiceInfo(ServiceInfo serviceInfo) {
        Globals.stdOutPrintln("\tServiceInfo:");
        Globals.stdOutPrintln("\t  name=" + serviceInfo.name);
        Globals.stdOutPrintln("\t  protocol=" + serviceInfo.protocol);
        Globals.stdOutPrintln("\t  type=" + serviceInfo.type);
        Globals.stdOutPrintln("\t  state=" + serviceInfo.state);
        Globals.stdOutPrintln("\t  nConnections=" + serviceInfo.nConnections);
        Globals.stdOutPrintln("\t  currentThreads=" + serviceInfo.currentThreads);
        Globals.stdOutPrintln("\t  dynamicPort=" + serviceInfo.dynamicPort);
        Globals.stdOutPrintln("\t  metrics=" + serviceInfo.metrics);
        Globals.stdOutPrintln("\t  port=" + serviceInfo.port);
        Globals.stdOutPrintln("\t  minThreads=" + serviceInfo.minThreads);
        Globals.stdOutPrintln("\t  maxThreads=" + serviceInfo.maxThreads);
    }

    private void printConnectionInfoList(Vector vector) {
        Enumeration enumeration = vector.elements();
        Globals.stdOutPrintln("\t************************");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Hashtable)) {
                Globals.stdOutPrintln("\tprintConnectionInfoList: Vector contained object of type: " + e.getClass().getName() + "(expected java.util.Hashtable)");
                Globals.stdOutPrintln("\t************************");
                return;
            }
            Hashtable hashtable = (Hashtable)e;
            this.printConnectionInfo(hashtable);
            if (!enumeration.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printConnectionInfo(Hashtable hashtable) {
        Globals.stdOutPrintln("\tConnection Info:");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            String string2 = v.toString();
            Globals.stdOutPrintln("\t  " + string + "=" + string2);
        }
    }

    private void printDurableInfoList(Vector vector) {
        Enumeration enumeration = vector.elements();
        Globals.stdOutPrintln("\t************************");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof DurableInfo)) {
                Globals.stdOutPrintln("\tprintDurableInfoList: Vector contained object of type: " + e.getClass().getName());
                Globals.stdOutPrintln("\t************************");
                return;
            }
            DurableInfo durableInfo = (DurableInfo)e;
            this.printDurableInfo(durableInfo);
            if (!enumeration.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printDurableInfo(DurableInfo durableInfo) {
        Globals.stdOutPrintln("\tDurableInfo:");
        Globals.stdOutPrintln("\t  name=" + durableInfo.name);
        Globals.stdOutPrintln("\t  clientID=" + durableInfo.clientID);
        Globals.stdOutPrintln("\t  nMessages=" + durableInfo.nMessages);
        Globals.stdOutPrintln("\t  isActive=" + durableInfo.isActive);
        Globals.stdOutPrintln("\t  ConsumerInfo=" + durableInfo.consumer);
    }

    private void printTxnInfoList(Vector vector) {
        Enumeration enumeration = vector.elements();
        Globals.stdOutPrintln("\t************************");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Hashtable)) {
                Globals.stdOutPrintln("\tprintTxnInfoList: Vector contained object of type: " + e.getClass().getName() + "(expected java.util.Hashtable)");
                Globals.stdOutPrintln("\t************************");
                return;
            }
            Hashtable hashtable = (Hashtable)e;
            this.printTxnInfo(hashtable);
            if (!enumeration.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printTxnInfo(Hashtable hashtable) {
        Globals.stdOutPrintln("\tTransaction Info:");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            String string2 = v.toString();
            Globals.stdOutPrintln("\t  " + string + "=" + string2);
        }
    }

    private void printClusterList(Vector vector) {
        Enumeration enumeration = vector.elements();
        Globals.stdOutPrintln("\t************************");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof BrokerClusterInfo)) {
                Globals.stdOutPrintln("\tprintClusterList: Vector contained object of type: " + e.getClass().getName() + "(expected BrokerClusterInfo)");
                Globals.stdOutPrintln("\t************************");
                return;
            }
            BrokerClusterInfo brokerClusterInfo = (BrokerClusterInfo)e;
            this.printBkrClsInfo(brokerClusterInfo);
            if (!enumeration.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printBkrClsInfo(BrokerClusterInfo brokerClusterInfo) {
        Globals.stdOutPrintln("\tBroker Cluster Info:");
    }

    private void printJMXList(Vector vector) {
        Enumeration enumeration = vector.elements();
        Globals.stdOutPrintln("\t************************");
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Hashtable)) {
                Globals.stdOutPrintln("\tprintJMXList: Vector contained object of type: " + e.getClass().getName() + "(expected java.util.Hashtable)");
                Globals.stdOutPrintln("\t************************");
                return;
            }
            Hashtable hashtable = (Hashtable)e;
            this.printJMXInfo(hashtable);
            if (!enumeration.hasMoreElements()) continue;
            Globals.stdOutPrintln("");
        }
        Globals.stdOutPrintln("\t************************");
    }

    private void printJMXInfo(Hashtable hashtable) {
        Globals.stdOutPrintln("\tJMX Connector Info:");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = hashtable.get(string);
            String string2 = v.toString();
            Globals.stdOutPrintln("\t  " + string + "=" + string2);
        }
    }

    private void handleSendExceptions(Exception exception) throws BrokerAdminException {
        if (exception instanceof BrokerAdminException) {
            throw (BrokerAdminException)exception;
        }
        if (exception instanceof JMSException) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(1);
            brokerAdminException.setLinkedException(exception);
            throw brokerAdminException;
        }
        BrokerAdminException brokerAdminException = new BrokerAdminException(1);
        brokerAdminException.setLinkedException(exception);
        throw brokerAdminException;
    }

    private void handleReceiveExceptions(Exception exception) throws BrokerAdminException {
        if (exception instanceof BrokerAdminException) {
            throw (BrokerAdminException)exception;
        }
        if (exception instanceof JMSException) {
            BrokerAdminException brokerAdminException = new BrokerAdminException(2);
            brokerAdminException.setLinkedException(exception);
            throw brokerAdminException;
        }
        BrokerAdminException brokerAdminException = new BrokerAdminException(2);
        brokerAdminException.setLinkedException(exception);
        throw brokerAdminException;
    }

    public void addAdminEventListener(AdminEventListener adminEventListener) {
        this.eListeners.addElement(adminEventListener);
    }

    public void removeAdminEventListener(AdminEventListener adminEventListener) {
        this.eListeners.removeElement(adminEventListener);
    }

    public void removeAllAdminEventListeners() {
        this.eListeners.removeAllElements();
    }

    public void fireAdminEventDispatched(AdminEvent adminEvent) {
        for (int i = 0; i < this.eListeners.size(); ++i) {
            ((AdminEventListener)this.eListeners.elementAt(i)).adminEventDispatched(adminEvent);
        }
    }

    protected BrokerCmdStatusEvent createStatusEvent(int n, int n2, String string) {
        BrokerCmdStatusEvent brokerCmdStatusEvent = new BrokerCmdStatusEvent(this, this, n);
        brokerCmdStatusEvent.setReplyType(n2);
        brokerCmdStatusEvent.setReplyTypeString(string);
        return brokerCmdStatusEvent;
    }

    protected void clearStatusEvent() {
        this.statusEvent = null;
    }

    protected void sendStatusEvent(Message message, Exception exception) {
        if (this.statusEvent != null) {
            if (message == null) {
                this.statusEvent.setSuccess(false);
                this.statusEvent.setLinkedException(exception);
            } else {
                try {
                    this.checkReplyTypeStatus(message, this.statusEvent.getReplyType(), this.statusEvent.getReplyTypeString());
                    if (message instanceof ObjectMessage) {
                        try {
                            this.statusEvent.setReturnedObject(((ObjectMessage)message).getObject());
                        }
                        catch (JMSException jMSException) {
                            this.statusEvent.setSuccess(false);
                            this.statusEvent.setLinkedException((Exception)((Object)jMSException));
                        }
                    }
                    this.statusEvent.setSuccess(true);
                }
                catch (BrokerAdminException brokerAdminException) {
                    this.statusEvent.setSuccess(false);
                    this.statusEvent.setLinkedException(brokerAdminException);
                }
            }
            this.fireAdminEventDispatched(this.statusEvent);
            this.clearStatusEvent();
        }
    }

    public void onException(JMSException jMSException) {
        BrokerErrorEvent brokerErrorEvent = null;
        this.isConnected = false;
        if ("C4056" == jMSException.getErrorCode()) {
            if (!this.isInitiator()) {
                brokerErrorEvent = new BrokerErrorEvent(this, 1);
                brokerErrorEvent.setBrokerHost(this.getBrokerHost());
                brokerErrorEvent.setBrokerPort(this.getBrokerPort());
                brokerErrorEvent.setBrokerName(this.getKey());
            }
        } else if (jMSException.getLinkedException() instanceof EOFException) {
            brokerErrorEvent = new BrokerErrorEvent(this, 0);
            brokerErrorEvent.setBrokerHost(this.getBrokerHost());
            brokerErrorEvent.setBrokerPort(this.getBrokerPort());
            brokerErrorEvent.setBrokerName(this.getKey());
        } else {
            brokerErrorEvent = new BrokerErrorEvent(this, 2);
            brokerErrorEvent.setBrokerHost(this.getBrokerHost());
            brokerErrorEvent.setBrokerPort(this.getBrokerPort());
            brokerErrorEvent.setBrokerName(this.getKey());
        }
        if (brokerErrorEvent != null) {
            this.fireAdminEventDispatched(brokerErrorEvent);
        }
        this.removeAllAdminEventListeners();
    }

    public static void setDebug(boolean bl) {
        debug = bl;
    }

    public static boolean getDebug() {
        return debug;
    }

    public void setAssociatedObj(Object object) {
        this.aObj = object;
    }

    public Object getAssociatedObj() {
        return this.aObj;
    }
}

