#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT CALENDER v3.0.5
## (c)2008-2010 NorenzPRO Ltd. TakafumiArai 2010/8/11
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##★ライブラリ
use CGI;
use Encode;
require '../admin/aelib.cgi';

##★管理者ID＆パスワード(AD-EDIT部品の場合は設定不要)
our $adid='user';
our $adpw='pass';
require './calendlib.pl';

##★このスクリプトの名前
our $cginame = 'admin.cgi';

##★データファイルのパス
our $datafile = './data.dat';

##★休日や祝日のデータが入っているファイル。
$calenderfile = './calender.lib';

##★アップロード画像格納ディレクトリ（相対・絶対パス）
our $img_dir = './file/';

##★アップロード画像公開ディレクトリ（相対・絶対パス）
our $img_path = './file/';

##★クッキーの名称
our $CookieName = 'AdminPass';

##★パスワードファイル
our $passfile='../admin/pass.cgi';

##★カレンダー表の色
#平日の色
our $weekdaycolor='#FFFFFF';
#土曜日の色
our $saturdaycolor='#F0F0FF';
#日曜・祝日の色
our $holidaycolor='#FFF0FF';

##★カレンダーテキスト色
#平日の色
our $weekdaytextcolor='#333333';
#土曜日の色
our $saturdaytextcolor='#0000EE';
#日曜・祝日の色
our $holidaytextcolor='#EE0000';
#平日の色-薄色
our $weekday2textcolor='#666666';
#土曜日の色-薄色
our $saturday2textcolor='#6666EE';
#日曜・祝日-薄色
our $holiday2textcolor='#EE6666';

##=====================================================================================##
##メインルーチン
##=====================================================================================##

our @DATA;
our @WRDATA;
our @CALENDER;

##システム設定ファイル読込
our $servconf = '../admin/conf.dat';
our @SVCONF;
if (-e $servconf) {
	open(SVCFGRD,"$servconf");
	@SVCONF = <SVCFGRD>;
	close(SVCFGRD);
}
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($servconf);
if ($contCC eq 'shiftjis') {
	foreach (@SVCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}
our $DirMode =$SVCONF[0];
$DirMode =~ s/\r//g; $DirMode =~ s/\n//g;
our $ExecMode =$SVCONF[1];
$ExecMode =~ s/\r//g; $ExecMode =~ s/\n//g;
our $WRMode =$SVCONF[2];
$WRMode =~ s/\r//g; $WRMode =~ s/\n//g;
our $Domain =$SVCONF[3];
$Domain =~ s/\r//g; $Domain =~ s/\n//g;
our $PerlPath =$SVCONF[4];
$PerlPath =~ s/\r//g; $PerlPath =~ s/\n//g;
our $EditType =$SVCONF[5];
$EditType =~ s/\r//g; $EditType =~ s/\n//g;
our $EditName =$SVCONF[6];
$EditName =~ s/\r//g; $EditName =~ s/\n//g;
our $SendmailPath =$SVCONF[7];
$SendmailPath =~ s/\r//g; $SendmailPath =~ s/\n//g;
our $GmapAPIkey =$SVCONF[8];
$GmapAPIkey =~ s/\r//g; $GmapAPIkey =~ s/\n//g;
our $SysVersion =$SVCONF[9];
$SysVersion =~ s/\r//g; $SysVersion =~ s/\n//g;
our $RootPath =$SVCONF[10];
$RootPath =~ s/\r//g; $RootPath =~ s/\n//g;
our $LogoutTime =$SVCONF[11];
$LogoutTime =~ s/\r//g; $LogoutTime =~ s/\n//g;
our $PathConvert =$SVCONF[12];
$PathConvert =~ s/\r//g; $PathConvert =~ s/\n//g;
if ($LogoutTime eq '') { $LogoutTime='259200'; }
if ($DirMode eq '') { $DirMode ='0755'; }
if ($ExecMode eq '') { $ExecMode ='0755'; }
if ($WRMode eq '') { $WRMode ='0666'; }
if ($PerlPath eq '') { $PerlPath ='#!/usr/local/bin/perl'; }

##設定ファイル読込
our $conffile='./conf.dat';
our @CONF;
open(CONFRD,"$conffile");
@CONF = <CONFRD>;
close(CONFRD);
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($conffile);
if ($contCC eq 'shiftjis') {
	foreach (@CONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}
our $AdmiTitle =$CONF[0];
$AdmiTitle =~ s/\r//g;$AdmiTitle =~ s/\n//g;
our $FileTypeLine =$CONF[1];
$FileTypeLine =~ s/\r//g;$FileTypeLine =~ s/\n//g;
our @FileType=split(/:/,$FileTypeLine);
our $UploadMaxSize =$CONF[2];
$UploadMaxSize =~ s/\r//g;$UploadMaxSize =~ s/\n//g;
if ($UploadMaxSize eq '') { $UploadMaxSize=512; }
our $PageTitle =$CONF[3];
$PageTitle =~ s/\r//g;$PageTitle =~ s/\n//g;
our $PageHeadMsg =$CONF[4];
$PageHeadMsg =~ s/\r//g;$PageHeadMsg =~ s/\n//g;
our $HtmlHeader =$CONF[5];
$HtmlHeader =~ s/\r//g;$HtmlHeader =~ s/\n//g;
our $CalLayout =$CONF[6];
$CalLayout =~ s/\r//g;$CalLayout =~ s/\n//g;
our $TxtDayColor =$CONF[7];
$TxtDayColor =~ s/\r//g;$TxtDayColor =~ s/\n//g;
our $TxtSatColor =$CONF[8];
$TxtSatColor =~ s/\r//g;$TxtSatColor =~ s/\n//g;
our $TxtHoliColor =$CONF[9];
$TxtHoliColor =~ s/\r//g;$TxtHoliColor =~ s/\n//g;
our $BgDayColor =$CONF[10];
$BgDayColor =~ s/\r//g;$BgDayColor =~ s/\n//g;
our $BgSatColor =$CONF[11];
$BgSatColor =~ s/\r//g;$BgSatColor =~ s/\n//g;
our $BgHoliColor =$CONF[12];
$BgHoliColor =~ s/\r//g;$BgHoliColor =~ s/\n//g;
our $SkinFile =$CONF[13];
$SkinFile =~ s/\r//g;$SkinFile =~ s/\n//g;
our $DirName =$CONF[14];
$DirName =~ s/\r//g;$DirName =~ s/\n//g;
our $NaviBack =$CONF[15];
$NaviBack =~ s/\r//g;$NaviBack =~ s/\n//g;
our $NaviCurrent =$CONF[16];
$NaviCurrent =~ s/\r//g;$NaviCurrent =~ s/\n//g;
our $NaviNext =$CONF[17];
$NaviNext =~ s/\r//g;$NaviNext =~ s/\n//g;
our $MobiTitle =$CONF[18];
$MobiTitle =~ s/\r//g;$MobiTitle =~ s/\n//g;
our $MobiHeadMsg =$CONF[19];
$MobiHeadMsg =~ s/\r//g;$MobiHeadMsg =~ s/\n//g;
our $MobiDayColor =$CONF[20];
$MobiDayColor =~ s/\r//g;$MobiDayColor =~ s/\n//g;
our $MobiSatColor =$CONF[21];
$MobiSatColor =~ s/\r//g;$MobiSatColor =~ s/\n//g;
our $MobiHoliColor =$CONF[22];
$MobiHoliColor =~ s/\r//g;$MobiHoliColor =~ s/\n//g;
our $MobiTcolor =$CONF[23];
$MobiTcolor =~ s/\r//g;$MobiTcolor =~ s/\n//g;
our $MobiSkin =$CONF[24];
$MobiSkin =~ s/\r//g;$MobiSkin =~ s/\n//g;
our $MobiBack =$CONF[25];
$MobiBack =~ s/\r//g;$MobiBack =~ s/\n//g;
our $MobiCurrent =$CONF[26];
$MobiCurrent =~ s/\r//g;$MobiCurrent =~ s/\n//g;
our $MobiNext =$CONF[27];
$MobiNext =~ s/\r//g;$MobiNext =~ s/\n//g;
our $MobiToHome =$CONF[28];
$MobiToHome =~ s/\r//g;$MobiToHome =~ s/\n//g;
$MobiToHome =~ s/</&lt;/g;$MobiToHome =~ s/>/&gt;/g;
our $OutPutHTML =$CONF[37];
$OutPutHTML =~ s/\r//g;$OutPutHTML =~ s/\n//g;

our $vPageHeadMsg=$PageHeadMsg; $vPageHeadMsg =~ s/<br>/\n/g;
our $vHtmlHeader=$HtmlHeader; $vHtmlHeader =~ s/<br>/\n/g;
our $vMobiHeadMsg=$MobiHeadMsg; $vMobiHeadMsg =~ s/<br>/\n/g;
if ($NaviBack eq '') { $NaviBack='[＜＜ＢＡＣＫ]'; }
if ($NaviCurrent eq '') { $NaviCurrent='[今月を表示]'; }
if ($NaviNext eq '') { $NaviNext='[ＮＥＸＴ＞＞]'; }
if ($MobiBack eq '') { $MobiBack='[＜前月]'; }
if ($MobiCurrent eq '') { $MobiCurrent='[今月]'; }
if ($MobiNext eq '') { $MobiNext='[次月＞]'; }
if ($MobiToHome eq '') { $MobiToHome='[HOME]'; }

##転送許可ファイルタイプ
my $FtLot=@FileType-1; my $i=0;
our $FtypeTag;
for (0..$FtLot) {
	if ($FileType[$i] eq 'jpg') { $FtypeTag=$FtypeTag.'<option value="jpg">JPG画像</option>'; }
	elsif ($FileType[$i] eq 'gif') { $FtypeTag=$FtypeTag.'<option value="gif">GIF画像</option>'; }
	elsif ($FileType[$i] eq 'doc') { $FtypeTag=$FtypeTag.'<option value="doc">WORD書類</option>'; }
	elsif ($FileType[$i] eq 'docx') { $FtypeTag=$FtypeTag.'<option value="docx">WORD2007書類</option>'; }
	elsif ($FileType[$i] eq 'xls') { $FtypeTag=$FtypeTag.'<option value="xls">EXCEL書類</option>'; }
	elsif ($FileType[$i] eq 'xlsx') { $FtypeTag=$FtypeTag.'<option value="xlsx">EXCEL2007書類</option>'; }
	elsif ($FileType[$i] eq 'ppt') { $FtypeTag=$FtypeTag.'<option value="ppt">PPT書類</option>'; }
	elsif ($FileType[$i] eq 'pptx') { $FtypeTag=$FtypeTag.'<option value="pptx">PPT2007書類</option>'; }
	elsif ($FileType[$i] eq 'jtd') { $FtypeTag=$FtypeTag.'<option value="jtd">一太郎書類</option>'; }
	elsif ($FileType[$i] eq 'txt') { $FtypeTag=$FtypeTag.'<option value="txt">テキスト書類</option>'; }
	elsif ($FileType[$i] eq 'pdf') { $FtypeTag=$FtypeTag.'<option value="pdf">PDF書類</option>'; }
	elsif ($FileType[$i] eq 'mp3') { $FtypeTag=$FtypeTag.'<option value="mp3">MP3音声</option>'; }
	elsif ($FileType[$i] eq 'mmf') { $FtypeTag=$FtypeTag.'<option value="mmf">MMF音声</option>'; }
	elsif ($FileType[$i] eq 'mld') { $FtypeTag=$FtypeTag.'<option value="mld">MLD音声</option>'; }
	elsif ($FileType[$i] eq 'wma') { $FtypeTag=$FtypeTag.'<option value="wma">WMA音声</option>'; }
	elsif ($FileType[$i] eq 'wmv') { $FtypeTag=$FtypeTag.'<option value="wmv">WMV動画</option>'; }
	elsif ($FileType[$i] eq 'mp4') { $FtypeTag=$FtypeTag.'<option value="mp4">MPEG4動画</option>'; }
	elsif ($FileType[$i] eq '3gp') { $FtypeTag=$FtypeTag.'<option value="3gp">3GPP動画</option>'; }
	elsif ($FileType[$i] eq '3g2') { $FtypeTag=$FtypeTag.'<option value="3g2">3GPP2動画</option>'; }
	elsif ($FileType[$i] eq 'zip') { $FtypeTag=$FtypeTag.'<option value="zip">ZIPファイル</option>'; }
	elsif ($FileType[$i] eq 'lzh') { $FtypeTag=$FtypeTag.'<option value="lzh">LZHファイル</option>'; }
	$i++;
}

##転送許可ファイルのサイズ上限
if ($UploadMaxSize < 1024) {
	$ViewMaxSize= $UploadMaxSize."KB";
} else {
	$UploadMax2Size = int($UploadMaxSize*10/1024)/10;
	$ViewMaxSize= $UploadMax2Size."MB";
}
$MaxDataSize=$UploadMaxSize*1024;

##編集者IDパスワード読込
if (open(PASSRD,"$passfile")) {
	@PASSID = <PASSRD>;
	$admin_id =$PASSID[0];
	$admin_id =~ s/\r//g; $admin_id =~ s/\n//g;
	$admin_pw =$PASSID[1];
	$admin_pw =~ s/\r//g; $admin_pw =~ s/\n//g;
	$admin_pw =crypt($admin_pw,'ae');
	close(PASSRD);
} else {
	$admin_id =$adid;
	$admin_pw =$adpw;
	$admin_pw =crypt($admin_pw,'ae');
}

##日付・時刻情報の取得
$ENV{'TZ'} = "JST-9";
our($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
$year += 1900;
$mon++;
$mon= sprintf("%02d",$mon);
$mday=sprintf("%02d",$mday);
$hour=sprintf("%02d",$mday);
$min= sprintf("%02d",$mday);
$youbi = ('日','月','火','水','木','金','土') [$wday];
$DATE = $year.'/'.$mon.'/'.$mday.' '.$hour.':'.min;

##AGENTの取得
$agent = $ENV{'HTTP_USER_AGENT'};
$agent =~ s/\,/\./g;

##フォームの取得
our %in;
our @in;
our $upfile;
if ($MaxDataSize < $ENV{'CONTENT_LENGTH'}) { &error('添付ファイル容量オーバー'); }
my $query = CGI->new;
*in = $query->Vars();
our $vyear = $in{'vyear'};
if ($vyear eq '') { $vyear = "$year"; }
our $vmonth = $in{'vmonth'};
if ($vmonth eq '') { $vmonth = "$mon"; }

##アップロードファイルの取得
if ($in{'img0file'} ne '') {
	my $query = CGI->new; 
	$upfile= $query->param('img0file'); 
}

$wg=$in{'wg'};
if ($wg eq '') { $wg=0; }

##==============メインアクション==============

##ログイン認証
$LoginFlag='false'; $edituser=0;
if ($in{'loging'} eq "new") {
	# フォーム認証
	$input_id = $in{'admin_id'};
	$input_pw = $in{'admin_pw'};
	$input_pw =crypt($input_pw,'ae');
	if ($input_id ne $admin_id) { $edituser=1; }
	if ($input_pw ne $admin_pw) { $edituser=1; }
	if ($edituser==1) {
		@passline=grep(/EditUser\t$input_id\t/,@PASSID);
		@passdatas=split(/\t/,$passline[0]);
		$admin_id=$passdatas[1];
		$admin_pw=$passdatas[2];
		$admin_pw =crypt($admin_pw,'ae');
		if ($input_id ne $admin_id) { &error('認証エラー'); }
		if ($input_pw ne $admin_pw) { &error('認証エラー'); }
		$EditUser='user';
	} else { $EditUser='admin'; }
	&set_cookie;
	$LoginFlag='true';
} else {
	# クッキー認証
	&get_cookie;
	if (($ck_id eq $admin_id)&&($ck_pw eq $admin_pw)) {
			$LoginFlag='true'; $EditUser='admin';
	} else {
		@passline=grep(/EditUser\t$ck_id\t/,@PASSID);
		@passdatas=split(/\t/,$passline[0]);
		$admin_id=$passdatas[1];
		$admin_pw=$passdatas[2];
		$admin_pw =crypt($admin_pw,'ae');
		if (($ck_id eq $admin_id)&&($ck_pw eq $admin_pw)) {
			$LoginFlag='true'; $EditUser='user';
		}
	}
}

# 処理分岐
if ($LoginFlag eq 'true') {
	if ($in{'mode'} eq 'admin') { &admin; }
	elsif ($in{'mode'} eq 'regist') { &regist; }
	elsif ($in{'mode'} eq 'delete') { &delete; }
	elsif ($in{'mode'} eq 'input') { &input; }
	elsif ($in{'mode'} eq 'delregist') { &delregist; }
	elsif ($in{'mode'} eq 'onoff') { &onoff; }
	else { &admin; }
} else {
	&login;
}

exit;

##=====================================================================================##
##メインルーチン
##=====================================================================================##
sub html_head {

if ($in{'mode'} eq 'input') {
 $JkCalTag='<script type="text/javascript" src="../admin/wysiwyg/scripts/jkl-calendar.js"></script>';
} else { $JkCalTag=''; }
if (($in{'mode'} eq 'input')&&($wg==1)) {
$htWYSIWYG = <<"WYSIWYG";
<script type="text/javascript" src="../admin/wysiwyg/scripts/wysiwyg.js"></script>
<script type="text/javascript" src="../admin/wysiwyg/scripts/wysiwyg-settings.js"></script>
<script type="text/javascript">
	//WYSIWYG.attach('all', full/small);
	WYSIWYG.attach('openWYSIWYG$DirName', full);
</script>
WYSIWYG
} else {
$htWYSIWYG = <<"WYSIWYG";
<script language="JavaScript"><!--
function AddRows(targetObj) {
  var obj = document.getElementsByName(targetObj)[0];
  obj.rows = obj.rows+5;
}
--></script>
WYSIWYG
}

##★HTMLヘッダの変更はここを訂正
$html_head = <<"HTMLHEAD";
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>$AdmiTitle - 編集画面</title>
<meta http-equiv="Content-Script-Type" content="text/javascript">
$JkCalTag $htWYSIWYG
<link rel="stylesheet" href="../admin/style.css" type="text/css">
</head>
<body>
<div align="right">コンテンツ確認
<a href="index.cgi" target="_blank">[ＰＣサイト]</a>
<a href="mobi.cgi" target="_blank">[携帯サイト]</a>
</div>
<h3 align=center>$AdmiTitle - 編集画面</h3>
HTMLHEAD

print "Content-type: text/html\n\n";
print "$html_head\n";

}
##=======================================================================================
sub html_foot {

##★HTMLフッタの変更はここを訂正
$html_foot = <<"HTMLFOOT";
</body>
</html>
HTMLFOOT

print "$html_foot\n";

}
##=======================================================================================
sub login {

##★ログイン画面の変更はここを訂正
$html_login = <<"LOGINHTML";
<div align="center">
<form method="post" action="$cginame">
<br>
<h5 align=center style="color:red">セッションタイムアウト</h5>
<h4 align=center>管理画面 再ログイン</h4>
<div align=center>ログインID　<input type="text" name="admin_id" size="25" value="$ck_id" class="Hankaku"></div>
<div align=center>パスワード　<input type="password" name="admin_pw" size="25" value="$ck_pw" class="Hankaku"></div>
<div align="center">
<input type="submit" name="submit" value="ログイン">
<input type="reset" value="リセット">
<input type="hidden" name="mode" value="admin">
<input type="hidden" name="loging" value="new">
</div>
</form>
LOGINHTML

&html_head;
print "$html_login\n";
&html_foot;

exit;
}
##=======================================================================================
sub admin {

##★折畳み機能JS
$JSadminview=1300;
$JsFols = <<"JsFols";
<script language="JavaScript"><!--
function jsKiji(selectedID) {
  var xid; var targIDname; var obj;
  if(document.getElementById) {
    if (selectedID == 'AllHide') {
      for (xid=1000; xid<$JSadminview; xid++) {
        targIDname='xKiji'+xid;
        obj = document.getElementById(targIDname);
        if(obj) {
          obj.className = 'DisplayHide';
        }
      }
    } else if (selectedID == 'AllShow') {
      for (xid=1000; xid<$JSadminview; xid++) {
        targIDname='xKiji'+xid;
        obj = document.getElementById(targIDname);
        if(obj) {
          obj.className = 'DisplayShow';
        }
      }
    } else {
      obj = document.getElementById(selectedID);
      if(obj) {
        if (obj.className == 'DisplayHide') {
          obj.className = 'DisplayShow';
        } else {
          obj.className = 'DisplayHide';
        }
      }
    }
  }
}
--></script>
JsFols
$NaviFols='<div align="right"><img src="../admin/img/fols.gif" align="absmiddle" border="0">'
	.'<a href="javascript:void(0);" onclick="javascript:jsKiji('."\'".'AllShow'."\'".');">[記事を表示]</a>'
	.'<a href="javascript:void(0);" onclick="javascript:jsKiji('."\'".'AllHide'."\'".');">[非表示]</a></div>';


$view_month = int($vmonth);
$TableTitle = "$vyear"."年"." $view_month"."月";

#★ナビボタン定義
if ($vmonth eq "01") {
	$nextyear = $vyear;		$nextmonth = int($vmonth)+1;
	$lastyear = $vyear-1;	$lastmonth = 12;
} elsif ($vmonth eq "12") {
	$nextyear = $vyear+1;	$nextmonth = 1;
	$lastyear = $vyear;		$lastmonth = int($vmonth)-1;
} else {
	$nextyear = $vyear;		$nextmonth = int($vmonth)+1;
	$lastyear = $vyear;		$lastmonth = int($vmonth)-1;
}
$nextmonth=sprintf("%02d",$nextmonth);
$lastmonth=sprintf("%02d",$lastmonth);
$MnextTag = "<a href=\"$cginame?mode=admin&vyear=$nextyear&vmonth=$nextmonth&wg=$wg\">[ＮＥＸＴ≫]</a>";
$MprevTag = "<a href=\"$cginame?mode=admin&vyear=$lastyear&vmonth=$lastmonth&wg=$wg\">[≪ＰＲＥＶ]</a>";
$vnextyear=$vyear+1;
$vprevyear=$vyear-1;
$YnextTag = "<a href=\"$cginame?mode=admin&vyear=$vnextyear&vmonth=$vmonth&wg=$wg\">[≫]</a>";
$YprevTag = "<a href=\"$cginame?mode=admin&vyear=$vprevyear&vmonth=$vmonth&wg=$wg\">[≪]</a>";
$CurrentTag = "<a href=\"$cginame?mode=admin&vyear=$year&vmonth=$mon&wg=$wg\">[今月表\示]</a>";

##★管理画面前半の変更はここを訂正
$htmla_admin = <<"ADMINA";
<hr size="1" align="center">
<h4 align="center">カレンダー編集</h4>
<hr size="1" align="center">
$JsFols
$NaviFols
<br>
<table width="95%" border="1" cellspacing="0" cellpadding="5" align="center" bgcolor="#FFFFFF">
ADMINA

##★ナビボタンの変更はここを訂正
$navi_button = <<"NAVIBTN";
  <tr>
    <td bgcolor="#eeeeee" colspan="3" align="center">
    $YprevTag $MprevTag 　　　　　 <strong>$TableTitle</strong>$CurrentTag 　　　　　 $MnextTag $YnextTag
    </td>
  </tr>
NAVIBTN

##★管理画面後半の変更はここを訂正
$htmlb_admin = <<"ADMINB";
</table>
<br>
$NaviFols
ADMINB

&html_head;
print $htmla_admin;
print $navi_button;
&list_admin;
print $navi_button;
print $htmlb_admin;
&html_foot;

exit;
}
##=======================================================================================
sub list_admin {

$srcdate = "$vyear"."$vmonth";
$srcday = "$vyear"."$vmonth"."01";
$todaydate = "$year"."$mon";
$zennjitsuHoliFlag=0;
$zennjitsuHoliCheck=0;
$yokujitsuHoliFlag=0;

&calender_read;
$v_yearmonth = $srcdate;
$r_lastday = &calendlib'getmday($v_yearmonth);
$v_lastday = $r_lastday - 1;
$v_topweek = &calendlib'getweek($srcday);

&data_read;

if ($v_topweek eq "sun") { @v_youbi = ('日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土'); }
elsif ($v_topweek eq "mon") { @v_youbi = ('月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日'); }
elsif ($v_topweek eq "tue") { @v_youbi = ('火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月'); }
elsif ($v_topweek eq "wed") { @v_youbi = ('水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火'); }
elsif ($v_topweek eq "thu") { @v_youbi = ('木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水'); }
elsif ($v_topweek eq "fri") { @v_youbi = ('金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木'); }
elsif ($v_topweek eq "sat") { @v_youbi = ('土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金'); }
@v_weekcnt = ('1','1','1','1','1','1','1','2','2','2','2','2','2','2','3','3','3','3','3','3','3','4','4','4','4','4','4','4','5','5','5');

$daycount=1;
$weekcount=0;

#暦情報取得(春分日/秋分日)
if ($vmonth eq '03') {
	my $spday=&calendlib'getspring($vyear);
	$spday=sprintf("%02d",$spday);
	my $spformat='monthday='.$vmonth.$spday."\t".'dayname=春分の日'."\t".'condition=holiday'."\t\n";
	push(@CALENDER,$spformat);
} elsif ($vmonth eq '09') {
	my $spday=&calendlib'getautmn($vyear);
	$spday=sprintf("%02d",$spday);
	my $spformat='monthday='.$vmonth.$spday."\t".'dayname=秋分の日'."\t".'condition=holiday'."\t\n";
	push(@CALENDER,$spformat);
}

#カレンダーリスト出力
$sh=1000;
for (0..$v_lastday) {
	$dayname='';
	$condition='';
	$daytablecolor = $weekdaycolor;
	$daytextcolor = $weekdaytextcolor;
	if ($a_furikae==1) { $b_furikae=1; }
	$yokujitsuHoliFlag=0;
	if ($zennjitsuHoliCheck==1) { $zennjitsuHoliCheck=0; $zennjitsuHoliFlag=1; }
	else { $zennjitsuHoliCheck=0; $zennjitsuHoliFlag=0; }
	#日数桁数調整
	if ($daycount < 10) { $caldaycount = "0"."$daycount"; }
	else { $caldaycount = $daycount; }
	#祝日判定(固定月日タイプ)
	$va_monthday = "$vmonth"."$caldaycount";
	@HOLIDAYA = grep(/monthday=$va_monthday/,@CALENDER);
	if (@HOLIDAYA) {
		@HALINE = split(/\t/,$HOLIDAYA[0]);
		foreach (@HALINE) {
			($key, $value) = split(/=/,$_);
			$HOLA{$key} = $value;
		}
		$dayname = $HOLA{'dayname'};
		$condition = $HOLA{'condition'};
		if ($HOLA{'condition'} eq 'holiday') { $zennjitsuHoliCheck=1; }
	}
	#祝日判定(第Ｘ曜日タイプ)
	if ($v_youbi[$weekcount] eq "日") { $vc_weekday = "sun"; }
	elsif ($v_youbi[$weekcount] eq "月") { $vc_weekday = "mon"; }
	elsif ($v_youbi[$weekcount] eq "火") { $vc_weekday = "tue"; }
	elsif ($v_youbi[$weekcount] eq "水") { $vc_weekday = "wed"; }
	elsif ($v_youbi[$weekcount] eq "木") { $vc_weekday = "thu"; }
	elsif ($v_youbi[$weekcount] eq "金") { $vc_weekday = "fri"; }
	elsif ($v_youbi[$weekcount] eq "土") { $vc_weekday = "sat"; }
	$vb_monthday = "$vmonth"."$vc_weekday"."$v_weekcnt[$weekcount]";
	@HOLIDAYB = grep(/monthday=$vb_monthday/,@CALENDER);
	if (@HOLIDAYB) {
		@HBLINE = split(/\t/,$HOLIDAYB[0]);
		foreach (@HBLINE) {
			($key, $value) = split(/=/,$_);
			$HOLB{$key} = $value;
		}
		$dayname = $HOLB{'dayname'};
		$condition = $HOLB{'condition'};
		if ($HOLB{'condition'} eq 'holiday') { $zennjitsuHoliCheck=1; }
	}
	#国民の休日判定(前後が祝日である)
	$xthisdate=$vyear.$vmonth.''.sprintf("%02d",$daycount);
	$xnextdate=&calendlib'gettomorrow($xthisdate);
	$xnextyear=substr($xnextdate,0,4);
	$xnextmon= substr($xnextdate,4,2);
	$xnextday= substr($xnextdate,6,2);
	if ($vc_weekday eq "sun") { $xnextweek = "mon"; }
	elsif ($vc_weekday eq "mon") { $xnextweek = "tue"; }
	elsif ($vc_weekday eq "tue") { $xnextweek = "wed"; }
	elsif ($vc_weekday eq "wed") { $xnextweek = "thu"; }
	elsif ($vc_weekday eq "thu") { $xnextweek = "fri"; }
	elsif ($vc_weekday eq "fri") { $xnextweek = "sat"; }
	elsif ($vc_weekday eq "sat") { $xnextweek = "sun"; }
	#翌日が固定月日タイプの祝日の場合
	@xNextHoliday=();
	@xNextHolipre=grep(/monthday=$xnextmon$xnextday\t/,@CALENDER);
	@xNextHoliday=grep(/\tcondition=holiday\t/,@xNextHolipre);
	$LotNextHoliday=@xNextHoliday;
	if ($LotNextHoliday>0) { $yokujitsuHoliFlag=1; }
	#翌日が第Ｘ曜日タイプの祝日の場合
	if ($daycount==$r_lastday) { $xnextwcount=1; } else { $xnextwcount=$v_weekcnt[$weekcount+1]; }
	@xNextHoliday=();
	@xNextHolipre=grep(/monthday=$xnextmon$xnextweek$xnextwcount\t/,@CALENDER);
	@xNextHoliday=grep(/\tcondition=holiday\t/,@xNextHolipre);
	$LotNextHoliday=@xNextHoliday;
	if ($LotNextHoliday>0) { $yokujitsuHoliFlag=1; }
	if (($zennjitsuHoliFlag==1)&&($yokujitsuHoliFlag==1)) {
		$daytablecolor = $holidaycolor;
		$daytextcolor = $holidaytextcolor;
		$daytablecolor = $holidaycolor;
		$daytextcolor = $holidaytextcolor;
		if ($dayname eq '') { $dayname = '国民の休日'; }
	}
	#振替休日判定
	if ($v_youbi[$weekcount] eq "日") { $daytablecolor = $holidaycolor; $daytextcolor = $holidaytextcolor; }
	if ($v_youbi[$weekcount] eq "土") { $daytablecolor = $saturdaycolor; $daytextcolor = $saturdaytextcolor;}
	if ($condition eq "holiday") {
		$daytablecolor = $holidaycolor;
		$daytextcolor = $holidaytextcolor;
		if ($v_youbi[$weekcount] eq "日") { $a_furikae=1; }
	}
	if (($b_furikae == 1) && ($condition ne "holiday")) {
		$daytablecolor = $holidaycolor;
		$daytextcolor = $holidaytextcolor;
		$dayname = '振替休日';
		$a_furikae=0;
	}
	
	#各日データ読込出力
	$v_thisday = "$srcdate"."$caldaycount";
	@VIEWDATA = grep(/code=$v_thisday/,@DATA);
	$v1_lot = (@VIEWDATA);
	$v2_lot = $v1_lot + 1;
	if ($v2_lot == 2) { $v2_lot = 2; }
	
	$v_rowspan=$v2_lot;
	
	print"<tr>\n";
	print"  <td bgcolor=\"$daytablecolor\" width=\"10\%\" rowspan=\"$v_rowspan\" align=\"center\">\n";
	print"  <font color=\"$daytextcolor\"><b>$daycount ($v_youbi[$weekcount])</b></font><br>$dayname</td>\n";
	if ($v1_lot != 0) {
		foreach $vd_line (@VIEWDATA) {
			@VIEWLINE = split(/\t/,$vd_line);
			foreach (@VIEWLINE) {
				($key, $value) = split(/=/,$_);
				$VIEWDATA{$key} = $value;
			}
			
			$v_code = $VIEWDATA{'code'};
			$v_show = $VIEWDATA{'show'};
			$v_date = $VIEWDATA{'date'};
			$v_title = $VIEWDATA{'title'};
				$v_title =~ s/\|amp\|/\&/g;
				$v_title =~ s/\|eq\|/=/g;
				$v_title =~ s/\|quot\|/\"/g;
				$v_title =~ s/\|squot\|/\'/g;
				$v_title = &tag_change($v_title);
			$v_message = $VIEWDATA{'message'};
				$v_message =~ s/\|amp\|/\&/g;
				$v_message =~ s/\|eq\|/=/g;
				$v_message =~ s/\|quot\|/\"/g;
				$v_message =~ s/\|squot\|/\'/g;
				$v_message =~ s/\|br\|//g;
				$v_message =~ s/<\!--\#include/&lt;\!--\#include/g;
				$v_message = &tag_change($v_message);
				$v_message = &inline_link($v_message);
			$v_url = $VIEWDATA{'url'};
			$v_mrl = $VIEWDATA{'mrl'};
			##添付ファイルがあれば表示
			$FtLot=@FileType-1;$i=0;
			for (0..$FtLot) {
				$f_filepath = $img_dir.$v_code.'0.'.$FileType[$i];
				$h_filepath = $img_path.$v_code.'0.'.$FileType[$i];
				if ($FileType[$i] eq 'jpg') { $FtypeName='[JPG画像]'; }
				elsif ($FileType[$i] eq 'gif') { $FtypeName='[GIF画像]'; }
				elsif ($FileType[$i] eq 'doc') { $FtypeName='[WORD書類]'; }
				elsif ($FileType[$i] eq 'docx') { $FtypeName='[WORD2007書類]'; }
				elsif ($FileType[$i] eq 'xls') { $FtypeName='[EXCEL書類]'; }
				elsif ($FileType[$i] eq 'xlsx') { $FtypeName='[EXCEL2007書類]'; }
				elsif ($FileType[$i] eq 'ppt') { $FtypeName='[PPT書類]'; }
				elsif ($FileType[$i] eq 'pptx') { $FtypeName='[PPT2007書類]'; }
				elsif ($FileType[$i] eq 'jtd') { $FtypeName='[一太郎書類]'; }
				elsif ($FileType[$i] eq 'txt') { $FtypeName='[テキスト書類]'; }
				elsif ($FileType[$i] eq 'pdf') { $FtypeName='[PDF書類]'; }
				elsif ($FileType[$i] eq 'mp3') { $FtypeName='[MP3音声]'; }
				elsif ($FileType[$i] eq 'wma') { $FtypeName='[WMA音声]'; }
				elsif ($FileType[$i] eq 'mmf') { $FtypeName='[MMF音声]'; }
				elsif ($FileType[$i] eq 'mld') { $FtypeName='[MLD音声]'; }
				elsif ($FileType[$i] eq 'wmv') { $FtypeName='[WMV動画]'; }
				elsif ($FileType[$i] eq 'mp4') { $FtypeName='[MPEG4動画]'; }
				elsif ($FileType[$i] eq '3gp') { $FtypeName='[3GPP動画]'; }
				elsif ($FileType[$i] eq '3g2') { $FtypeName='[3GPP2動画]'; }
				elsif ($FileType[$i] eq 'zip') { $FtypeName='[ZIPファイル]'; }
				elsif ($FileType[$i] eq 'lzh') { $FtypeName='[LZHファイル]'; }
				if (-e $f_filepath) {
					$v_filetag = '<a href='.$h_filepath.' target=top><img src=../icon/'.$FileType[$i]
						.'.gif align=absmiddle border=0>'.$FtypeName.'</a>　';
					last;
				} else { $v_filetag=''; }
				$i++;
			}
			#記事出力
			&list_2admin;
			
			$v_code = "";
			$v_date = "";
		}
	}
	$ldaytextcolor=$daytextcolor;
	$ldaytextcolor =~ s/$weekdaytextcolor/$weekday2textcolor/g;
	$ldaytextcolor =~ s/$saturdaytextcolor/$saturday2textcolor/g;
	$ldaytextcolor =~ s/$holidaytextcolor/$holiday2textcolor/g;
	print"  <td bgcolor=\"$weekdaycolor\" width=\"80\%\" align=\"right\">\n";
	print"  <font color=\"$ldaytextcolor\">$daycount ($v_youbi[$weekcount])</font><br><font color=\"#666666\">$dayname</font></td>\n";
	print"  <td bgcolor=\"$weekdaycolor\" width=\"10\%\">\n";
	print"    <form action=\"$cginame\" method=\"POST\">\n";
	print"      <input type=\"submit\" name=\"submit\" value=\"新規登録\">\n";
	print"      <input type=\"hidden\" name=\"mode\" value=\"input\">\n";
	print"      <input type=\"hidden\" name=\"type\" value=\"new\">\n";
	print"      <input type=\"hidden\" name=\"vyear\" value=\"$vyear\">\n";
	print"      <input type=\"hidden\" name=\"vmonth\" value=\"$vmonth\">\n";
	print"      <input type=\"hidden\" name=\"i_year\" value=\"$vyear\">\n";
	print"      <input type=\"hidden\" name=\"i_month\" value=\"$vmonth\">\n";
	print"      <input type=\"hidden\" name=\"i_day\" value=\"$caldaycount\">\n";
	print"      <input type=\"hidden\" name=\"i_weekday\" value=\"$v_youbi[$weekcount]\">\n";
	print"      <input type=\"hidden\" name=\"i_color\" value=\"$daytextcolor\">\n";
	print"      <input type=\"hidden\" name=\"i_dayname\" value=\"$dayname\">\n";
	print"      <input type=\"hidden\" name=\"wg\" value=\"$wg\">\n";
	print"    </form>\n";
	print"  </td>\n";
	print"</tr>\n";
	
	$daycount++;
	$weekcount++;
	$b_furikae=0;
}

}
##=======================================================================================
sub list_2admin {

$java2 = <<"JVB";
<script language="Javascript"><!--
function conf$v_code() {
if (confirm("$v_date\\(code\\:$v_code\\)を削除しますか？"))
{ location.href="./$cginame?mode=delete&delcode=$v_code&vyear=$vyear&vmonth=$vmonth&wg=$wg"; }
}
// -->
</script>
JVB

##詳細記事URL
if ($VIEWDATA{'title'} ne '') {
	if ($RootPath ne '') {
		$KijiURL='<br><b>詳細ページURL：</b> http://'.$Domain.'/'.$RootPath.'/'.$DirName.'/index.cgi?pg='.$v_code;
	} else {
		$KijiURL='<br><b>詳細ページURL：</b> http://'.$Domain.'/'.$DirName.'/index.cgi?pg='.$v_code;
	}
} else { $KijiURL=''; }

##★編集画面リストの変更はここを訂正
if ($v_show eq 'off') { $showStyle='#ffeeee'; } else { $showStyle='#eeeeee'; }

$htmld_admin = <<"ADMIND";
<td bgcolor="$weekdaycolor" width="70\%">
<div style="background-color:$showStyle; padding:2px; margin-bottom:3px;">
<a href="javascript:void(0);" onclick="javascript:jsKiji('xKiji$sh');"><img src="../admin/img/fols.gif" align="absmiddle" border="0"></a>
Time $v_date <br>
<b>$v_title</b>
</div>
<div id="xKiji$sh" class="DisplayShow">
$v_message
<hr size=1>
<b>添付ファイル：</b> $v_filetag
<b>参照URL：</b> PC: $v_url 　 携帯: $v_mrl <br>
<b>公開モード：</b>
<a href="$cginame?mode=onoff&code=$v_code&pline=$input_pline&vyear=$vyear&vmonth=$vmonth">[ $v_show ]</a>
<b>プレビュー：</b>
<a href="index.cgi?mode=preview&vyear=$vyear&vmonth=$vmonth" target="_blank">[ＰＣサイト]</a>
<a href="mobi.cgi?mode=preview&vyear=$vyear&vmonth=$vmonth" target="_blank">[携帯サイト]</a>
$KijiURL
</div>
</td>
<td bgcolor="$weekdaycolor" width="5\%">
$java2
  <form action="$cginame" method="POST">
  <input type="submit" name="submit" value="変更">
  <input type="button" value="削除" onClick="conf$v_code()">
  <input type="hidden" name="mode" value="input">
  <input type="hidden" name="type" value="correct">
  <input type="hidden" name="code" value="$v_code">
  <input type="hidden" name="vyear" value="$vyear">
  <input type="hidden" name="vmonth" value="$vmonth">
  <input type="hidden" name="i_year" value="$vyear">
  <input type="hidden" name="i_month" value="$vmonth">
  <input type="hidden" name="i_day" value="$caldaycount">
  <input type="hidden" name="i_weekday" value="$v_youbi[$weekcount]">
  <input type="hidden" name="i_color" value="$daytextcolor">
  <input type="hidden" name="i_dayname" value="$dayname">
  <input type="hidden" name="wg" value="$wg">
  </form>
  </td>
</tr>
<tr>
ADMIND

print "$htmld_admin\n";
$sh++;

}
##=======================================================================================
sub input {

##★フォーム取得
$input_code = $in{'code'};
$input_type = $in{'type'};
$input_year = $in{'i_year'};
$input_month = $in{'i_month'};
$input_day = $in{'i_day'};
$input_hour = substr($input_code,8,2);
if ($input_hour eq '') { $input_hour='00'; }
$input_min = substr($input_code,10,2);
if ($input_min eq '') { $input_min='00'; }
$input_weekday = $in{'i_weekday'};
$input_daycolor = $in{'i_color'};
$input_dayname = $in{'i_dayname'};

##★データ読込
&data_read;
@CRDATA = grep(/code=$input_code\t/,@DATA);
@CRLINE = split(/\t/,$CRDATA[0]);
foreach (@CRLINE) {
	($key, $value) = split(/=/,$_);
	$FILE{$key} = $value;
}
$v_code = $FILE{'code'};
$v_show = $FILE{'show'};
$v_date = $FILE{'date'};
$v_title = $FILE{'title'};
	$v_title =~ s/\|amp\|/\&/g;
	$v_title =~ s/\|eq\|/=/g;
	$v_title =~ s/\|quot\|/&quot;/g;
	$v_title =~ s/\"/&quot;/g;
	$v_title =~ s/\|squot\|/\'/g;
	$v_title = &tag_change($v_title);
$v_message = $FILE{'message'};
	$v_message =~ s/\|amp\|/\&/g;
	$v_message =~ s/\|eq\|/=/g;
	$v_message =~ s/\|quot\|/&quot;/g;
	$v_message =~ s/\|squot\|/\'/g;
	$v_message = &tag_change($v_message);
	$v_message = &inline_link($v_message);
	if ($in{'wg'} eq "1") {
		$v_message =~ s/\|br\|/\n/g;
		$v_message =~ s/&quot;/\"/g;
	} else {
		$v_message =~ s/\|br\|/\n/g;
		$v_message =~ s/<br>/\n/g;
		$v_message =~ s/&lt;/&amp;lt;/g;
		$v_message =~ s/&gt;/&amp;gt;/g;
	}
$v_url = $FILE{'url'};
	$v_url =~ s/\|amp\|/\&/g;
	$v_url =~ s/\|eq\|/=/g;
	$v_url =~ s/\|quot\|/\"/g;
	$v_url =~ s/\|squot\|/\'/g;
$v_targ = $FILE{'targ'};
$v_mrl = $FILE{'mrl'};
	$v_mrl =~ s/\|amp\|/\&/g;
	$v_mrl =~ s/\|eq\|/=/g;
	$v_mrl =~ s/\|quot\|/\"/g;
	$v_mrl =~ s/\|squot\|/\'/g;

##★データ補正
if ($FILE{'show'} eq "on") {
	$cor1show = " selected";
	$cor2show = "";
} elsif ($FILE{'show'} eq "off") {
	$cor1show = "";
	$cor2show = " selected";
} else {
	$cor1show = " selected";
	$cor2show = "";
}
if ($FILE{'targ'} eq "_self") {
	$targ1 = " selected";
} elsif ($FILE{'targ'} eq "_blank") {
	$targ2 = " selected";
} elsif ($FILE{'targ'} eq "_parent") {
	$targ3 = " selected";
} elsif ($FILE{'targ'} eq "_top") {
	$targ4 = " selected";
} else {
	$targ1 = " selected";
}

##★新規or変更振分処理
if ($input_type eq 'new') {
	$i_flag = "<font color=#ff0000> [新規登録] </font>\n";
	$i1_button = "<input type=\"submit\" value=\"上記内容で登録\">";
	$i2_button = "<input type=\"hidden\" name=\"mode\" value=\"regist\">";
	$i3_button = "";
	$i4_button = "";
} elsif ($input_type eq 'correct') {
	$i_flag = "<font color=#0000ff> [内容変更] </font>\n";
	$i1_button = "<input type=\"submit\" value=\"上記内容に訂正\">";
	$i2_button = "<input type=\"hidden\" name=\"mode\" value=\"delregist\">";
	$i3_button = "<input type=\"hidden\" name=\"delcode\" value=\"$input_code\">";
	$i4_button = "<input type=\"checkbox\" name=\"copy\" value=\"1\"> 記事複製";
}

##★WYSIWYGフラグ
if ($FILE{'wg'}==1) { $swHtFlag=' checked'; }
$bReq='&mode='.$in{'mode'}.'&type='.$in{'type'}.'&code='.$in{'code'}.'&vyear='.$in{'vyear'}.'&vmonth='.$in{'vmonth'}.'&i_year='.$in{'i_year'}
.'&i_month='.$in{'i_month'}.'&i_day='.$in{'i_day'}.'&i_weekday='.$in{'i_weekday'}.'&i_color='.$in{'i_color'}.'&i_dayname='.$in{'i_dayname'};
if ($wg==1) {
	$swWYSIWYG='<a href="'.$cginame.'?&wg=0'.$bReq.'">'
		.'<img src="../admin/img/wgSW.gif" border="0" align="absmiddle"> [シンプルモードへ切替]</a>'
		.' <small>FireFoxなどのブラウザでは、いったん半角英数で何か入力すると日本語入力できるようになります</small>';
	$swImageFile1='<!--';
	$swImageFile2='--><input type=hidden name=file0ext value=none><input type=hidden name=file1ext value=none><input type=hidden name=align value=none>';
	$swHTML='';
	$TextAreaHeight='10';
} else {
	$swWYSIWYG='<a href="'.$cginame.'?wg=1'.$bReq.'">'
		.'<img src="../admin/img/wgSW.gif" border="0" align="absmiddle"> [エディタモードへ切替]</a>';
	$swImageFile1='';	$swImageFile2='';
	$swHTML='<input type="checkbox" name="HtmlTag"'.$swHtFlag.'>HTMLソースとして入力 [改行する場合、&lt;br&gt;タグを挿入]';
	$TextAreaHeight='10';
}

##★日付表示
$iv_month = int($input_month);
$iv_day = int($input_day);
$thistable = $input_year.'年 '.$iv_month.'月 '.$iv_day.'日 ('.$input_weekday.'曜日)';
$thisdayname= '<div align="center" style="color:$input_daycolor;">'.$input_dayname.'</div>';

##★添付ファイルがあれば表示
$FtLot=@FileType-1;$i=0;
for (0..$FtLot) {
	$f_filepath = $img_dir.$v_code.'0.'.$FileType[$i];
	$h_filepath = $img_path.$v_code.'0.'.$FileType[$i];
	if ($FileType[$i] eq 'jpg') { $FtypeName='[JPG画像]'; }
	elsif ($FileType[$i] eq 'gif') { $FtypeName='[GIF画像]'; }
	elsif ($FileType[$i] eq 'doc') { $FtypeName='[WORD書類]'; }
	elsif ($FileType[$i] eq 'docx') { $FtypeName='[WORD2007書類]'; }
	elsif ($FileType[$i] eq 'xls') { $FtypeName='[EXCEL書類]'; }
	elsif ($FileType[$i] eq 'xlsx') { $FtypeName='[EXCEL2007書類]'; }
	elsif ($FileType[$i] eq 'ppt') { $FtypeName='[PPT書類]'; }
	elsif ($FileType[$i] eq 'pptx') { $FtypeName='[PPT2007書類]'; }
	elsif ($FileType[$i] eq 'jtd') { $FtypeName='[一太郎書類]'; }
	elsif ($FileType[$i] eq 'txt') { $FtypeName='[テキスト書類]'; }
	elsif ($FileType[$i] eq 'pdf') { $FtypeName='[PDF書類]'; }
	elsif ($FileType[$i] eq 'mp3') { $FtypeName='[MP3音声]'; }
	elsif ($FileType[$i] eq 'wma') { $FtypeName='[WMA音声]'; }
	elsif ($FileType[$i] eq 'mmf') { $FtypeName='[MMF音声]'; }
	elsif ($FileType[$i] eq 'mld') { $FtypeName='[MLD音声]'; }
	elsif ($FileType[$i] eq 'wmv') { $FtypeName='[WMV動画]'; }
	elsif ($FileType[$i] eq 'mp4') { $FtypeName='[MPEG4動画]'; }
	elsif ($FileType[$i] eq '3gp') { $FtypeName='[3GPP動画]'; }
	elsif ($FileType[$i] eq '3g2') { $FtypeName='[3GPP2動画]'; }
	elsif ($FileType[$i] eq 'zip') { $FtypeName='[ZIPファイル]'; }
	elsif ($FileType[$i] eq 'lzh') { $FtypeName='[LZHファイル]'; }
	if (-e $f_filepath) {
		$fv_filetag = '<a href='.$h_filepath.' target=top><img src=/icon/'.$FileType[$i]
			.'.gif align="absmiddle" border="0">'.$FtypeName.'</a>　←削除 <input type="checkbox" name="del0" value="1"><br>';
		last;
	}
	$i++;
}

##★入力画面の変更はここを訂正
$input_date=$input_year.'/'.$input_month.'/'.$input_day;
$html_input = <<"INPUTHTML";
<hr size="1" align="center">
<h4 align="center">$i_flag 　 <span style="color:$input_daycolor;">$thistable</h4>
$thisdayname
<hr size="1" align="center">
<form action="$cginame" method="POST" enctype="multipart/form-data" id="admin">
<table bgcolor="$input_color" border="0" cellspacing="0" cellpadding="5" align="center">
  <tr>
    <td align="right"><b>日　時　</b></td>
    <td>
      <script language=Javascript><!--
      var cal1 = new JKL.Calendar("calid1","admin","ndate");
      cal1.setStyle( "frame_color", "#666666" );
      //--></script>
      <input type="text" size="12" name="ndate" value="$input_date" onClick="cal1.write();" onChange="cal1.getFormValue(); cal1.hide();" class="Hankaku">　
      <select name="nhour">
        <option value="$input_hour" selected>$input_hour</option>
        <option value="00">00</option><option value="01">01</option><option value="02">02</option>
        <option value="03">03</option><option value="04">04</option><option value="05">05</option>
        <option value="06">06</option><option value="07">07</option><option value="08">08</option>
        <option value="09">09</option><option value="10">10</option><option value="11">11</option>
        <option value="12">12</option><option value="13">13</option><option value="14">14</option>
        <option value="15">15</option><option value="16">16</option><option value="17">17</option>
        <option value="18">18</option><option value="19">19</option><option value="20">20</option>
        <option value="21">21</option><option value="22">22</option><option value="23">23</option>
      </select>：<select name="nmin">
        <option value="$input_min" selected>$input_min</option>
        <option value="00">00</option><option value="05">05</option><option value="10">10</option>
        <option value="15">15</option><option value="20">20</option><option value="25">25</option>
        <option value="30">30</option><option value="35">35</option><option value="40">40</option>
        <option value="45">45</option><option value="50">50</option><option value="55">55</option>
      </select> $i4_button <br>
      <div id="calid1"></div><font color="#FF0000" size="2">半角数字YYYY/MM/DD 形式、時刻表\示しない場合でも設定が必要です</font>
    </td>
  </tr>
  <tr>
    <td align="right"><b>タイトル　</b></td>
    <td>
      <input type="text" size="60" name="title" value="$v_title">
    </td>
  </tr>
  <tr>
    <td align="right"><b>本　文　</b></td>
    <td>$swWYSIWYG <br>
      <textarea id="openWYSIWYG$DirName" name="message" cols="80" rows="$TextAreaHeight" onDblClick="AddRows('message')">$v_message</textarea>
      <br />$swHTML
    </td>
  </tr>
  $swImageFile1
  <tr>
    <td align="right"><b>添付画像　</b></td>
    <td> 
      <select name="file0ext">
        <option value="none" selected>添付しない</option>
        $FtypeTag
      </select>
      <input type="file" name="img0file" size="40"><br>
      $fv_filetag
      <font color="#FF0000">※ファイル添付時はファイルタイプを必ず選択ください</font><br>
      <font color="#FF0000">※アップロード上限サイズ：$ViewMaxSize</font>
    </td>
  </tr>
  $swImageFile2
  <tr>
    <td align="right"><b>PC用参照URL　</b></td>
    <td>
      <input type="text" size="60" name="url" value="$v_url">
      ターゲット
      <select name="targ">
        <option value="_self"$targ1>自ウィンドウ表\示 [_self]</option>
        <option value="_blank"$targ2>別ウィンドウ表\示[_blank]</option>
        <option value="_parent"$targ3>親ウィンドウ表\示[_parent]</option>
        <option value="_top"$targ4>上位ウィンドウ表\示[_top]</option>
      </select>
    </td>
  </tr>
  <tr>
    <td align="right"><b>携帯用参照URL　</b></td>
    <td>
      <input type="text" size="60" name="mrl" value="$v_mrl">
    </td>
  </tr>
  <tr>
    <td align="right"><b>公開モード　</b></td>
    <td>
      <select name="show">
        <option value="on"$cor1show>公開</option>
        <option value="off"$cor2show>非公開</option>
      </select>
    </td>
  </tr>
  <tr>
    <td colspan="2" align="center">
      $i1_button
      <input type="reset" value="リセット"><br><br>
      <input type="hidden" name="wg" value="$wg">
      <input type="hidden" name="vyear" value="$vyear">
      <input type="hidden" name="vmonth" value="$vmonth">
      $i2_button
      $i3_button
    </td>
  </tr>
</table>
</form>
<div align="center"><a href='javascript:history.go(-1)'>[管理画面へ戻る]</a></div>
INPUTHTML

&html_head;
print "$html_input\n";
&html_foot;

exit;
}
##=======================================================================================
sub regist {

&data_read;

$in{'ndate'} =~ s/\///g;
$in{'ndate'} =~ s/／//g;
$in{'nhour'}=  sprintf("%02d",$in{'nhour'});
$in{'nmin'} =  sprintf("%02d",$in{'nmin'});
$input_code = $in{'ndate'}.$in{'nhour'}.$in{'nmin'}.'';
	$input_code =~ s/１/1/g;	$input_code =~ s/６/6/g;
	$input_code =~ s/２/2/g;	$input_code =~ s/７/7/g;
	$input_code =~ s/３/3/g;	$input_code =~ s/８/8/g;
	$input_code =~ s/４/4/g;	$input_code =~ s/９/9/g;
	$input_code =~ s/５/5/g;	$input_code =~ s/０/0/g;
	$input_code =~ s/　//g;	$input_code =~ s/ //g;
	$input_code =~ s/\n//g;	$input_code =~ s/\r//g;
	$input_code =~ s/\t//g;	$input_code =~ s/\s//g;
	@FLAG = grep(/code=$input_code\t/,@DATA);
	$FlagLot=@FLAG;
	if ($FlagLot >= 1) {
		&error('日時が重複しています');
	} else {
		$db_code = $input_code;
	}
$input_show = "$in{'show'}";
	$db_show = $input_show;
$input_date = $in{'nhour'}.':'.$in{'nmin'};
	$db_date = $input_date;
$input_title = "$in{'title'}";
	$db_title = $input_title;
	$db_title =~ s/\t/ /g;
	$db_title =~ s/=/\|eq\|/g;
	$db_title =~ s/\"/\|quot\|/g;
$input_url = "$in{'url'}";
	$db_url = $input_url;
	$db_url =~ s/=/\|eq\|/g;
$input_targ = "$in{'targ'}";
	$db_targ = $input_targ;
$input_mrl = "$in{'mrl'}";
	$db_mrl = $input_mrl;
	$db_mrl =~ s/=/\|eq\|/g;
$input_message = "$in{'message'}";
	$db_message = $input_message;
	$db_message =~ s/\t/ /g;
	$db_message =~ s/=/\|eq\|/g;
	$db_message =~ s/\"/\|quot\|/g;
	if (($in{'HtmlTag'} ne '')||($in{'wg'}==1)) {
		$db_message =~ s/\r\n/\|br\|/g;
		$db_message =~ s/\r/\|br\|/g;
		$db_message =~ s/\n/\|br\|/g;
		$db_message =~ s/<A/<a/g;
		$db_message =~ s/<\/A>/<\/a>/g;
		$db_message =~ s/target\|eq\|_blank/target\|eq\|\|quot\|_blank\|quot\|/g;
		$db_message =~ s/<BR>/<br>/g;
		$db_message =~ s/<P>/<p>/g;
		$db_message =~ s/<\/P>/<\/p>/g;
		$db_message =~ s/<HR>/<hr>/g;
		$db_message =~ s/<hr size\|eq\|\|quot\|2\|quot\| width\|eq\|\|quot\|100\%\|quot\|>/<hr>/g;
		$db_message =~ s/<hr style\|eq\|\|quot\|width\: 100\%; height\: 2px\;\|quot\|>/<hr>/g;
		$db_message =~ s/<TABLE/<table/g;
		$db_message =~ s/<\/TABLE>/<\/table>/g;
		$db_message =~ s/<br clear\|eq\|\|quot\|all\|quot\| \/><br clear\|eq\|\|quot\|all\|quot\| \/>/<br clear\|eq\|\|quot\|all\|quot\| \/>/g;
		$db_message =~ s/TBODY>/tbody>/g;
		$db_message =~ s/<TR/<tr/g;
		$db_message =~ s/\/TR>/\/tr>/g;
		$db_message =~ s/<TD/<td/g;
		$db_message =~ s/\/TD>/\/td>/g;
		$db_message =~ s/ border\|eq\|([a-zA-Z0-9]*) / border\|eq\|\|quot\|$1\|quot\| /g;
		$db_message =~ s/ cellSpacing\|eq\|([a-zA-Z0-9]*) / cellspacing\|eq\|\|quot\|$1\|quot\| /g;
		$db_message =~ s/ borderColor\|eq\|([a-zA-Z0-9\#]*) / bordercolor\|eq\|\|quot\|$1\|quot\| /g;
		$db_message =~ s/ cellPadding\|eq\|([a-zA-Z0-9]*) / cellpadding\|eq\|\|quot\|$1\|quot\| /g;
		$db_message =~ s/ bgColor\|eq\|([a-zA-Z0-9\#]*)/ bgcolor\|eq\|\|quot\|$1\|quot\|/g;
		$db_message =~ s/ align\|eq\|([a-zA-Z0-9]*)>/ align\|eq\|\|quot\|$1\|quot\|>/g;
		$db_message =~ s/ align\|eq\|([a-zA-Z0-9]*) / align\|eq\|\|quot\|$1\|quot\| /g;
		$db_message =~ s/\|eq\|\|quot\|\|quot\|\|quot\|/\|eq\|\|quot\|/g;
	} else {
		$db_message =~ s/\r\n/<br>/g;
		$db_message =~ s/\r/<br>/g;
		$db_message =~ s/\n/<br>/g;
		$db_message =~ s/\"><br><input/\"><input/g;
		$db_message =~ s/\"><br><\/form/\"><\/form/g;
	}
if ($in{'HtmlTag'} ne '') { $vwg=1; } else { $vwg=$wg; }
##★データフォーマット
$format = join("\t",
	"code=$db_code",
	"show=$db_show",
	"date=$db_date",
	"title=$db_title",
	"url=$db_url",
	"targ=$db_targ",
	"mrl=$db_mrl",
	"message=$db_message",
	"wg=$vwg",
	"\n"
);
push (@DATA,$format);

##★ソート処理
foreach $dataline (@DATA) {
	@DTLINE = split(/\t/,$dataline);
	foreach (@DTLINE) {
		($key, $value) = split(/=/,$_);
		$SORT{$key} = $value;
	}
	$newcode = $SORT{'code'};
	push(@PRECODE,$newcode);
}
@NEWCODE = sort { $b <=> $a } @PRECODE;
$i=0;
foreach (@NEWCODE) {
	@PRTDATA = grep(/code=$NEWCODE[$i]/,@DATA);
	unshift(@WRDATA,@PRTDATA);
	$i++;
}

##★添付ファイルのアップロード
if ($in{'file0ext'} ne "none") {
	if (($agent =~ /Mac/i) | ($agent =~ /PPC/i)) {
		foreach (@in) { if ($_ =~ /Content-type:/i) { &image0_regist; } }
	} elsif (($agent =~ /Windows/i) | ($agent =~ /NT/i))  {
		if ($in{'img0file'} ne '') { &image0_regist; }
	} else {
		if ($in{'img0file'} ne '') { &image0_regist; }
	}
}
##★データセーブ
&data_save;

##★処理画面出力
$jumpurl = "$cginame?mode=admin&vyear=$vyear&vmonth=$vmonth&wg=$wg";
$htmla_jumpurl = <<"JUMPA";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>登録処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h2 align="center">只今、登録処理中です。</h2>
</body></html>
JUMPA

print "Content-type: text/html\n\n";
print "$htmla_jumpurl\n\n";

exit;
}
##=======================================================================================
sub delete {

&data_read;

##★フォーム取得処理
$delcode = "$in{'delcode'}";

##★データ削除処理
$match = 0; $i =0;
foreach $line (@DATA) {
	@LINE = split(/\t/,$line);
	foreach (@LINE) {
		($key, $value) = split(/=/,$_);
		$FILE{$key} = $value;
	}
	if ($FILE{'code'} == $delcode) {
		splice(@DATA,$i,1);
		$match = 1;
		last;
	}
	$i++;
}

push(@WRDATA,@DATA);

##★データセーブ
&data_save;

##★添付ファイル削除
$FtLot=@FileType-1;$i=0;
for (0..$FtLot) {
	$filepath = $img_dir.$delcode.'0.'.$FileType[$i];
	if (-e $filepath) { unlink $filepath; last; }
	$i++;
}

##★処理画面出力
$jumpurl = "$cginame?mode=admin&vyear=$vyear&vmonth=$vmonth&wg=$wg";
$htmlb_jumpurl = <<"JUMPB";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>削除処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h2 align="center">只今、削除処理中です。</h2>
</body></html>
JUMPB

print "Content-type: text/html\n\n";
print "$htmlb_jumpurl\n\n";

exit;
}
##=======================================================================================
sub delregist {

&data_read;

##★更新情報の取得
$delcode = $in{'delcode'};

$in{'ndate'} =~ s/\///g;
$in{'ndate'} =~ s/／//g;
$in{'nhour'}=  sprintf("%02d",$in{'nhour'});
$in{'nmin'} =  sprintf("%02d",$in{'nmin'});
$input_code = $in{'ndate'}.$in{'nhour'}.$in{'nmin'}.'';
	$input_code =~ s/１/1/g;	$input_code =~ s/６/6/g;
	$input_code =~ s/２/2/g;	$input_code =~ s/７/7/g;
	$input_code =~ s/３/3/g;	$input_code =~ s/８/8/g;
	$input_code =~ s/４/4/g;	$input_code =~ s/９/9/g;
	$input_code =~ s/５/5/g;	$input_code =~ s/０/0/g;
	$input_code =~ s/　//g;	$input_code =~ s/ //g;
	$input_code =~ s/\n//g;	$input_code =~ s/\r//g;
	$input_code =~ s/\t//g;	$input_code =~ s/\s//g;
	@FLAG = grep(/code=$input_code\t/,@DATA);
	$FlagLot=@FLAG;
	if (($delcode ne $input_code)&&($FlagLot >= 1)) {
		&error('日時が重複しています');
	} else {
		$db_code = $input_code;
	}
$input_show = "$in{'show'}";
	$db_show = $input_show;
$input_date = $in{'nhour'}.':'.$in{'nmin'};
	$db_date = $input_date;
$input_title = "$in{'title'}";
	$db_title = $input_title;
	$db_title =~ s/=/\|eq\|/g;
$input_url = "$in{'url'}";
	$db_url = $input_url;
	$db_url =~ s/=/\|eq\|/g;
$input_targ = "$in{'targ'}";
	$db_targ = $input_targ;
$input_mrl = "$in{'mrl'}";
	$db_mrl = $input_mrl;
	$db_mrl =~ s/=/\|eq\|/g;
$input_message = "$in{'message'}";
	$db_message = $input_message;
	$db_message =~ s/\t/ /g;
	$db_message =~ s/=/\|eq\|/g;
	if (($in{'HtmlTag'} ne '')||($in{'wg'}==1)) {
		$db_message =~ s/\r\n/\|br\|/g;
		$db_message =~ s/\r/\|br\|/g;
		$db_message =~ s/\n/\|br\|/g;
		$db_message =~ s/<A/<a/g;
		$db_message =~ s/<\/A>/<\/a>/g;
		$db_message =~ s/target\|eq\|_blank/target\|eq\|\|quot\|_blank\|quot\|/g;
		$db_message =~ s/<BR>/<br>/g;
		$db_message =~ s/<P>/<p>/g;
		$db_message =~ s/<\/P>/<\/p>/g;
		$db_message =~ s/<HR>/<hr>/g;
		$db_message =~ s/<hr size\|eq\|\|quot\|2\|quot\| width\|eq\|\|quot\|100\%\|quot\|>/<hr>/g;
		$db_message =~ s/<hr style\|eq\|\|quot\|width\: 100\%; height\: 2px\;\|quot\|>/<hr>/g;
		$db_message =~ s/<TABLE/<table/g;
		$db_message =~ s/<\/TABLE>/<\/table>/g;
		$db_message =~ s/<br clear\|eq\|\|quot\|all\|quot\| \/><br clear\|eq\|\|quot\|all\|quot\| \/>/<br clear\|eq\|\|quot\|all\|quot\| \/>/g;
		$db_message =~ s/TBODY>/tbody>/g;
		$db_message =~ s/<TR/<tr/g;
		$db_message =~ s/\/TR>/\/tr>/g;
		$db_message =~ s/<TD/<td/g;
		$db_message =~ s/\/TD>/\/td>/g;
		$db_message =~ s/ border\|eq\|([a-zA-Z0-9]*) / border\|eq\|\|quot\|$1\|quot\| /g;
		$db_message =~ s/ cellSpacing\|eq\|([a-zA-Z0-9]*) / cellspacing\|eq\|\|quot\|$1\|quot\| /g;
		$db_message =~ s/ borderColor\|eq\|([a-zA-Z0-9\#]*) / bordercolor\|eq\|\|quot\|$1\|quot\| /g;
		$db_message =~ s/ cellPadding\|eq\|([a-zA-Z0-9]*) / cellpadding\|eq\|\|quot\|$1\|quot\| /g;
		$db_message =~ s/ bgColor\|eq\|([a-zA-Z0-9\#]*)/ bgcolor\|eq\|\|quot\|$1\|quot\|/g;
		$db_message =~ s/ align\|eq\|([a-zA-Z0-9]*)>/ align\|eq\|\|quot\|$1\|quot\|>/g;
		$db_message =~ s/ align\|eq\|([a-zA-Z0-9]*) / align\|eq\|\|quot\|$1\|quot\| /g;
		$db_message =~ s/\|eq\|\|quot\|\|quot\|\|quot\|/\|eq\|\|quot\|/g;
	} else {
		$db_message =~ s/\r\n/<br>/g;
		$db_message =~ s/\r/<br>/g;
		$db_message =~ s/\n/<br>/g;
		$db_message =~ s/\"><br><input/\"><input/g;
		$db_message =~ s/\"><br><\/form/\"><\/form/g;
	}
if ($in{'HtmlTag'} ne '') { $vwg=1; } else { $vwg=$wg; }
##★データフォーマット
$format = join("\t",
	"code=$db_code",
	"show=$db_show",
	"date=$db_date",
	"title=$db_title",
	"url=$db_url",
	"targ=$db_targ",
	"mrl=$db_mrl",
	"message=$db_message",
	"wg=$vwg",
	"\n"
);

##★データ削除処理
if ($in{'copy'} ne '1') {
	$match = 0; $i =0;
	foreach $line (@DATA) {
		@LINE = split(/\t/,$line);
		foreach (@LINE) {
			($key, $value) = split(/=/,$_);
			$FILE{$key} = $value;
		}
		if ($FILE{'code'} == $delcode) {
			splice(@DATA,$i,1);
			$match = 1;
			last;
		}
		$i++;
	}
}
##★ソート処理
unshift(@DATA,$format);
foreach $dataline (@DATA) {
	@DTLINE = split(/\t/,$dataline);
	foreach (@DTLINE) {
		($key, $value) = split(/=/,$_);
		$SORT{$key} = $value;
	}
	$newcode = $SORT{'code'};
	push(@PRECODE,$newcode);
}
@NEWCODE = sort { $b <=> $a } @PRECODE;
$i=0;
foreach (@NEWCODE) {
	@PRTDATA = grep(/code=$NEWCODE[$i]/,@DATA);
	unshift(@WRDATA,@PRTDATA);
	$i++;
}

##★添付ファイルの削除
if (($in{'del0'} eq "1")||($in{'file0ext'} ne 'none')) {
	$FtLot=@FileType-1;$i=0;
	for (0..$FtLot) {
		$filepath = $img_dir.$delcode.'0.'.$FileType[$i];
		if (-e $filepath) { unlink $filepath; last; }
		$i++;
	}
}
##★添付ファイルのアップロード
if ($in{'file0ext'} ne "none") {
	if (($agent =~ /Mac/i) | ($agent =~ /PPC/i)) {
		foreach (@in) { if ($_ =~ /Content-type:/i) { &image0_regist; } }
	} elsif (($agent =~ /Windows/i) | ($agent =~ /NT/i))  {
		if ($in{'img0file'} ne '') { &image0_regist; }
	} else {
		if ($in{'img0file'} ne '') { &image0_regist; }
	}
}
##★添付ファイルリネーム
if ($delcode ne $input_code) {
	$FtLot=@FileType-1;$i=0;
	for (0..$FtLot) {
		$file1path = $img_dir.$delcode.'0.'.$FileType[$i];
		$file2path = $img_dir.$db_code.'0.'.$FileType[$i];
		if (-e $file1path) { rename($file1path,$file2path); last; }
		$i++;
	}
}
##★データセーブ
&data_save;

##★更新処理画面の変更はここを訂正
$jumpurl = "$cginame?mode=admin&vyear=$vyear&vmonth=$vmonth&wg=$wg";
$htmlc_jumpurl = <<"JUMPC";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>更新処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h2 align="center">只今、更新処理中です。</h2>
</body></html>
JUMPC

print "Content-type: text/html\n\n";
print "$htmlc_jumpurl\n\n";

exit;
}
##=======================================================================================
sub onoff {

&data_read;

##★フォーム取得処理
$chcode = "$in{'code'}";

##★データ表示切替処理
$dataLot=@DATA-1; $i=0;
for (0..$dataLot) {
	if ($DATA[$i] =~ /code=$chcode\tshow=on\t/i) {
		$DATA[$i] =~ s/\tshow=on\t/\tshow=off\t/g;
	} elsif ($DATA[$i] =~ /code=$chcode\tshow=off\t/i) {
		$DATA[$i] =~ s/\tshow=off\t/\tshow=on\t/g;
	}
	$i++;
}

push(@WRDATA,@DATA);

##★データセーブ
&data_save;

##★処理画面出力
$jumpurl = "$cginame?mode=admin&vyear=$vyear&vmonth=$vmonth&wg=$wg";
$htmlb_jumpurl = <<"JUMPB";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>削除処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h2 align="center">只今、公開モード切替中です。</h2>
</body></html>
JUMPB

print "Content-type: text/html\n\n";
print "$htmlb_jumpurl\n\n";

exit;
}
##=======================================================================================
sub data_read {
	if (open(DBREAD,"$datafile")) {
		@DATA = <DBREAD>;
		close(DBREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($datafile);
		if ($contCC eq 'shiftjis') {
			foreach (@DATA) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	}
}
##=======================================================================================
sub data_save {
	$tmpfile = "$$\.tmp";
	if (!open(TMP,">$tmpfile")) { &error('パーミッションエラー'); }
	print TMP @WRDATA;
	close(TMP);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$datafile);
	##★index.html更新
	&MakeIndexFile;
}
##=======================================================================================
sub calender_read {
	if (open(CLDREAD,"$calenderfile")) {
		@CALENDER = <CLDREAD>;
		close(CLDREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($calenderfile);
		if ($contCC eq 'shiftjis') {
			foreach (@CALENDER) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else { &error(bad_calenderfile); }
}
##=======================================================================================
sub image0_regist {
	# 画像処理
	$tail = $in{'file0ext'};
	
	# マックバイナリ対策
	my $macbin=0;
	foreach (@in) {
		if ($_ =~ /application\/x-macbinary/i) { $macbin=1; }
	}
	if ($macbin) {
		my $length = substr($upfile,83,4);
		$length = unpack("%N",$length);
		$upfile = substr($upfile,128,$length);
	}
	
	# 添付データを書き込み
	my $buffer;
	my $ImgFile = $img_dir.$db_code."0.".$tail;
	open(OUT,"> $ImgFile") || &error('アップロード失敗');
	binmode(OUT);
	binmode(STDOUT);
	while (read($upfile, $buffer, 1024)) { 
		print OUT $buffer;
	}
	close(OUT);
	chmod(oct($WRMode),$ImgFile);
	
}
##=======================================================================================
sub tag_change {
	##	$var = &tag_change($var); で変換する
	if ($RootPath ne '') { $TcRootPath='/'.$RootPath; } else { $TcRootPath=''; }
	local($_) = $_[0];
	1 while s/\[new\]/<img src=\"$TcRootPath\/icon\/new\.gif\" align=\"middle\" alt=\"new\" border=\"0\" \/>/g;
	1 while s/\[red\]/<span style=\"color\:\#FF0000\">/g;
	1 while s/\[\/red\]/<\/span>/g;
	1 while s/\[blue\]/<span style=\"color\:\#0000FF\">/g;
	1 while s/\[\/blue\]/<\/span>/g;
	1 while s/\[green\]/<span style=\"color\:\#009900\">/g;
	1 while s/\[\/green\]/<\/span>/g;
	1 while s/\/TD>/\/td>/g;
	1 while s/<TD/<td/g;
	1 while s/\/TR>/\/tr>/g;
	1 while s/<TR/<tr/g;
	1 while s/\/TABLE>/\/table>/g;
	1 while s/<TABLE/<table/g;
	1 while s/\/TBODY>/\/tbody>/g;
	1 while s/<TBODY/<tbody/g;
	$_;
}
##=======================================================================================
sub MakeIndexFile {

if ($OutPutHTML ne '') {
	#URL取得
	use LWP::Simple;
	our $geturl;
	if ($RootPath eq '') { 
		$geturl = 'http://'.$Domain.'/'.$DirName.'/index.cgi';
	} else {
		$geturl = 'http://'.$Domain.'/'.$RootPath.'/'.$DirName.'/index.cgi';
	}
	
	#古いindex.htmlを削除
	unlink ('index.html');
	
	#index.htmlを書き出し
	getstore($geturl, 'index.html');
	chmod(oct($WRMode),'index.html');
} else {
	if (-e 'index.html') { unlink('index.html'); }
}

}
##=======================================================================================
