#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT CORE v3.0.5
## (c)2008-2010 NorenzPRO Ltd. TakafumiArai 2010/8/8
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##★ライブラリファイルのパス。
use strict;
use Encode;
require '../admin/aelib.cgi';

##★データファイルのパス
our $datafile = '../admin/dir.dat';


##=====================================================================================##
##メインルーチン
##=====================================================================================##

##システム設定ファイル読込
our $servconf = '../admin/conf.dat';
our $pcoutCode;
our @SVCONF;
if (-e $servconf) {
	open(SVCFGRD,"$servconf");
	@SVCONF = <SVCFGRD>;
	close(SVCFGRD);
	##文字コード判定→UTF8変換
	my $contCC=&checkCharCode($servconf);
	if ($contCC eq 'shiftjis') {
		foreach (@SVCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
	}
	$pcoutCode =$SVCONF[22];
	$pcoutCode =~ s/\r//g; $pcoutCode =~ s/\n//g;
}
if ($pcoutCode eq '') { $pcoutCode='sjis'; }

&data_read;
&NewsList;
exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub NewsList {

our @DATA;

##最終更新日の調査
our $DataLot=@DATA-1;
my $i=0;
our @year;our @mon;our @day;our @hour;our @min;our @sec;
our @lastmodified;our @modline;our @Title;
for (0..$DataLot) {
	our $DirList =$DATA[$i];
		$DirList =~ s/\r//g;
		$DirList =~ s/\n//g;
	our @DirName=split(/\,/,$DirList);
	our $ConfFile='../'.$DirName[0].'/conf.dat';
	our $LogFile='../'.$DirName[0].'/data.dat';
	my ($devNo,$inoNo,$ChMod,$linkLot,$uID,$gID,$rDev,$fSize,$aTime,$mTime,$cTime,$BlkSize,$Blocks) = stat($LogFile);
	($sec[$i],$min[$i],$hour[$i],$day[$i],$mon[$i],$year[$i]) = localtime($mTime);
		$year[$i] = sprintf("%04d",$year[$i]-100);
		$mon[$i] = sprintf("%02d",$mon[$i]+1);
		$day[$i] = sprintf("%02d",$day[$i]);
		$hour[$i] = sprintf("%02d",$hour[$i]);
		$min[$i] = sprintf("%02d",$min[$i]);
		$sec[$i] = sprintf("%02d",$sec[$i]);
		$lastmodified[$i]=$year[$i].$mon[$i].$day[$i].$hour[$i].$min[$i].$sec[$i];
	if (open(CONFRD,"$ConfFile")) {
		our @CONF = <CONFRD>;
		$Title[$i]=$CONF[0];
		close(CONFRD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($ConfFile);
		if ($contCC eq 'shiftjis') {
			Encode::from_to($Title[$i], 'shiftjis', 'utf8');
		}
	} else { $Title[$i]='未設定ページ'; }
	our $LogSize = -s $LogFile;
	if ($LogSize > 0) {
		$modline[$i]=$lastmodified[$i]."\t".$Title[$i]."\t".$DirName[0]."\t";
	}
	$i++;
}

##最終更新日のソート
our @newmodified = sort { $b <=> $a } @modline;

##新着出力
print "Content-type: text/html\n\n";
print "<ul>";
$i=0;
our @name;our @dir;our @time;
my $ViewLot=@newmodified-1;
my $tagList;
if (@newmodified > 4) { $ViewLot=4 }
for (0..$ViewLot) {
	($time[$i],$name[$i],$dir[$i])=split(/\t/,$newmodified[$i]);
		$name[$i] =~ s/\r//g;
		$name[$i] =~ s/\n//g;
	my $yy=substr($time[$i],2,2);
	my $mm=substr($time[$i],4,2);
	my $dd=substr($time[$i],6,2);
	$tagList= '<li><a href="./'.$dir[$i].'/index.cgi">'.$name[$i].'['.$mm.'/'.$dd.']</a></li>'."\n";
	if ($pcoutCode eq 'sjis') { Encode::from_to($tagList, 'utf8', 'shiftjis'); }
	print $tagList;
	$i++;
}
print "</ul>";

}
##=======================================================================================
sub data_read {
	our @DATA=();
	if (open(DBREAD,"$datafile")) {
		@DATA = <DBREAD>;
		close(DBREAD);
	} else { &errorout('ファイル読込失敗'); }
}
##=======================================================================================
sub errorout {

my $error = $_[0];

##★エラーメッセージの変更はここを訂正
my $errHTML = <<"ERRORMESS";
<span style="color:#ff0000">ERROR</span>
<div align="center">&nbsp;<br>$error</div>
ERRORMESS

print "Content-type: text/html\n\n";
if ($pcoutCode eq 'sjis') { Encode::from_to($errHTML, 'utf8', 'shiftjis'); }
print $errHTML;
exit;

}
##=======================================================================================
