#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT GMAP v3.0.5
## (c)2008-2010 NorenzPRO Ltd. TakafumiArai 2010/8/10
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##==============基本設定==============

##★ライブラリファイルのパス。
use Encode;
require '../admin/emoji.pl';
require '../admin/aelib.cgi';

##★データファイルのパス
$datafile = './data.dat';

##★このスクリプトの名前
$cginame = 'mbmap.cgi';

##★アップロード画像格納ディレクトリ（相対・絶対パス）
$img_dir = './file/';

##★アップロード画像公開ディレクトリ（相対・絶対パス）
$img_path = './file/';

##★ベースURL
$BaseURL = 'http://maps.google.com/mapdata';

##★アップロード画像公開ディレクトリ（相対・絶対パス）
$img_path = './file/';

##★マップのデフォルトズーム度[0～9]
$DefZoom = 0;

##=====================================================================================##
##メインルーチン
##=====================================================================================##

##キャリア識別
$ua = $ENV{"HTTP_USER_AGENT"};
if ($ua =~ /DoCoMo\/1\.0/i) { $xCR='dc'; }
elsif ($ua =~ /Mozilla/i) { $xCR='pc'; }
elsif ($ua =~ /(DoCoMo\/2\.0|FOMA)/i) { $xCR='dc'; }
elsif ($ua =~ /^(SoftBank|Vodafone|J\-PHONE|MOT\-[CV])/i) { $xCR='sb'; }
elsif ($ua =~ /^UP\.Browser/i) { $xCR='ez'; }
elsif ($ua =~ /^(KDDI\-|OPWV|MMP)/i) { $xCR='ez'; }
else { $xCR='pc'; }

@ZmLv=(300,600,1000,2000,3500,7000,14000,30000,70000,201000);

##システム設定ファイル読込
$servconf = '../admin/conf.dat';
if (-e $servconf) {
	open(SVCFGRD,"$servconf");
	@SVCONF = <SVCFGRD>;
	close(SVCFGRD);
	##文字コード判定→UTF8変換
	my $contCC=&checkCharCode($servconf);
	if ($contCC eq 'shiftjis') {
		foreach (@SVCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
	}
	$Domain =$SVCONF[3];
	$Domain =~ s/\r//g; $Domain =~ s/\n//g;
	$GmapAPIkey =$SVCONF[8];
	$GmapAPIkey =~ s/\r//g; $GmapAPIkey =~ s/\n//g;
	$RootPath =$SVCONF[10];
	$RootPath =~ s/\r//g; $RootPath =~ s/\n//g;
	$mboutCode =$SVCONF[23];
	$mboutCode =~ s/\r//g; $mboutCode =~ s/\n//g;
}
if ($mboutCode eq '') { $mboutCode='sjis'; }

##設定ファイル読込
$conffile='./conf.dat';
open(CONFRD,"$conffile");
@CONF = <CONFRD>;
close(CONFRD);
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($conffile);
if ($contCC eq 'shiftjis') {
	foreach (@CONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}
$DefIdo =$CONF[2];
$DefIdo =~ s/\r//g;$DefIdo =~ s/\n//g;
$DefKeido =$CONF[3];
$DefKeido =~ s/\r//g;$DefKeido =~ s/\n//g;
$FileTypeLine =$CONF[4];
$FileTypeLine =~ s/\r//g;$FileTypeLine =~ s/\n//g;
@FileType=split(/:/,$FileTypeLine);
$MobiTitle =$CONF[11];
$MobiTitle =~ s/\r//g;$MobiTitle =~ s/\n//g;
$MobiColor =$CONF[12];
$MobiColor =~ s/\r//g;$MobiColor =~ s/\n//g;
$MobiView =$CONF[13];
$MobiView =~ s/\r//g;$MobiView =~ s/\n//g;
$MapWidth =200;
$MapHeight =200;
$MapZoom =$CONF[16];
$MapZoom =~ s/\r//g;$MapZoom =~ s/\n//g;
$mbHmark =$CONF[17];
$mbHmark =~ s/\r//g;$mbHmark =~ s/\n//g;
$mbHcolor =$CONF[18];
$mbHcolor =~ s/\r//g;$mbHcolor =~ s/\n//g;
$MobiHeadMsg =$CONF[20];
$MobiHeadMsg =~ s/\r//g;$MobiHeadMsg =~ s/\n//g;
$MobiHeadMsg = &inline_link($MobiHeadMsg);
$MobiHeadMsg = &tag_change($MobiHeadMsg);
$MobiBack =$CONF[23];
$MobiBack =~ s/\r//g;$MobiBack =~ s/\n//g;
$MobiNext =$CONF[24];
$MobiNext =~ s/\r//g;$MobiNext =~ s/\n//g;
$MobiToList =$CONF[25];
$MobiToList =~ s/\r//g;$MobiToList =~ s/\n//g;
$MobiToHome =$CONF[26];
$MobiToHome =~ s/\r//g;$MobiToHome =~ s/\n//g;
$MobiSkin =$CONF[27];
$MobiSkin =~ s/\r//g;$MobiSkin =~ s/\n//g;
$DirName =$CONF[31];
$DirName =~ s/\r//g;$DirName =~ s/\n//g;

$GmapKey=$GmapAPIkey;
if ($MobiSkin eq '') { $MobiSkin='/skin/mobi.html'; }
if ($MobiBack eq '') { $MobiBack='[＜前]'; }
if ($MobiNext eq '') { $MobiNext='[次＞]'; }
if ($MobiToList eq '') { $MobiToList='[リストへ戻る]'; }
if ($MobiToHome eq '') { $MobiToHome='[HOME]'; }

##フォームの取得
$buffer = $ENV{'QUERY_STRING'};
@pairs = split(/&/,$buffer);
for $pair (@pairs) {
	($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	if ($mboutCode eq 'sjis') { Encode::from_to($value, 'shiftjis', 'utf8'); }
	$in{$name} = $value;
}
if ($in{'pg'} ne '') { $in{'code'}=$in{'pg'}; }

##==============メインアクション==============

if ($in{'mode'} eq 'ezmovie') { &ezmovie; }
if (($xCR eq 'ez')&&($in{'lat'} ne '')) { $in{'mode'}='gps'; }
if (($xCR eq 'sb')&&($in{'geo'} ne '')) { $in{'mode'}='gps'; }

&html_head;
if ($in{'mode'} eq 'gps') { &html_gps; } else { &html_map; }
&html_foot;
exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub html_head {

if ($RootPath ne '') {
	$RssURL='http://'.$Domain.'/'.$RootPath.'/'.$DirName.'/rdfmb.cgi';
} else {
	$RssURL='http://'.$Domain.'/'.$DirName.'/rdfmb.cgi';
}
$RdfTag='<link rel="alternate" type="application/rss+xml" title="'.$PageTitle.'" href="'.$RssURL.'" />';

#スキンページ読込
&page_read;
print "Content-type: text/html\n\n";
$phi=0;
foreach (@PHEAD) {
	$PHEAD[$phi]=~ s/<\/title>/ $MobiTitle<\/title>/g;
	$PHEAD[$phi]=~ s/<\/head>/$RdfTag\n<\/head>/g;
	if ($mboutCode eq 'sjis') { Encode::from_to($PHEAD[$phi], 'utf8', 'shiftjis'); }
	print $PHEAD[$phi];
	$phi++;
}
$htHead = <<"htHead";
<font color=$MobiColor>$MobiTitle</font>
<hr>
htHead
if ($mboutCode eq 'sjis') { Encode::from_to($htHead, 'utf8', 'shiftjis'); }
print $htHead;

}
##=======================================================================================
sub html_foot {

$pline = $in{'pline'};
$BackURL = "mobi.cgi?pline=$pline";
if ($MobiToHome ne 'none') { $TagHome='<br><a href="../mobi/">'.$MobiToHome.'</a>'; }

$htFoot = <<"htFoot";
<hr>
<a href=$BackURL>$MobiToList</a>
$TagHome
htFoot
if ($mboutCode eq 'sjis') { Encode::from_to($htFoot, 'utf8', 'shiftjis'); }
print $htFoot;

#スキンページ読込
&page_read;
$pfi=0;
foreach (@PFOOT) {
	if ($mboutCode eq 'sjis') { Encode::from_to($PFOOT[$pfi], 'utf8', 'shiftjis'); }
	print $PFOOT[$pfi];
	$pfi++;
}

}
##=======================================================================================
sub html_map {

$code = $in{'code'};
$pline = $in{'pline'};

##DATA取得
&data_read;
@PRE = grep(/code=$code\t/,@DATA);
@NEW = grep(/\tshow=on\t/,@PRE);
@LINE = split(/\t/,$NEW[0]);
foreach (@LINE) {
	($key, $value) = split(/=/,$_);
	$value =~ s/\|eq\|/=/g;
	$value =~ s/\|quot\|/\"/g;
	$value =~ s/\|apos\|/\'/g;
	$value =~ s/\|amp\|/\&/g;
	$FILE{$key} = $value;
}
$vCode = $FILE{'code'};
$vShow = $FILE{'show'};
$vTitle = $FILE{'title'};
	$vTitle = &tag_change($vTitle);
	$vTitle = &EmojiTagToGif($vTitle);
$vMessage = $FILE{'message'};
	$vMessage =~ s/\|br\|//g;
	$vMessage = &inline_link($vMessage);
	$vMessage = &tag_change($vMessage);
	$vMessage = &EmojiTagToGif($vMessage);
	if ($vMessage ne "") { $vMessage=$vMessage.'<br>'; } else { $vMessage=''; }
$vPhone = $FILE{'phone'};
	if ($vPhone ne "") { $vPhone='TEL: <a href=tel:'.$vPhone.'>'.$vPhone.'</a><br>'; } else { $vPhone=''; }
$vFax = $FILE{'fax'};
	if ($vFax ne "") { $vFax='FAX: '.$vFax.'<br>'; } else { $vFax=''; }
$vAlign = $FILE{'align'};
$DefIdo = $FILE{'ido'};
$DefKeido = $FILE{'keido'};

	##★添付ファイル1があれば表示
	$FtLot=@FileType-1;$i=0;
	for (0..$FtLot) {
		$f0_filepath = $img_dir.$vCode.'0.'.$FileType[$i];
		$h0_filepath = $img_path.$vCode.'0.'.$FileType[$i];
		$f1_filepath = $img_dir.$vCode.'0m.'.$FileType[$i];
		$h1_filepath = $img_path.$vCode.'0m.'.$FileType[$i];
		if ($FileType[$i] eq 'jpg') { $FtypeName='[画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'gif') { $FtypeName='[画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'doc') { $FtypeName='[WORD書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'docx') { $FtypeName='[WORD2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'xls') { $FtypeName='[EXCEL書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'xlsx') { $FtypeName='[EXCEL2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'ppt') { $FtypeName='[PPT書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'pptx') { $FtypeName='[PPT2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'jtd') { $FtypeName='[一太郎書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'txt') { $FtypeName='[テキスト書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'pdf') { $FtypeName='[PDF書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mp3') { $FtypeName='[MP3音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'wma') { $FtypeName='[WMA音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mmf') { $FtypeName='[音声再生]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mld') { $FtypeName='[音声再生]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'wmv') { $FtypeName='[WMV動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mp4') { $FtypeName='[MPEG4動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq '3gp') { $FtypeName='[動画再生]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq '3g2') { $FtypeName='[動画再生]'; $FtypeImg=2; }
		elsif ($FileType[$i] eq 'zip') { $FtypeName='[ZIPファイル]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'lzh') { $FtypeName='[LZHファイル]'; $FtypeImg=0; }
		if ((-e $f1_filepath)&&($FtypeImg==1)) {
			if ($in{'align'} eq 'bottom') {
				$f0a_imgtag = '';
				$f0b_imgtag = '<br><img src="'.$h1_filepath.'">';
			} else {
				$f0a_imgtag = '<img src="'.$h1_filepath.'"><br>';
				$f0b_imgtag = '';
			}
			$f0_filetag='';
			last;
		} elsif ((-e $f0_filepath)&&($FtypeImg==2)&&($xCR eq 'ez')) {
			$f0a_imgtag=''; $f0b_imgtag='';
			$ezmvurl=$cginame.'?mode=ezmovie&ezmvfile='.$vCode.'0.'.$FileType[$i];
			$f0_filetag = '<a href="'.$ezmvurl.'" target="top">'.$FtypeName.' '.$fv_filesize.'</a>';
			last;
		} elsif (-e $f0_filepath) {
			$f0a_imgtag=''; $f0b_imgtag='';
			$f0_filetag = '<a href="'.$h0_filepath.'" target="top">'.$FtypeName.'</a>';
			last;
		} else { $f0a_imgtag=''; $f0b_imgtag=''; $f0_filetag='' }
		$i++;
	}
	##★添付ファイル2があれば表示
	$FtLot=@FileType-1;$i=0;
	for (0..$FtLot) {
		$f0_filepath = $img_dir.$vCode.'1.'.$FileType[$i];
		$h0_filepath = $img_path.$vCode.'1.'.$FileType[$i];
		$f1_filepath = $img_dir.$vCode.'1m.'.$FileType[$i];
		$h1_filepath = $img_path.$vCode.'1m.'.$FileType[$i];
		if ($FileType[$i] eq 'jpg') { $FtypeName='[画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'gif') { $FtypeName='[画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'doc') { $FtypeName='[WORD書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'docx') { $FtypeName='[WORD2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'xls') { $FtypeName='[EXCEL書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'xlsx') { $FtypeName='[EXCEL2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'ppt') { $FtypeName='[PPT書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'pptx') { $FtypeName='[PPT2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'jtd') { $FtypeName='[一太郎書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'txt') { $FtypeName='[テキスト書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'pdf') { $FtypeName='[PDF書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mp3') { $FtypeName='[MP3音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'wma') { $FtypeName='[WMA音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mmf') { $FtypeName='[音声再生]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mld') { $FtypeName='[音声再生]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'wmv') { $FtypeName='[WMV動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mp4') { $FtypeName='[MPEG4動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq '3gp') { $FtypeName='[動画再生]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq '3g2') { $FtypeName='[動画再生]'; $FtypeImg=2; }
		elsif ($FileType[$i] eq 'zip') { $FtypeName='[ZIPファイル]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'lzh') { $FtypeName='[LZHファイル]'; $FtypeImg=0; }
		if ((-e $f1_filepath)&&($FtypeImg==1)) {
			if ($in{'align'} eq 'bottom') {
				$f1a_imgtag = '';
				$f1b_imgtag = '<br><img src="'.$h1_filepath.'">';
			} else {
				$f1a_imgtag = '<img src="'.$h1_filepath.'"><br>';
				$f1b_imgtag = '';
			}
			$f1_filetag='';
			last;
		} elsif ((-e $f0_filepath)&&($FtypeImg==2)&&($xCR eq 'ez')) {
			$f1a_imgtag=''; $f1b_imgtag='';
			$ezmvurl=$cginame.'?mode=ezmovie&ezmvfile='.$vCode.'1.'.$FileType[$i];
			$f1_filetag = '<a href="'.$ezmvurl.'" target="top">'.$FtypeName.' '.$fv_filesize.'</a>';
			last;
		} elsif (-e $f0_filepath) {
			$f1a_imgtag=''; $f1b_imgtag='';
			$f1_filetag = '<a href="'.$h0_filepath.'" target="top">'.$FtypeName.'</a>';
			last;
		} else { $f1a_imgtag=''; $f1b_imgtag=''; $f1_filetag='' }
		$i++;
	}
##★画面リストの変更はここを訂正
if ($vTitle ne "") {
	$htDetail = <<"htDetail";
	<p><font color=$mbHcolor>$mbHmark $vTitle</font><br>
	$f0a_imgtag $f1a_imgtag $vMessage $vPhone $vFax $f0b_imgtag $f1b_imgtag $f0_filetag $f1_filetag </p>
htDetail
} else {
	$htDetail = <<"htDetail";
	<p><font color=$mbHcolor>$mbHmark</font> $f0a_imgtag $f1a_imgtag $vMessage $vPhone $vFax $f0b_imgtag $f1b_imgtag $f0_filetag $f1_filetag </p>
htDetail
}

##スタート座標＆マーカー座標
$CenterX=$in{'cx'};
if ($CenterX eq '') { $CenterX = $DefKeido; }
$pCenterX=int($CenterX * 1000000);

$CenterY=$in{'cy'};
if ($CenterY eq '') { $CenterY = $DefIdo; }
$pCenterY=int($CenterY * 1000000);

##表示座標
$ViewX=$in{'vx'};
if ($ViewX eq '') { $ViewX = $DefKeido; }
$pViewX=int($ViewX * 1000000);

$ViewY=$in{'vy'};
if ($ViewY eq '') { $ViewY = $DefIdo; }
$pViewY=int($ViewY * 1000000);

##デフォルトズーム度
$Zoom=$in{'zm'};
if ($Zoom eq '') { $Zoom = $DefZoom; }
$pZoom=$ZmLv[$Zoom];

##ズームアップ＆ダウン
if ($Zoom==0) { $sel0=' selected'; } else { $sel0=''; }
if ($Zoom==1) { $sel1=' selected'; } else { $sel1=''; }
if ($Zoom==2) { $sel2=' selected'; } else { $sel2=''; }
if ($Zoom==3) { $sel3=' selected'; } else { $sel3=''; }
if ($Zoom==4) { $sel4=' selected'; } else { $sel4=''; }
if ($Zoom==5) { $sel5=' selected'; } else { $sel5=''; }
if ($Zoom==6) { $sel6=' selected'; } else { $sel6=''; }
if ($Zoom==7) { $sel7=' selected'; } else { $sel7=''; }
if ($Zoom==8) { $sel8=' selected'; } else { $sel8=''; }
if ($Zoom==9) { $sel9=' selected'; } else { $sel9=''; }

##移動先座標
$EastViewX = $ViewX + (0.000003 * $pZoom);
$WestViewX = $ViewX - (0.000003 * $pZoom);
$NorthViewY = $ViewY + (0.000003 * $pZoom);
$SouthViewY = $ViewY - (0.000003 * $pZoom);

##GPSMAPへのリンク
if ($xCR eq 'dc') {
	$gpsTag ='<a href="'.$cginame.'?mode=gps&code='.$code.'&amp;pline='.$pline.'" lcs>[現在地GPS確認]</a>';
}
if ($xCR eq 'ez') {
	if ($RootPath ne '') {
		$GpsURL='http://'.$Domain.'/'.$RootPath.'/'.$DirName.'/';
	} else {
		$GpsURL='http://'.$Domain.'/'.$DirName.'/';
	}
	$gpsTag ='<form action="device:gpsone" method="GET">'
	.'<input type="hidden" name="url" value="'.$GpsURL.$cginame.'">'
	.'<input type="hidden" name="ver" value="1">'
	.'<input type="hidden" name="datum" value="0">'
	.'<input type="hidden" name="unit" value="1">'
	.'<input type="hidden" name="acry" value="0">'
	.'<input type="hidden" name="number" value="0">'
	.'<input type="submit" value="現在地GPS確認"></form>';
}
if ($xCR eq 'sb') {
	$gpsTag ='<a href="location:auto?url='.$cginame.'">[現在地GPS確認]</a>';
}

##GMAP出力
if (($FILE{'ido'} ne 'NoneSet')||($FILE{'keido'} ne 'NoneSet')) {
$html_gmap = <<"GMAP";
<font color=$mbHcolor>$vTitle</font>
<center>
<hr>
<form action="$cginame" method="GET">
<img src="$BaseURL?latitude_e6=$pViewY&longitude_e6=$pViewX&zm=$pZoom&w=$MapWidth&h=$MapHeight&cc=US&min_priority=1&Point=b&Point.latitude_e6=$pCenterY&Point.longitude_e6=$pCenterX&Point.iconid=16&Point=e"><br>
<br>
<a href="$cginame?cx=$CenterX&cy=$CenterY&vx=$WestViewX&vy=$NorthViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="1">[1]</a>
<a href="$cginame?cx=$CenterX&cy=$CenterY&vx=$ViewX&vy=$NorthViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="2">[↑2]</a>
<a href="$cginame?cx=$CenterX&cy=$CenterY&vx=$EastViewX&vy=$NorthViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="3">[3]</a>
<br>
<a href="$cginame?cx=$CenterX&cy=$CenterY&vx=$WestViewX&vy=$ViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="4">[4←]</a>
<a href="$cginame?cx=$DefKeido&cy=$DefIdo&vx=$DefKeido&vy=$DefIdo&zm=$Zoom&code=$code&pline=$pline" accesskey="5">[始5]</a>
<a href="$cginame?cx=$CenterX&cy=$CenterY&vx=$EastViewX&vy=$ViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="6">[→6]</a>
<br>
<a href="$cginame?cx=$CenterX&cy=$CenterY&vx=$WestViewX&vy=$SouthViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="7">[7]</a>
<a href="$cginame?cx=$CenterX&cy=$CenterY&vx=$ViewX&vy=$SouthViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="8">[↓8]</a>
<a href="$cginame?cx=$CenterX&cy=$CenterY&vx=$EastViewX&vy=$SouthViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="9">[9]</a>
<hr>
縮尺<select name="zm">
<option value="0"$sel0>1/3千</option>
<option value="1"$sel1>1/5千</option>
<option value="2"$sel2>1/1万</option>
<option value="3"$sel3>1/2万</option>
<option value="4"$sel4>1/3万</option>
<option value="5"$sel5>1/7.5万</option>
<option value="6"$sel6>1/15万</option>
<option value="7"$sel7>1/30万</option>
<option value="8"$sel8>1/90万</option>
<option value="9"$sel9>1/150万</option>
</select>
<input type="submit" value="変更">
<input type="hidden" name="cx" value="$CenterX">
<input type="hidden" name="cy" value="$CenterY">
<input type="hidden" name="vx" value="$ViewX">
<input type="hidden" name="vy" value="$ViewY">
<input type="hidden" name="code" value="$code">
<input type="hidden" name="cat" value="$incat">
<input type="hidden" name="pline" value="$pline">
<br>
</form>
$gpsTag
</center>
<hr>
$htDetail
GMAP
} else {
$html_gmap = <<"GMAP";
<font color=$mbHcolor>$vTitle</font>
<hr>
GMAP
}
if ($mboutCode eq 'sjis') { Encode::from_to($html_gmap, 'utf8', 'shiftjis'); }
print $html_gmap;

}
##=======================================================================================
sub html_gps {

$code = $in{'code'};
$pline = $in{'pline'};

##DATA取得
&data_read;
@PRE = grep(/code=$code\t/,@DATA);
@NEW = grep(/\tshow=on\t/,@PRE);
@LINE = split(/\t/,$NEW[0]);
foreach (@LINE) {
	($key, $value) = split(/=/,$_);
	$value =~ s/\|eq\|/=/g;
	$value =~ s/\|quot\|/\"/g;
	$value =~ s/\|apos\|/\'/g;
	$value =~ s/\|amp\|/\&/g;
	$FILE{$key} = $value;
}
$vCode = $FILE{'code'};
$vShow = $FILE{'show'};
$vTitle = $FILE{'title'};
	$vTitle = &tag_change($vTitle);
	$vTitle = &EmojiTagToGif($vTitle);
$vMessage = $FILE{'message'};
	$vMessage = &inline_link($vMessage);
	$vMessage = &tag_change($vMessage);
	$vMessage = &EmojiTagToGif($vMessage);
	$vMessage =~ s/\|br\|//g;
	if ($vMessage ne "") { $vMessage=$vMessage.'<br>'; } else { $vMessage=''; }
$vPhone = $FILE{'phone'};
	if ($vPhone ne "") { $vPhone='TEL: <a href=tel:'.$vPhone.'>'.$vPhone.'</a><br>'; } else { $vPhone=''; }
$vFax = $FILE{'fax'};
	if ($vFax ne "") { $vFax='FAX: '.$vFax.'<br>'; } else { $vFax=''; }
$vAlign = $FILE{'align'};
$DefIdo = $FILE{'ido'};
$DefKeido = $FILE{'keido'};

##GPS座標取得
if ($xCR eq 'dc') {
	#ドコモ
	($gido1,$gido2,$gido3a,$gido3b)=split(/\./,$in{'lat'});
	$gido2=$gido2/60;
	$gido3=$gido3a.'.'.$gido3b;
	$gido3=$gido3/3600;
	$gido=$gido1+$gido2+$gido3;
	($gkeido1,$gkeido2,$gkeido3a,$gkeido3b)=split(/\./,$in{'lon'});
	$gkeido2=$gkeido2/60;
	$gkeido3=$gkeido3a.'.'.$gkeido3b;
	$gkeido3=$gkeido3/3600;
	$gkeido=$gkeido1+$gkeido2+$gkeido3;
} elsif ($xCR eq 'ez') {
	#AU-KDDI
	$gido=$in{'lat'};
	$gkeido=$in{'lon'};
} elsif ($xCR eq 'sb') {
	#SoftBank
	$gpos=$in{'pos'};
	if ($gpos =~ /E/) {	($gido60,$gkeido60)=split(/E/,$gpos); }
	if ($gpos =~ /W/) {	($gido60,$gkeido60)=split(/W/,$gpos); }
	$gido60 =~ s/N//g;	$gido60 =~ s/S//g;
	$gkeido60 =~ s/E//g;	$gkeido60 =~ s/W//g;
	($gido1,$gido2,$gido3a,$gido3b)=split(/\./,$gido60);
	$gido2=$gido2/60;
	$gido3=$gido3a.'.'.$gido3b;
	$gido3=$gido3/3600;
	$gido=$gido1+$gido2+$gido3;
	($gkeido1,$gkeido2,$gkeido3a,$gkeido3b)=split(/\./,$gkeido60);
	$gkeido2=$gkeido2/60;
	$gkeido3=$gkeido3a.'.'.$gkeido3b;
	$gkeido3=$gkeido3/3600;
	$gkeido=$gkeido1+$gkeido2+$gkeido3;
} else {
	$gido=$DefIdo;
	$gkeido=$DefKeido;
}

##スタート座標＆マーカー座標
$CenterX=$in{'cx'};
if ($CenterX eq '') { $CenterX = $gkeido; }
$pCenterX=int($CenterX * 1000000);

$CenterY=$in{'cy'};
if ($CenterY eq '') { $CenterY = $gido; }
$pCenterY=int($CenterY * 1000000);

##表示座標
$ViewX=$in{'vx'};
if ($ViewX eq '') { $ViewX = $gkeido; }
$pViewX=int($ViewX * 1000000);

$ViewY=$in{'vy'};
if ($ViewY eq '') { $ViewY = $gido; }
$pViewY=int($ViewY * 1000000);

##デフォルトズーム度
$Zoom=$in{'zm'};
if ($Zoom eq '') { $Zoom = $DefZoom; }
$pZoom=$ZmLv[$Zoom];

##ズームアップ＆ダウン
if ($Zoom==0) { $sel0=' selected'; } else { $sel0=''; }
if ($Zoom==1) { $sel1=' selected'; } else { $sel1=''; }
if ($Zoom==2) { $sel2=' selected'; } else { $sel2=''; }
if ($Zoom==3) { $sel3=' selected'; } else { $sel3=''; }
if ($Zoom==4) { $sel4=' selected'; } else { $sel4=''; }
if ($Zoom==5) { $sel5=' selected'; } else { $sel5=''; }
if ($Zoom==6) { $sel6=' selected'; } else { $sel6=''; }
if ($Zoom==7) { $sel7=' selected'; } else { $sel7=''; }
if ($Zoom==8) { $sel8=' selected'; } else { $sel8=''; }
if ($Zoom==9) { $sel9=' selected'; } else { $sel9=''; }

##移動先座標
$EastViewX = $ViewX + (0.000003 * $pZoom);
$WestViewX = $ViewX - (0.000003 * $pZoom);
$NorthViewY = $ViewY + (0.000003 * $pZoom);
$SouthViewY = $ViewY - (0.000003 * $pZoom);

##GMAP出力
if (($FILE{'ido'} ne 'NoneSet')||($FILE{'keido'} ne 'NoneSet')) {
$html_gmap = <<"GMAP";
<font color=$mbHcolor>現在地</font>
<center>
<hr>
<form action="$cginame" method="GET">
<img src="$BaseURL?latitude_e6=$pViewY&longitude_e6=$pViewX&zm=$pZoom&w=$MapWidth&h=$MapHeight&cc=US&min_priority=1&Point=b&Point.latitude_e6=$pCenterY&Point.longitude_e6=$pCenterX&Point.iconid=16&Point=e"><br>
<br>
<a href="$cginame?mode=gps&cx=$CenterX&cy=$CenterY&vx=$WestViewX&vy=$NorthViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="1">[1]</a>
<a href="$cginame?mode=gps&cx=$CenterX&cy=$CenterY&vx=$ViewX&vy=$NorthViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="2">[↑2]</a>
<a href="$cginame?mode=gps&cx=$CenterX&cy=$CenterY&vx=$EastViewX&vy=$NorthViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="3">[3]</a>
<br>
<a href="$cginame?mode=gps&cx=$CenterX&cy=$CenterY&vx=$WestViewX&vy=$ViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="4">[4←]</a>
<a href="$cginame?mode=gps&cx=$DefKeido&cy=$DefIdo&vx=$DefKeido&vy=$DefIdo&zm=$Zoom&code=$code&pline=$pline" accesskey="5">[始5]</a>
<a href="$cginame?mode=gps&cx=$CenterX&cy=$CenterY&vx=$EastViewX&vy=$ViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="6">[→6]</a>
<br>
<a href="$cginame?mode=gps&cx=$CenterX&cy=$CenterY&vx=$WestViewX&vy=$SouthViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="7">[7]</a>
<a href="$cginame?mode=gps&cx=$CenterX&cy=$CenterY&vx=$ViewX&vy=$SouthViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="8">[↓8]</a>
<a href="$cginame?mode=gps&cx=$CenterX&cy=$CenterY&vx=$EastViewX&vy=$SouthViewY&zm=$Zoom&code=$code&pline=$pline" accesskey="9">[9]</a>
<hr>
縮尺<select name="zm">
<option value="0"$sel0>1/3千</option>
<option value="1"$sel1>1/5千</option>
<option value="2"$sel2>1/1万</option>
<option value="3"$sel3>1/2万</option>
<option value="4"$sel4>1/3万</option>
<option value="5"$sel5>1/7.5万</option>
<option value="6"$sel6>1/15万</option>
<option value="7"$sel7>1/30万</option>
<option value="8"$sel8>1/90万</option>
<option value="9"$sel9>1/150万</option>
</select>
<input type="submit" value="変更">
<input type="hidden" name="mode" value="gps">
<input type="hidden" name="cx" value="$CenterX">
<input type="hidden" name="cy" value="$CenterY">
<input type="hidden" name="vx" value="$ViewX">
<input type="hidden" name="vy" value="$ViewY">
<input type="hidden" name="code" value="$code">
<input type="hidden" name="cat" value="$incat">
<input type="hidden" name="pline" value="$pline">
<br>
先ほどのページへは、ブラウザバックで戻ってください
</form>
</center>
GMAP
} else {
$html_gmap = <<"GMAP";
<font color=$mbHcolor>$vTitle</font>
<hr>
GMAP
}
if ($mboutCode eq 'sjis') { Encode::from_to($html_gmap, 'utf8', 'shiftjis'); }
print $html_gmap;

}
##=======================================================================================
sub ezmovie {

$ezmvpath = $img_path.$in{'ezmvfile'}.'';
$ezmvsize = -s $ezmvpath;
if ($RootPath eq '') { $EzURL='http://'.$Domain.'/'.$DirName; }
else { $EzURL='http://'.$Domain.'/'.$RootPath.'/'.$DirName; }

$XMLBody = <<"XMLBody";
<?xml version="1.0"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML Basic 1.0//EN"
"http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<body>
<object data="$EzURL/file/$in{'ezmvfile'}" type="video/3gpp2" standby="MoviePlay" copyright="no">'
<param name="disposition" value="devmpzz" valuetype="data" />
<param name="size" value="$ezmvsize" valuetype="data" />
<param name="title" value="$DATE3" valuetype="data" /></object>
</body>
</html>
XMLBody

print "Content-type: text/html\n\n";
if ($mboutCode eq 'sjis') { Encode::from_to($XMLBody, 'utf8', 'shiftjis'); }
print $XMLBody;
exit;

}
##=======================================================================================
sub data_read {
	if (open(DBREAD,"$datafile")) {
		@DATA = <DBREAD>;
		close(DBREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($datafile);
		if ($contCC eq 'shiftjis') {
			foreach (@DATA) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else { &errorout('DBファイルの読込に失敗しました。'); }
}
##=======================================================================================
sub page_read {
	$rMobiSkin='..'.$MobiSkin;
	if (open(PAGEREAD,"$rMobiSkin")) {
		@PAGE = <PAGEREAD>;
		close(PAGEREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($rMobiSkin);
		if ($contCC eq 'shiftjis') {
			foreach (@PAGE) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else {
		$alMobiSkin=$rMobiSkin; $alMobiSkin=~ s/\.\.//i;
		$PAGE[0] ='<html>'."\n";
		$PAGE[1] ='<head><meta http-equiv="Content-Type" content="text/html;charset='.$mboutCode.'"></head>'."\n";
		$PAGE[2] ='<body><font color="red">[設定]にて指定したスキンファイル ['.$alMobiSkin.'] が存在しません</font><br>'."\n";
		$PAGE[3] ='<font color="red">[設定]にて正しいスキンファイルを指定するか、[スキン編集]にて作成する必要があります</font>'."\n";
		$PAGE[4] ='<!-- MainZone -->'."\n";
		$PAGE[5] ='<body></html>'."\n";
	}
	$pageflag = 0;
	@PHEAD = (); @PFOOT = (); $pi = 0;
	foreach (@PAGE) {
		if ($PAGE[$pi] =~ /MainZone/i) { $pageflag = 1; }
		if ($pageflag==0) { push(@PHEAD,$PAGE[$pi]); }
		if ($pageflag==1) { push(@PFOOT,$PAGE[$pi]); }
		$pi++;
	}
}
##=======================================================================================
sub tag_change {
	##	$var = &tag_change($var); で変換する
	if ($RootPath ne '') { $TcRootPath='/'.$RootPath; } else { $TcRootPath=''; }
	local($_) = $_[0];
	1 while s/\[new\]/<img src=\"$TcRootPath\/icon\/new\.gif\" align=\"middle\" alt=\"new\" border=\"0\" \/>/g;
	1 while s/\[red\]/<font color=\"\#FF0000\">/g;
	1 while s/\[\/red\]/<\/font>/g;
	1 while s/\[blue\]/<font color=\"\#0000FF\">/g;
	1 while s/\[\/blue\]/<\/font>/g;
	1 while s/\[green\]/<font color=\"\#009900\">/g;
	1 while s/\[\/green\]/<\/font>/g;
	1 while s/AeDirTop/mobi.cgi/g;
	$_;
}
##=======================================================================================
sub errorout {

$error = $_[0];

##★エラーメッセージの変更はここを訂正
$errHTML = <<"ERRORMESS";
<font color=#ff0000>ERROR</font><br>
$error
ERRORMESS

if ($mboutCode eq 'sjis') { Encode::from_to($errHTML, 'utf8', 'shiftjis'); }
print $errHTML;
&html_foot;
exit;

}
##=======================================================================================
