#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT HTML-EDIT v3.0.9
## (c)2008-2010 NorenzPRO Ltd. TakafumiArai 2010/9/16
##=======================================================================##

##=======================================================================##
## 設定項目
##=======================================================================##

##★ライブラリ
use Encode;
require '../admin/aelib.cgi';

##★このスクリプトの名前
$cginame = 'index.cgi';

##★データファイルのパス
$datafile = './data.dat';

##=====================================================================================##
##メインルーチン
##=====================================================================================##

##キャリア転送
$ua = $ENV{"HTTP_USER_AGENT"};
if ($ua =~ /DoCoMo\/1\.0/i) { $xCR='mobi'; }
elsif ($ua =~ /Mozilla/i) { $xCR='pc'; }
elsif ($ua =~ /(DoCoMo\/2\.0|FOMA)/i) { $xCR='mobi'; }
elsif ($ua =~ /^(SoftBank|Vodafone|J\-PHONE|MOT\-[CV])/i) { $xCR='mobi'; }
elsif ($ua =~ /^UP\.Browser/i) { $xCR='mobi'; }
elsif ($ua =~ /^(KDDI\-|OPWV|MMP)/i) { $xCR='mobi'; }
else { $xCR='pc'; }
if ($xCR eq 'mobi') {
	print "Location:mobi.cgi?".$ENV{'QUERY_STRING'}."\n\n";
	exit;
}

##システム設定ファイル読込
$servconf = '../admin/conf.dat';
if (-e $servconf) {
	open(SVCFGRD,"$servconf");
	@SVCONF = <SVCFGRD>;
	close(SVCFGRD);
	##文字コード判定→UTF8変換
	my $contCC=&checkCharCode($servconf);
	if ($contCC eq 'shiftjis') {
		foreach (@SVCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
	}
	$Domain =$SVCONF[3];
	$Domain =~ s/\r//g; $Domain =~ s/\n//g;
	$RootPath =$SVCONF[10];
	$RootPath =~ s/\r//g; $RootPath =~ s/\n//g;
	$pcoutCode =$SVCONF[22];
	$pcoutCode =~ s/\r//g; $pcoutCode =~ s/\n//g;
}
if ($pcoutCode eq '') { $pcoutCode='sjis'; }

##設定ファイル読込
$conffile='./conf.dat';
open(CONFRD,"$conffile");
@CONF = <CONFRD>;
close(CONFRD);
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($conffile);
if ($contCC eq 'shiftjis') {
	foreach (@CONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}
$PageTitle =$CONF[1];
$PageTitle =~ s/\r//g;$PageTitle =~ s/\n//g;
$SkinFile =$CONF[2];
$SkinFile =~ s/\r//g;$SkinFile =~ s/\n//g;
$SkinFile ='..'.$SkinFile;
$HtmlHeader =$CONF[16];
$HtmlHeader =~ s/\r//g;$HtmlHeader =~ s/\n//g;
$HtmlHeader =~ s/<br>/\n/g;
$PgTitleClass =$CONF[17];
$PgTitleClass =~ s/\r//g;$PgTitleClass =~ s/\n//g;

##==============メインアクション==============

&html_head;
&html_list;
&html_foot;
exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub html_head {

#スキンページ読込
&page_read;
if ($PgTitleClass ne '') { $addTitleClass=' class="'.$PgTitleClass.'"'; }

print "Content-type: text/html\n\n";
$phi=0;
foreach (@PHEAD) {
	if ($pcoutCode eq 'sjis') { Encode::from_to($PHEAD[$phi], 'utf8', 'shiftjis'); }
	print $PHEAD[$phi];
	$phi++;
}
if ($PageTitle ne '') {
	$tagMessage= '<h2'.$addTitleClass.'>'.$PageTitle.'</h2>';
	if ($pcoutCode eq 'sjis') { Encode::from_to($tagMessage, 'utf8', 'shiftjis'); }
	print $tagMessage;
}

}
##=======================================================================================
sub html_foot {

#スキンページ読込
&page_read;

$pfi=0;
foreach (@PFOOT) {
	if ($pcoutCode eq 'sjis') { Encode::from_to($PFOOT[$pfi], 'utf8', 'shiftjis'); }
	print $PFOOT[$pfi];
	$pfi++;
}

}
##=======================================================================================
sub html_list {

&data_read;

print '<div class="KijiArea">'."\n";
$dataLot=@DATA;
$i=0;
for (1..$dataLot) {
	$DATA[$i] =~ s/<br>/<br \/>/g;
	$DATA[$i] =~ s/<BR>/<br \/>/g;
	$DATA[$i] = &cgi_include($DATA[$i]);
	$DATA[$i] = &url_import($DATA[$i]);
	if ($pcoutCode eq 'sjis') { Encode::from_to($DATA[$i], 'utf8', 'shiftjis'); }
	print $DATA[$i];
	$i++;
}
print '</div>'."\n";

}
##=======================================================================================
sub data_read {
	if (open(DBREAD,"$datafile")) {
		@DATA = <DBREAD>;
		close(DBREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($datafile);
		if ($contCC eq 'shiftjis') {
			foreach (@DATA) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else { &errorout('DBファイルの読込に失敗しました。'); }
}
##=======================================================================================
sub page_read {

	if ($RootPath ne '') { $BaseRoot='/'.$RootPath; } else { $BaseRoot=''; }
	$QRCodeS='<img src="http://adedit.norenz.net/qrcode/qr_img.cgi?d=http://'.$Domain.$BaseRoot.'/mobi/&amp;s=2" alt="QRコード" />';
	$QRCodeM='<img src="http://adedit.norenz.net/qrcode/qr_img.cgi?d=http://'.$Domain.$BaseRoot.'/mobi/&amp;s=3" alt="QRコード" />';
	$QRCodeL='<img src="http://adedit.norenz.net/qrcode/qr_img.cgi?d=http://'.$Domain.$BaseRoot.'/mobi/&amp;s=4" alt="QRコード" />';

	if (open(PAGEREAD,"$SkinFile")) {
		@PAGE = <PAGEREAD>;
		close(PAGEREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($SkinFile);
		if ($contCC eq 'shiftjis') {
			foreach (@PAGE) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else {
		$alSkinFile=$SkinFile; $alSkinFile=~ s/\.\.//i;
		$PAGE[0] ='<html>'."\n";
		$PAGE[1] ='<head><meta http-equiv="Content-Type" content="text/html;charset='.$pcoutCode.'"></head>'."\n";
		$PAGE[2] ='<body><h2 style="color:red">[設定]にて指定したスキンファイル ['.$alSkinFile.'] が存在しません</h2>'."\n";
		$PAGE[3] ='<span style="color:red">[設定]にて正しいスキンファイルを指定するか、[スキン編集]にて作成する必要があります</span>'."\n";
		$PAGE[4] ='<!-- MainZone -->'."\n";
		$PAGE[5] ='</body></html>'."\n";
	}
	#AD-EDITでメニューデータがあれば表示
	$MenuFile=''; $mzi=1;
	for (0..99) {
		@MenuZone=();
		$MenuHTML[$mzi]='';
		$MenuFile='../admin/menu'.$mzi.'.inc';
		if (-e $MenuFile) {
			open(MENURD,"$MenuFile");
			@MenuZone = <MENURD>;
			close(MENURD);
			##文字コード判定→UTF8変換
			my $contCC=&checkCharCode($MenuFile);
			if ($contCC eq 'shiftjis') {
				foreach (@MenuZone) { Encode::from_to($_, 'shiftjis', 'utf8'); }
			}
			$LotMenuLine=@MenuZone;
			$mzline=0;
			for (0..$LotMenuLine) { $MenuHTML[$mzi]=$MenuHTML[$mzi].$MenuZone[$mzline].''; $mzline++; }
		} else { last; }
		$mzi++;
	}
	$mzi=$mzi-1;
	$pageflag = 0;
	@PHEAD = (); @PFOOT = (); $pi = 0;
	foreach (@PAGE) {
		if ($PAGE[$pi] =~ /MainZone/i) {
			$PAGE[$pi]=~ s/<\!-- MainZone -->/<\!--MainZone-->/g;
			($SkinBefore,$SkinAfter)=split(/<\!--MainZone-->/,$PAGE[$pi]);
			$PAGE[$pi]=$SkinBefore;
			push(@PFOOT,$SkinAfter);
			$pageflag = 1;
		}
		$mzj=1;
		for (0..$mzi) {
			$PAGE[$pi]=~ s/<MenuZone$mzj>/$MenuHTML[$mzj]/g;
			$mzj++;
		}
		$PAGE[$pi]=~ s/<QRCodeS>/$QRCodeS/g;
		$PAGE[$pi]=~ s/<QRCodeM>/$QRCodeM/g;
		$PAGE[$pi]=~ s/<QRCodeL>/$QRCodeL/g;
		$PAGE[$pi]=~ s/<\/title>/ - $PageTitle<\/title>/i;
		$PAGE[$pi]=~ s/<\/head>/$HtmlHeader\n<\/head>/i;
		$PAGE[$pi]=~ s/<\/h1>/ - $PageTitle<\/h1>/i;
		$PAGE[$pi] = &cgi_include($PAGE[$pi]);
		$PAGE[$pi] = &url_import($PAGE[$pi]);
		if ($pageflag==0) { push(@PHEAD,$PAGE[$pi]); }
		if ($pageflag==1) { push(@PFOOT,$PAGE[$pi]); }
		$pi++;
	}
}
##=======================================================================================
sub errorout {

$error = $_[0];

$ReturnLink='<a href="javascript:history.go(-1)">[先程のページへ戻る]</a>';

##★エラーメッセージの変更はここを訂正
$errHTML = <<"ERRORMESS";
<h4 align="center"><span style="color:#ff0000">ERROR</span></h4>
<div align="center">&nbsp;<br />$error<br />&nbsp;<br />$ReturnLink</div>
ERRORMESS

if ($pcoutCode eq 'sjis') { Encode::from_to($errHTML, 'utf8', 'shiftjis'); }
print $errHTML;
&html_foot;
exit;

}
##=======================================================================================
