#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT LIST-NAVI v3.0.9
## (c)2008-2010 NorenzPRO Ltd. TakafumiArai 2010/9/16
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##★ライブラリ
use Encode;
require '../admin/aelib.cgi';

##★このスクリプトの名前
$cginame = 'mobi.cgi';

##★データファイルのパス
$datafile = './data.dat';

##★アップロード画像格納ディレクトリ（相対・絶対パス）
$img_dir = './file/';

##★アップロード画像公開ディレクトリ（相対・絶対パス）
$img_path = './file/';

##★サムネール画像タイプ
@ImageType=('jpg','gif');

##=====================================================================================##
##メインルーチン
##=====================================================================================##

##キャリア識別
$ua = $ENV{"HTTP_USER_AGENT"};
if ($ua =~ /DoCoMo\/1\.0/i) { $xCR='dc'; }
elsif ($ua =~ /Mozilla/i) { $xCR='pc'; }
elsif ($ua =~ /(DoCoMo\/2\.0|FOMA)/i) { $xCR='dc'; }
elsif ($ua =~ /^(SoftBank|Vodafone|J\-PHONE|MOT\-[CV])/i) { $xCR='sb'; }
elsif ($ua =~ /^UP\.Browser/i) { $xCR='ez'; }
elsif ($ua =~ /^(KDDI\-|OPWV|MMP)/i) { $xCR='ez'; }
else { $xCR='pc'; }

##システム設定ファイル読込
$servconf = '../admin/conf.dat';
if (-e $servconf) {
	open(SVCFGRD,"$servconf");
	@SVCONF = <SVCFGRD>;
	close(SVCFGRD);
	##文字コード判定→UTF8変換
	my $contCC=&checkCharCode($servconf);
	if ($contCC eq 'shiftjis') {
		foreach (@SVCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
	}
	$Domain =$SVCONF[3];
	$Domain =~ s/\r//g; $Domain =~ s/\n//g;
	$RootPath =$SVCONF[10];
	$RootPath =~ s/\r//g; $RootPath =~ s/\n//g;
	$mboutCode =$SVCONF[23];
	$mboutCode =~ s/\r//g; $mboutCode =~ s/\n//g;
}
if ($mboutCode eq '') { $mboutCode='sjis'; }

##設定ファイル読込
$conffile='./conf.dat';
open(CONFRD,"$conffile");
@CONF = <CONFRD>;
close(CONFRD);
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($conffile);
if ($contCC eq 'shiftjis') {
	foreach (@CONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}
$FileTypeLine =$CONF[12];
$FileTypeLine =~ s/\r//g;$FileTypeLine =~ s/\n//g;
@FileType=split(/:/,$FileTypeLine);
$TimeStamp =$CONF[13];
$TimeStamp =~ s/\r//g;$TimeStamp =~ s/\n//g;
$DirName =$CONF[14];
$DirName =~ s/\r//g;$DirName =~ s/\n//g;
$MobiTitle =$CONF[15];
$MobiTitle =~ s/\r//g;$MobiTitle =~ s/\n//g;
$mbcolor =$CONF[16];
$mbcolor =~ s/\r//g;$mbcolor =~ s/\n//g;
$mbview =$CONF[17];
$mbview =~ s/\r//g;$mbview =~ s/\n//g;
$mbHmark =$CONF[19];
$mbHmark =~ s/\r//g;$mbHmark =~ s/\n//g;
$mbHcolor =$CONF[20];
$mbHcolor =~ s/\r//g;$mbHcolor =~ s/\n//g;
$MobiHeadMsg =$CONF[22];
$MobiHeadMsg =~ s/\r//g;$MobiHeadMsg =~ s/\n//g;
$MobiHeadMsg = &inline_link($MobiHeadMsg);
$MobiHeadMsg = &tag_change($MobiHeadMsg);
$MobiHeadMsg =~ s/<br>/<br \/>\&\#32\;/g;
$MobiBack =$CONF[26];
$MobiBack =~ s/\r//g;$MobiBack =~ s/\n//g;
$MobiBack =~ s/</&lt;/g;$MobiBack =~ s/>/&gt;/g;
$MobiNext =$CONF[27];
$MobiNext =~ s/\r//g;$MobiNext =~ s/\n//g;
$MobiNext =~ s/</&lt;/g;$MobiNext =~ s/>/&gt;/g;
$MobiToHome =$CONF[28];
$MobiToHome =~ s/\r//g;$MobiToHome =~ s/\n//g;
$MobiToHome =~ s/</&lt;/g;$MobiToHome =~ s/>/&gt;/g;
$MobiSkin =$CONF[31];
$MobiSkin =~ s/\r//g;$MobiSkin =~ s/\n//g;

if ($MobiSkin eq '') { $MobiSkin='/skin/mobi.html'; }
if ($MobiBack eq '') { $MobiBack='[＜前]'; }
if ($MobiNext eq '') { $MobiNext='[次＞]'; }
if ($MobiToHome eq '') { $MobiToHome='[HOME]'; }

##フォームの取得
$buffer = $ENV{'QUERY_STRING'};
@pairs = split(/&/,$buffer);
for $pair (@pairs) {
	($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	if ($mboutCode eq 'sjis') { Encode::from_to($value, 'shiftjis', 'utf8'); }
	$in{$name} = $value;
}

##==============メインアクション==============

if ($in{'mode'} eq 'ezmovie') { &ezmovie; }
else { &list; }
exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub html_head {

if ($RootPath ne '') {
	$RssURL='http://'.$Domain.'/'.$RootPath.'/'.$DirName.'/rdfmb.cgi';
} else {
	$RssURL='http://'.$Domain.'/'.$DirName.'/rdfmb.cgi';
}
$RdfTag='<link rel="alternate" type="application/rss+xml" title="'.$MobiTitle.'" href="'.$RssURL.'" />';

#スキンページ読込
&page_read;

print "Content-type: text/html\n\n";
$phi=0;
foreach (@PHEAD) {
	$PHEAD[$phi]=~ s/<\/title>/ $MobiTitle<\/title>/g;
	$PHEAD[$phi]=~ s/<\/head>/$RdfTag\n<\/head>/g;
	if ($mboutCode eq 'sjis') { Encode::from_to($PHEAD[$phi], 'utf8', 'shiftjis'); }
	print $PHEAD[$phi];
	$phi++;
}
if ($MobiHeadMsg ne '') { $MobiHeadMsg='<br>'.$MobiHeadMsg; } else { $MobiHeadMsg=''; }
$htHead = <<"htHead";
<font color=$mbcolor>$MobiTitle</font>
$MobiHeadMsg
<hr>
htHead
if ($mboutCode eq 'sjis') { Encode::from_to($htHead, 'utf8', 'shiftjis'); }
print $htHead;

}
##=======================================================================================
sub html_foot {

if ($MobiToHome ne 'none') { $TagHome='<hr><a href="../mobi/">'.$MobiToHome.'</a>'; }

$htFoot = <<"htFoot";
$TagHome
htFoot
if ($mboutCode eq 'sjis') { Encode::from_to($htFoot, 'utf8', 'shiftjis'); }
print $htFoot;

#スキンページ読込
&page_read;
$pfi=0;
foreach (@PFOOT) {
	if ($mboutCode eq 'sjis') { Encode::from_to($PFOOT[$pfi], 'utf8', 'shiftjis'); }
	print $PFOOT[$pfi];
	$pfi++;
}

}
##=======================================================================================
sub list {

##★フォーム取得
$input_pline = $in{'pline'};

&html_head;
&html_list;
&html_foot;

exit;
}
##=======================================================================================
sub html_list {

&data_read;
@TRUE = grep(/code=/,@DATA);
@NEW = grep(/\tshow=on\t/,@TRUE);
if ($in{'mode'} eq "preview") {
	@NEW=();
	@NEW = grep(/code=$in{'prevcode'}\t/,@TRUE);
}

if ($in{'pline'} eq '') { $pline = 0; } else { $pline = $in{'pline'}; }
$end_data = @NEW - 1;
$page_top = $pline;
$page_end = $pline + ($mbview - 1);
if ($page_end >= $end_data) { $page_end = $end_data; }

foreach ($pline .. $page_end) {
	$f1_code='';
	$f1_show='';
	$f1_date='';
	$f1_label='';
	$f1_title='';
	$f1_sub='';
	$f1_tclass='';
	$fv_tclass='';
	$f1_url='';
	$f1_mrl='';
	$f1_filetag='';
	$f0_imgtag='';
	$flink1='';
	$flink2='';
	$FILE{'tclass'}='';
	$f1_code=''; $f0_imgtag='';
	$f0_jpgpath=''; $h0_jpgpath='';
	$f0_gifpath=''; $h0_gifpath='';
	$f0_pngpath=''; $h0_pngpath='';
	$FtypeImg='';
	@LINE = split(/\t/,$NEW[$_]);
	foreach (@LINE) {
		($key, $value) = split(/=/,$_);
		$value =~ s/\|eq\|/=/g;
		$value =~ s/\|quot\|/\"/g;
		$value =~ s/\|apos\|/\'/g;
		$FILE{$key} = $value;
	}
	$f1_code = $FILE{'code'};
	$f1_show = $FILE{'show'};
	$f1_date = $FILE{'date'};
	$f1_label = $FILE{'label'};
		if ($FILE{'label'} eq'') { $f1_label='li'; }
	$f1_title = $FILE{'title'};
		$f1_title = &tag_change($f1_title);
	$f1_sub = $FILE{'sub'};
		$f1_sub = &tag_change($f1_sub);
	$f1_tclass = $FILE{'tclass'};
	$f1_url = $FILE{'url'};
	$f1_mrl = $FILE{'mrl'};
	##★イメージリンク表示
	$FtLot=@FileType-1;$i=0;
	for (0..$FtLot) {
		$f1_filepath = $img_dir.$f1_code.'1.'.$FileType[$i];
		$h1_filepath = $img_path.$f1_code.'1.'.$FileType[$i];
		if ($FileType[$i] eq 'jpg') { $FtypeName='[JPG画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'gif') { $FtypeName='[GIF画像]'; $FtypeImg=1; }
		elsif ($FileType[$i] eq 'doc') { $FtypeName='[WORD書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'docx') { $FtypeName='[WORD2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'xls') { $FtypeName='[EXCEL書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'xlsx') { $FtypeName='[EXCEL2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'ppt') { $FtypeName='[PPT書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'pptx') { $FtypeName='[PPT2007書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'jtd') { $FtypeName='[一太郎書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'txt') { $FtypeName='[テキスト書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'pdf') { $FtypeName='[PDF書類]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mp3') { $FtypeName='[MP3音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'wma') { $FtypeName='[WMA音声]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mmf') { $FtypeName='[音声再生]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mld') { $FtypeName='[音声再生]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'wmv') { $FtypeName='[WMV動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'mp4') { $FtypeName='[MPEG4動画]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq '3gp') { $FtypeName='[動画再生]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq '3g2') { $FtypeName='[動画再生]'; $FtypeImg=2; }
		elsif ($FileType[$i] eq 'zip') { $FtypeName='[ZIPファイル]'; $FtypeImg=0; }
		elsif ($FileType[$i] eq 'lzh') { $FtypeName='[LZHファイル]'; $FtypeImg=0; }
		##ファイル添付の場合はファイルへリンク
		if ((-e $f1_filepath)&&($FtypeImg==2)&&($xCR eq 'ez')) {
			$ezmvurl=$cginame.'?mode=ezmovie&ezmvfile='.$f1_code.'1.'.$FileType[$i];
			$flink1='<a href="'.$ezmvurl.'"  target="_blank">';
			$flink2='</a>';
			last;
		} elsif (-e $f1_filepath) {
			$flink1='<a href="'.$h1_filepath.'"  target="_blank">';
			$flink2='</a>';
			last;
		}
		$i++;
	}
	##★URLリンクの場合はURLへリンク
	if ($f1_mrl ne '') {
		$flink1='<a href="'.$f1_mrl.'">';
		$flink2='</a>';
	}
	##★管理画面リストの変更はここを訂正
	if ($f1_mrl ne '') { $fv_mrl='<a href="'.$f1_mrl.'">'.$MobiToDetail.'</a>'; $f1_filetag=''; } else { $fv_mrl=''; }
	if (($TimeStamp eq '1')&&($f1_date ne '')) { $TTtag=$f1_date.'<br>'; } else { $TTtag=''; }
	if ($f1_title ne "") {
		if ($f1_label eq 'li') {
			$htmlc_list = <<"LISTC";
			<div><font color=$mbHcolor>$mbHmark$flink1 $f1_title $f1_sub $flink2</font><br>$TTtag </div>
LISTC
		} elsif($f1_label eq 'text') {
			$htmlc_list = <<"LISTC";
			<div>$f1_title $f1_sub</div>
LISTC
		} else {
			$htmlc_list = <<"LISTC";
			<div><hr><font color=$mbHcolor>▼ $f1_title </font></div>
LISTC
		}
		if ($mboutCode eq 'sjis') { Encode::from_to($htmlc_list, 'utf8', 'shiftjis'); }
		print $htmlc_list;
	}
}

$next_line = $page_end + 1;
$back_line = $page_top - $mbview;

print "<hr>\n";
if ($page_top != 0) {
	$tagNavigator= "<a href=$cginame?mode=list&pline=$back_line>$MobiBack</a>\n";
	if ($mboutCode eq 'sjis') { Encode::from_to($tagNavigator, 'utf8', 'shiftjis'); }
	print $tagNavigator;
}
if ($page_end != $end_data) {
	$tagNavigator= "<a href=$cginame?mode=list&pline=$next_line>$MobiNext</a>\n";
	if ($mboutCode eq 'sjis') { Encode::from_to($tagNavigator, 'utf8', 'shiftjis'); }
	print $tagNavigator;
}


}
##=======================================================================================
sub ezmovie {

$ezmvpath = $img_path.$in{'ezmvfile'}.'';
$ezmvsize = -s $ezmvpath;
if ($RootPath eq '') { $EzURL='http://'.$Domain.'/'.$DirName; }
else { $EzURL='http://'.$Domain.'/'.$RootPath.'/'.$DirName; }

$XMLBody = <<"XMLBody";
<?xml version="1.0"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML Basic 1.0//EN"
"http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<body>
<object data="$EzURL/file/$in{'ezmvfile'}" type="video/3gpp2" standby="MoviePlay" copyright="no">'
<param name="disposition" value="devmpzz" valuetype="data" />
<param name="size" value="$ezmvsize" valuetype="data" />
<param name="title" value="$DATE3" valuetype="data" /></object>
</body>
</html>
XMLBody

print "Content-type: text/html\n\n";
if ($mboutCode eq 'sjis') { Encode::from_to($XMLBody, 'utf8', 'shiftjis'); }
print $XMLBody;

}
##=======================================================================================
sub data_read {
	if (open(DBREAD,"$datafile")) {
		@DATA = <DBREAD>;
		close(DBREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($datafile);
		if ($contCC eq 'shiftjis') {
			foreach (@DATA) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else { &errorout('DBファイルの読込に失敗しました。'); }
}
##=======================================================================================
sub page_read {
	$rMobiSkin='..'.$MobiSkin;
	if (open(PAGEREAD,"$rMobiSkin")) {
		@PAGE = <PAGEREAD>;
		close(PAGEREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($rMobiSkin);
		if ($contCC eq 'shiftjis') {
			foreach (@PAGE) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else {
		$alMobiSkin=$rMobiSkin; $alMobiSkin=~ s/\.\.//i;
		$PAGE[0] ='<html>'."\n";
		$PAGE[1] ='<head><meta http-equiv="Content-Type" content="text/html;charset='.$mboutCode.'"></head>'."\n";
		$PAGE[2] ='<body><font color="red">[設定]にて指定したスキンファイル ['.$alMobiSkin.'] が存在しません</font><br>'."\n";
		$PAGE[3] ='<font color="red">[設定]にて正しいスキンファイルを指定するか、[スキン編集]にて作成する必要があります</font>'."\n";
		$PAGE[4] ='<!-- MainZone -->'."\n";
		$PAGE[5] ='</body></html>'."\n";
	}
	$pageflag = 0;
	@PHEAD = (); @PFOOT = (); $pi = 0;
	foreach (@PAGE) {
		if ($PAGE[$pi] =~ /MainZone/i) { $pageflag = 1; }
		if ($pageflag==0) { push(@PHEAD,$PAGE[$pi]); }
		if ($pageflag==1) { push(@PFOOT,$PAGE[$pi]); }
		$pi++;
	}
}
##=======================================================================================
sub tag_change {
	##	$var = &tag_change($var); で変換する
	if ($RootPath ne '') { $TcRootPath='/'.$RootPath; } else { $TcRootPath=''; }
	local($_) = $_[0];
	1 while s/\[new\]/<img src=\"$TcRootPath\/icon\/new\.gif\" align=\"middle\" alt=\"new\" border=\"0\" \/>/g;
	1 while s/\[red\]/<font color=\"\#FF0000\">/g;
	1 while s/\[\/red\]/<\/font>/g;
	1 while s/\[blue\]/<font color=\"\#0000FF\">/g;
	1 while s/\[\/blue\]/<\/font>/g;
	1 while s/\[green\]/<font color=\"\#009900\">/g;
	1 while s/\[\/green\]/<\/font>/g;
	1 while s/AeDirTop/mobi.cgi/g;
	$_;
}
##=======================================================================================
sub errorout {

$error = $_[0];

##★エラーメッセージの変更はここを訂正
$errHTML = <<"ERRORMESS";
<font color=#ff0000>ERROR</font><br>
$error
ERRORMESS

if ($mboutCode eq 'sjis') { Encode::from_to($errHTML, 'utf8', 'shiftjis'); }
print $errHTML;
&html_foot;
exit;

}
##=======================================================================================
