#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT HTML-EDIT v3.0.5
## (c)2008-2010 NorenzPRO Ltd. TakafumiArai 2010/8/13
##=======================================================================##

##=======================================================================##
## 設定項目
##=======================================================================##

##★ライブラリ
use Encode;
require '../admin/aelib.cgi';

##★このスクリプトの名前
$cginame = 'index.cgi';

##★データファイルのパス
$datafile = './data.dat';

##=====================================================================================##
##メインルーチン
##=====================================================================================##

##システム設定ファイル読込
$servconf = '../admin/conf.dat';
if (-e $servconf) {
	open(SVCFGRD,"$servconf");
	@SVCONF = <SVCFGRD>;
	close(SVCFGRD);
	##文字コード判定→UTF8変換
	my $contCC=&checkCharCode($servconf);
	if ($contCC eq 'shiftjis') {
		foreach (@SVCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
	}
	$pcoutCode =$SVCONF[22];
	$pcoutCode =~ s/\r//g; $pcoutCode =~ s/\n//g;
}
if ($pcoutCode eq '') { $pcoutCode='sjis'; }

##設定ファイル読込
$conffile='./conf.dat';
open(CONFRD,"$conffile");
@CONF = <CONFRD>;
close(CONFRD);
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($conffile);
if ($contCC eq 'shiftjis') {
	foreach (@CONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}

$SSITitle =$CONF[3];
$SSITitle =~ s/\r//g;$SSITitle =~ s/\n//g;
$SsiTitleClass =$CONF[18];
$SsiTitleClass =~ s/\r//g;$SsiTitleClass =~ s/\n//g;

##フォームの取得
$buffer = $ENV{'QUERY_STRING'};
@pairs = split(/&/,$buffer);
for $pair (@pairs) {
	($name, $value) = split(/=/, $pair);
	$value =~ tr/+/ /;
	$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	Encode::from_to($value, 'shiftjis', 'shiftjis'); 
	$in{$name} = $value;
}

##==============メインアクション==============

if ($SsiTitleClass ne '') { $addTitleClass=' class="'.$SsiTitleClass.'"'; }

print "Content-type: text/html\n\n";
if ($SSITitle ne '') {
	$tagMessage= '<h2'.$addTitleClass.'>'.$SSITitle.'</h2>';
	if ($pcoutCode eq 'sjis') { Encode::from_to($tagMessage, 'utf8', 'shiftjis'); }
	print $tagMessage;
}

&list;
exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub list {

&data_read;

print '<div class="KijiArea">'."\n";
$dataLot=@DATA;
$i=0;
for (1..$dataLot) {
	$DATA[$i] =~ s/<br>/<br \/>/g;
	$DATA[$i] =~ s/<BR>/<br \/>/g;
	if ($pcoutCode eq 'sjis') { Encode::from_to($DATA[$i], 'utf8', 'shiftjis'); }
	print $DATA[$i];
	$i++;
}
print '</div>'."\n";

exit;
}
##=======================================================================================
sub data_read {
	if (open(DBREAD,"$datafile")) {
		@DATA = <DBREAD>;
		close(DBREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($datafile);
		if ($contCC eq 'shiftjis') {
			foreach (@DATA) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else { &errorout('DBファイルの読込に失敗しました。'); }
}
##=======================================================================================
sub errorout {

$error = $_[0];

$ReturnLink='<a href="javascript:history.go(-1)">[先程のページへ戻る]</a>';

##★エラーメッセージの変更はここを訂正
$errHTML = <<"ERRORMESS";
<h4 align="center"><span style="color:#ff0000">ERROR</span></h4>
<div align="center">&nbsp;<br />$error<br />&nbsp;<br/ >$ReturnLink</div>
ERRORMESS

if ($pcoutCode eq 'sjis') { Encode::from_to($errHTML, 'utf8', 'shiftjis'); }
print $errHTML;
&html_foot;
exit;

}
##=======================================================================================
