#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT CORE v4.0.1
## (c)2008-2011 NorenzPRO Ltd. TalafumiArai 2011/11/22
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##★ライブラリ
require './aelib.cgi';
require './emoji.pl';
use strict;
use CGI;
use Encode;

##★このスクリプトの名前
our $cginame = 'admobi.cgi';

##★ディレクトリ構成ファイル
our $dirfile = './dir.dat';

##★クッキーの名称
our $CookieName = 'AdminPass';

##★設定ファイルのパス
our $conffile = './conf.dat';

##★パスワードファイル
our $passfile='./pass.cgi';

##★データファイル
our $MenuDataFile='./mobi.dat';

##★携帯トップHTMLファイル
our $MenuHtmlFileK ='../mobi/mobi.html';

##★スマホトップHTMLファイル
our $MenuHtmlFileS ='../mobi/smobi.html';

##★携帯トップ用SSIファイル
our $MenuIncludeFileK ='../mobi/menu.inc';

##★スマホトップ用SSIファイル
our $MenuIncludeFileS ='../mobi/smenu.inc';

##★携帯スキンHTMLファイル
our $SkinHtmlFileK ='../skin/mobi.html';

##★スマホスキンHTMLファイル
our $SkinHtmlFileS ='../skin/smobi.html';

##=====================================================================================##
##メインルーチン
##=====================================================================================##

our $kSourceTag;
our $kMenuTag;
our $kSkinTag;
our $sSourceTag;
our $sMenuTag;
our $sSkinTag;

##ディレクトリファイル読込
open(DIRRD,"$dirfile");
our @DIR = <DIRRD>;
close(DIRRD);

##システム設定ファイル読込
open(CONFRD,"$conffile");
our @CONF = <CONFRD>;
close(CONFRD);
our $DirMode =$CONF[0];
$DirMode =~ s/\r//g; $DirMode =~ s/\n//g;
our $ExecMode =$CONF[1];
$ExecMode =~ s/\r//g; $ExecMode =~ s/\n//g;
our $WRMode =$CONF[2];
$WRMode =~ s/\r//g; $WRMode =~ s/\n//g;
our $Domain =$CONF[3];
$Domain =~ s/\r//g; $Domain =~ s/\n//g;
our $PerlPath =$CONF[4];
$PerlPath =~ s/\r//g; $PerlPath =~ s/\n//g;
our $EditType =$CONF[5];
$EditType =~ s/\r//g; $EditType =~ s/\n//g;
our $EditName =$CONF[6];
$EditName =~ s/\r//g; $EditName =~ s/\n//g;
our $SendmailPath =$CONF[7];
$SendmailPath =~ s/\r//g; $SendmailPath =~ s/\n//g;
our $GmapAPIkey =$CONF[8];
$GmapAPIkey =~ s/\r//g; $GmapAPIkey =~ s/\n//g;
our $SysVersion =$CONF[9];
$SysVersion =~ s/\r//g; $SysVersion =~ s/\n//g;
our $RootPath =$CONF[10];
$RootPath =~ s/\r//g; $RootPath =~ s/\n//g;
our $LogoutTime =$CONF[11];
$LogoutTime =~ s/\r//g; $LogoutTime =~ s/\n//g;
our $PathConvert =$CONF[12];
$PathConvert =~ s/\r//g; $PathConvert =~ s/\n//g;
our $UpdateOut =$CONF[13];
$UpdateOut =~ s/\r//g; $UpdateOut =~ s/\n//g;
our $DefMainURL =$CONF[14];
$DefMainURL =~ s/\r//g; $DefMainURL =~ s/\n//g;
our $SearchSkinURL =$CONF[15];
$SearchSkinURL =~ s/\r//g; $SearchSkinURL =~ s/\n//g;
our $pcoutCode =$CONF[22];
$pcoutCode =~ s/\r//g; $pcoutCode =~ s/\n//g;
our $mboutCode =$CONF[23];
$mboutCode =~ s/\r//g; $mboutCode =~ s/\n//g;

if ($DirMode eq '') { $DirMode ='0755'; }
if ($ExecMode eq '') { $ExecMode ='0755'; }
if ($WRMode eq '') { $WRMode ='0666'; }
if ($PerlPath eq '') { $PerlPath ='#!/usr/local/bin/perl'; }
if ($DefMainURL eq '') { $DefMainURL ='main.html'; }
if ($SearchSkinURL eq '') { $SearchSkinURL ='/skin/skin.html'; }
our $vLogoutTime;
if ($LogoutTime eq '1800') { $vLogoutTime='30分'; }
elsif ($LogoutTime eq '3600') { $vLogoutTime='1時間'; }
elsif ($LogoutTime eq '10800') { $vLogoutTime='3時間'; }
elsif ($LogoutTime eq '21600') { $vLogoutTime='6時間'; }
elsif ($LogoutTime eq '43200') { $vLogoutTime='12時間'; }
elsif ($LogoutTime eq '86400') { $vLogoutTime='1日'; }
elsif ($LogoutTime eq '259200') { $vLogoutTime='3日'; }
elsif ($LogoutTime eq '604800') { $vLogoutTime='7日'; }
else { $LogoutTime='259200'; $vLogoutTime='3日'; }
if ($pcoutCode eq '') { $pcoutCode='sjis'; }
if ($mboutCode eq '') { $mboutCode='sjis'; }

##編集者IDパスワード読込
our $admin_id;
our $admin_pw;
if (open(PASSRD,"$passfile")) {
	my @PASSID = <PASSRD>;
	$admin_id =$PASSID[0];
	$admin_id =~ s/\r//g; $admin_id =~ s/\n//g;
	$admin_pw =$PASSID[1];
	$admin_pw =~ s/\r//g; $admin_pw =~ s/\n//g;
	$admin_pw =crypt($admin_pw,'ae');
	close(PASSRD);
} else { &error('パスワードファイル読込エラー'); }

##フォームの取得
our %in;
our @in;
my $query = CGI->new;
*in = $query->Vars();
foreach (%in) { 
	$_ =~ s/\xEF\xBD\x9E/\xE3\x80\x9C/g; 
	$_ =~ s/\xEF\xBC\x8D/\xE2\x88\x92/g; 
}

##メニュー定義ファイル読込
our @MenuData=();
if (open(MENURD,"$MenuDataFile")) {
	@MenuData = <MENURD>;
	close(MENURD);
}
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($MenuDataFile);
if ($contCC eq 'shiftjis') {
	foreach (@MenuData) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}

##==============メインアクション==============

## 管理者ログイン認証
our $ck_id; our $ck_pw;
our $c_id; our $c_pw;
if ($in{'loging'} eq "new") {
	# フォーム認証
	my $input_id = $in{'admin_id'};
	my $input_pw = $in{'admin_pw'};
	$input_pw =crypt($input_pw,'ae');
	if ($input_id ne "$admin_id") { &error('認証エラー'); }
	if ($input_pw ne "$admin_pw") { &error('認証エラー'); }
	&set_cookie;
	&admin;
} else {
	# クッキー認証
	&get_cookie;
	if (($ck_id eq "$admin_id")&&($ck_pw eq "$admin_pw")) {
		# 処理分岐
		if ($in{'mode'} eq 'admin') { &admin; }
		elsif ($in{'mode'} eq 'add') { &add; }
		elsif ($in{'mode'} eq 'del') { &del; }
		elsif ($in{'mode'} eq 'label') { &label; }
		elsif ($in{'mode'} eq 'defset') { &defset; }
		elsif ($in{'mode'} eq 'sort') { &sort; }
		else { &admin; }
	} else {
		&login;
	}
}

exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub html_head {

##★HTMLヘッダの変更はここを訂正
my $html_head = <<"HTMLHEAD";
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>モバイル設定</title>
<link rel="stylesheet" href="../admin/style.css" type="text/css">
<script language="JavaScript"><!--
function AddRows(targetObj) {
  var obj = document.getElementsByName(targetObj)[0];
  obj.rows = obj.rows+5;
}
--></script>
</head>
<body onload="javascript:parent.menu.location.href='menu.cgi'">
<h3 align=center>モバイル設定</h3>
<div align=center>ここの設定の前に、
<img src=../icon/conf.gif align=absmiddle><a href="adedit.cgi">[コンテンツ設定]</a> にてコンテンツ登録を行ってください</div>
HTMLHEAD

print "Content-type: text/html\n\n";
print $html_head;

}
##=======================================================================================
sub html_foot {

##★HTMLフッタの変更はここを訂正
my $html_foot = <<"HTMLFOOT";
</body>
</html>
HTMLFOOT

print $html_foot;

}
##=======================================================================================
sub login {

##★ログイン画面の変更はここを訂正
my $html_login = <<"LOGINHTML";
<div align="center">
<form method="post" action="$cginame">
<br>
<h5 align=center style="color:red">セッションタイムアウト</h5>
<h4 align=center>管理画面 再ログイン</h4>
<div align=center>ログインID　<input type="text" name="admin_id" size="25" value="$ck_id" class="Hankaku"></div>
<div align=center>パスワード　<input type="password" name="admin_pw" size="25" value="$ck_pw" class="Hankaku"></div>
<div align="center">
<input type="submit" name="submit" value="ログイン">
<input type="reset" value="リセット">
<input type="hidden" name="mode" value="admin">
<input type="hidden" name="loging" value="new">
</div>
</form>
LOGINHTML

&html_head;
print $html_login;
&html_foot;

exit;
}
##=======================================================================================
sub admin {

&html_head;

##デフォルトバス
my $DefRootPath;
if ($RootPath ne '') { $DefRootPath='/'.$RootPath; } else  { $DefRootPath=''; }

##メニューリスト定義
my $MenuLot=@MenuData-1;my $mi=0;
my $TitleHtml;
my $kBodyTag;
my $kHeader;
my $kHeadHtml;
my $kFootHtml;
my $kSkinHeadHtml;
my $kSkinFootHtml;
my $sTitleHtml;
my $sBodyTag;
my $sHeader;
my $sHeadHtml;
my $sFootHtml;
my $sSkinHeadHtml;
my $sSkinFootHtml;
my $ListTag;
my @MenuLine;
my @MenuLabel;
my @MenuTypeS;
my @MenuTypeK;
my @MenuContentS;
my @MenuContentK;
my @vMenuTypeS;
my @vMenuTypeK;
my @vMenuGotoS;
my @vMenuGotoK;
my @ContentConfData;
my @ConfDataS;
my @ConfDataK;
my $HtmlRegK;
my $vHtmlRegK;
my $HtmlRegS;
my $vHtmlRegS;
my $sDataRole;
for (0..$MenuLot) {
	@MenuLine=split(/\t/,$MenuData[$mi]);
	if ($mi==0) {
		##HTML設定
		$TitleHtml=$MenuLine[0];
			$TitleHtml =~ s/\"/&quot;/g;
		$kBodyTag=$MenuLine[1];
			$kBodyTag =~ s/\"/&quot;/g;
		$kHeadHtml=$MenuLine[2];
			$kHeadHtml =~ s/\|br\|/\n/g;
			$kHeadHtml =~ s/</&lt;/g;
			$kHeadHtml =~ s/>/&gt;/g;
		$kFootHtml=$MenuLine[3];
			$kFootHtml =~ s/\|br\|/\n/g;
			$kFootHtml =~ s/</&lt;/g;
			$kFootHtml =~ s/>/&gt;/g;
		$kHeader=$MenuLine[4];
			$kHeader =~ s/\|br\|/\n/g;
			$kHeader =~ s/<br>/\n/g;
			$kHeader =~ s/</&lt;/g;
			$kHeader =~ s/>/&gt;/g;
		$sTitleHtml=$MenuLine[5];
			$sTitleHtml =~ s/\"/&quot;/g;
		$sBodyTag=$MenuLine[6];
			$sBodyTag =~ s/\"/&quot;/g;
		$sHeadHtml=$MenuLine[7];
			$sHeadHtml =~ s/\|br\|/\n/g;
			$sHeadHtml =~ s/</&lt;/g;
			$sHeadHtml =~ s/>/&gt;/g;
		$sFootHtml=$MenuLine[8];
			$sFootHtml =~ s/\|br\|/\n/g;
			$sFootHtml =~ s/</&lt;/g;
			$sFootHtml =~ s/>/&gt;/g;
		$sHeader=$MenuLine[9];
			$sHeader =~ s/\|br\|/\n/g;
			$sHeader =~ s/<br>/\n/g;
			$sHeader =~ s/</&lt;/g;
			$sHeader =~ s/>/&gt;/g;
		$kSkinHeadHtml=$MenuLine[10];
			$kSkinHeadHtml =~ s/\|br\|/\n/g;
			$kSkinHeadHtml =~ s/</&lt;/g;
			$kSkinHeadHtml =~ s/>/&gt;/g;
		$kSkinFootHtml=$MenuLine[11];
			$kSkinFootHtml =~ s/\|br\|/\n/g;
			$kSkinFootHtml =~ s/</&lt;/g;
			$kSkinFootHtml =~ s/>/&gt;/g;
		$sSkinHeadHtml=$MenuLine[12];
			$sSkinHeadHtml =~ s/\|br\|/\n/g;
			$sSkinHeadHtml =~ s/</&lt;/g;
			$sSkinHeadHtml =~ s/>/&gt;/g;
		$sSkinFootHtml=$MenuLine[13];
			$sSkinFootHtml =~ s/\|br\|/\n/g;
			$sSkinFootHtml =~ s/</&lt;/g;
			$sSkinFootHtml =~ s/>/&gt;/g;
		$HtmlRegK=$MenuLine[14];
		$HtmlRegS=$MenuLine[15];
		if ($HtmlRegK ne "") { $vHtmlRegK=' checked'; }
		if ($HtmlRegS ne "") { $vHtmlRegS=' checked'; }
		$sDataRole=$MenuLine[16];
			$sDataRole =~ s/\"/&quot;/g;
	} else {
		##メニューリスト
		$MenuLabel[$mi]=$MenuLine[0];
		$MenuTypeS[$mi]=$MenuLine[1];
		$MenuContentS[$mi]=$MenuLine[2];
		$MenuTypeK[$mi]=$MenuLine[3];
			$MenuTypeK[$mi] =~ s/\r//g;
			$MenuTypeK[$mi] =~ s/\n//g;
		$MenuContentK[$mi]=$MenuLine[4];
			$MenuContentK[$mi] =~ s/\r//g;
			$MenuContentK[$mi] =~ s/\n//g;
		if ($MenuTypeK[$mi] eq '') { $MenuTypeK[$mi]=$MenuTypeS[$mi]; }
		if ($MenuContentK[$mi] eq '') { $MenuContentK[$mi]=$MenuContentS[$mi]; }
		##リンクタイプ取得(スマホ/携帯用)
		if ($MenuTypeS[$mi] eq 'dir') {
			$vMenuTypeS[$mi]='コンテンツ';
			##コンテンツ調査(スマホ/携帯用)
			my $ConfFile='../'.$MenuContentS[$mi].'/conf.dat';
			if (open(CONFRD,"$ConfFile")) {
				@ConfDataS = <CONFRD>;
				close(CONFRD);
				##コンテンツ文字コード判定→UTF8変換
				my $contCC=&checkCharCode($ConfFile);
				if ($contCC eq 'shiftjis') {
					foreach (@ConfDataS) { Encode::from_to($_, 'shiftjis', 'utf8'); }
				}
				$vMenuGotoS[$mi]=$ConfDataS[0]
			} else {
				$vMenuGotoS[$mi]=$MenuContentS[$mi];
			}
		} elsif ($MenuTypeS[$mi] eq 'url') {
			$vMenuTypeS[$mi]='URL';
			$vMenuGotoS[$mi]=$MenuContentS[$mi];
		} elsif ($MenuTypeS[$mi] eq 'text') {
			$vMenuTypeS[$mi]='テキスト文';
			$vMenuGotoS[$mi]='-';
		} elsif ($MenuTypeS[$mi] eq 'hr') {
			$vMenuTypeS[$mi]='罫線 &lt;hr&gt;';
			$vMenuGotoS[$mi]='-';
		}
		##リンクタイプ取得(携帯用)
		if ($MenuTypeK[$mi] eq 'dir') {
			$vMenuTypeK[$mi]='コンテンツ';
			##コンテンツ調査(携帯用)
			my $ConfFileK='../'.$MenuContentK[$mi].'/conf.dat';
			if (open(CONFRD,"$ConfFileK")) {
				@ConfDataK = <CONFRD>;
				close(CONFRD);
				##コンテンツ文字コード判定→UTF8変換
				my $contCC=&checkCharCode($ConfFileK);
				if ($contCC eq 'shiftjis') {
					foreach (@ConfDataK) { Encode::from_to($_, 'shiftjis', 'utf8'); }
				}
				$vMenuGotoK[$mi]=$ConfDataK[0]
			} else {
				$vMenuGotoK[$mi]=$MenuContentK[$mi];
			}
		} elsif ($MenuTypeK[$mi] eq 'url') {
			$vMenuTypeK[$mi]='URL';
			$vMenuGotoK[$mi]=$MenuContentK[$mi];
		} elsif ($MenuTypeK[$mi] eq 'text') {
			$vMenuTypeK[$mi]='テキスト文';
			$vMenuGotoK[$mi]='-';
		} elsif ($MenuTypeK[$mi] eq 'hr') {
			$vMenuTypeK[$mi]='罫線 &lt;hr&gt;';
			$vMenuGotoK[$mi]='-';
		}
		$MenuLabel[$mi] =~ s/\"/&quot;/g;
		$ListTag=$ListTag.'<tr><td>'
			.'<form action="'.$cginame.'" method="post">'
			.'<input type="submit" value="▲">'
			.'<input type="hidden" name="mode" value="sort">'
			.'<input type="hidden" name="key" value="'.$mi.'">'
			.'</form>'
			.'</td><td>'
			.'<form action="'.$cginame.'" method="post">'
			.'<input type="text" name="newlabel" value="'.$MenuLabel[$mi].'" size="25">'
			.'<input type="submit" value="変更">'
			.'<input type="hidden" name="mode" value="label">'
			.'<input type="hidden" name="line" value="'.$mi.'">'
			.'</form>'
			.'</td><td>['.$vMenuTypeS[$mi].']'.$vMenuGotoS[$mi].'</td><td>['.$vMenuTypeK[$mi].']'.$vMenuGotoK[$mi].'</td><td>'
			.'<form action="'.$cginame.'" method="post">'
			.'<input type="submit" value="メニュー削除">'
			.'<input type="hidden" name="mode" value="del">'
			.'<input type="hidden" name="line" value="'.$mi.'">'
			.'</form>'
			.'</td></tr>';
	}
	$mi++;
}

##コンテンツリスト
my $DirLot=@DIR-1; my $dd=0;
my $dSelectGoto;my $tSelectGoto;
my $vSelectGoto;my $SelectGoto;
for (0..$DirLot) {
	($dSelectGoto,$tSelectGoto)=split(/\,/,$DIR[$dd]);
	##コンテンツ調査
	my $ConfFile='../'.$dSelectGoto.'/conf.dat';
	if (open(CONFRD,"$ConfFile")) {
		@ContentConfData = <CONFRD>;
		close(CONFRD);
		##コンテンツ文字コード判定→UTF8変換
		my $contCC=&checkCharCode($ConfFile);
		if ($contCC eq 'shiftjis') {
			foreach (@ContentConfData) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
		$vSelectGoto=$ContentConfData[0];
	} else {
		$vSelectGoto=$dSelectGoto;
	}
	$vSelectGoto =~ s/\r//g;
	$vSelectGoto =~ s/\n//g;
	$SelectGoto=$SelectGoto.'  <option value="'.$dSelectGoto.'">'.$vSelectGoto.'</option>'."\n";
	$dd++;
}

##★変更画面の変更はここを訂正
my $htmlForm = <<"htmlForm";
<hr size="1" align="center">
  <h4 align="center">メニューリストの設定</h4>
<hr size="1" align="center">
<table width="95%" border="1" cellspacing="0" cellpadding="3" align="center" bgcolor="#FFFFFF">
<tr> 
  <td align="center" width="5%"><b>順</b></td>
  <td align="center" width="25%"><b>メニューラベル</b></td>
  <td align="center" width="30%"><b>リンク先(スマホ)</b></td>
  <td align="center" width="30%"><b>リンク先(携帯)</b></td>
  <td align="center" width="10%"><b>メニュー削除</b></td>
</tr>
$ListTag
</table>

<table width="95%" border="0" cellspacing="0" cellpadding="5" align="center">
<tr><td>
<form action="$cginame" method="post">
<br>
<strong>メニュー追加</strong>　<a href="adedit.cgi">[コンテンツ設定]</a>で登録された項目がリンク先に一覧表示されます<br>
  　メニューラベル <input type=text name="MenuLabel" size="20"><br>
  　リンク先(スマホ用) <select name="MenuGotoS">
  <option value="url" selected>URLの場合のみ→</option>
  <option value="text">テキスト文</option>
  <option value="hr">罫線 - &lt;hr&gt;</option>
  $SelectGoto
  </select>
  　アドレス <input type="text" name="MenuUrlS" value="$DefRootPath/mobi/" size="30" class="Hankaku"><br>
  　リンク先(携帯用)　 <select name="MenuGotoK">
  <option value="none" selected>上記と同一設定</option>
  <option value="url">URLの場合のみ→</option>
  <option value="text">テキスト文</option>
  <option value="hr">罫線 - &lt;hr&gt;</option>
  $SelectGoto
  </select>
  　アドレス <input type="text" name="MenuUrlK" value="" size="30" class="Hankaku"><br>
  　<input type=submit value="メニュー項目を追加">
  <input type=hidden name="mode" value="add"><br>
  <br>
<strong>モバイルメニューのSSIソースタグ</strong>　モバイルサイトのトップメニューにもSSIが利用可能です<br>
  　スマホ用 <input type="text" size="40" value="&lt;!--#include virtual=&quot;$DefRootPath/mobi/smenu.inc&quot; --&gt;">
    <a href="../mobi/smenu.inc" target="_blank">[ソース表示]</a><br>
  　携帯用 　<input type="text" size="40" value="&lt;!--#include virtual=&quot;$DefRootPath/mobi/menu.inc&quot; --&gt;">
    <a href="../mobi/menu.inc" target="_blank">[ソース表示]</a><br>
  　※SSIファイルを利用するためには、<a href="adskin.cgi">[スキン編集]</a> にて/mobi/mobi.html, /mobi/smobi.htmlを、*.shtml形式へ変更してください<br>
</form>
</td></tr></table>

<form action="$cginame" method="post">
<hr size="1" align="center">
  <h4 align="center">デザインの設定 <small>(スマートフォン用 /mobi/smobi.html, /skin/smobi.html)</small></h4>
  <div align="center"><img src="../icon/conf.gif" align="absmiddle"><a href="adskin.cgi">[スキン編集]</a>
  にて直接HTMLソース編集することもできます</div>
<hr size="1" align="center">
<table style="width:95%" border="0" cellspacing="0" cellpadding="5" align="center">
<tr><td>
  <strong>タイトル</strong> 全ページ共通 <br>
  　<input type="text" name="sTitleHtml" value="$sTitleHtml" style="width:95%"><br>
  <br>
  <strong>追加HTMLヘッダ</strong> 全ページ共通 <br>
  　<textarea type="text" name="sHeader" rows="4" style="width:95%" onDblClick="AddRows('sHeader')">$sHeader</textarea><br>
  <br>
  <strong>BODYタグ</strong> 全ページ共通 <br>
  　<input type="text" name="sBodyTag" value='$sBodyTag' style="width:95%" class="Hankaku"><br>
  <br>
  <strong>BODYヘッダ</strong> トップページ用 <a href="../mobi/smobi.html" target="_blank">[/mobi/smobi.html]</a><br>
  　<textarea type="text" name="sHeadHtml" rows="5" style="width:95%" onDblClick="AddRows('sHeadHtml')">$sHeadHtml</textarea><br>
  <strong>&lt;a&gt;タグへの挿入パラメータ</strong> data-role設定など <br>
  　<input type="text" name="sDataRole" value='$sDataRole' style="width:95%" class="Hankaku"><br>
  <strong>BODYヘッダ</strong> コンテンツページ用 <a href="../skin/smobi.html" target="_blank">[/skin/smobi.html]</a><br>
  　<textarea type="text" name="sSkinHeadHtml" rows="5" style="width:95%" onDblClick="AddRows('sSkinHeadHtml')">$sSkinHeadHtml</textarea><br>
  <br>
  　　　　△<br>
  　ここにメニューリストや本文などが挿入されます<br>
  　　　　▽<br>
  <br>
  <strong>BODYフッタ</strong> トップページ用 <a href="../mobi/smobi.html" target="_blank">[/mobi/smobi.html]</a><br>
  　<textarea type=text name="sFootHtml" rows="5" style="width:95%" onDblClick="AddRows('sFootHtml')">$sFootHtml</textarea><br>
  <strong>BODYフッタ</strong> コンテンツページ用 <a href="../skin/smobi.html" target="_blank">[/skin/smobi.html]</a><br>
  　<textarea type=text name="sSkinFootHtml" rows="5" style="width:95%" onDblClick="AddRows('sSkinFootHtml')">$sSkinFootHtml</textarea><br>
  <br>
  <input type=hidden name="mode" value="defset">
  　<input type="submit" value="設定変更">
  　<input type="checkbox" name="sHtmlReg" value="sHtmlReg"$vHtmlRegS>HTMLソースとして入力 [改行する場合、&lt;br&gt;タグを挿入]
</td>
<td valign="top" width="150"><img src="img/smobi.gif"></td>
</tr></table>

<hr size="1" align="center">
  <h4 align="center">デザインの設定 <small>(一般携帯用 /mobi/mobi.html, /skin/mobi.html)</small></h4>
  <div align="center"><img src="../icon/conf.gif" align="absmiddle"><a href="adskin.cgi">[スキン編集]</a>
  にて直接HTMLソース編集することもできます</div>
<hr size="1" align="center">
<table style="width:95%" border="0" cellspacing="0" cellpadding="5" align="center">
<tr><td>
  <strong>タイトル</strong> 全ページ共通 <br>
  　<input type=text name="TitleHtml" value="$TitleHtml" style="width:95%"><br>
  <br>
  <strong>追加HTMLヘッダ</strong> 全ページ共通 <br>
  　<textarea type=text name="kHeader" rows="4" style="width:95%" onDblClick="AddRows('kHeader')">$kHeader</textarea><br>
  <br>
  <strong>BODYタグ</strong> 全ページ共通 <br>
  　<input type=text name="kBodyTag" value='$kBodyTag' style="width:95%" class="Hankaku"><br>
  　 bgcolor = &quot;<a href="color.html" target="tips">背景色</a>&quot;
  　text = &quot;<a href="color.html" target="tips">文字色</a>&quot;
  　link = &quot;<a href="color.html" target="tips">リンク文字色</a>&quot;
  　vlink = &quot;<a href="color.html" target="tips">リンク文字の色(アクセス済)</a>&quot;<br>
  <br>
  <strong>BODYヘッダ</strong> トップページ用 <a href="../mobi/mobi.html" target="_blank">[/mobi/mobi.html]</a><br>
  　<textarea type=text name="kHeadHtml" rows="5" style="width:95%" onDblClick="AddRows('kHeadHtml')">$kHeadHtml</textarea><br>
  <strong>BODYヘッダ</strong> コンテンツページ用 <a href="../skin/mobi.html" target="_blank">[/skin/mobi.html]</a><br>
  　<textarea type=text name="kSkinHeadHtml" rows="5" style="width:95%" onDblClick="AddRows('kSkinHeadHtml')">$kSkinHeadHtml</textarea><br>
  <br>
  　　　　△<br>
  　ここにメニューリストや本文などが挿入されます<br>
  　　　　▽<br>
  <br>
  <strong>BODYフッタ</strong> トップページ用 <a href="../mobi/mobi.html" target="_blank">[/mobi/mobi.html]</a><br>
  　<textarea type=text name="kFootHtml" rows="5" style="width:95%" onDblClick="AddRows('kFootHtml')">$kFootHtml</textarea><br>
  <strong>BODYフッタ</strong> コンテンツページ用 <a href="../skin/mobi.html" target="_blank">[/skin/mobi.html]</a><br>
  　<textarea type=text name="kSkinFootHtml" rows="5" style="width:95%" onDblClick="AddRows('kSkinFootHtml')">$kSkinFootHtml</textarea><br>
  <br>
  　<input type=submit value="設定変更">
  　<input type="checkbox" name="kHtmlReg" value="kHtmlReg"$vHtmlRegK> HTMLソースとして入力 [改行する場合、&lt;br&gt;タグを挿入]
</td>
<td valign="top" width="150"><img src="img/mobi.gif"></td>
</tr></table>
</form>

htmlForm
print $htmlForm;
&html_foot;

exit;
}
##=======================================================================================
sub defset {

$in{'kHeadHtml'} =~ s/\r\n/\|br\|/g;
$in{'kHeadHtml'} =~ s/\r/\|br\|/g;
$in{'kHeadHtml'} =~ s/\n/\|br\|/g;
$in{'kFootHtml'} =~ s/\r\n/\|br\|/g;
$in{'kFootHtml'} =~ s/\r/\|br\|/g;
$in{'kFootHtml'} =~ s/\n/\|br\|/g;
$in{'kSkinHeadHtml'} =~ s/\r\n/\|br\|/g;
$in{'kSkinHeadHtml'} =~ s/\r/\|br\|/g;
$in{'kSkinHeadHtml'} =~ s/\n/\|br\|/g;
$in{'kSkinFootHtml'} =~ s/\r\n/\|br\|/g;
$in{'kSkinFootHtml'} =~ s/\r/\|br\|/g;
$in{'kSkinFootHtml'} =~ s/\n/\|br\|/g;
$in{'kHeader'} =~ s/\r\n/\|br\|/g;
$in{'kHeader'} =~ s/\r/\|br\|/g;
$in{'kHeader'} =~ s/\n/\|br\|/g;
$in{'sHeadHtml'} =~ s/\r\n/\|br\|/g;
$in{'sHeadHtml'} =~ s/\r/\|br\|/g;
$in{'sHeadHtml'} =~ s/\n/\|br\|/g;
$in{'sFootHtml'} =~ s/\r\n/\|br\|/g;
$in{'sFootHtml'} =~ s/\r/\|br\|/g;
$in{'sFootHtml'} =~ s/\n/\|br\|/g;
$in{'sSkinHeadHtml'} =~ s/\r\n/\|br\|/g;
$in{'sSkinHeadHtml'} =~ s/\r/\|br\|/g;
$in{'sSkinHeadHtml'} =~ s/\n/\|br\|/g;
$in{'sSkinFootHtml'} =~ s/\r\n/\|br\|/g;
$in{'sSkinFootHtml'} =~ s/\r/\|br\|/g;
$in{'sSkinFootHtml'} =~ s/\n/\|br\|/g;
$in{'sHeader'} =~ s/\r\n/\|br\|/g;
$in{'sHeader'} =~ s/\r/\|br\|/g;
$in{'sHeader'} =~ s/\n/\|br\|/g;
$MenuData[0]=$in{'TitleHtml'}."\t".$in{'kBodyTag'}."\t".$in{'kHeadHtml'}."\t".$in{'kFootHtml'}."\t".$in{'kHeader'}."\t"
	.$in{'sTitleHtml'}."\t".$in{'sBodyTag'}."\t".$in{'sHeadHtml'}."\t".$in{'sFootHtml'}."\t".$in{'sHeader'}."\t"
	.$in{'kSkinHeadHtml'}."\t".$in{'kSkinFootHtml'}."\t".$in{'sSkinHeadHtml'}."\t".$in{'sSkinFootHtml'}."\t"
	.$in{'kHtmlReg'}."\t".$in{'sHtmlReg'}."\t".$in{'sDataRole'}."\t\n";

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##携帯HTMLファイル書式
&kMakeHTML;

##携帯HTMLファイル書込
if (-e $MenuHtmlFileK) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $kSourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFileK);
}

##スマホHTMLファイル書式
&sMakeHTML;

##スマホHTMLファイル書込
if (-e $MenuHtmlFileK) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $sSourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFileS);
}

##携帯SSIファイル書込
$tmpfile = "../mobi/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $kMenuTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncludeFileK);

##携帯スキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $kSkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFileK);

##スマホスキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $sSkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFileS);

##処理画面出力
my $jumpurl = "$cginame?mode=admin";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>モバイルサイト設定処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、モバイルサイトの設定処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub add {

##フォーム取得処理
my $MenuLabel = $in{'MenuLabel'};
my $MenuTypeS;my $MenuGotoS;
if ($in{'MenuGotoS'} eq 'url') {
	$MenuTypeS='url';
	$MenuGotoS=$in{'MenuUrlS'};
} elsif ($in{'MenuGotoS'} eq 'text') {
	$MenuTypeS='text';
	$MenuGotoS=$in{'MenuGotoS'};
} elsif ($in{'MenuGotoS'} eq 'hr') {
	$MenuTypeS='hr';
	$MenuGotoS=$in{'MenuGotoS'};
} else {
	$MenuTypeS='dir';
	$MenuGotoS=$in{'MenuGotoS'};
}
my $MenuTypeK;my $MenuGotoK;
if ($in{'MenuGotoK'} eq 'none') {
	$MenuTypeK=$MenuTypeS;
	$MenuGotoK=$MenuGotoS;
} elsif ($in{'MenuGotoK'} eq 'url') {
	$MenuTypeK='url';
	$MenuGotoK=$in{'MenuUrlK'};
} elsif ($in{'MenuGotoK'} eq 'text') {
	$MenuTypeK='text';
	$MenuGotoK=$in{'MenuGotoK'};
} elsif ($in{'MenuGotoK'} eq 'hr') {
	$MenuTypeK='hr';
	$MenuGotoK=$in{'MenuGotoK'};
} else {
	$MenuTypeK='dir';
	$MenuGotoK=$in{'MenuGotoK'};
}

##メニュー項目追加
my $format=$MenuLabel."\t".$MenuTypeS."\t".$MenuGotoS."\t".$MenuTypeK."\t".$MenuGotoK."\t\n";
push(@MenuData,$format);

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##携帯HTMLファイル書式
($in{'TitleHtml'},$in{'kBodyTag'},$in{'kHeadHtml'},$in{'kFootHtml'},$in{'kHeader'}
 ,$in{'sTitleHtml'},$in{'sBodyTag'},$in{'sHeadHtml'},$in{'sFootHtml'},$in{'sHeader'}
 ,$in{'kSkinHeadHtml'},$in{'kSkinFootHtml'},$in{'sSkinHeadHtml'},$in{'sSkinFootHtml'}
 ,$in{'kHtmlReg'},$in{'sHtmlReg'},$in{'sDataRole'}) = split(/\t/,$MenuData[0]);
&kMakeHTML;
&sMakeHTML;

##携帯HTMLファイル書込
if (-e $MenuHtmlFileK) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $kSourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFileK);
}

##スマホHTMLファイル書込
if (-e $MenuHtmlFileS) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $sSourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFileS);
}

##携帯SSIファイル書込
$tmpfile = "../mobi/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $kMenuTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncludeFileK);

##スマホSSIファイル書込
$tmpfile = "../mobi/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $sMenuTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncludeFileS);

##携帯スキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $kSkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFileK);

##スマホスキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $sSkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFileS);

##★処理画面出力
my $jumpurl = "$cginame?mode=admin";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>モバイルサイトメニュー追加処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、モバイルサイトメニューの追加処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub del {

##★フォーム取得処理
my $delLine = $in{'line'};

##メニュー項目追加
splice(@MenuData, $delLine, 1);

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##携帯HTMLファイル書式
($in{'TitleHtml'},$in{'kBodyTag'},$in{'kHeadHtml'},$in{'kFootHtml'},$in{'kHeader'}
 ,$in{'sTitleHtml'},$in{'sBodyTag'},$in{'sHeadHtml'},$in{'sFootHtml'},$in{'sHeader'}
 ,$in{'kSkinHeadHtml'},$in{'kSkinFootHtml'},$in{'sSkinHeadHtml'},$in{'sSkinFootHtml'}
 ,$in{'kHtmlReg'},$in{'sHtmlReg'},$in{'sDataRole'}) = split(/\t/,$MenuData[0]);
&kMakeHTML;
&sMakeHTML;

##携帯HTMLファイル書込
if (-e $MenuHtmlFileK) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $kSourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFileK);
}

##スマホHTMLファイル書込
if (-e $MenuHtmlFileK) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $sSourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFileS);
}

##携帯SSIファイル書込
$tmpfile = "../mobi/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $kMenuTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncludeFileK);

##スマホSSIファイル書込
$tmpfile = "../mobi/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $sMenuTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncludeFileS);

##携帯スキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $kSkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFileK);

##スマホスキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $sSkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFileS);

##★処理画面出力
my $jumpurl = "$cginame?mode=admin";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>モバイルサイトメニュー削除処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、モバイルサイトメニューの削除処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub sort {

##★フォーム取得処理
my $key=$in{'key'};

##並び替え処理
my $switch=$key-1;
my $upContent;my $dnContent;
if ($key > 1) {
	$upContent=$MenuData[$key];
	$dnContent=$MenuData[$switch];
	$MenuData[$key]=$dnContent;
	$MenuData[$switch]=$upContent;
}

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##携帯HTMLファイル書式
($in{'TitleHtml'},$in{'kBodyTag'},$in{'kHeadHtml'},$in{'kFootHtml'},$in{'kHeader'}
 ,$in{'sTitleHtml'},$in{'sBodyTag'},$in{'sHeadHtml'},$in{'sFootHtml'},$in{'sHeader'}
 ,$in{'kSkinHeadHtml'},$in{'kSkinFootHtml'},$in{'sSkinHeadHtml'},$in{'sSkinFootHtml'}
 ,$in{'kHtmlReg'},$in{'sHtmlReg'},$in{'sDataRole'}) = split(/\t/,$MenuData[0]);
&kMakeHTML;
&sMakeHTML;

##携帯HTMLファイル書込
if (-e $MenuHtmlFileK) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $kSourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFileK);
}

##スマホHTMLファイル書込
if (-e $MenuHtmlFileS) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $sSourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFileS);
}

##携帯SSIファイル書込
$tmpfile = "../mobi/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $kMenuTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncludeFileK);

##スマホSSIファイル書込
$tmpfile = "../mobi/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $sMenuTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncludeFileS);

##携帯スキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $kSkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFileK);

##スマホスキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $sSkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFileS);

##★処理画面出力
my $jumpurl = "$cginame?mode=admin";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>モバイルサイトメニュー並び替え処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、モバイルサイトメニューの並び替え処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub label {

##★フォーム取得処理
my $line=$in{'line'};

##ラベル名変更処理
my $TargLabel;my $TargDir;my $TargType;
($TargLabel,$TargDir,$TargType) = split(/\t/,$MenuData[$line]);
$MenuData[$line]=$in{'newlabel'}."\t".$TargDir."\t".$TargType."\t\n";

##メニュー定義ファイル書込
my $tmpfile = "$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR @MenuData;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuDataFile);

##携帯HTMLファイル書式
($in{'TitleHtml'},$in{'kBodyTag'},$in{'kHeadHtml'},$in{'kFootHtml'},$in{'kHeader'}
 ,$in{'sTitleHtml'},$in{'sBodyTag'},$in{'sHeadHtml'},$in{'sFootHtml'},$in{'sHeader'}
 ,$in{'kSkinHeadHtml'},$in{'kSkinFootHtml'},$in{'sSkinHeadHtml'},$in{'sSkinFootHtml'}
 ,$in{'kHtmlReg'},$in{'sHtmlReg'},$in{'sDataRole'}) = split(/\t/,$MenuData[0]);
&kMakeHTML;
&sMakeHTML;

##携帯HTMLファイル書込
if (-e $MenuHtmlFileK) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $kSourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFileK);
}

##スマホHTMLファイル書込
if (-e $MenuHtmlFileK) {
	$tmpfile = "../mobi/$$\.tmp";
	if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
	print MENUWR $sSourceTag;
	close(MENUWR);
	chmod(oct($WRMode),$tmpfile);
	rename($tmpfile,$MenuHtmlFileS);
}

##携帯SSIファイル書込
$tmpfile = "../mobi/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $kMenuTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncludeFileK);

##スマホSSIファイル書込
$tmpfile = "../mobi/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $sMenuTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$MenuIncludeFileS);

##携帯スキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $kSkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFileK);

##スマホスキン書込
$tmpfile = "../skin/$$\.tmp";
if (!open(MENUWR,">$tmpfile")) { &error('パーミッションエラー'); }
print MENUWR $sSkinTag;
close(MENUWR);
chmod(oct($WRMode),$tmpfile);
rename($tmpfile,$SkinHtmlFileS);

##★処理画面出力
my $jumpurl = "$cginame?mode=admin";
my $htJump = <<"htJump";
<html><head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>モバイルサイトメニュー並び替え処理</title>
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<link rel="stylesheet" href="style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF" text="#000000">
<h3 align="center">只今、モバイルサイトメニューの並び替え処理中です。</h3>
</body></html>
htJump

print "Content-type: text/html\n\n";
print $htJump;

exit;
}
##=======================================================================================
sub kMakeHTML {

my $mbsetCode;
if ($mboutCode eq 'sjis') { $mbsetCode='Shift_JIS'; } else {  $mbsetCode='UTF-8'; }

$in{'kHeader'} =~ s/<br>/\n/g;
$in{'kHeader'} =~ s/\|br\|/\n/g;
if ($in{'kHtmlReg'} ne "") {
	$in{'kHeadHtml'} =~ s/\|br\|/\n/g;
	$in{'kFootHtml'} =~ s/\|br\|/\n/g;
	$in{'kSkinHeadHtml'} =~ s/\|br\|/\n/g;
	$in{'kSkinFootHtml'} =~ s/\|br\|/\n/g;
} else {
	$in{'kHeadHtml'} =~ s/\|br\|/<br>/g;
	$in{'kFootHtml'} =~ s/\|br\|/<br>/g;
	$in{'kSkinHeadHtml'} =~ s/\|br\|/<br>/g;
	$in{'kSkinFootHtml'} =~ s/\|br\|/<br>/g;
}

$kMenuTag='';
$kSourceTag = <<"HTMLHEAD";
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=$mbsetCode">
<title>$in{'TitleHtml'}</title>
$in{'kHeader'}
</head>
$in{'kBodyTag'}
$in{'kHeadHtml'}
HTMLHEAD

my $MenuLot=@MenuData-1;my $mi=1;
my @MenuLine;
for (1..$MenuLot) {
	@MenuLine=split(/\t/,$MenuData[$mi]);
	if ($MenuLine[1] eq 'url') {
		$kMenuTag=$kMenuTag.'<a href="'.$MenuLine[2].'">'.$MenuLine[0].'</a><br>'."\n";
	}
	if ($MenuLine[1] eq 'dir') {
		$kMenuTag=$kMenuTag.'<a href="../'.$MenuLine[2].'/mobi.cgi">'.$MenuLine[0].'</a><br>'."\n";
	}
	if ($MenuLine[1] eq 'text') {
		$kMenuTag=$kMenuTag.$MenuLine[0].'<br>'."\n";
	}
	if ($MenuLine[1] eq 'hr') {
		$kMenuTag=$kMenuTag.'<hr>'."\n";
	}
	$mi++;
}
$kMenuTag = &EmojiTagToGif($kMenuTag);
$kMenuTag = &tag_change($kMenuTag);
$kSourceTag = $kSourceTag.$kMenuTag.'';
$kSourceTag = $kSourceTag."\n".$in{'FootHtml'}."\n".'<body></html>';

$kSkinTag = <<"HTMLHEAD";
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=$mbsetCode">
<title>$in{'TitleHtml'}</title>
$in{'kHeader'}
</head>
$in{'kBodyTag'}
$in{'kSkinHeadHtml'}
<!-- MainZone -->
$in{'kSkinFootHtml'}
<body></html>
HTMLHEAD

if ($mboutCode eq 'sjis') {
	Encode::from_to($kSourceTag, 'utf8', 'shiftjis');
	Encode::from_to($kMenuTag, 'utf8', 'shiftjis');
	Encode::from_to($kSkinTag, 'utf8', 'shiftjis');
}

}
##=======================================================================================
sub sMakeHTML {

$in{'sHeader'} =~ s/<br>/\n/g;
$in{'sHeader'} =~ s/\|br\|/\n/g;
if ($in{'sHtmlReg'} ne "") {
	$in{'sHeadHtml'} =~ s/\|br\|/\n/g;
	$in{'sFootHtml'} =~ s/\|br\|/\n/g;
	$in{'sSkinHeadHtml'} =~ s/\|br\|/\n/g;
	$in{'sSkinFootHtml'} =~ s/\|br\|/\n/g;
} else {
	$in{'sHeadHtml'} =~ s/\|br\|/<br>/g;
	$in{'sFootHtml'} =~ s/\|br\|/<br>/g;
	$in{'sSkinHeadHtml'} =~ s/\|br\|/<br>/g;
	$in{'sSkinFootHtml'} =~ s/\|br\|/<br>/g;
}

$sMenuTag='';
$sSourceTag = <<"HTMLHEAD";
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>$in{'sTitleHtml'}</title>
$in{'sHeader'}
</head>
$in{'sBodyTag'}
$in{'sHeadHtml'}
HTMLHEAD

my $MenuLot=@MenuData-1;my $mi=1;
my @MenuLine;
for (1..$MenuLot) {
	@MenuLine=split(/\t/,$MenuData[$mi]);
	$MenuLine[3] =~ s/\r//g;
	$MenuLine[3] =~ s/\n//g;
	$MenuLine[4] =~ s/\r//g;
	$MenuLine[4] =~ s/\n//g;
	if ($MenuLine[3] eq '') { $MenuLine[3]=$MenuLine[1]; }
	if ($MenuLine[4] eq '') { $MenuLine[4]=$MenuLine[2]; }
	if ($MenuLine[3] eq 'url') {
		$sMenuTag=$sMenuTag.'<a href="'.$MenuLine[4].'" '.$in{'sDataRole'}.'>'.$MenuLine[0].'</a><br>'."\n";
	}
	if ($MenuLine[3] eq 'dir') {
		$sMenuTag=$sMenuTag.'<a href="../'.$MenuLine[4].'/smobi.cgi" '.$in{'sDataRole'}.'>'.$MenuLine[0].'</a><br>'."\n";
	}
	if ($MenuLine[3] eq 'text') {
		$sMenuTag=$sMenuTag.$MenuLine[0].'<br>'."\n";
	}
	if ($MenuLine[3] eq 'hr') {
		$sMenuTag=$sMenuTag.'<hr>'."\n";
	}
	$mi++;
}
$sMenuTag = &EmojiTagToGif($sMenuTag);
$sMenuTag = &tag_change($sMenuTag);
$sSourceTag = $sSourceTag.$sMenuTag.'';
$sSourceTag = $sSourceTag."\n".$in{'sFootHtml'}."\n".'<body></html>';

$sSkinTag = <<"HTMLHEAD";
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>$in{'sTitleHtml'}</title>
$in{'sHeader'}
</head>
$in{'sBodyTag'}
$in{'sSkinHeadHtml'}
<!-- MainZone -->
$in{'sSkinFootHtml'}
<body></html>
HTMLHEAD

}
##=======================================================================================
sub tag_change {
	## $var = &tag_change($var); で変換する
	my $TcRootPath;
	if ($RootPath ne '') { $TcRootPath='/'.$RootPath; } else { $TcRootPath=''; }
	local($_) = $_[0];
	1 while s/\[new\]/<img src=\"$TcRootPath\/icon\/new\.gif\" align=\"middle\" alt=\"new\" border=\"0\" \/>/g;
	1 while s/\[red\]/<span style=\"color\:\#FF0000\">/g;
	1 while s/\[\/red\]/<\/span>/g;
	1 while s/\[blue\]/<span style=\"color\:\#0000FF\">/g;
	1 while s/\[\/blue\]/<\/span>/g;
	1 while s/\[green\]/<span style=\"color\:\#009900\">/g;
	1 while s/\[\/green\]/<\/span>/g;
	1 while s/AeDirTop/index.cgi/g;
	$_;
}
##=======================================================================================
