#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT ImageBrowser for CKEditor v3.1.4
## (c)2008-2011 NorenzPRO Ltd. TakafumiArai 2011/1/15
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##
##★ライブラリ
use strict;
use CGI;
use Encode;
use File::Path;

##★このCGIの名前
our $cginame = 'imgbrowser.cgi';

##★システム設定ファイルのパス
our $conffile = '../../conf.dat';

##★ファイルアップロード上限サイズ(KB)
our $UploadMaxSize=5120;

##=====================================================================================##
##メインルーチン
##=====================================================================================##

##システム設定ファイル読込
open(CONFRD,"$conffile");
our @CONF = <CONFRD>;
close(CONFRD);
our $DirMode =$CONF[0];
$DirMode =~ s/\r//g; $DirMode =~ s/\n//g;
our $ExecMode =$CONF[1];
$ExecMode =~ s/\r//g; $ExecMode =~ s/\n//g;
our $WRMode =$CONF[2];
$WRMode =~ s/\r//g; $WRMode =~ s/\n//g;
our $Domain =$CONF[3];
$Domain =~ s/\r//g; $Domain =~ s/\n//g;
our $PerlPath =$CONF[4];
$PerlPath =~ s/\r//g; $PerlPath =~ s/\n//g;
our $EditType =$CONF[5];
$EditType =~ s/\r//g; $EditType =~ s/\n//g;
our $EditName =$CONF[6];
$EditName =~ s/\r//g; $EditName =~ s/\n//g;
our $SendmailPath =$CONF[7];
$SendmailPath =~ s/\r//g; $SendmailPath =~ s/\n//g;
our $SysVersion =$CONF[9];
$SysVersion =~ s/\r//g; $SysVersion =~ s/\n//g;
our $RootPath =$CONF[10];
$RootPath =~ s/\r//g; $RootPath =~ s/\n//g;
our $LogoutTime =$CONF[11];
$LogoutTime =~ s/\r//g; $LogoutTime =~ s/\n//g;
our $PathConvert =$CONF[12];
$PathConvert =~ s/\r//g; $PathConvert =~ s/\n//g;
our $UpdateOut =$CONF[13];
$UpdateOut =~ s/\r//g; $UpdateOut =~ s/\n//g;
our $DefMainURL =$CONF[14];
$DefMainURL =~ s/\r//g; $DefMainURL =~ s/\n//g;
our $SearchSkinURL =$CONF[15];
$SearchSkinURL =~ s/\r//g; $SearchSkinURL =~ s/\n//g;
if ($DirMode eq '') { $DirMode ='0755'; }
if ($ExecMode eq '') { $ExecMode ='0755'; }
if ($WRMode eq '') { $WRMode ='0666'; }
if ($PerlPath eq '') { $PerlPath ='#!/usr/local/bin/perl'; }
if ($DefMainURL eq '') { $DefMainURL ='main.html'; }
if ($SearchSkinURL eq '') { $SearchSkinURL ='/skin/skin.html'; }
our $vLogoutTime;
if ($LogoutTime eq '1800') { $vLogoutTime='30分'; }
elsif ($LogoutTime eq '3600') { $vLogoutTime='1時間'; }
elsif ($LogoutTime eq '10800') { $vLogoutTime='3時間'; }
elsif ($LogoutTime eq '21600') { $vLogoutTime='6時間'; }
elsif ($LogoutTime eq '43200') { $vLogoutTime='12時間'; }
elsif ($LogoutTime eq '86400') { $vLogoutTime='1日'; }
elsif ($LogoutTime eq '259200') { $vLogoutTime='3日'; }
elsif ($LogoutTime eq '604800') { $vLogoutTime='7日'; }
else { $LogoutTime='259200'; $vLogoutTime='3日'; }

##転送許可ファイルのサイズ上限
our $ViewMaxSize;
if ($UploadMaxSize < 1024) {
	$ViewMaxSize=$UploadMaxSize."KB";
} else {
	my $ViewMaxMB =int($UploadMaxSize*10/1024)/10;
	$ViewMaxSize=$ViewMaxMB.'MB';
}
our $MaxDataSize=$UploadMaxSize*1024;

##フォームの取得
our %ENV;
our %in;
our @in;
our $upfile;
if ($MaxDataSize < $ENV{'CONTENT_LENGTH'}) { &error('添付ファイル容量オーバー'); }
my $query = CGI->new;
*in = $query->Vars();
if ($in{'imgfile'} ne '') {
	if ($in{'imgfile'} =~ /\\/) {
		my @FilePath=split(/\\/,$in{'imgfile'});
		$in{'imgfile'} =pop(@FilePath);
	} elsif ($in{'imgfile'} =~ /\//) {
		my @FilePath=split(/\//,$in{'imgfile'});
		$in{'imgfile'} =pop(@FilePath);
	}
	$in{'imgfile'} =~ s/\\//g;
	$in{'imgfile'} =~ s/\///g;
	my $query = CGI->new; 
	$upfile= $query->param('imgfile'); 
}

our $orgfname;
our $wysiwyg=$in{'CKEditor'};
our $resize=$in{'resize'};
our $targd=$wysiwyg;
$targd =~ s/smallWYSIWYG//g;
$targd =~ s/fullWYSIWYG//g;
$targd =~ s/MailFormHeader//g;
$targd =~ s/MailFormFooter//g;
our $seld=$in{'seld'};
our $FuncNum=$in{'CKEditorFuncNum'};

##ディレクトリ切替
our $swTagLocal;
our $swTagPub;
our $updir;
our $showdir;
our $setPath;
if ($RootPath ne '') { $setPath='/'.$RootPath.'/'; } else { $setPath='/'; }
if ($seld eq '') { $seld='loc'; }
if ($targd eq '') { $seld='pub'; }
if ($seld eq 'pub') {
	$updir = '../../../uploads/';
	$showdir = $setPath.'uploads/';
	$swTagLocal='<a href="'.$cginame.'?CKEditor='.$wysiwyg.'&amp;CKEditorFuncNum='.$FuncNum.'&amp;targd='.$targd.'&amp;seld=loc">[コンテンツ]</a>';
	$swTagPub='[サイト共有]';
} elsif ($seld eq 'loc') {
	$updir = '../../../'.$targd.'/file/';
	$showdir = $setPath.$targd.'/file/';
	$swTagLocal='[コンテンツ]';
	$swTagPub='<a href="'.$cginame.'?CKEditor='.$wysiwyg.'&amp;CKEditorFuncNum='.$FuncNum.'&amp;targd='.$targd.'&amp;seld=pub">[サイト共有]</a>';
}

if ($in{'mode'} eq 'regfile') { &regfile; }
elsif ($in{'mode'} eq 'delcheck') { &delcheck; }
elsif ($in{'mode'} eq 'delfile') { &delfile; }
elsif ($in{'mode'} eq 'list') { &list; }
elsif ($in{'mode'} eq 'view') { &view; }
else { &html; }

exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub html {

my $hideTag1;
my $hideTag2;
if ($PathConvert eq '') {
	$hideTag1='<!--';
	$hideTag2='-->';
}

##★HTML変更はここを訂正
my $viewHTML = <<"HTML";
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Cache-Control" content="no-cache">
<meta http-equiv="expires" content="0">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>ファイルブラウザ $targd $seld</title>
<script language="JavaScript" type="text/javascript">
function insertImage() {
	var setImageURL = document.fbForm.src.value;
	window.opener.CKEDITOR.tools.callFunction('$FuncNum', setImageURL);
}
function closeWindow() {
	window.close();
}
</script>
</head>
<body bgcolor="#EEEEEE" marginwidth="0" marginheight="0" topmargin="0" leftmargin="0">
<table border="0" cellpadding="0" cellspacing="0" style="padding: 10px;">
	<tr>
		<td style="vertical-align:top;">
		<form method="POST" action="$cginame" enctype="multipart/form-data" id="fbForm" name="fbForm">
		<input type="hidden" id="dir" name="dir" value="">
		<input type="hidden" name="mode" value="regfile">
		<input type="hidden" name="CKEditor" value="$wysiwyg">
		<input type="hidden" name="CKEditorFuncNum" value="$FuncNum">
		<input type="hidden" name="seld" value="$seld">
		<input type="hidden" name="targd" value="$targd">
		<span style="font-size: 12px; font-weight: bold;">ファイルのアップロード</span>
		<table width="350" border="0" cellpadding="0" cellspacing="0" style="background-color: #F7F7F7; border: 2px solid #FFFFFF; padding: 5px;">
			<tr>
				<td style="padding-top: 0px;padding-bottom: 0px; font-size: 12px;" width="80">アップロード:</td>
				<td style="padding-top: 0px;padding-bottom: 0px;width:300px;"><input type="file" name="imgfile" size="30" style="font-size: 10px; width: 100%;" /></td>
			</tr>
			<tr>
				<td style="padding-top: 0px;padding-bottom: 2px; font-size: 10px;">&nbsp;</td>
				<td style="padding-top: 0px;padding-bottom: 2px; font-size: 12px;">添付サイズ上限: $ViewMaxSize</td>
			</tr>
$hideTag1
			<tr>
				<td style="padding-bottom: 2px; padding-top: 0px; font-size: 12px;">JPGリサイズ:</td>
				<td style="padding-bottom: 2px; padding-top: 0px; font-size: 12px;"><input type="text" name="resize" value="" style="font-size: 10px; width:30%;"> px (JPG画像のみ有効)</td>
			</tr>
			<tr>
				<td style="padding-top: 0px;padding-bottom: 2px; font-size: 10px;">&nbsp;</td>
				<td style="padding-top: 0px;padding-bottom: 2px; font-size: 12px;">推奨サイズ: 640px以下</td>
			</tr>
$hideTag2
		</table>
		<div align="right">
			<input type="submit" value="ライブラリへアップロード" style="font-size: 12px;">
		</div>

		<span style="font-size: 12px; font-weight: bold;">ライブラリファイルの挿入 </span>
		<table width="350" border="0" cellpadding="0" cellspacing="0" style="background-color: #F7F7F7; border: 2px solid #FFFFFF; padding: 5px;">
			<tr>
				<td style="padding-bottom: 2px; padding-top: 0px; font-size: 12px;" colspan="2"><iframe id="selImage" frameborder="0" framespacing="0" style="height:180px;width: 330px;border: 1px solid #999999; padding: 0px;margin: 0px;" src=""></iframe></td>
			</tr>
			<tr>
				<td style="padding-bottom: 2px; padding-top: 0px; font-size: 12px;" width="60">URL:</td>
				<td style="padding-bottom: 2px; padding-top: 0px;" width="320"><input type="text" name="src" id="src" value=""  style="font-size: 10px; width: 100%;"></td>
			</tr>
			<tr>
				<td style="padding-top: 0px;padding-bottom: 2px; font-size: 10px;">&nbsp;</td>
				<td style="padding-top: 0px;padding-bottom: 2px; font-size: 12px;">▲ライブラリからファイルをクリックして選択</td>
			</tr>
		</table>
		
			<div align="right">
				<input type="button" value="上記ファイルを挿入" onclick="javascript:insertImage();closeWindow();" style="font-size: 12px;">
				<input type="button" value="キャンセル" onclick="javascript:closeWindow();" style="font-size: 12px;">	
			</div>
		</form>
		
	</td>
	<td style="vertical-align: top;width: 260px; padding-left: 5px;" rowspan="2">
		<span style="font-size: 12px; font-weight: bold;">ファイルライブラリ</span>
		<span style="font-size: 12px;">参照：$swTagLocal $swTagPub </span>
		<iframe id="chooser" frameborder="0" framespacing="0" style="height:410px;width: 280px;border: 1px solid #999999; padding: 0px;" src="$cginame?mode=list&amp;targd=$targd&amp;seld=$seld&amp;CKEditor=$wysiwyg&amp;CKEditorFuncNum=$FuncNum"></iframe>
	</td>
	</tr>
</table>
</body>
</html>
HTML

print "Content-type: text/html\n\n";
print $viewHTML;

}
##=======================================================================================
sub list {

our @UploadedListA=&GetFilelist($updir,0,0);
our @UploadedFilesB = sort @UploadedListA;
our @UploadedFiles = reverse(@UploadedFilesB);
our $TagFiles;
our $fi;
foreach (@UploadedFiles) {
	my @Pathes=();
	my $IconExt='';
	@Pathes=split(/\./,$UploadedFiles[$fi]);
	my $FileExt=pop(@Pathes);
	if (($FileExt =~ /jpg/i)||($FileExt =~ /jpeg/i)) { $IconExt='jpg'; }
	elsif ($FileExt =~ /gif/i) { $IconExt='gif'; }
	elsif ($FileExt =~ /png/i) { $IconExt='png'; }
	elsif ($FileExt =~ /doc/i) { $IconExt='doc'; }
	elsif ($FileExt =~ /docx/i) { $IconExt='docx'; }
	elsif ($FileExt =~ /xls/i) { $IconExt='xls'; }
	elsif ($FileExt =~ /xlsx/i) { $IconExt='xlsx'; }
	elsif ($FileExt =~ /ppt/i) { $IconExt='ppt'; }
	elsif ($FileExt =~ /pptx/i) { $IconExt='pptx'; }
	elsif ($FileExt =~ /jtd/i) { $IconExt='jtd'; }
	elsif ($FileExt =~ /txt/i) { $IconExt='txt'; }
	elsif ($FileExt =~ /pdf/i) { $IconExt='pdf'; }
	elsif ($FileExt =~ /mp3/i) { $IconExt='mp3'; }
	elsif ($FileExt =~ /wma/i) { $IconExt='wma'; }
	elsif ($FileExt =~ /mmf/i) { $IconExt='mmf'; }
	elsif ($FileExt =~ /mld/i) { $IconExt='mld'; }
	elsif ($FileExt =~ /wmv/i) { $IconExt='wmv'; }
	elsif ($FileExt =~ /swf/i) { $IconExt='swf'; }
	elsif ($FileExt =~ /mp4/i) { $IconExt='mp4'; }
	elsif ($FileExt =~ /3gp/i) { $IconExt='3gp'; }
	elsif ($FileExt =~ /3g2/i) { $IconExt='3g2'; }
	elsif ($FileExt =~ /zip/i) { $IconExt='zip'; }
	elsif ($FileExt =~ /lzh/i) { $IconExt='lzh'; }
	else { $IconExt='help'; }
	$TagFiles=$TagFiles."<a href=\"javascript:void(0)\" onclick=\"selectImage(\'".$showdir.$UploadedFiles[$fi]."\')\;"
	."showImage(\'".$cginame.'?mode=view&amp;xurl='.$updir.$UploadedFiles[$fi]."\')\;\"><img src=\"../../../icon/".$IconExt.".gif\" alt=\"".$UploadedFiles[$fi]."\" border=\"0\" /> "
	."<strong>".$UploadedFiles[$fi]."</strong></a> "
	."<a href=\"".$cginame.'?CKEditor='.$wysiwyg.'&amp;CKEditorFuncNum='.$FuncNum.'&amp;mode=delcheck&amp;seld='.$seld.'&amp;targd='.$targd.'&amp;dfile='.$UploadedFiles[$fi]."\" onclick=\"showImage(\'"
	.$cginame.'?mode=view&amp;CKEditor='.$wysiwyg.'&amp;CKEditorFuncNum='.$FuncNum.'&amp;seld='.$seld.'&amp;targd='.$targd.'&amp;xurl='.$updir.$UploadedFiles[$fi]."\')\;\" style=\"color:red\">[削除]</a><br>\n";
	$fi++;
}

my $listHTML = <<"listHTML";
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Cache-Control" content="no-cache">
<meta http-equiv="expires" content="0">
<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
<title>SelectImage</title>
<link rel="stylesheet" href="../../style.css" type="text/css">
<script type="text/javascript">
	function selectImage(url) {
		if(parent) {
			parent.document.getElementById("src").value = url;
		}
	}
	function showImage(xurl) {
		if(parent) {
			parent.document.getElementById("selImage").src = xurl;
		}
	}
	if(parent) {
		parent.document.getElementById("dir").value = '$updir';
	}
	
</script>
</head>
<body style="margin:2px">
$TagFiles
</body>
</html>
listHTML

print "Content-type: text/html\n\n";
print $listHTML;

}
##=======================================================================================
sub view {

my $imgTag;
if ($in{'xurl'} ne '') {
	$imgTag='<img src="'.$in{'xurl'}.'">';
}

my $veiwHTML = <<"veiwHTML";
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Cache-Control" content="no-cache">
<meta http-equiv="expires" content="0">
<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
<title>showImage</title>
<link rel="stylesheet" href="../../style.css" type="text/css">
</head>
<body style="margin:0px">
$imgTag
</body>
</html>
veiwHTML

print "Content-type: text/html\n\n";
print $veiwHTML;

}
##=======================================================================================
sub regfile {

##ファイル名を取得
$orgfname=$in{'imgfile'};
if ($orgfname =~ /\\/) {
	my @OrgFilePath=split(/\\/,$orgfname);
	$orgfname =pop(@OrgFilePath);
}
if ($orgfname =~ /\//) {
	my @OrgFilePath=split(/\//,$orgfname);
	$orgfname =pop(@OrgFilePath);
}

my $TmpImage=$updir.$$.'.tmp';
my $FinImage=$updir.$orgfname.'';

if ($in{'imgfile'} eq '') { &error('ファイルが添付されていません'); }
if (-e $FinImage) { &error('このファイル名('.$orgfname.')はすでにライブラリ登録されています'); }

# 拡張子チェック
my @Pathes=();
my $CheckExt='';
@Pathes=split(/\./,$orgfname);
my $FileExt=pop(@Pathes);
if ($FileExt =~ /jpg/i) { $CheckExt='jpg'; }
elsif ($FileExt =~ /jpeg/i) { $CheckExt='jpg'; }
elsif ($FileExt =~ /gif/i) { $CheckExt='gif'; }
elsif ($FileExt =~ /png/i) { $CheckExt='png'; }
elsif ($FileExt =~ /doc/i) { $CheckExt='doc'; }
elsif ($FileExt =~ /docx/i) { $CheckExt='docx'; }
elsif ($FileExt =~ /xls/i) { $CheckExt='xls'; }
elsif ($FileExt =~ /xlsx/i) { $CheckExt='xlsx'; }
elsif ($FileExt =~ /ppt/i) { $CheckExt='ppt'; }
elsif ($FileExt =~ /pptx/i) { $CheckExt='pptx'; }
elsif ($FileExt =~ /jtd/i) { $CheckExt='jtd'; }
elsif ($FileExt =~ /txt/i) { $CheckExt='txt'; }
elsif ($FileExt =~ /pdf/i) { $CheckExt='pdf'; }
elsif ($FileExt =~ /mp3/i) { $CheckExt='mp3'; }
elsif ($FileExt =~ /wma/i) { $CheckExt='wma'; }
elsif ($FileExt =~ /mmf/i) { $CheckExt='mmf'; }
elsif ($FileExt =~ /mld/i) { $CheckExt='mld'; }
elsif ($FileExt =~ /wmv/i) { $CheckExt='wmv'; }
elsif ($FileExt =~ /swf/i) { $CheckExt='swf'; }
elsif ($FileExt =~ /mp4/i) { $CheckExt='mp4'; }
elsif ($FileExt =~ /3gp/i) { $CheckExt='3gp'; }
elsif ($FileExt =~ /3g2/i) { $CheckExt='3g2'; }
elsif ($FileExt =~ /zip/i) { $CheckExt='zip'; }
elsif ($FileExt =~ /lzh/i) { $CheckExt='lzh'; }
if ($CheckExt eq '') {
	&error('このファイルは添付できません');
}

# 添付データを書き込み
my $buffer;
open(OUT,"> $TmpImage") || &error('アップロード失敗');
binmode(OUT);
binmode(STDOUT);
while (read($upfile, $buffer, 1024)) { 
	print OUT $buffer;
} 
close(OUT);
chmod(oct($WRMode),$TmpImage);

# JPGリサイズ
my $JpegFlag;
my $setSize;
my $outMsg;
if (($in{'imgfile'}=~/.jpg/)||($in{'imgfile'}=~/.JPG/)) { $JpegFlag=1; } else { $JpegFlag=0; }
if (($in{'resize'} ne '')&&($JpegFlag==1)) {
		$setSize=$in{'resize'}.'x'.$in{'resize'};
		system("$PathConvert -quality 90 -thumbnail $setSize $TmpImage $FinImage");
		$outMsg=$setSize.' JPGリサイズ処理';
		sleep(1);
} else {
	rename($TmpImage,$FinImage);
}
if (-e $TmpImage) { unlink($TmpImage); }

#処理画面出力
my $jumpurl=$cginame.'?CKEditor='.$wysiwyg.'&amp;CKEditorFuncNum='.$FuncNum.'&amp;seld='.$seld.'&amp;targd='.$targd;
my $htJUMP = <<"htJUMP";
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<title>ファイル操作</title>
</head>
<body bgcolor="#FFFFFF">
<h3 align="center">只今、$orgfname を登録中です。</h3>
<div align="center">$outMsg</div>
</body>
</html>
htJUMP

print "Content-type: text/html\n\n";
print $htJUMP;

exit;
}
##=======================================================================================
sub delcheck {

our $delfile=$updir.$in{'dfile'}.'';

if (-e $delfile) { 
#処理画面出力
my $htJUMP = <<"htJUMP";
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
<title>ファイル操作</title>
<link rel="stylesheet" href="../../style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF">
<div align="center">
<b style="color:red">$in{'dfile'} を削除しますか？</b><br>
<a href="$cginame?CKEditor=$wysiwyg&amp;CKEditorFuncNum=$FuncNum&amp;mode=delfile&amp;seld=$seld&amp;targd=$targd&amp;dfile=$in{'dfile'}">[削除]
<a href="$cginame?CKEditor=$wysiwyg&amp;CKEditorFuncNum=$FuncNum&amp;mode=list&amp;seld=$seld&amp;targd=$targd">[キャンセル]</a>
</div>
</body>
</html>
htJUMP
print "Content-type: text/html\n\n";
print $htJUMP;
} else { &error('ファイルがみつからないか、すでに削除されています'); }

exit;
}
##=======================================================================================
sub delfile {

our $delfile=$updir.$in{'dfile'}.'';
if (-e $delfile) { 
	unlink($delfile);
} else { &error('ファイルがみつからないか、すでに削除されています'); }


#処理画面出力
my $jumpurl=$cginame.'?CKEditor='.$wysiwyg.'&amp;CKEditorFuncNum='.$FuncNum.'&amp;mode=list&amp;seld='.$seld.'&amp;targd='.$targd;
my $htJUMP = <<"htJUMP";
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
<meta http-equiv="Refresh" content="1;url=$jumpurl">
<title>ファイル操作</title>
<link rel="stylesheet" href="../../style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF">
<h4 align="center">$in{'dfile'} を削除中です。</h4>
</body>
</html>
htJUMP

print "Content-type: text/html\n\n";
print $htJUMP;

exit;
}
##=======================================================================================
sub error {

my $error = $_[0];
my $ReturnLink='<a href="javascript:history.go(-1)">[先程のページへ戻る]</a>';

##★エラーメッセージの変更はここを訂正
my $errHTML = <<"ERRORMESS";
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
<title>ERROR</title>
<link rel="stylesheet" href="../../style.css" type="text/css">
</head>
<body bgcolor="#FFFFFF">
<h3 align="center"><span style="color:#ff0000">ERROR</span></h3>
<div align="center">&nbsp;<br>$error<br>&nbsp;<br>$ReturnLink</div>
</body>
</html>
ERRORMESS

print "Content-type: text/html\n\n";
print $errHTML;

exit;
}
##=======================================================================================
sub GetFilelist {

# ファイルリストの取得 
# &GetFilelist(ディレクトリ, 拡張子, スイッチ);
# 返り値：ファイル一覧（ディレクトリが開けない場合は「false」） 
# ディレクトリは相対パスで指定（絶対パスは不可） 
# 拡張子は「/（スラッシュ）」で区切ることで複数指定可 
# 拡張子に「.[*]」を指定すると全てのファイルを返す 
# 拡張子に0を指定する（&GetFilelist(ディレクトリ, 0, スイッチ);）とディレクトリ一覧を返す 
# スイッチは0か1を指定。1を指定するとファイル名を全て小文字に変換して検索。
# 0の場合は大文字と小文字が区別される 


# 引数の取得、変数の準備
my ($dir, $extension, $swich) = @_;
my ($temp, $file, $e, $n, @filelist);
my $i = 0;

# 複数指定の拡張子を分割
my @ext = split(/\//, $extension);

# ディレクトリを開く
opendir (DIR , $dir) || return 0;

# ディレクトリにあるファイル等を１つずつ抽出
while ($file = readdir DIR) {
	# ゴミをはじく
	if ($file =~ /^\.{1,2}$/) {
		next;
	} else {
		# 大文字小文字の判定
		if ($swich == 1) {
			$temp = lc($file);
			foreach (@ext) {
				$_ = lc($_);
			}
		} else {
			 $temp = $file;
		}
		# ファイルが指定拡張子と合致するかを拡張子毎にチェック
		foreach $e (@ext) {
			# 拡張子が指定されていて且つ、ワイルドカードではない
			if ($e && $e ne ".[*]") {
				# 拡張子以外の文字列に引っかからないための措置
				if (index($temp, $e, length($temp) - length($e)) != -1) {
					$filelist[$i] = $file;
					$i++;
					# ヒットしたら次のファイルへ
					last;
				} else {
					# ヒットしないため別の拡張子へ
					next;
				}
			} else {
					# ワイルドカードを指定された時
					if ($e eq ".[*]") {
						if ($file =~/\./) {
							$filelist[$i] = $file;
							$i++;
							last;
						}
					} else {
						# 拡張子の指定がない時
						$filelist[$i] = $file;
						$i++;
						last;
					}
			}
		}
	}
}

closedir(DIR) ;

# 結果としてファイル一覧を返す
return @filelist;

}
##=======================================================================================
