#!/usr/local/bin/perl

##=======================================================================##
## AD-EDIT CALENDER v4.1.0
## (c)2008-2012 NorenzPRO Ltd. TakafumiArai 2012/6/7
##=======================================================================##
use CGI::Carp qw(fatalsToBrowser);

##=======================================================================##
## 設定項目
##=======================================================================##

##★ライブラリ
use CGI;
use Encode;
require './calendlib.pl';
require '../admin/emoji.pl';
require '../admin/aelib.cgi';

##★このスクリプトの名前
$cginame = 'mobi.cgi';

##★データファイルのパス
$datafile = './data.dat';

##★休日や祝日のデータが入っているファイル。
$calenderfile = './calender.lib';

##★アップロード画像格納ディレクトリ（相対・絶対パス）
$img_dir = './file/';

##★アップロード画像公開ディレクトリ（相対・絶対パス）
$img_path = './file/';

##=====================================================================================##
##メインルーチン
##=====================================================================================##

our @DATA;
our @WRDATA;
our @CALENDER;

##キャリア識別
$ua = $ENV{"HTTP_USER_AGENT"};
if ($ua =~ /Android/i) { print "Location:smobi.cgi?".$ENV{'QUERY_STRING'}."\n\n"; exit; }
if ($ua =~ /iPhone/i) { print "Location:smobi.cgi?".$ENV{'QUERY_STRING'}."\n\n"; exit; }
if ($ua =~ /iPod/i) { print "Location:smobi.cgi?".$ENV{'QUERY_STRING'}."\n\n"; exit; }
if ($ua =~ /iPad/i) { print "Location:smobi.cgi?".$ENV{'QUERY_STRING'}."\n\n"; exit; }
if ($ua =~ /DoCoMo\/1\.0/i) { $xCR='dc'; }
elsif ($ua =~ /Mozilla/i) { $xCR='pc'; }
elsif ($ua =~ /(DoCoMo\/2\.0|FOMA)/i) { $xCR='dc'; }
elsif ($ua =~ /^(SoftBank|Vodafone|J\-PHONE|MOT\-[CV])/i) { $xCR='sb'; }
elsif ($ua =~ /^UP\.Browser/i) { $xCR='ez'; }
elsif ($ua =~ /^(KDDI\-|OPWV|MMP)/i) { $xCR='ez'; }
else { $xCR='pc'; }

##システム設定ファイル読込
our $servconf = '../admin/conf.dat';
our @SVCONF;
if (-e $servconf) {
	open(SVCFGRD,"$servconf");
	@SVCONF = <SVCFGRD>;
	close(SVCFGRD);
	##文字コード判定→UTF8変換
	my $contCC=&checkCharCode($servconf);
	if ($contCC eq 'shiftjis') {
		foreach (@SVCONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
	}
}
our $Domain =$SVCONF[3];
$Domain =~ s/\r//g; $Domain =~ s/\n//g;
our $RootPath =$SVCONF[10];
$RootPath =~ s/\r//g; $RootPath =~ s/\n//g;
our $mboutCode =$SVCONF[23];
$mboutCode =~ s/\r//g; $mboutCode =~ s/\n//g;

if ($mboutCode eq '') { $mboutCode='sjis'; }

##設定ファイル読込
our $conffile='./conf.dat';
our @CONF;
open(CONFRD,"$conffile");
@CONF = <CONFRD>;
close(CONFRD);
##文字コード判定→UTF8変換
my $contCC=&checkCharCode($conffile);
if ($contCC eq 'shiftjis') {
	foreach (@CONF) { Encode::from_to($_, 'shiftjis', 'utf8'); }
}

our $FileTypeLine =$CONF[1];
$FileTypeLine =~ s/\r//g;$FileTypeLine =~ s/\n//g;
our @FileType=split(/:/,$FileTypeLine);
our $DirName =$CONF[14];
$DirName =~ s/\r//g;$DirName =~ s/\n//g;
our $MobiTitle =$CONF[18];
$MobiTitle =~ s/\r//g;$MobiTitle =~ s/\n//g;
our $MobiHeadMsg =$CONF[19];
$MobiHeadMsg =~ s/\r//g;$MobiHeadMsg =~ s/\n//g;
$MobiHeadMsg = &inline_link($MobiHeadMsg);
$MobiHeadMsg = &tag_change($MobiHeadMsg);
our $MobiDayColor =$CONF[20];
$MobiDayColor =~ s/\r//g;$MobiDayColor =~ s/\n//g;
our $MobiSatColor =$CONF[21];
$MobiSatColor =~ s/\r//g;$MobiSatColor =~ s/\n//g;
our $MobiHoliColor =$CONF[22];
$MobiHoliColor =~ s/\r//g;$MobiHoliColor =~ s/\n//g;
our $MobiTcolor =$CONF[23];
$MobiTcolor =~ s/\r//g;$MobiTcolor =~ s/\n//g;
our $MobiSkin =$CONF[24];
$MobiSkin =~ s/\r//g;$MobiSkin =~ s/\n//g;
our $MobiBack =$CONF[25];
$MobiBack =~ s/\r//g;$MobiBack =~ s/\n//g;
our $MobiCurrent =$CONF[26];
$MobiCurrent =~ s/\r//g;$MobiCurrent =~ s/\n//g;
our $MobiNext =$CONF[27];
$MobiNext =~ s/\r//g;$MobiNext =~ s/\n//g;
our $MobiToHome =$CONF[28];
$MobiToHome =~ s/\r//g;$MobiToHome =~ s/\n//g;
$MobiToHome =~ s/</&lt;/g;$MobiToHome =~ s/>/&gt;/g;
our $TimeStamp =$CONF[29];
$TimeStamp =~ s/\r//g;$TimeStamp =~ s/\n//g;
our $MobiSkipBack =$CONF[33];
$MobiSkipBack =~ s/\r//g;$MobiSkipBack =~ s/\n//g;
our $MobiSkipNext =$CONF[34];
$MobiSkipNext =~ s/\r//g;$MobiSkipNext =~ s/\n//g;
our $MobiBackCal =$CONF[35];
$MobiBackCal =~ s/\r//g;$MobiBackCal =~ s/\n//g;
our $MobiHRcolor =$CONF[54];
$MobiHRcolor =~ s/\r//g;$MobiHRcolor =~ s/\n//g;
our $hdMobiTitle =$CONF[56];
$hdMobiTitle =~ s/\r//g;$hdMobiTitle =~ s/\n//g;

our $vMobiHeadMsg=$MobiHeadMsg; $vMobiHeadMsg =~ s/<br>/\n/g;
if ($MobiSkipBack eq '') { $MobiSkipBack='[≪]'; }
if ($MobiBack eq '') { $MobiBack='[≪前月]'; }
if ($MobiCurrent eq '') { $MobiCurrent='[今月]'; }
if ($MobiNext eq '') { $MobiNext='[次月≫]'; }
if ($MobiSkipNext eq '') { $MobiSkipNext='[≫]'; }
if ($MobiBackCal eq '') { $MobiBackCal='[戻る]'; }
if ($MobiToHome eq '') { $MobiToHome='[HOME]'; }
if ($hdMobiTitle eq '') { $hdMobiTitle=$MobiTitle; }

our $weekdaytextcolor=$MobiDayColor;
our $saturdaytextcolor=$MobiSatColor;
our $holidaytextcolor=$MobiHoliColor;
if ($MobiHRcolor eq '') { $MobiHRcolor=''; } else { $MobiHRcolor=' color="'.$MobiHRcolor.'"'; }

##日付・時刻情報の取得
$ENV{'TZ'} = "JST-9";
our($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
$year += 1900;
$mon++;
$mon= sprintf("%02d",$mon);
$mday=sprintf("%02d",$mday);
$hour=sprintf("%02d",$mday);
$min= sprintf("%02d",$mday);
$youbi = ('日','月','火','水','木','金','土') [$wday];
$DATE = $year.'/'.$mon.'/'.$mday.' '.$hour.':'.min;

##フォームの取得
our %in;
our @in;
our $upfile;
if ($MaxDataSize < $ENV{'CONTENT_LENGTH'}) { &errorout('添付ファイル容量オーバー'); }
my $query = CGI->new;
*in = $query->Vars();
if ($mboutCode eq 'sjis') { Encode::from_to(*in, 'shiftjis', 'utf8'); }

our $vyear = $in{'vyear'};
if ($vyear eq '') { $vyear = "$year"; }
our $vmonth = $in{'vmonth'};
if ($vmonth eq '') { $vmonth = "$mon"; }

##==============メインアクション==============
if ($in{'pg'} ne '') {
	$in{'mode'}='detail';
	$in{'code'}=$in{'pg'};
	$vyear=substr($in{'code'},0,4);
	$vmonth= substr($in{'code'},4,2);
}

# 処理分岐
if ($in{'mode'} eq 'list') { &list; }
elsif ($in{'mode'} eq 'detail') { &detail; }
elsif ($in{'mode'} eq 'preview') { &list; }
elsif ($in{'mode'} eq 'ezmovie') { &ezmovie; }
else { &list;  }

exit;

##=====================================================================================##
##サブルーチン
##=====================================================================================##
sub html_head {

if ($RootPath ne '') {
	$RssURL='http://'.$Domain.'/'.$RootPath.'/'.$DirName.'/rdfmb.cgi';
} else {
	$RssURL='http://'.$Domain.'/'.$DirName.'/rdfmb.cgi';
}
$RdfTag='<link rel="alternate" type="application/rss+xml" title="'.$hdMobiTitle.'" href="'.$RssURL.'" />';

#スキンページ読込
&page_read;

print "Content-type: text/html\n\n";
$phi=0;
foreach (@PHEAD) {
	$PHEAD[$phi]=~ s/<title>/<title>$hdMobiTitle /g;
	$PHEAD[$phi]=~ s/<\/head>/$RdfTag\n<\/head>/g;
	if ($mboutCode eq 'sjis') { Encode::from_to($PHEAD[$phi], 'utf8', 'shiftjis'); }
	print $PHEAD[$phi];
	$phi++;
}
if ($MobiHeadMsg ne '') { $MobiHeadMsg='<br>'.$MobiHeadMsg; } else { $MobiHeadMsg=''; }
$htHead = <<"htHead";
<font color="$MobiTcolor">$MobiTitle</font>
$MobiHeadMsg
<hr$MobiHRcolor>
htHead
if ($mboutCode eq 'sjis') { Encode::from_to($htHead, 'utf8', 'shiftjis'); }
print $htHead;

}
##=======================================================================================
sub html_foot {

if ($MobiToHome ne 'none') { $TagHome='<hr'.$MobiHRcolor.'><a href="../mobi/">'.$MobiToHome.'</a>'; }

$htFoot = <<"htFoot";
$TagHome
htFoot
if ($mboutCode eq 'sjis') { Encode::from_to($htFoot, 'utf8', 'shiftjis'); }
print $htFoot;

#スキンページ読込
&page_read;
$pfi=0;
foreach (@PFOOT) {
	if ($mboutCode eq 'sjis') { Encode::from_to($PFOOT[$pfi], 'utf8', 'shiftjis'); }
	print $PFOOT[$pfi];
	$pfi++;
}

}
##=======================================================================================
sub list {

#★イニシャライズ
$view_month = int($vmonth);
$TableTitle = $vyear."年".$view_month."月";
$srcdate = "$vyear"."$vmonth";
$srcday = "$vyear"."$vmonth"."01";
$todaydate = "$year"."$mon";
$zennjitsuHoliFlag=0;
$zennjitsuHoliCheck=0;
$yokujitsuHoliFlag=0;

#★データ読込
&data_read;
&calender_read;
$v_yearmonth = $srcdate;
$r_lastday = &calendlib'getmday($v_yearmonth);
$v_lastday = $r_lastday - 1;
$v_topweek = &calendlib'getweek($srcday);

#★曜日定義
if ($v_topweek eq "sun") { @v_youbi = ('日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土'); }
elsif ($v_topweek eq "mon") { @v_youbi = ('月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日'); }
elsif ($v_topweek eq "tue") { @v_youbi = ('火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月'); }
elsif ($v_topweek eq "wed") { @v_youbi = ('水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火'); }
elsif ($v_topweek eq "thu") { @v_youbi = ('木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水'); }
elsif ($v_topweek eq "fri") { @v_youbi = ('金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木'); }
elsif ($v_topweek eq "sat") { @v_youbi = ('土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金','土','日','月','火','水','木','金'); }
@v_weekcnt = ('1','1','1','1','1','1','1','2','2','2','2','2','2','2','3','3','3','3','3','3','3','4','4','4','4','4','4','4','5','5','5');

#★ナビボタン定義
if ($vmonth eq "01") {
	$nextyear = $vyear;		$nextmonth = int($vmonth)+1;
	$lastyear = $vyear-1;	$lastmonth = 12;
} elsif ($vmonth eq "12") {
	$nextyear = $vyear+1;	$nextmonth = 1;
	$lastyear = $vyear;		$lastmonth = int($vmonth)-1;
} else {
	$nextyear = $vyear;		$nextmonth = int($vmonth)+1;
	$lastyear = $vyear;		$lastmonth = int($vmonth)-1;
}
$nextmonth=sprintf("%02d",$nextmonth);
$lastmonth=sprintf("%02d",$lastmonth);
$MnextTag = "<a href=\"$cginame?vyear=$nextyear&amp;vmonth=$nextmonth\">$MobiNext</a>";
$MprevTag = "<a href=\"$cginame?vyear=$lastyear&amp;vmonth=$lastmonth\">$MobiBack</a>";
$vnextyear=$vyear+1;
$vprevyear=$vyear-1;
$YnextTag = "<a href=\"$cginame?vyear=$vnextyear&amp;vmonth=$vmonth\">$MobiSkipNext</a>";
$YprevTag = "<a href=\"$cginame?vyear=$vprevyear&amp;vmonth=$vmonth\">$MobiSkipBack</a>";
$CurrentTag = "<a href=\"$cginame?vyear=$year&amp;vmonth=$mon\">$MobiCurrent</a>";

##★カレンダーテーブルの変更はここを訂正
$htCalHead = <<"htCalHead";
$TableTitle <br>
$YprevTag $MprevTag $MnextTag $YnextTag <br>
$CurrentTag <br>
htCalHead

##★カレンダー出力
&html_head;
if ($mboutCode eq 'sjis') { Encode::from_to($htCalHead, 'utf8', 'shiftjis'); }
print $htCalHead;
print "<hr$MobiHRcolor>";
&listTable;
print $htCalHead;
&html_foot;

exit;
}
##=======================================================================================
sub listTable {

$daycount=1;
$weekcount=0;

#暦情報取得(春分日/秋分日)
if ($vmonth eq '03') {
	my $spday=&calendlib'getspring($vyear);
	$spday=sprintf("%02d",$spday);
	my $spformat='monthday='.$vmonth.$spday."\t".'dayname=春分の日'."\t".'condition=holiday'."\t\n";
	push(@CALENDER,$spformat);
} elsif ($vmonth eq '09') {
	my $spday=&calendlib'getautmn($vyear);
	$spday=sprintf("%02d",$spday);
	my $spformat='monthday='.$vmonth.$spday."\t".'dayname=秋分の日'."\t".'condition=holiday'."\t\n";
	push(@CALENDER,$spformat);
}

#カレンダーリスト出力
for (0..$v_lastday) {
	$dayname='';
	$condition='';
	$daytextcolor = $weekdaytextcolor;
	if ($a_furikae==1) { $b_furikae=1; }
	$yokujitsuHoliFlag=0;
	if ($zennjitsuHoliCheck==1) { $zennjitsuHoliCheck=0; $zennjitsuHoliFlag=1; }
	else { $zennjitsuHoliCheck=0; $zennjitsuHoliFlag=0; }
	#日数桁数調整
	if ($daycount < 10) { $caldaycount = "0"."$daycount"; }
	else { $caldaycount = $daycount; }
	#祝日判定(固定月日タイプ)
	$va_monthday = "$vmonth"."$caldaycount";
	@HOLIDAYA = grep(/monthday=$va_monthday/,@CALENDER);
	if (@HOLIDAYA) {
		@HALINE = split(/\t/,$HOLIDAYA[0]);
		foreach (@HALINE) {
			($key, $value) = split(/=/,$_);
			$HOLA{$key} = $value;
		}
		$dayname = $HOLA{'dayname'};
		$condition = $HOLA{'condition'};
		if ($HOLA{'condition'} eq 'holiday') { $zennjitsuHoliCheck=1; }
	}
	#祝日判定(第Ｘ曜日タイプ)
	if ($v_youbi[$weekcount] eq "日") { $vc_weekday = "sun"; }
	elsif ($v_youbi[$weekcount] eq "月") { $vc_weekday = "mon"; }
	elsif ($v_youbi[$weekcount] eq "火") { $vc_weekday = "tue"; }
	elsif ($v_youbi[$weekcount] eq "水") { $vc_weekday = "wed"; }
	elsif ($v_youbi[$weekcount] eq "木") { $vc_weekday = "thu"; }
	elsif ($v_youbi[$weekcount] eq "金") { $vc_weekday = "fri"; }
	elsif ($v_youbi[$weekcount] eq "土") { $vc_weekday = "sat"; }
	$vb_monthday = "$vmonth"."$vc_weekday"."$v_weekcnt[$weekcount]";
	@HOLIDAYB = grep(/monthday=$vb_monthday/,@CALENDER);
	if (@HOLIDAYB) {
		@HBLINE = split(/\t/,$HOLIDAYB[0]);
		foreach (@HBLINE) {
			($key, $value) = split(/=/,$_);
			$HOLB{$key} = $value;
		}
		$dayname = $HOLB{'dayname'};
		$condition = $HOLB{'condition'};
		if ($HOLB{'condition'} eq 'holiday') { $zennjitsuHoliCheck=1; }
	}
	#国民の休日判定(前後が祝日である)
	$xthisdate=$vyear.$vmonth.''.sprintf("%02d",$daycount);
	$xnextdate=&calendlib'gettomorrow($xthisdate);
	$xnextyear=substr($xnextdate,0,4);
	$xnextmon= substr($xnextdate,4,2);
	$xnextday= substr($xnextdate,6,2);
	if ($vc_weekday eq "sun") { $xnextweek = "mon"; }
	elsif ($vc_weekday eq "mon") { $xnextweek = "tue"; }
	elsif ($vc_weekday eq "tue") { $xnextweek = "wed"; }
	elsif ($vc_weekday eq "wed") { $xnextweek = "thu"; }
	elsif ($vc_weekday eq "thu") { $xnextweek = "fri"; }
	elsif ($vc_weekday eq "fri") { $xnextweek = "sat"; }
	elsif ($vc_weekday eq "sat") { $xnextweek = "sun"; }
	#翌日が固定月日タイプの祝日の場合
	@xNextHoliday=();
	@xNextHolipre=grep(/monthday=$xnextmon$xnextday\t/,@CALENDER);
	@xNextHoliday=grep(/\tcondition=holiday\t/,@xNextHolipre);
	$LotNextHoliday=@xNextHoliday;
	if ($LotNextHoliday>0) { $yokujitsuHoliFlag=1; }
	#翌日が第Ｘ曜日タイプの祝日の場合
	if ($daycount==$r_lastday) { $xnextwcount=1; } else { $xnextwcount=$v_weekcnt[$weekcount+1]; }
	@xNextHoliday=();
	@xNextHolipre=grep(/monthday=$xnextmon$xnextweek$xnextwcount\t/,@CALENDER);
	@xNextHoliday=grep(/\tcondition=holiday\t/,@xNextHolipre);
	$LotNextHoliday=@xNextHoliday;
	if ($LotNextHoliday>0) { $yokujitsuHoliFlag=1; }
	if (($zennjitsuHoliFlag==1)&&($yokujitsuHoliFlag==1)) {
		$daytextcolor = $holidaytextcolor;
		$daytextcolor = $holidaytextcolor;
		if ($dayname eq '') { $dayname = '国民の休日'; }
	}
	#振替休日判定
	if ($v_youbi[$weekcount] eq "日") { $daytextcolor = $holidaytextcolor; }
	if ($v_youbi[$weekcount] eq "土") {  $daytextcolor = $saturdaytextcolor;}
	if ($condition eq "holiday") {
		$daytextcolor = $holidaytextcolor;
		if ($v_youbi[$weekcount] eq "日") { $a_furikae=1; }
	}
	if (($b_furikae == 1) && ($condition ne "holiday")) {
		$daytextcolor = $holidaytextcolor;
		$dayname = '振替休日';
		$a_furikae=0;
	}
	
	#各日データ読込出力
	$v_thisday = "$srcdate"."$caldaycount";
	if ($in{'mode'} eq 'preview') {
		@VIEWDATA = grep(/code=$v_thisday/,@DATA);
	} else {
		@PRE = grep(/code=$v_thisday/,@DATA);
		@VIEWDATA = grep(/\tshow=on\t/,@PRE);
	}
	$v1_lot=@VIEWDATA;
	if ($v1_lot==0) { $v_rowspan=1; }
	elsif ($v1_lot==1) { $v_rowspan=1; }
	else { $v_rowspan= $v1_lot; }
	
	$tagMessage="<font color=\"$daytextcolor\">$daycount($v_youbi[$weekcount])</font> <small>$dayname</small><br>\n";
	if ($mboutCode eq 'sjis') { Encode::from_to($tagMessage, 'utf8', 'shiftjis'); }
	print $tagMessage;
	if ($v1_lot != 0) {
		foreach $vd_line (@VIEWDATA) {
			@VIEWLINE = split(/\t/,$vd_line);
			foreach (@VIEWLINE) {
				($key, $value) = split(/=/,$_);
				$VIEWDATA{$key} = $value;
			}
			
			$v_code = $VIEWDATA{'code'};
			$v_show = $VIEWDATA{'show'};
			$v_date = $VIEWDATA{'date'};
			$v_title = $VIEWDATA{'title'};
				$v_title =~ s/\|br\|//g;
				$v_title =~ s/\|amp\|/\&/g;
				$v_title =~ s/\|eq\|/=/g;
				$v_title =~ s/\|quot\|/\"/g;
				$v_title =~ s/\|squot\|/\'/g;
				$v_title = &tag_change($v_title);
				$v_title = &EmojiTagToGif($v_title);
			$v_message = $VIEWDATA{'message'};
				$v_message =~ s/\|br\|//g;
				$v_message =~ s/\|amp\|/\&/g;
				$v_message =~ s/\|eq\|/=/g;
				$v_message =~ s/\|quot\|/\"/g;
				$v_message =~ s/\|squot\|/\'/g;
				$v_message = &inline_link($v_message);
				$v_message = &tag_change($v_message);
				$v_message = &EmojiTagToGif($v_message);
			$v_url = $VIEWDATA{'url'};
			$v_targ = $VIEWDATA{'targ'};
			$v_mrl = $VIEWDATA{'mrl'};
			##添付ファイルがあれば表示
			$FtLot=@FileType-1;$i=0;
			for (0..$FtLot) {
				$f_filepath = $img_dir.$v_code.'0.'.$FileType[$i];
				$h_filepath = $img_path.$v_code.'0.'.$FileType[$i];
				if ($FileType[$i] eq 'jpg') { $FtypeName='[画像]'; $FtypeImg=1; }
				elsif ($FileType[$i] eq 'gif') { $FtypeName='[画像]'; $FtypeImg=1; }
				elsif ($FileType[$i] eq 'png') { $FtypeName='[画像]'; $FtypeImg=1; }
				elsif ($FileType[$i] eq 'doc') { $FtypeName='[WORD書類]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq 'docx') { $FtypeName='[WORD2007書類]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq 'xls') { $FtypeName='[EXCEL書類]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq 'xlsx') { $FtypeName='[EXCEL2007書類]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq 'ppt') { $FtypeName='[PPT書類]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq 'pptx') { $FtypeName='[PPT2007書類]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq 'jtd') { $FtypeName='[一太郎書類]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq 'txt') { $FtypeName='[テキスト書類]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq 'pdf') { $FtypeName='[PDF書類]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq 'mp3') { $FtypeName='[MP3音声]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq 'mmf') { $FtypeName='[音声再生]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq 'mld') { $FtypeName='[音声再生]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq 'wma') { $FtypeName='[WMA音声]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq 'wmv') { $FtypeName='[WMV動画]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq '3gp') { $FtypeName='[動画再生]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq '3g2') { $FtypeName='[動画再生]'; $FtypeImg=2; }
				elsif ($FileType[$i] eq 'zip') { $FtypeName='[ZIPファイル]'; $FtypeImg=0; }
				elsif ($FileType[$i] eq 'lzh') { $FtypeName='[LZHファイル]'; $FtypeImg=0; }
				if ((-e $f_filepath)&&($FtypeImg==2)&&($xCR eq 'ez')) {
					$ezmvurl=$cginame.'?mode=ezmovie&ezmvfile='.$v_code.'0.'.$FileType[$i];
					$v_filetag = '<a href="'.$ezmvurl.'" target="top">'.$FtypeName.' '.$fv_filesize.'</a>';
					last;
				} elsif (-e $f_filepath) {
					$v_filetag = '<a href='.$h_filepath.' target="_blank"><img src="../icon/'.$FileType[$i]
						.'.gif" align="absmiddle" border="0">'.$FtypeName.'</a>　';
					last;
				} else { $v_filetag=''; }
				if ($VIEWDATA{'url'} ne '') {
					$v_filetag = '<a href="'.$v_url.'" target="'.$v_targ.'">'
						.'<img src=../icon/home.gif align="absmiddle" border="0">[参照URL]</a>　';
				}
				$i++;
			}
			#記事出力
			&listBox;
			
			$v_code = "";
			$v_date = "";
		}
	}
	print"<hr$MobiHRcolor>\n";
	
	$daycount++;
	$weekcount++;
	$b_furikae=0;
}

}
##=======================================================================================
sub listBox {

if ($TimeStamp eq 'on') { $selDate=$v_date.' '; }
else { $selDate=''; }

##★リスト画面の変更はここを訂正
if ($daytextcolor eq $weekdaytextcolor) { $dtype='d'; }
if ($daytextcolor eq $saturdaytextcolor) { $dtype='s'; }
if ($daytextcolor eq $holidaytextcolor) { $dtype='h'; }
$htmldList = <<"htLISTD";
<small>$selDate</small>
<a href="$cginame?pg=$v_code&amp;d=$dtype">$v_title</a><br>
htLISTD

if ($mboutCode eq 'sjis') { Encode::from_to($htmldList, 'utf8', 'shiftjis'); }
print $htmldList;

}
##=======================================================================================
sub detail {

#★変数取得
$dcode=$in{'code'};
$dtype=$in{'d'};

#★日付情報取得
$dyear=substr($dcode,0,4);
$dmon =substr($dcode,4,2);
$dday =substr($dcode,6,2);
$dhour=substr($dcode,8,2);
$dmin =substr($dcode,10,2);
$ddate = $dyear.$dmon.$dday;
$dweek = &calendlib'getweek($ddate);
if ($dweek eq "sun") { $dweek='日'; }
elsif ($dweek eq "mon") { $dweek='月'; }
elsif ($dweek eq "tue") { $dweek='火'; }
elsif ($dweek eq "wed") { $dweek='水'; }
elsif ($dweek eq "thu") { $dweek='木'; }
elsif ($dweek eq "fri") { $dweek='金'; }
elsif ($dweek eq "sat") { $dweek='土'; }
if ($dtype eq 'd') { $daytextcolor=$weekdaytextcolor; }
elsif ($dtype eq 's') { $daytextcolor=$saturdaytextcolor; }
elsif ($dtype eq 'h') { $daytextcolor=$holidaytextcolor; }

#★イニシャライズ
$view_month = int($vmonth);
$TableDate = $dyear.'/'.$dmon.'/'.$dday.'('.$dweek.')';
if ($TimeStamp eq 'on') { $TableTime = $dhour.':'.$dmin; }

#★データ読込
&data_read;
@DETAIL=grep(/code=$dcode\t/,@DATA);
$dData=$DETAIL[0];
@VIEWLINE = split(/\t/,$dData);
foreach (@VIEWLINE) {
	my($key, $value) = split(/=/,$_);
	$VIEWDATA{$key} = $value;
}
$v_code = $VIEWDATA{'code'};
$v_show = $VIEWDATA{'show'};
$v_date = $VIEWDATA{'date'};
$v_title = $VIEWDATA{'title'};
	$v_title =~ s/\|br\|//g;
	$v_title =~ s/\|amp\|/\&/g;
	$v_title =~ s/\|eq\|/=/g;
	$v_title =~ s/\|quot\|/\"/g;
	$v_title =~ s/\|squot\|/\'/g;
	$v_title = &tag_change($v_title);
	$v_title = &EmojiTagToGif($v_title);
$v_title2 = $VIEWDATA{'title2'};
	if ($VIEWDATA{'title2'} eq '') {
		$v_title2=$v_title;
	} else {
		$v_title2 =~ s/\|br\|//g;
		$v_title2 =~ s/\|amp\|/\&/g;
		$v_title2 =~ s/\|eq\|/=/g;
		$v_title2 =~ s/\|quot\|/\"/g;
		$v_title2 =~ s/\|squot\|/\'/g;
		$v_title2 = &tag_change($v_title2);
		$v_title2 = &EmojiTagToGif($v_title2);
	}
$v_message = $VIEWDATA{'message'};
	$v_message =~ s/\|br\|//g;
	$v_message =~ s/\|amp\|/\&/g;
	$v_message =~ s/\|eq\|/=/g;
	$v_message =~ s/\|quot\|/\"/g;
	$v_message =~ s/\|squot\|/\'/g;
	$v_message = &inline_link($v_message);
	$v_message = &tag_change($v_message);
	$v_message = &EmojiTagToGif($v_message);
$v_url = $VIEWDATA{'url'};
$v_targ = $VIEWDATA{'targ'};
$v_mrl = $VIEWDATA{'mrl'};

##添付ファイルがあれば表示
$FtLot=@FileType-1;$i=0;
for (0..$FtLot) {
	$f_filepath = $img_dir.$v_code.'0.'.$FileType[$i];
	$h_filepath = $img_path.$v_code.'0.'.$FileType[$i];

	if ($FileType[$i] eq 'jpg') { $FtypeName='[画像]'; $FtypeImg=1; }
	elsif ($FileType[$i] eq 'gif') { $FtypeName='[画像]'; $FtypeImg=1; }
	elsif ($FileType[$i] eq 'png') { $FtypeName='[画像]'; $FtypeImg=1; }
	elsif ($FileType[$i] eq 'doc') { $FtypeName='[WORD書類]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq 'docx') { $FtypeName='[WORD2007書類]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq 'xls') { $FtypeName='[EXCEL書類]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq 'xlsx') { $FtypeName='[EXCEL2007書類]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq 'ppt') { $FtypeName='[PPT書類]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq 'pptx') { $FtypeName='[PPT2007書類]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq 'jtd') { $FtypeName='[一太郎書類]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq 'txt') { $FtypeName='[テキスト書類]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq 'pdf') { $FtypeName='[PDF書類]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq 'mp3') { $FtypeName='[MP3音声]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq 'mmf') { $FtypeName='[音声再生]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq 'mld') { $FtypeName='[音声再生]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq 'wma') { $FtypeName='[WMA音声]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq 'wmv') { $FtypeName='[WMV動画]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq '3gp') { $FtypeName='[動画再生]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq '3g2') { $FtypeName='[動画再生]'; $FtypeImg=2; }
	elsif ($FileType[$i] eq 'zip') { $FtypeName='[ZIPファイル]'; $FtypeImg=0; }
	elsif ($FileType[$i] eq 'lzh') { $FtypeName='[LZHファイル]'; $FtypeImg=0; }

	if ((-e $f_filepath)&&($FtypeImg==2)&&($xCR eq 'ez')) {
		$ezmvurl=$cginame.'?mode=ezmovie&ezmvfile='.$v_code.'0.'.$FileType[$i];
		$v_filetag = '<a href="'.$ezmvurl.'" target="top">'.$FtypeName.' '.$fv_filesize.'</a>';
		last;
	} elsif (-e $f_filepath) {
		$v_filetag = '<a href='.$h_filepath.' target="_blank"><img src="../icon/'.$FileType[$i]
			.'.gif" align="middle" border="0">'.$FtypeName.'</a>　';
		last;
	} else { $v_filetag=''; }
	$i++;
}
if ($VIEWDATA{'url'} ne '') {
	$v_filetag = '<a href="'.$v_url.'" target="'.$v_targ.'">'
		.'<img src=../icon/home.gif align="middle" border="0">[参照URL]</a>　';
}

#★ナビボタン定義
$BackTag = "<a href=\"$cginame?vyear=$vyear&amp;vmonth=$vmonth\">$MobiBackCal</a>";

##★記事詳細の変更はここを訂正
$htDetail = <<"htDetail";
<font color="$daytextcolor">$TableDate $TableTime </font><br>
$v_title2
<hr$MobiHRcolor>
$v_message $v_filetag
<hr$MobiHRcolor>
$BackTag
htDetail


##★カレンダー出力
&html_head;
if ($mboutCode eq 'sjis') { Encode::from_to($htDetail, 'utf8', 'shiftjis'); }
print $htDetail;
&html_foot;

exit;
}
##=======================================================================================
sub ezmovie {

$ezmvpath = $img_path.$in{'ezmvfile'}.'';
$ezmvsize = -s $ezmvpath;
if ($RootPath eq '') { $EzURL='http://'.$Domain.'/'.$DirName; }
else { $EzURL='http://'.$Domain.'/'.$RootPath.'/'.$DirName; }

$XMLBody = <<"XMLBody";
<?xml version="1.0"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML Basic 1.0//EN"
"http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<body>
<object data="$EzURL/file/$in{'ezmvfile'}" type="video/3gpp2" standby="MoviePlay" copyright="no">'
<param name="disposition" value="devmpzz" valuetype="data" />
<param name="size" value="$ezmvsize" valuetype="data" />
<param name="title" value="$DATE3" valuetype="data" /></object>
</body>
</html>
XMLBody

print "Content-type: text/html\n\n";
if ($mboutCode eq 'sjis') { Encode::from_to($XMLBody, 'utf8', 'shiftjis'); }
print $XMLBody;

}
##=======================================================================================
sub data_read {
	if (open(DBREAD,"$datafile")) {
		@DATA = <DBREAD>;
		close(DBREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($datafile);
		if ($contCC eq 'shiftjis') {
			foreach (@DATA) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else { &errorout('DBファイルの読込に失敗しました。'); }
}
##=======================================================================================
sub calender_read {
	if (open(CLDREAD,"$calenderfile")) {
		@CALENDER = <CLDREAD>;
		close(CLDREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($calenderfile);
		if ($contCC eq 'shiftjis') {
			foreach (@CALENDER) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else { &errorout('カレンダー祝日定義ファイルが存在しません'); }
}
##=======================================================================================
sub page_read {
	$rMobiSkin='..'.$MobiSkin;
	if (open(PAGEREAD,"$rMobiSkin")) {
		@PAGE = <PAGEREAD>;
		close(PAGEREAD);
		##文字コード判定→UTF8変換
		my $contCC=&checkCharCode($rMobiSkin);
		if ($contCC eq 'shiftjis') {
			foreach (@PAGE) { Encode::from_to($_, 'shiftjis', 'utf8'); }
		}
	} else {
		$alMobiSkin=$rMobiSkin; $alMobiSkin=~ s/\.\.//i;
		$PAGE[0] ='<html>'."\n";
		$PAGE[1] ='<head><meta http-equiv="Content-Type" content="text/html;charset='.$mboutCode.'"></head>'."\n";
		$PAGE[2] ='<body><font color="red">[設定]にて指定したスキンファイル ['.$alMobiSkin.'] が存在しません</font><br>'."\n";
		$PAGE[3] ='<font color="red">[設定]にて正しいスキンファイルを指定するか、[スキン編集]にて作成する必要があります</font>'."\n";
		$PAGE[4] ='<!-- MainZone -->'."\n";
		$PAGE[5] ='</body></html>'."\n";
	}
	$pageflag = 0;
	@PHEAD = (); @PFOOT = (); $pi = 0;
	foreach (@PAGE) {
		if ($PAGE[$pi] =~ /MainZone/i) { $pageflag = 1; }
		if ($pageflag==0) { push(@PHEAD,$PAGE[$pi]); }
		if ($pageflag==1) { push(@PFOOT,$PAGE[$pi]); }
		$pi++;
	}
}
##=======================================================================================
sub tag_change {
	##	$var = &tag_change($var); で変換する
	if ($RootPath ne '') { $TcRootPath='/'.$RootPath; } else { $TcRootPath=''; }
	local($_) = $_[0];
	1 while s/\[new\]/<img src=\"$TcRootPath\/icon\/new\.gif\" align=\"middle\" alt=\"new\" border=\"0\" \/>/g;
	1 while s/\[red\]/<font color=\"\#FF0000\">/g;
	1 while s/\[\/red\]/<\/font>/g;
	1 while s/\[blue\]/<font color=\"\#0000FF\">/g;
	1 while s/\[\/blue\]/<\/font>/g;
	1 while s/\[green\]/<font color=\"\#009900\">/g;
	1 while s/\[\/green\]/<\/font>/g;
	1 while s/AeDirTop/mobi.cgi/g;
	$_;
}
##=======================================================================================
sub errorout {

$error = $_[0];

$ReturnLink='<a href="javascript:history.go(-1)">[先程のページへ戻る]</a>';

##★エラーメッセージの変更はここを訂正
$errHTML = <<"ERRORMESS";
<p><font color="#ff0000">ERROR</font>
&nbsp;<br>$error<br>　 <br>$ReturnLink</p></div>
ERRORMESS

if ($mboutCode eq 'sjis') { Encode::from_to($errHTML, 'utf8', 'shiftjis'); }
print $errHTML;
&html_foot;
exit;

}
##=======================================================================================
