/*
 *  ADP (Another Data Processor) www.adp.la
 *  Copyright (C) 2010 Katsuhisa Ohfuji <katsuhisa@ohfuji.name>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 */
#include "adp.h"

// delete
void PNil::del() { return; }
void PString::del() { pmm.mydelete( const_cast<PString*>(this)); }
void PDouble::del() { pmm.mydelete( const_cast<PDouble*>(this)); }
void PInteger::del() { pmm.mydelete( const_cast<PInteger*>(this)); }
void PList::del() { PList *p = const_cast<PList*>(this); pmm.mydelete(p); }
void PArray::del() { PArray *p = const_cast<PArray*>(this); pmm.mydelete(p); }
void PPredicate::del() { PPredicate *p = const_cast<PPredicate*>(this); pmm.mydelete(p); }
void PVeriable::del() { delete this; }
void PWildCard::del() { return; }
void PEVeriable::del() { PEVeriable *p = const_cast<PEVeriable*>(this); pmm.mydelete(p); }
void PGoal::del() { delete this; }
void PHorn::del() { delete this; }
void PHorns::del() { delete this; }
void PHornBase::del() { delete this; }

// clone
PNil *PNil::clone(PObjectArray*) const { return const_cast<PNil*>(this); }
PString *PString::clone(PObjectArray *objs) const { return pmm.newPString(objs,*this);}
PDouble *PDouble::clone(PObjectArray *objs) const { return pmm.newPDouble(objs,*this);}
PInteger *PInteger::clone(PObjectArray *objs) const { return pmm.newPInteger(objs,*this);}
PList *PList::clone(PObjectArray *objs) const { 
	PObject *l = lvalue->clone(objs);
	PObject *r = rvalue->clone(objs);
	bool	c = constant;
	PList *p = pmm.newPList(objs,l,r,c); 
	return p;
}
PArray *PArray::clone(PObjectArray *objs) const { 
	PArray *p = pmm.newPArray(objs);
	for ( PObjectArray::const_iterator i = value.begin(); i < value.end(); i++ ) {
		PObject *o = (*i)->clone(objs);
		p->value.push_back(o);
	}
	p->hamap = hamap;
	p->constant = constant;
	p->args = args;
	p->brace = brace;
	return p;
}
PPredicate *PPredicate::clone(PObjectArray *objs) const { 
	PPredicate *p = pmm.newPPredicate(objs);
	p->name = 0;
	if ( name ) p->name = name->clone(objs);
	if ( arglist.size() > 0 ) p->arglist = *arglist.clone(objs);
	p->constant = constant;
	p->opt = opt;
	p->factory = 0;
	return p;
}

PVeriable *PVeriable::clone(PObjectArray *objs) const { PVeriable *p = new PVeriable(*this); objs->push_back(p); return p;}
PWildCard *PWildCard::clone(PObjectArray *objs) const { return const_cast<PWildCard*>(this); }
PEVeriable *PEVeriable::clone(PObjectArray *objs) const { return pmm.newPEVeriable(objs,*this);}
PGoal *PGoal::clone(PObjectArray *objs) const { PGoal *p = new PGoal(*this); objs->push_back(p); return p;}
PHorn *PHorn::clone(PObjectArray *objs) const { PHorn *p = new PHorn(*this); objs->push_back(p); return p;}
PHorns *PHorns::clone(PObjectArray *objs) const { PHorns *p = new PHorns(*this); objs->push_back(p); return p;}
PHornBase *PHornBase::clone(PObjectArray *objs) const { PHornBase *p = new PHornBase(*this); objs->push_back(p); return p;}


