/*
 *  ADP (Another Data Processor) www.adp.la
 *  Copyright (C) 2010 Katsuhisa Ohfuji <katsuhisa@ohfuji.name>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 */

#ifndef ADP_BUILTIN_DEBUG_H
#define ADP_BUILTIN_DEBUG_H

struct ExecContext_Debug : public ExecContextRoot {
	ExecContext_Debug(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContextRoot(p_, f_, pred_, l) {}
	virtual bool first(PException &excp) { 
		for ( size_t i = 0; i < pred->size(); i++ ) {
			const PVeriable *v = dynamic_cast<const PVeriable *>((*pred)[i]);
			const PEVeriable *ve = dynamic_cast<const PEVeriable *>((*pred)[i]);
			if ( ve ) {
				cerr << v->getName() << "(" << ve->vl << ":" << ve->idx << ")" << ",";
			} else if ( v ) {
				cerr << v->getName() << "(" << v->idx << ")" << ",";
			}
			const PObject *item = get<PObject>(i);
			// cerr << item << "=";
			cerr << "=";
			string	txt;
			if ( item->cnv_string(txt) ) {
				cerr << txt;
			} else {
				item->recompile(cerr);
			}
			cerr << endl;
		}
		return true;
	};
};

struct ExecContext_DebugN : public ExecContext_Debug {
	ExecContext_DebugN(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContext_Debug(p_, f_, pred_, l) {}
	virtual bool first(PException &excp) { 
		bool result = ExecContext_Debug::first(excp);
		cerr << endl;
		return result;
	};
};

struct ExecContext_Assert : public ExecContextRoot {
	ExecContext_Assert(ExecContext *p_, void *f_, const PPredicate *pred_, VLocal *l) : ExecContextRoot(p_, f_, pred_, l) {}
	virtual bool first(PException &excp) { 
		return true;
	};
};

#endif
